/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;

public class LsnodesUtil {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle(PrCtMsgID.facility);
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String LSNODES = this.nativeSystem.getExeName("lsnodes");
    private static final String LS_CLUSTER_NAME = "-c";
    private static final String LS_LOCAL_NODE_NAME = "-l";
    private static final String LS_NODE_NAMES = "";
    private CmdToolUtil m_cmdtool;

    public LsnodesUtil(String crsHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(crsHome, true);
        this.m_cmdtool = new CmdToolUtil(this.LSNODES, crsHome, crsHome, null);
    }

    public String getClusterName(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        CommandResult result = this.m_cmdtool.execute(nodeName, new String[]{LS_CLUSTER_NAME});
        String[] res = result.getResultString();
        if (res == null || res.length < 1) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_CLUSTER_NAME, nodeName);
        }
        res[0] = res[0].trim();
        return res[0];
    }

    public String[] getNodeNames() throws CmdToolUtilException {
        CommandResult result = this.m_cmdtool.execute(new String[]{LS_NODE_NAMES}, null);
        String[] res = result.getResultString();
        if (res == null || res.length <= 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_NODE_NAMES, new Object[0]);
        }
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == null) continue;
            res[i] = res[i].trim();
        }
        return res;
    }

    public String getLocalNodeName() throws CmdToolUtilException {
        CommandResult result = this.m_cmdtool.execute(new String[]{LS_LOCAL_NODE_NAME}, null);
        String[] res = result.getResultString();
        if (res == null || res.length < 1) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_LOCAL_NODE_NAME, new Object[0]);
        }
        res[0] = res[0].trim();
        return res[0];
    }
}

