/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class GETCRSHOMEUtil {
    private static final String GETCRSHOME = new SystemFactory().CreateSystem().getExeName("getcrshome");
    private static final String EXE_LOC = "srvm" + File.separator + "admin";
    private static final String[] GETCRSHOME_DEP = new String[]{GETCRSHOME};
    private static final boolean s_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    private CmdToolUtil m_cmdTool;

    public GETCRSHOMEUtil(String oracleHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(oracleHome, true);
        String toolLoc = oracleHome;
        toolLoc = s_isUnixSystem ? toolLoc + File.separator + EXE_LOC : toolLoc + File.separator + "bin";
        this.m_cmdTool = new CmdToolUtil(GETCRSHOME, toolLoc, GETCRSHOME_DEP);
        Trace.out("Toolname: " + GETCRSHOME + "   ---    Tool location: " + toolLoc + "Tool dependencies: " + GETCRSHOME_DEP);
    }

    public String getORACLE_HOME() throws CmdToolUtilException {
        return this.getCRS_HOME("localnode");
    }

    public String getCRS_HOME() throws CmdToolUtilException {
        return this.getCRS_HOME("localnode");
    }

    public String getCRS_HOME(String nodeName) throws CmdToolUtilException {
        String[] errorString;
        CmdToolUtil.assertNode(nodeName);
        String[] args = new String[]{};
        String[] env = null;
        CommandResult result = null;
        result = nodeName.equals("localnode") ? this.m_cmdTool.executeLocally(args, env) : this.m_cmdTool.execute(nodeName, args, env, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("cmdTool.execute() failed.");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            if (nodeName == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.GETCRSHOME_FAIL, stringBuilder.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.GETCRSHOME_FAIL, nodeName, stringBuilder.toString());
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("getcrshome command succeeded, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, GETCRSHOME, nodeName);
        }
        return cmdOutput[0];
    }
}

