/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.net.UnknownHostException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.SQLPLUSUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.RemoteListener;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.RemoteArgs;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.WindowsSystem;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

class CmdToolUtil
implements Constants {
    public static final String DOT_SEPARATOR = ".";
    private static final String FSEP = System.getProperty("file.separator");
    private static final String NLS_LANG_ENG = "NLS_LANG=American_America.UTF8";
    private static final String LANG_ENG = "LANG=en_US.UTF-8";
    private static final String LANG_ENG_HP = "LANG=en_US.utf8";
    private static final String LC_ALL_ENG = "LC_ALL=en_US.UTF-8";
    private static final String LC_ALL_ENG_HP = "LC_ALL=en_US.utf8";
    public static final String ECHO = "/bin/echo";
    private static final int ERROR_SIGNAL_SUBTRACT_VAL = 128;
    private static final int SEG_FAULT_ERROR_SIGNAL = 11;
    private String m_home = null;
    private String m_toolName;
    private String m_srcLoc;
    private String[] m_envs = null;
    private String m_winDllLoc;
    private String m_destLoc;
    private String[] m_deps;
    private boolean m_bisCopied = false;
    private RemoteUserInfo m_uInfo = null;
    private RemoteListener m_lsnr = null;
    private static final boolean s_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();

    CmdToolUtil(String toolName, String srcLoc) throws CmdToolUtilException {
        this(toolName, srcLoc, null);
    }

    CmdToolUtil(String toolName, String srcLoc, String[] deps) throws CmdToolUtilException {
        this(toolName, srcLoc, System.getProperty("java.io.tmpdir"), deps);
    }

    CmdToolUtil(String toolName, String srcLoc, String destLoc, String[] deps) throws CmdToolUtilException {
        this(toolName, srcLoc, srcLoc, destLoc, deps);
    }

    CmdToolUtil(String toolName, String srcLoc, String dllLoc, String destLoc, String[] deps) throws CmdToolUtilException {
        CmdToolUtil.assertFile(srcLoc);
        CmdToolUtil.assertFile(destLoc);
        this.m_toolName = toolName;
        this.m_srcLoc = srcLoc;
        String string = this.m_winDllLoc = s_isUnixSystem ? srcLoc : dllLoc;
        if (!s_isUnixSystem && srcLoc.equalsIgnoreCase(dllLoc)) {
            String scratchPathWinLoc = System.getProperty("oracle.installer.scratchPath");
            if (scratchPathWinLoc != null) {
                String tmpScratchPath = scratchPathWinLoc + File.separator + "ext" + File.separator + "bin";
                WindowsSystem ws = (WindowsSystem)new SystemFactory().CreateSystem();
                String[] remExecFileArr = ws.getRemoteExecServerFiles();
                boolean isUseScratchPath = true;
                for (String remExecFile : remExecFileArr) {
                    boolean fileExists1 = new File(tmpScratchPath + FSEP + remExecFile).exists();
                    boolean fileExists2 = new File(tmpScratchPath + FSEP + "bin" + FSEP + remExecFile).exists();
                    if (fileExists1 || fileExists2) continue;
                    isUseScratchPath = false;
                    break;
                }
                if (isUseScratchPath) {
                    this.m_winDllLoc = tmpScratchPath;
                }
            }
            Trace.out("m_winDllLoc = " + this.m_winDllLoc);
        }
        this.m_destLoc = destLoc;
        this.m_deps = deps;
        this.m_bisCopied = false;
    }

    CmdToolUtil(RemoteUserInfo uInfo, String toolName, String toolLoc) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(toolName, "CmdToolUtil-constr-toolName");
        oracle.cluster.impl.util.Utils.assertInput(toolLoc, "CmdToolUtil-constr-toolLoc");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "CmdToolUtil-constr-uInfo");
        if (!s_isUnixSystem) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-not Unix");
        }
        String exePath = toolLoc + File.separator + toolName;
        this.m_toolName = toolName;
        this.m_srcLoc = toolLoc;
        this.m_uInfo = uInfo;
    }

    CmdToolUtil(RemoteUserInfo uInfo, String toolName, String toolLoc, RemoteListener lsnr) throws InvalidArgsException, CmdToolUtilException {
        this(uInfo, toolName, toolLoc);
        oracle.cluster.impl.util.Utils.assertInputNotNull(lsnr, "CmdToolUtil-constr-lsnr");
        this.m_lsnr = lsnr;
    }

    static final void assertFile(String file) throws CmdToolUtilException {
        if (file == null || file.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.NULL_FILE_PATH, new Object[0]);
        }
    }

    static final void assertDir(String dirName, boolean checkPathType) throws CmdToolUtilException {
        if (dirName == null || dirName.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.NULL_DIR_NAME, new Object[0]);
        }
        if (checkPathType && !new File(dirName).isDirectory()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.NO_SUCH_DIRECTORY, dirName);
        }
    }

    static final void assertNode(String node) throws CmdToolUtilException {
        if (node == null || node.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.NULL_NODE_NAME, new Object[0]);
        }
    }

    static final void assertVersion(Version version) throws CmdToolUtilException {
        if (version == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.NULL_VERSION, new Object[0]);
        }
    }

    CommandResult execute(String node, String[] args, String[] env, String[] stdIn, String asUser, boolean toIgnore) throws CmdToolUtilException {
        return this.execute(node, args, env, stdIn, asUser, toIgnore, 36000);
    }

    CommandResult execute(String node, String[] args, String[] env, String[] stdIn, String asUser, boolean toIgnore, int timeout) throws CmdToolUtilException {
        if (node == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute1-error1");
        }
        return this.doexecute(node, args, env, stdIn, asUser, false, false, toIgnore, timeout);
    }

    CommandResult execute(String nodeName, String[] args, boolean chkException) throws CmdToolUtilException {
        return this.execute(nodeName, args, null, false, chkException);
    }

    CommandResult execute(String nodeName, String[] args) throws CmdToolUtilException {
        return this.execute(nodeName, args, null, false);
    }

    CommandResult execute(String nodeName, String[] args, String[] env, boolean toCopy, boolean chkException) throws CmdToolUtilException {
        return this.doexecute(nodeName, args, env, null, null, toCopy, chkException, false, 36000);
    }

    CommandResult execute(String nodeName, String[] args, String[] env, boolean toCopy, boolean chkException, boolean toIgnore) throws CmdToolUtilException {
        return this.doexecute(nodeName, args, env, null, null, toCopy, chkException, toIgnore, 36000);
    }

    CommandResult execute(String nodeName, String[] args, String[] env, boolean toCopy) throws CmdToolUtilException {
        return this.doexecute(nodeName, args, env, null, null, toCopy, false, false, 36000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CommandResult doexecute(String nodeName, String[] args, String[] env, String[] stdIn, String asUser, boolean toCopy, boolean chkException, boolean toIgnore, int timeout) throws CmdToolUtilException {
        if (args == null || Arrays.asList(args).contains(null)) {
            Trace.out("Command arguments: " + Arrays.toString(args));
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, new Object[]{"CmdToolUtil-doexecute-nullarg-01"});
        }
        localNodeName = null;
        try {
            localNodeName = Utils.getLocalNodeName();
        }
        catch (UnknownHostException e) {
            throw new CmdToolUtilException(e);
        }
        if ((nodeName.equals("localnode") || nodeName.equals(localNodeName)) && stdIn == null) {
            return this.execute(args, env, chkException, toIgnore);
        }
        if (this.m_uInfo != null) {
            try {
                this.enforceEnglishVars(env, args, true);
                rf = RemoteFactory.getInstance();
                remArgs = new RemoteArgs(this.m_uInfo);
                if (asUser != null && !asUser.trim().isEmpty()) {
                    remArgs.setAsUser(asUser);
                }
                if (stdIn != null) {
                    remArgs.setStdin(stdIn);
                }
                if (this.m_lsnr != null) {
                    remArgs.setListener(this.m_lsnr);
                }
                execCmd = rf.getExecCommandNoUserEq(remArgs);
                if (!this.m_toolName.equals(SQLPLUSUtil.SQLPLUSUTL) || !CmdToolUtil.s_isUnixSystem || asUser != null || stdIn != null) {
                    cmdStr = this.m_srcLoc + File.separator + this.m_toolName;
                } else {
                    SQLPLUS_SCRIPT = "/tmp/execute_sqlplus_command_" + new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss.SSS").format(new Date()) + ".sh";
                    cmdStr = "/usr/bin/sh -c \"/bin/echo " + this.m_srcLoc + File.separator + this.m_toolName + " " + String.join((CharSequence)" ", args) + " >" + SQLPLUS_SCRIPT + ";" + "/usr/bin/sh" + " " + SQLPLUS_SCRIPT + "\";status=$?;" + "/usr/bin/rm" + " " + SQLPLUS_SCRIPT + ";exit $status";
                    args = new String[]{};
                }
                Trace.out("Executing %s on %s ...", new Object[]{cmdStr, nodeName});
                resultMap = execCmd.runCmd(cmdStr, args, this.m_envs, new String[]{nodeName}, timeout);
                Trace.out("Successfully executed %s on %s", new Object[]{cmdStr, nodeName});
                result = resultMap.get(nodeName);
                if (result == null) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, new Object[]{"CmdToolUtil-doexecute1-error01"});
                }
                result.setBooleanResult(true);
                return result;
            }
            catch (CompositeOperationException e) {
                Trace.out(e);
                nativeRes = null;
                try {
                    nativeRes = e.getNativeResult(nodeName);
                }
                catch (NoSuchIdentifierException nsie) {
                    Trace.out(nsie);
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)nsie, new Object[]{"CmdToolUtil-doexecute1-error02"});
                }
                if (nativeRes == null) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, new Object[]{"CmdToolUtil-doexecute1-error03"});
                }
                if (!toIgnore) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, (Throwable)new Exception(nativeRes.getException()), new Object[]{this.getToolName(), nodeName});
                }
                Trace.out("Returning with exception");
                result = new CommandResult(false, nativeRes.getResultString());
                result.setException(e);
                return result;
            }
            catch (ExecException e) {
                Trace.out(e);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, (Throwable)e, new Object[]{this.getToolName(), nodeName});
            }
            catch (InvalidArgsException e) {
                Trace.out(e);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, (Throwable)e, new Object[]{this.getToolName(), nodeName});
            }
        }
        if (stdIn != null) {
            return this.doexecute(nodeName, args, env, stdIn, asUser);
        }
        toolLoc = toCopy != false ? this.m_destLoc : this.m_srcLoc;
        cmdStr = toolLoc + File.separator + this.m_toolName;
        this.enforceEnglishVars(env, args, true);
        Trace.out("m_bisCopied = " + this.m_bisCopied);
        cmd = new RemoteExecCommand(cmdStr, args, this.m_envs, nodeName, false, this.m_bisCopied != false ? null : this.m_deps, this.m_bisCopied != false ? null : this.m_srcLoc, this.m_winDllLoc, this.m_bisCopied != false ? null : this.m_destLoc, chkException);
        this.m_bisCopied = true;
        cmdSucc = false;
        ex = null;
        try {
            Trace.out("Calling RemoteExecCommand.execute(" + toCopy + ")");
            cmdSucc = cmd.execute(toCopy);
            ** if (toIgnore || cmdSucc && ex == null) goto lbl-1000
        }
        catch (ClusterException ce) {
            try {
                Trace.out("ClusterExceptionc occured. err msg:" + ce.getMessage());
                ex = ce;
                ** if (toIgnore || cmdSucc && ex == null) goto lbl-1000
            }
            catch (Throwable var17_33) {
                if (!(toIgnore || cmdSucc && ex == null)) {
                    Trace.out("RemoteExecCommand.execute failed. Command = " + cmdStr + " arguments = " + Arrays.toString(args) + " env = " + Arrays.toString(env));
                    errStr = cmd.getErrorString();
                    if (errStr == null) {
                        errStr = "";
                    }
                    Trace.out("Detailed error: " + errStr);
                    if (ex != null) {
                        Trace.out("exception: " + ex.getMessage());
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL_ERROR, (Throwable)ex, new Object[]{this.m_toolName, nodeName, errStr});
                    }
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL_ERROR, new Object[]{this.m_toolName, nodeName, errStr});
                }
                throw var17_33;
            }
lbl-1000:
            // 1 sources

            {
                Trace.out("RemoteExecCommand.execute failed. Command = " + cmdStr + " arguments = " + Arrays.toString(args) + " env = " + Arrays.toString(env));
                errStr = cmd.getErrorString();
                if (errStr == null) {
                    errStr = "";
                }
                Trace.out("Detailed error: " + errStr);
                if (ex != null) {
                    Trace.out("exception: " + ex.getMessage());
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL_ERROR, (Throwable)ex, new Object[]{this.m_toolName, nodeName, errStr});
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL_ERROR, new Object[]{this.m_toolName, nodeName, errStr});
            }
lbl-1000:
            // 1 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Trace.out("RemoteExecCommand.execute failed. Command = " + cmdStr + " arguments = " + Arrays.toString(args) + " env = " + Arrays.toString(env));
            errStr = cmd.getErrorString();
            if (errStr == null) {
                errStr = "";
            }
            Trace.out("Detailed error: " + errStr);
            if (ex != null) {
                Trace.out("exception: " + ex.getMessage());
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL_ERROR, (Throwable)ex, new Object[]{this.m_toolName, nodeName, errStr});
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL_ERROR, new Object[]{this.m_toolName, nodeName, errStr});
        }
lbl-1000:
        // 1 sources

        {
        }
        result = cmd.getCommandResult();
        cmd.clean();
        return result;
    }

    CommandResult execute(String[] args, String[] env) throws CmdToolUtilException {
        return this.doexecute(args, env, null, false, false);
    }

    CommandResult execute(String[] args, String[] env, boolean chkException) throws CmdToolUtilException {
        return this.doexecute(args, env, null, chkException, false);
    }

    CommandResult execute(String[] args, String[] env, boolean chkException, boolean toIgnore) throws CmdToolUtilException {
        return this.doexecute(args, env, null, chkException, toIgnore);
    }

    CommandResult execute(String[] args, String[] env, String user, boolean chkException, boolean toIgnore) throws CmdToolUtilException {
        return this.doexecute(args, env, user, chkException, toIgnore);
    }

    private CommandResult doexecute(String[] args, String[] env, String user, boolean chkException, boolean toIgnore) throws CmdToolUtilException {
        Object[] newargs;
        String cmdStr;
        if (args == null || Arrays.asList(args).contains(null)) {
            Trace.out("Command arguments: " + Arrays.toString(args));
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-doexecute-nullarg-02");
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem() || user == null || user.trim().length() == 0) {
            cmdStr = this.m_srcLoc + File.separator + this.m_toolName;
            newargs = args;
        } else {
            cmdStr = "/bin/su " + user + " " + "-c" + " \"" + this.m_srcLoc + File.separator + this.m_toolName;
            newargs = new String[args.length + 1];
            System.arraycopy(args, 0, newargs, 0, args.length);
            newargs[newargs.length - 1] = "\"";
        }
        CommandResult commandResult = new CommandResult();
        if (nativeSystem.isRemoteExecServerNeeded()) {
            try {
                String localHost = null;
                NativeResult nativeResult = new NativeResult();
                try {
                    localHost = Utils.getLocalHost();
                }
                catch (UnknownHostException e) {
                    Trace.out("UnknownHostException for retrieval of local host; msg= " + e.getMessage());
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.FAILED_TO_GET_LOCAL_NODE_NAME, new Object[0]);
                }
                if (!nativeSystem.isRemExecServiceRunning(localHost, nativeResult)) {
                    Trace.out("starting remote exec server on local node src=" + this.m_winDllLoc + " dest=" + this.m_destLoc);
                    nativeSystem.startRemoteExecServer(this.m_winDllLoc, this.m_destLoc);
                }
            }
            catch (NativeException ne) {
                Trace.out("nativeSystem.startRemoteExecServer failed");
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.REMOTEEXECSERVER_FAILED_ON_LOCAL_NODE, (Throwable)ne, new Object[0]);
            }
        }
        this.enforceEnglishVars(env, args, false);
        nativeSystem.runRemoteExecCmd(cmdStr, (String[])newargs, this.m_envs, commandResult, chkException, toIgnore);
        if (!toIgnore && !commandResult.getStatus()) {
            String outputStr = Arrays.toString(commandResult.getOutputString());
            if (outputStr.equals("null")) {
                outputStr = "";
            }
            String errorStr = commandResult.getErrorString();
            Trace.out("nativeSystem.runRemoteExecCmd failed. Command = " + cmdStr + " arguments = " + Arrays.toString(newargs) + " env = " + Arrays.toString(env) + " error = " + errorStr + " output = " + outputStr);
            errorStr = errorStr == null ? outputStr : outputStr + Constants.LINE_SEPARATOR + errorStr;
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_LOCAL_NODE_FAIL, this.m_toolName, errorStr);
        }
        return commandResult;
    }

    CommandResult execute(String node, String[] args, String[] env, String[] stdIn) throws CmdToolUtilException {
        if (node == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute2-node");
        }
        if (args == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute2-args");
        }
        if (env == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute2-env");
        }
        if (stdIn == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute2-stdIn");
        }
        return this.doexecute(node, args, env, stdIn, null);
    }

    CommandResult execute(String node, String[] args, String[] env, String[] stdIn, String asUser) throws CmdToolUtilException {
        if (node == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute3-node");
        }
        if (args == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute3-args");
        }
        if (env == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute3-env");
        }
        if (stdIn == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute3-stdIn");
        }
        if (asUser == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-execute3-asUser");
        }
        return this.doexecute(node, args, env, stdIn, asUser);
    }

    private CommandResult doexecute(String node, String[] args, String[] env, String[] stdIn, String asUser) throws CmdToolUtilException {
        Object[] newargs;
        String cmdStr;
        if (args == null || Arrays.asList(args).contains(null)) {
            Trace.out("Command arguments: " + Arrays.toString(args));
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-doexecute-nullarg-03");
        }
        if (this.m_uInfo != null) {
            return this.doexecute(node, args, env, stdIn, asUser, false, false, false, 36000);
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem() || asUser == null || asUser.trim().length() == 0) {
            cmdStr = this.m_srcLoc + File.separator + this.m_toolName;
            newargs = args;
        } else {
            cmdStr = "/bin/su " + asUser + " " + "-c" + " \"" + this.m_srcLoc + File.separator + this.m_toolName;
            newargs = new String[args.length + 1];
            System.arraycopy(args, 0, newargs, 0, args.length);
            newargs[newargs.length - 1] = "\"";
        }
        if (nativeSystem.isRemoteExecServerNeeded()) {
            try {
                NativeResult nativeRes = new NativeResult();
                if (!nativeSystem.isRemExecServiceRunning(node, nativeRes)) {
                    Trace.out((Object)"Starting remote exec server on node %s", node);
                    Trace.out("src=%s  dest=%s", this.m_winDllLoc, this.m_destLoc);
                    nativeSystem.startRemoteExecServer(node, this.m_winDllLoc, this.m_destLoc);
                }
            }
            catch (NativeException e) {
                Trace.out((Object)"NativeException: %s", e.getMessage());
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.REMOTEEXECSERVER_FAILED, (Throwable)e, new Object[0]);
            }
        }
        this.enforceEnglishVars(env, args, false);
        String res = nativeSystem.runCmd(cmdStr, (String[])newargs, this.m_envs, stdIn, node);
        CommandResult commandResult = new CommandResult(res);
        if (!commandResult.getStatus()) {
            Trace.out("nativeSystem.runCmd() failed");
            Trace.out((Object)"Command: %s", cmdStr);
            Trace.out((Object)"Arguments: %s", Arrays.toString(newargs));
            Trace.out((Object)"Environment variables: %s", Arrays.toString(this.m_envs));
            String outputStr = Arrays.toString(commandResult.getOutputString());
            if (outputStr.equals("null")) {
                outputStr = "";
            }
            Trace.out((Object)"Output: %s", outputStr);
            String errorStr = commandResult.getErrorString();
            Trace.out((Object)"Error: %s", errorStr);
            errorStr = errorStr == null ? outputStr : outputStr + Constants.LINE_SEPARATOR + errorStr;
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, (Throwable)new Exception(errorStr), this.m_toolName, node);
        }
        return commandResult;
    }

    CommandResult executeLocally(String[] args, String[] env) throws CmdToolUtilException {
        return this.doexecuteLocally(args, env, false, false);
    }

    CommandResult executeLocally(String[] args, String[] env, boolean eflag) throws CmdToolUtilException {
        return this.doexecuteLocally(args, env, eflag, false);
    }

    CommandResult executeLocally(String[] args, String[] env, boolean eflag, boolean toIgnore) throws CmdToolUtilException {
        return this.doexecuteLocally(args, env, eflag, toIgnore);
    }

    private CommandResult doexecuteLocally(String[] args, String[] env, boolean eflag, boolean toIgnore) throws CmdToolUtilException {
        int i;
        Object[] cmdArray;
        if (args == null || Arrays.asList(args).contains(null)) {
            Trace.out("Command arguments: " + Arrays.toString(args));
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CmdToolUtil-doexecuteLocally-nullarg-01");
        }
        String cmdStr = this.m_srcLoc + File.separator + this.m_toolName;
        if (!s_isUnixSystem && (cmdStr.endsWith(".bat") || cmdStr.endsWith(".cmd"))) {
            cmdArray = new String[args.length + 3];
            cmdArray[0] = "cmd.exe";
            cmdArray[1] = "/c";
            cmdArray[2] = cmdStr;
            i = 3;
        } else {
            cmdArray = new String[args.length + 1];
            cmdArray[0] = cmdStr;
            i = 1;
        }
        if (args.length > 0) {
            System.arraycopy(args, 0, cmdArray, i, args.length);
        }
        String osName = DeterminePlatform.getOSName();
        Trace.out("OS Name is..." + osName);
        this.enforceEnglishVars(env, args, false);
        RuntimeExec runtime = new RuntimeExec((String[])cmdArray, null, this.m_envs);
        int retval = runtime.runCommand();
        String[] cmdOutput = runtime.getOutput();
        String[] rtErr = runtime.getError();
        int exitVal = runtime.getExitValue();
        Trace.out("retval =  " + retval);
        Trace.out("exitval =  " + exitVal);
        Trace.out("rtErrLength =  " + rtErr.length);
        if ((retval != 0 || exitVal != 0 || rtErr.length > 0 && !eflag) && !toIgnore) {
            String error = "";
            if (rtErr != null && rtErr.length > 0) {
                error = CmdToolUtil.strList2List(Arrays.asList(rtErr), ",");
            }
            String output = "";
            if (cmdOutput != null && cmdOutput.length > 0) {
                output = CmdToolUtil.strList2List(Arrays.asList(cmdOutput), ",");
            }
            if (error == null || error.trim().isEmpty()) {
                error = output;
            } else if (output != null && !output.trim().isEmpty()) {
                error = output + Constants.LINE_SEPARATOR + error;
            }
            if (s_isUnixSystem && exitVal - 128 == 11) {
                new MessageBundle(MessageBundleList.FacilityList.PrCt);
                error = MessageBundle.getMessage(PrCtMsgID.SEGMENTATION_FAULT_ERROR, true, 11);
            }
            Trace.out("Failed to execute command.\n Command = " + Arrays.toString(cmdArray) + "\n env = " + Arrays.toString(env) + "\n error = " + error);
            Exception exp = runtime.getException();
            if (exp != null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_LOCAL_NODE_FAIL, (Throwable)exp, this.m_toolName, error);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_LOCAL_NODE_FAIL, this.m_toolName, error);
        }
        CommandResult result = new CommandResult();
        result.setStatus(true);
        result.setResultString(cmdOutput);
        result.setBooleanResult(true);
        return result;
    }

    public static String strList2List(List<String> l, String delim) {
        StringBuilder strBuf = new StringBuilder("");
        if (l != null) {
            boolean first = true;
            for (String item : l) {
                if (item.trim().isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    strBuf.append(delim);
                }
                strBuf.append(String.valueOf(item));
            }
        }
        return strBuf.toString();
    }

    private void enforceEnglishVars(String[] env, String[] args, boolean isRemote) {
        boolean innerOutput = false;
        int argLen = args.length;
        for (int indx = 0; indx < argLen; ++indx) {
            if (!args[indx].equals("-S") || indx >= argLen - 1 || !args[indx + 1].equals("1")) continue;
            innerOutput = true;
            break;
        }
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            Trace.out("NT platform, do not add language env variables");
            this.m_envs = env;
        } else {
            if ((env == null || env.length == 0) && innerOutput) {
                return;
            }
            ArrayList<String> environment = env != null && env.length > 0 ? new ArrayList<String>(Arrays.asList(env)) : new ArrayList<String>(3);
            String osName = DeterminePlatform.getOSName();
            if (!innerOutput) {
                Trace.out("Set environment for English language");
                Trace.out("OS Name is..." + osName);
                if (osName.equals("HP-UX")) {
                    environment.add(LANG_ENG_HP);
                    environment.add(LC_ALL_ENG_HP);
                } else {
                    environment.add(LANG_ENG);
                    environment.add(LC_ALL_ENG);
                }
                environment.add(NLS_LANG_ENG);
            }
            this.m_envs = environment.toArray(new String[environment.size()]);
            if (Utils.isDevelopmentEnv() && !isRemote) {
                Trace.out("Development environment, inherit variables");
                this.inheritEnvironment(osName);
            }
        }
    }

    private void inheritEnvironment(String osName) {
        Trace.out("Copy and merge current environment with specified env variables");
        HashMap<String, String> currentEnv = new HashMap<String, String>(System.getenv());
        ArrayList<String> execEnv = new ArrayList<String>();
        Trace.out("Env value of SRVM_TRACE is : " + (String)currentEnv.get("SRVM_TRACE"));
        currentEnv.remove("SRVM_TRACE");
        Trace.out("After remove, Env value of SRVM_TRACE is : " + (String)currentEnv.get("SRVM_TRACE"));
        if (this.m_envs != null) {
            for (String element : this.m_envs) {
                String[] splitVar = element.split("=");
                if (currentEnv.containsKey(splitVar[0])) {
                    currentEnv.remove(splitVar[0]);
                }
                currentEnv.put(splitVar[0], splitVar.length == 1 ? "" : splitVar[1]);
            }
        }
        for (Map.Entry var : currentEnv.entrySet()) {
            String envKey = (String)var.getKey();
            String envValue = (String)var.getValue();
            if (osName.equals("HP-UX") && this.m_toolName.equals("srvctl") && envKey.contains("PATH")) {
                Trace.out("Skip adding environment variable " + envKey);
                continue;
            }
            execEnv.add(envKey + "=" + envValue);
        }
        this.m_envs = execEnv.toArray(new String[execEnv.size()]);
    }

    public String getToolName() {
        return this.m_toolName;
    }

    public String getSourceLocation() {
        return this.m_srcLoc;
    }

    static String getSourceLocation(String classLocation, String cmd) throws CmdToolUtilException {
        Object cmdlocation = null;
        if (classLocation == null) {
            return null;
        }
        String binsubdir = FSEP + "bin";
        String extbinsubdir = FSEP + "ext" + binsubdir;
        String orabinsubdir = FSEP + "oracle" + binsubdir;
        String bincmd = FSEP + "bin" + FSEP + cmd;
        String extbincmd = FSEP + "ext" + bincmd;
        String orabincmd = FSEP + "oracle" + bincmd;
        String cmdPath = classLocation;
        File classfile = null;
        File parentfile = null;
        for (int i = 0; i < 3 && (parentfile = (classfile = new File(cmdPath)).getParentFile()) != null; ++i) {
            cmdPath = parentfile.getAbsolutePath();
            Trace.out("GetSourceLocation: Check " + cmdPath);
            if (new File(cmdPath + bincmd).exists()) {
                return cmdPath + binsubdir;
            }
            if (new File(cmdPath + extbincmd).exists()) {
                return cmdPath + extbinsubdir;
            }
            if (!new File(cmdPath + orabincmd).exists()) continue;
            return cmdPath + orabinsubdir;
        }
        Trace.out("Can not determine the location for command " + cmd);
        return null;
    }

    static String getClassLocation(Class claz) {
        Class qualifiedClassObject = claz;
        String qualifiedClassName = qualifiedClassObject.getName();
        ProtectionDomain protectionDomain = null;
        try {
            protectionDomain = qualifiedClassObject.getProtectionDomain();
        }
        catch (SecurityException se) {
            Trace.out("The security manager of class \"" + qualifiedClassName + "\" doesn't allow getting the ProtectionDomain.");
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            Trace.out("Unknown code source for class " + qualifiedClassName);
            return null;
        }
        String location = codeSource.getLocation().getPath();
        Trace.out("The code source location is " + location);
        File classfile = new File(location);
        String classlocation = classfile.getAbsolutePath();
        Trace.out("The class location is " + classlocation);
        return classlocation;
    }
}

