/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class AFDDriverUtil {
    private static final String EXE_LOC = "bin";
    private static final String AFD_DRIVER_STATE = "afddriverstate";
    private static final String AFD_DRIVER_STATE_OH_OPTION = "-orahome";
    private static final String AFD_DRIVER = new SystemFactory().CreateSystem().getScriptFileName("afddriverstate");
    private final String[] AFD_DRIVER_DEP = new String[]{AFD_DRIVER};
    private static final String AFD_SUPPORTED = "AFD-9200";
    private static final String AFD_NOT_SUPPORTED = "AFD-9201";
    private static final String AFD_OS_NOT_SUPP = "AFD-618";
    private static final String AFD_INSTALLED = "AFD-9203";
    private static final String AFD_NOT_INSTALLED = "AFD-9204";
    private static final String AFD_LOADED = "AFD-9205";
    private static final String AFD_NOT_LOADED = "AFD-9206";
    private static final String NEWLINE = System.getProperty("line.separator");
    private String m_crsHome;
    private CmdToolUtil m_cmdtool;

    public AFDDriverUtil(String crsHome) throws CmdToolUtilException {
        String driverLoc = crsHome + File.separator + EXE_LOC;
        File afdFileDriver = new File(driverLoc + File.separator + AFD_DRIVER);
        Trace.out("Checking file exists for: " + afdFileDriver);
        if (!afdFileDriver.exists()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.AFD_DRIVER_NOT_FOUND, crsHome, EXE_LOC + File.separator + AFD_DRIVER);
        }
        this.m_cmdtool = new CmdToolUtil(AFD_DRIVER, driverLoc, this.AFD_DRIVER_DEP);
    }

    public boolean checkAFDState(AFDDriverState state, String oracleHome) throws CmdToolUtilException {
        return this.checkAFDState(state, oracleHome, "localnode");
    }

    public boolean checkAFDState(AFDDriverState state, String oracleHome, String nodename) throws CmdToolUtilException {
        String[] resultArr;
        if (state == null) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "state");
        }
        CmdToolUtil.assertDir(oracleHome, true);
        CmdToolUtil.assertNode(nodename);
        String[] args = new String[]{AFD_DRIVER_STATE_OH_OPTION, oracleHome, state.toString()};
        NativeResult result = null;
        if (nodename != null && !nodename.equals("")) {
            result = this.m_cmdtool.execute(nodename, args, null, false, true, true);
        }
        if (result != null && !result.getBooleanResult()) {
            Trace.out("result is negative");
            String[] errorString = result.getResultString();
            String[] outputString = result.getOutputString();
            String[] useString = errorString != null && errorString.length > 0 ? errorString : (outputString != null && outputString.length > 0 ? outputString : null);
            if (useString != null) {
                Trace.out("useString = " + Utils.getString(useString, NEWLINE));
                Trace.out("useString size = " + useString.length);
                for (int i = 0; i < useString.length; ++i) {
                    Trace.out(useString[i]);
                }
                return this.processState(state, useString, nodename);
            }
        }
        if ((resultArr = result.getResultString()) != null && resultArr.length > 0) {
            Trace.out("Printing AFD output");
            Trace.out(Utils.getString(resultArr, NEWLINE));
            return this.processState(state, resultArr, nodename);
        }
        if (nodename.equals("localnode")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.AFD_DRIVER_NO_OUTPUT, state.toString());
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.AFD_DRIVER_NO_OUTPUT_NODE, state.toString(), nodename);
    }

    private boolean processState(AFDDriverState state, String[] output, String nodename) throws CmdToolUtilException {
        if (state == AFDDriverState.SUPPORTED) {
            return this.processOutput(output, AFD_SUPPORTED, AFD_NOT_SUPPORTED, nodename, state);
        }
        if (state == AFDDriverState.INSTALLED) {
            return this.processOutput(output, AFD_INSTALLED, AFD_NOT_INSTALLED, nodename, state);
        }
        if (state == AFDDriverState.LOADED) {
            return this.processOutput(output, AFD_LOADED, AFD_NOT_LOADED, nodename, state);
        }
        return false;
    }

    private boolean processOutput(String[] output, String passed, String notPassed, String nodename, AFDDriverState state) throws CmdToolUtilException {
        if (output[0].indexOf(passed) >= 0) {
            return true;
        }
        for (String out : output) {
            if (!out.contains(notPassed) && !out.contains(AFD_OS_NOT_SUPP)) continue;
            return false;
        }
        return false;
    }

    public static enum AFDDriverState {
        SUPPORTED("supported"),
        INSTALLED("installed"),
        LOADED("loaded");

        private String m_state;

        private AFDDriverState(String state) {
            this.m_state = state;
        }

        public String toString() {
            return this.m_state;
        }
    }
}

