/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cha;

import oracle.cluster.cha.CHA;
import oracle.cluster.cha.CHADBConnection;
import oracle.cluster.cha.CHAException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.DBConnectionException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.impl.cha.CHAFactoryImpl;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;

public class CHAFactory {
    private static CHAFactory s_instance;
    private CHAFactoryImpl s_factoryImpl = CHAFactoryImpl.getInstance();

    private CHAFactory() throws SoftwareModuleException {
    }

    public static synchronized CHAFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new CHAFactory();
        }
        return s_instance;
    }

    public CHA createCHA(Version version, boolean force) throws AlreadyExistsException, CHAException {
        return this.s_factoryImpl.createCHA(version, force);
    }

    public CHA getCHA() throws NotExistsException, CHAException {
        return this.s_factoryImpl.getCHA();
    }

    public CHADBConnection createDBConnection() throws CHAException, DBConnectionException, DatabaseException {
        return this.s_factoryImpl.createDBConnection();
    }
}

