/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cha;

import oracle.cluster.cha.CompositeCHAStatus;
import oracle.cluster.common.SoftwareModuleException;
import oracle.ops.mgmt.nls.MessageKey;

public class CHAException
extends SoftwareModuleException {
    private static final String LSEP = System.getProperty("line.separator");
    private String m_msg = null;
    private CompositeCHAStatus m_ccs = null;

    public CHAException(MessageKey key, Object ... args) {
        super(key, args);
    }

    public CHAException(MessageKey key, Throwable cause, Object ... args) {
        super(key, cause, args);
    }

    public CHAException(MessageKey key, String msg, Object ... args) {
        super(key, args);
        this.m_msg = msg;
    }

    public CHAException(MessageKey key, CompositeCHAStatus ccs, Object ... args) {
        super(key, args);
        this.m_ccs = ccs;
    }

    public CHAException(MessageKey key, Throwable cause, CompositeCHAStatus ccs, Object ... args) {
        super(key, cause, args);
        this.m_ccs = ccs;
    }

    public CHAException(MessageKey key, String msg, CompositeCHAStatus ccs, Object ... args) {
        super(key, args);
        this.m_msg = msg;
        this.m_ccs = ccs;
    }

    public CHAException(MessageKey key, Throwable cause, String msg, CompositeCHAStatus ccs, Object ... args) {
        super(key, cause, args);
        this.m_ccs = ccs;
    }

    public CHAException(Throwable cause) {
        super(cause);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        StringBuilder failedMsg = new StringBuilder();
        String causedByMsg = super.getMessage();
        if (causedByMsg.length() != 0) {
            failedMsg.append(causedByMsg);
            failedMsg.append(LSEP);
        }
        if (this.m_msg != null) {
            failedMsg.append(this.m_msg);
            failedMsg.append(LSEP);
        }
        return failedMsg.toString();
    }

    public CompositeCHAStatus getCompositeCHAStatus() {
        return this.m_ccs;
    }
}

