/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.adminhelper;

import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.adminhelper.AdminHelperFactoryImpl;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;

public class AdminHelperFactory {
    private static AdminHelperFactory s_instance;
    private AdminHelperFactoryImpl s_factoryImpl = AdminHelperFactoryImpl.getInstance();

    private AdminHelperFactory() throws SoftwareModuleException {
    }

    public static synchronized AdminHelperFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new AdminHelperFactory();
        }
        return s_instance;
    }

    public AdminHelper createAdminHelper(Version version) throws AlreadyExistsException, AdminHelperException {
        return this.s_factoryImpl.createAdminHelper(version);
    }

    public AdminHelper createAdminHelper(String resourceName, Version version) throws AlreadyExistsException, AdminHelperException {
        return this.s_factoryImpl.createAdminHelper(resourceName, version);
    }

    public AdminHelper getAdminHelper() throws NotExistsException, AdminHelperException {
        return this.s_factoryImpl.getAdminHelper();
    }

    public AdminHelper getAdminHelper(String resourceName) throws NotExistsException, AdminHelperException {
        return this.s_factoryImpl.getAdminHelper(resourceName);
    }
}

