/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.adminhelper;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.cluster.adminhelper.AdminResult;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.helper.HelperUtil;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class AdminHelperException
extends SoftwareModuleException {
    private Map<String, AdminResult> errMap = new LinkedHashMap<String, AdminResult>();
    private static final String LSEP = System.getProperty("line.separator");

    public AdminHelperException(MessageKey key, Map<String, AdminResult> errMsgMap) {
        super(key, new Object[0]);
        this.errMap = errMsgMap;
    }

    public AdminHelperException(MessageKey key, Object ... args) {
        super(key, args);
    }

    public AdminHelperException(MessageKey key, Throwable cause, Object ... args) {
        super(key, cause, args);
    }

    public AdminHelperException(Throwable cause) {
        super(cause);
    }

    public Map<String, AdminResult> getErrorMap() {
        return this.errMap;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String getKeyMessage() {
        StringBuilder failedMsg = new StringBuilder();
        failedMsg.append(super.getMessage());
        return failedMsg.toString();
    }

    public String getNodeOutputError() {
        StringBuilder failedMsg = new StringBuilder();
        for (String node : this.errMap.keySet()) {
            Trace.out(node + " : " + this.errMap.get(node).getStatus() + " : " + this.errMap.get(node).getMsg());
            String[] retStrArr = HelperUtil.fetchError(this.errMap.get(node).getMsg().split(LSEP));
            if (retStrArr == null) continue;
            failedMsg.append(node + " : ");
            for (int i = 0; i < retStrArr.length; ++i) {
                failedMsg.append(LSEP);
                failedMsg.append(retStrArr[i]);
            }
        }
        return failedMsg.toString();
    }

    @Override
    public String getMessage() {
        StringBuilder failedMsg = new StringBuilder();
        failedMsg.append(super.getMessage());
        if (this.errMap.size() != 0) {
            for (String node : this.errMap.keySet()) {
                int i;
                String[] retStrArr;
                Trace.out(node + " : " + this.errMap.get(node).getStatus() + " : " + this.errMap.get(node).getMsg());
                if (failedMsg.length() == 0) {
                    retStrArr = HelperUtil.fetchError(this.errMap.get(node).getMsg().split(LSEP));
                    if (retStrArr == null) continue;
                    failedMsg.append(node + " : ");
                    for (i = 0; i < retStrArr.length; ++i) {
                        failedMsg.append(LSEP);
                        failedMsg.append(retStrArr[i]);
                    }
                    continue;
                }
                failedMsg.append(LSEP);
                retStrArr = HelperUtil.fetchError(this.errMap.get(node).getMsg().split(LSEP));
                if (retStrArr == null) continue;
                failedMsg.append(node + " : ");
                for (i = 0; i < retStrArr.length; ++i) {
                    failedMsg.append(LSEP);
                    failedMsg.append(retStrArr[i]);
                }
            }
        }
        return failedMsg.toString();
    }

    public AdminHelperException(String msg) {
        super(msg);
    }
}

