/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.HashMap;
import oracle.help.common.WindowType;
import oracle.help.library.Book;

public class WindowTypeRepository {
    private HashMap _table = new HashMap();
    private WindowType _default = new WindowType(null);

    public void addWindowType(WindowType windowType) {
        if (windowType != null) {
            this._table.put(windowType.getName(), windowType);
            if (windowType.isDefault()) {
                this._default = windowType;
            }
        }
    }

    public void removeWindowType(WindowType windowType) {
        if (windowType != null && this._table.containsValue(windowType)) {
            this._table.remove(windowType.getName());
            if (windowType == this._default) {
                this._default = null;
            }
        }
    }

    public void addWindowTypesInBook(Book book) {
        WindowType[] windowTypeArray = book.getWindowTypes();
        if (windowTypeArray != null) {
            for (int i = 0; i < windowTypeArray.length; ++i) {
                this.addWindowType(windowTypeArray[i]);
            }
        }
    }

    public void removeWindowTypesInBook(Book book) {
        WindowType[] windowTypeArray = book.getWindowTypes();
        if (windowTypeArray != null) {
            for (int i = 0; i < windowTypeArray.length; ++i) {
                this.removeWindowType(windowTypeArray[i]);
            }
        }
    }

    public WindowType getWindowType(String string) {
        return (WindowType)this._table.get(string);
    }

    public WindowType getDefaultWindowType() {
        return this._default;
    }
}

