/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.ArrayList;
import java.util.EventListener;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.Topic;
import oracle.help.common.View;

public class TopicTreeNode {
    private TopicTreeNode _parent;
    private ArrayList _children;
    private Topic _topic;
    private Object _clientData;
    private View _view;
    private ListenerManager _manager;

    public TopicTreeNode(View view) {
        this(view, null);
    }

    public TopicTreeNode(View view, Topic topic) {
        this(view, topic, null);
    }

    public TopicTreeNode() {
    }

    public TopicTreeNode(View view, Topic topic, TopicTreeNode topicTreeNode) {
        this._view = view;
        this._parent = topicTreeNode;
        this._topic = topic;
        this._children = null;
        this._clientData = null;
    }

    public View getView() {
        return this._view;
    }

    public TopicTreeNode getParent() {
        return this._parent;
    }

    public void setParent(TopicTreeNode topicTreeNode) {
        this._parent = topicTreeNode;
    }

    public ArrayList getChildren() {
        if (this._children == null) {
            this._children = new ArrayList(5);
        }
        return this._children;
    }

    public TopicTreeNode getChildByIndex(int n) throws IndexOutOfBoundsException {
        TopicTreeNode topicTreeNode = null;
        if (n >= this.getNumChildren()) {
            throw new IndexOutOfBoundsException("Child Index out of Bounds");
        }
        topicTreeNode = (TopicTreeNode)this.getChildren().get(n);
        return topicTreeNode;
    }

    public int removeChild(TopicTreeNode topicTreeNode) {
        int n = this.getChildren().indexOf(topicTreeNode);
        if (n != -1) {
            this.getChildren().remove(n);
        }
        return n;
    }

    public boolean isBranch() {
        return this.getNumChildren() > 0;
    }

    public int getNumChildren() {
        ArrayList arrayList = this.getChildren();
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    public Topic getTopic() {
        return this._topic;
    }

    public Topic[] getAllTopicsInSubTree() {
        ArrayList arrayList = new ArrayList();
        this._recursiveTopicHelper(this, arrayList);
        Topic[] topicArray = null;
        if (arrayList.size() > 0) {
            topicArray = new Topic[arrayList.size()];
            arrayList.toArray(topicArray);
        }
        return topicArray;
    }

    public void setTopic(Topic topic) {
        this._topic = topic;
    }

    public TopicTreeNode addChild(TopicTreeNode topicTreeNode) {
        topicTreeNode.setParent(this);
        this.getChildren().add(topicTreeNode);
        return topicTreeNode;
    }

    public void clearChildren() {
        if (this.getChildren() != null) {
            this.getChildren().clear();
        }
    }

    public boolean isTraversable() {
        return true;
    }

    public boolean allowsChildMerging() {
        return true;
    }

    public boolean hasChildren() {
        ArrayList arrayList = this.getChildren();
        if (arrayList == null) {
            return false;
        }
        return !arrayList.isEmpty();
    }

    public void setClientData(Object object) {
        this._clientData = object;
    }

    public Object getClientData() {
        return this._clientData;
    }

    public void addModelListener(EventListener eventListener) {
        if (eventListener != null) {
            if (this._manager == null) {
                this._manager = new ListenerManager();
            }
            this._manager.addListener(eventListener);
        }
    }

    public void removeModelListener(EventListener eventListener) {
        if (eventListener != null && this._manager != null) {
            this._manager.removeListener(eventListener);
        }
    }

    public ListenerManager getListenerManager() {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        return this._manager;
    }

    final void __setChildrenDirectly(ArrayList arrayList) {
        this._children = arrayList;
    }

    final ArrayList __getChildrenDirectly() {
        return this._children;
    }

    private void _recursiveTopicHelper(TopicTreeNode topicTreeNode, ArrayList arrayList) {
        if (topicTreeNode != null) {
            ArrayList arrayList2;
            Topic topic = topicTreeNode.getTopic();
            if (topic != null) {
                arrayList.add(topic);
            }
            if ((arrayList2 = topicTreeNode.getChildren()) != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    TopicTreeNode topicTreeNode2 = (TopicTreeNode)arrayList2.get(i);
                    this._recursiveTopicHelper(topicTreeNode2, arrayList);
                }
            }
        }
    }
}

