/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.HashMap;
import oracle.help.common.AssociativeLink;
import oracle.help.common.MergingAssociativeLink;
import oracle.help.library.Book;

public class AssociativeLinkRepository {
    private HashMap _linkTable = new HashMap();

    public void addLink(AssociativeLink associativeLink) {
        if (associativeLink != null) {
            String string = associativeLink.getLinkID();
            AssociativeLink associativeLink2 = (AssociativeLink)this._linkTable.get(string);
            if (associativeLink2 == null) {
                this._linkTable.put(string, associativeLink);
            } else {
                MergingAssociativeLink mergingAssociativeLink;
                if (associativeLink2 instanceof MergingAssociativeLink) {
                    mergingAssociativeLink = (MergingAssociativeLink)associativeLink2;
                } else {
                    mergingAssociativeLink = new MergingAssociativeLink(string);
                    mergingAssociativeLink.addAssociativeLink(associativeLink2);
                    this._linkTable.put(string, mergingAssociativeLink);
                }
                mergingAssociativeLink.addAssociativeLink(associativeLink);
            }
        }
    }

    public void removeLink(AssociativeLink associativeLink) {
        AssociativeLink associativeLink2;
        if (associativeLink != null && (associativeLink2 = (AssociativeLink)this._linkTable.get(associativeLink.getLinkID())) != null) {
            if (associativeLink2 instanceof MergingAssociativeLink) {
                ((MergingAssociativeLink)associativeLink2).removeAssociativeLink(associativeLink);
            } else {
                this._linkTable.remove(associativeLink.getLinkID());
            }
        }
    }

    public void addLinksInBook(Book book) {
        AssociativeLink[] associativeLinkArray = book.getAssociativeLinks();
        if (associativeLinkArray != null) {
            for (int i = 0; i < associativeLinkArray.length; ++i) {
                this.addLink(associativeLinkArray[i]);
            }
        }
    }

    public void removeLinksInBook(Book book) {
        AssociativeLink[] associativeLinkArray = book.getAssociativeLinks();
        if (associativeLinkArray != null) {
            for (int i = 0; i < associativeLinkArray.length; ++i) {
                this.removeLink(associativeLinkArray[i]);
            }
        }
    }

    public AssociativeLink getLink(String string) {
        return (AssociativeLink)this._linkTable.get(string);
    }
}

