/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.text.MessageFormat;
import oracle.sysman.oix.oixs.OixsXMLConstants;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Parser;

public class OixsXMLOps
implements OixsXMLConstants {
    public static Parser createSAXParser(boolean bDTDValidate, boolean bSchemaValidate) {
        SAXParser parser = new SAXParser();
        if (!bDTDValidate) {
            parser.setValidationMode(0);
        } else {
            parser.setValidationMode(bDTDValidate);
        }
        return parser;
    }

    public static Parser createSAXParser() {
        return OixsXMLOps.createSAXParser(false, false);
    }

    public static DOMParser createDOMParser() {
        return new DOMParser();
    }

    public static String createXMLDirective(boolean bStandalone) {
        String sYesOrNo = "yes";
        if (!bStandalone) {
            sYesOrNo = "no";
        }
        String sXML = MessageFormat.format("<?xml version=\"1.0\" standalone=\"{0}\" ?>", sYesOrNo);
        return sXML;
    }

    public static String getStandardHeader() {
        return HEADER;
    }

    public static String getCopyRight() {
        return COPYRIGHT;
    }

    public static String getStartTag(XMLElement element) {
        NamedNodeMap attrMap = element.getAttributes();
        StringBuffer sbTag = new StringBuffer("<" + element.getTagName());
        int attrCount = attrMap.getLength();
        for (int i = 0; i < attrCount; ++i) {
            Node attrNode = attrMap.item(i);
            sbTag.append(" ");
            sbTag.append(attrNode.getNodeName() + "=\"" + attrNode.getNodeValue() + "\"");
        }
        sbTag.append(">");
        return sbTag.toString();
    }

    public static String getEndTag(XMLElement element) {
        return "</" + element.getTagName() + ">";
    }

    public static boolean isEmpty(XMLElement element) {
        if (element == null) {
            return true;
        }
        if (element.hasChildNodes()) {
            return false;
        }
        NamedNodeMap nnm = element.getAttributes();
        return nnm == null || nnm.getLength() <= 0;
    }
}

