/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.util.Hashtable;
import java.util.Stack;
import oracle.sysman.oix.oixs.OixsAttributeListImpl;
import oracle.sysman.oix.oixs.OixsUnknownElementHandler;
import oracle.xml.parser.v2.XMLElement;
import org.xml.sax.AttributeList;

public class OixsElementHandler {
    private Hashtable m_childHandlers = new Hashtable();
    private String m_sName;
    private OixsUnknownElementHandler m_unknownElementHandler;

    public OixsElementHandler() {
    }

    public OixsElementHandler(String name) {
        this.m_sName = name;
    }

    public void addChildHandler(String name, OixsElementHandler handler) {
        this.m_childHandlers.put(name, handler);
    }

    public String getName() {
        return this.m_sName;
    }

    public void startElement(String name, AttributeList attributes, Stack handlers) {
        OixsElementHandler childHandler = (OixsElementHandler)this.m_childHandlers.get(name);
        if (childHandler == null) {
            if (this.m_unknownElementHandler == null) {
                this.m_unknownElementHandler = new OixsUnknownElementHandler(this.m_sName);
            }
            childHandler = this.m_unknownElementHandler;
        }
        handlers.push(childHandler);
        OixsAttributeListImpl oai = new OixsAttributeListImpl(attributes);
        childHandler.onStart(name, oai);
        childHandler.setUnknownElementHandler(name, oai);
    }

    public void endElement(String name, Stack handlers) {
        this.onEnd(name);
        handlers.pop();
    }

    public void onText(char[] chars, int start, int length) {
    }

    public Object getObject() {
        return null;
    }

    public void onStart(String name, AttributeList atts) {
    }

    public void onEnd(String name) {
    }

    protected OixsElementHandler getChildHandler(String name) {
        OixsElementHandler handler = null;
        handler = (OixsElementHandler)this.m_childHandlers.get(name);
        return handler;
    }

    void setUnknownElementHandler(String name, AttributeList atts) {
        this.m_unknownElementHandler = new OixsUnknownElementHandler(name);
        this.m_unknownElementHandler.setElementAttributes(atts);
    }

    public XMLElement getUnknownXMLElement() {
        if (this.m_unknownElementHandler != null) {
            return this.m_unknownElementHandler.getElement();
        }
        return null;
    }
}

