/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.util.Stack;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OixsDefaultHandler
extends HandlerBase {
    private Stack m_handlers = new Stack();
    private boolean m_bRootHandled = false;

    public OixsDefaultHandler() throws SAXException {
        OixsElementHandler root = this.createElementHandlers();
        if (root == null) {
            throw new SAXException("Null root handler");
        }
        this.m_handlers.push(root);
    }

    @Override
    public void startElement(String name, AttributeList attributes) throws SAXException {
        OixsElementHandler handler = (OixsElementHandler)this.m_handlers.peek();
        if (!this.m_bRootHandled) {
            handler.onStart(name, attributes);
            handler.setUnknownElementHandler(name, attributes);
            this.m_bRootHandled = true;
        } else {
            handler.startElement(name, attributes, this.m_handlers);
        }
    }

    @Override
    public void endElement(String name) throws SAXException {
        OixsElementHandler handler = (OixsElementHandler)this.m_handlers.peek();
        handler.endElement(name, this.m_handlers);
    }

    protected OixsElementHandler createElementHandlers() {
        return null;
    }

    @Override
    public void characters(char[] chars, int nStart, int nLength) throws SAXException {
        OixsElementHandler handler = (OixsElementHandler)this.m_handlers.peek();
        handler.onText(chars, nStart, nLength);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.warning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.fatalError(e);
    }
}

