/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixp;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIRegHandler;

public class OixpMultiHandler
implements OixpIRegHandler {
    private Hashtable m_handlerTable = new Hashtable();
    private int m_tagDepth = 0;
    private OixpIHandler m_curHandler = null;

    @Override
    public String[] getTagsForRegistration() {
        int numKeys = this.m_handlerTable.size();
        String[] retTags = new String[numKeys];
        Enumeration keys = this.m_handlerTable.keys();
        for (int i = 0; i < numKeys && keys.hasMoreElements(); ++i) {
            retTags[i] = (String)keys.nextElement();
        }
        return retTags;
    }

    public void registerHandler(OixpIRegHandler handler) {
        this.registerHandler(handler, false);
    }

    public void registerHandler(OixpIRegHandler handler, boolean checkExist) {
        String[] tagTypes = handler.getTagsForRegistration();
        for (int i = 0; i < tagTypes.length; ++i) {
            this.registerHandler(tagTypes[i], handler, checkExist);
        }
    }

    public void registerHandler(String tagType, OixpIHandler handler) {
        this.registerHandler(tagType, handler, false);
    }

    public void registerHandler(String tagType, OixpIHandler handler, boolean checkExist) {
        tagType = tagType.toUpperCase();
        if (!checkExist || this.m_handlerTable.get(tagType) == null) {
            this.m_handlerTable.put(tagType, handler);
        }
    }

    public boolean isTagRegistered(String tagType) {
        return this.m_handlerTable.get(tagType.toUpperCase()) != null;
    }

    public OixpIHandler getHandler(String tagType) {
        return (OixpIHandler)this.m_handlerTable.get(tagType.toUpperCase());
    }

    @Override
    public boolean doStartTag(OixpIElement el) {
        boolean retValue = false;
        if (this.m_curHandler == null) {
            this.m_curHandler = this.getHandler(el.getType());
        }
        if (this.m_curHandler != null) {
            retValue = this.m_curHandler.doStartTag(el);
            ++this.m_tagDepth;
        }
        return retValue;
    }

    @Override
    public boolean doText(OixpIElement el, String text) {
        boolean retValue = false;
        if (this.m_curHandler != null) {
            retValue = this.m_curHandler.doText(el, text);
        }
        return retValue;
    }

    @Override
    public boolean doEndTag(OixpIElement el) {
        boolean retValue = false;
        if (this.m_curHandler != null) {
            retValue = this.m_curHandler.doEndTag(el);
        }
        --this.m_tagDepth;
        if (this.m_tagDepth < 0) {
            this.m_tagDepth = 0;
        }
        if (this.m_tagDepth == 0) {
            this.m_curHandler = null;
        }
        return retValue;
    }
}

