/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiiz;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiCdLabel;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryEnvUpdater;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiLibraryIDPool;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageAreaControl;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiim.OiimCompInfo;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodDepRuleNode;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngErrListener;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFileWriter;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisFileEntry;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisMakeDeps;
import oracle.sysman.oii.oiis.OiisMakeDepsReader;
import oracle.sysman.oii.oiis.OiisPatchInstallation;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisRelinkInfo;
import oracle.sysman.oii.oiis.OiisSize;
import oracle.sysman.oii.oiis.OiisStagedCompHelper;
import oracle.sysman.oii.oiis.OiisStagedCompRep;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixIniComment;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixIniPair;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import oracle.sysman.oii.oiix.OiixIniRawText;
import oracle.sysman.oii.oiix.OiixIniSection;
import oracle.sysman.oii.oiix.OiixJarModifier;
import oracle.sysman.oii.oiix.OiixJarModifierPool;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oii.oiiz.OiizCDStager;
import oracle.sysman.oii.oiiz.OiizCallback;
import oracle.sysman.oii.oiiz.OiizConfigMasterGenerator;
import oracle.sysman.oii.oiiz.OiizInterCompLangIdxMap;
import oracle.sysman.oii.oiiz.OiizResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLConstants;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiizStageVerifier
implements OiicInstallTimeSession,
OiiodIDepEngErrListener,
OiiiInventoryEnvUpdater {
    private static final String DELIMITER = "::";
    private static final String QUOTES = "\"";
    private static final String OPENBRACE = "{";
    private static final String CLOSEBRACE = "}";
    private static final String COMMA = ",";
    private static final String COMPONENT = "component";
    private static final String PATCH = "patch";
    private static final String INTERNALNAME_DELIMITER = ".";
    private static final int SHORT_INTERNALNAME_SIZE = 3;
    public static final String S_FASTCOPY_METADATA = "fastcopy.xml";
    public static final String S_FASTCOPY_FOLDER = "fastcopy";
    public static final String S_FILEMAP_FOLDER = "filemap";
    public static final String S_SETPERMS_SCRIPT_BASE = "setperms";
    public static final String S_SETPERMS_SCRIPT_EXT = ".sh";
    public static final String S_FILES_MAP = "files.map";
    public static final String S_FILEMAP_JAR_SUFFIX = "_filemap.jar";
    public static final String S_RACFILES_JAR = "racfiles.jar";
    public static final int I_MAX_CMD_LINE_CHARS = 2047;
    public static final int I_MAX_CMD_LINE_ARGS = 255;
    public static final int I_MAX_CMD_LINE_ARG_LEN = 255;
    private static final int UPDATE_SIZES_BIT = 0;
    private static final int GENERATE_RESPONSE_FILE_BIT = 1;
    private static final int DELETE_COMPONENT_BIT = 2;
    private static final int ARRANGE_TOP_LEVEL_COMPS_BIT = 3;
    private static final int VALIDATE_STAGE_BIT = 4;
    private static final int REPORT_SUPERFUOUS_COMPS_BIT = 5;
    private static final int MERGE_STAGE_BIT = 6;
    private static final int GENERATE_CONFIG_MASTER_BIT = 7;
    private static final int UPDATE_CONFIG_MASTER_BIT = 8;
    private static final int MAKE_TEMPLATE_BIT = 10;
    private static final int UPDATE_SIZES = 1;
    private static final int GENERATE_RESPONSE_FILE = 2;
    private static final int DELETE_COMPONENT = 4;
    private static final int ARRANGE_TOP_LEVEL_COMPS = 8;
    private static final int VALIDATE_STAGE = 16;
    private static final int REPORT_SUPERFUOUS_COMPS = 32;
    private static final int MERGE_STAGE = 64;
    private static final int GENERATE_CONFIG_MASTER = 128;
    private static final int UPDATE_CONFIG_MASTER = 256;
    private OiizConfigMasterGenerator m_oConfigGenerator;
    private static final int MAKE_TEMPLATE = 1024;
    private int m_iOperationsPerformed = -1;
    private boolean m_bStageModified = false;
    private boolean m_bDisposed = false;
    private static boolean s_debug = false;
    private boolean m_bRespFileExists = false;
    private OiiiStageInventory m_stageInv;
    private Hashtable m_oIDsToInvEntriesTable;
    private String m_sInvLoc;
    private String m_sourceRoot;
    private String m_sStageLoc;
    private Hashtable m_IEsToComps;
    private Hashtable m_IDsToPSets;
    private static String sNewLine = System.getProperty("line.separator");
    private String sCommentChar = OiizResourceBundle.getString("S_COMMENT_CHAR");
    private OiizCallback m_callBack;
    private OiixProgressListener m_progListener;
    private OiiiStageAreaControl m_oiStageControl;
    private OiiiSourceAccess m_oiSourceAccess;
    private Hashtable m_oCompLangIdxMap;
    private boolean m_bWarning;
    private boolean m_bError = false;
    static final String s_JRE = "oracle.swd.jre";
    static final String s_OUI = "oracle.swd.oui";
    private String m_sHeader = null;
    private int m_nResponseFiles = 0;
    private static String m_sRspDirName = "Response";
    private static String m_sRspExt = ".rsp";
    private static String m_sRspBakExt = ".bak";
    private Vector m_vGeneratedRSPFiles = null;
    private static final int NEVER_GENERATE_FASTCOPY = 0;
    private static final int DEFAULT_GENERATE_FASTCOPY = 1;
    private static boolean m_bCheckSHPropXML = true;
    private static boolean m_bCheckBugListXML = true;
    private static final String s_buglistXML = "buglist.xml";
    private HashMap m_TLDepModeSizes;
    private HashMap m_CompsSizes;
    private String S_TOPLEVEL_SIZES_FOLDER = "sizes";
    private HashMap m_TLInstallType;
    public static final String S_TOPLEVEL_INSTALLTYPE_FOLDER = "ComponentList";
    public static final String S_XML = ".xml";
    public static final String S_PRODUCT_LANGS_FILE = "productlanguages.properties";

    public OiizStageVerifier(String invLoc, boolean bModify, OiizCallback cb, OiixProgressListener l) throws IOException {
        this.m_sInvLoc = OiixPathOps.getStandardForm(invLoc);
        this.m_sourceRoot = OiixPathOps.getParentDir(this.m_sInvLoc);
        this.m_sInvLoc = OiixPathOps.getNativeForm(this.m_sInvLoc);
        File f = new File(this.m_sInvLoc);
        this.m_sStageLoc = OiixPathOps.getStandardForm(f.getParent());
        this.m_callBack = cb;
        this.m_progListener = l;
        OiizStageVerifier.debug(this.m_sInvLoc);
        this.m_IEsToComps = new Hashtable();
        this.m_IDsToPSets = new Hashtable();
        this.m_bError = false;
        this.callBack(OiizResourceBundle.getString("S_LOADING_STAGE_INVENTORY"));
        OiiiCompIDPool.getInstance().clearPool();
        OiiiLibraryIDPool.getInstance().clearPool();
        if (bModify) {
            this.loadComponents(this.m_sInvLoc);
        } else {
            this.loadComponentsToRead(this.m_sInvLoc);
        }
    }

    public OiizStageVerifier(String invLoc, boolean bModify, OiizCallback cb) throws IOException {
        this(invLoc, bModify, cb, null);
    }

    public OiizStageVerifier(String invLoc, boolean bModify) throws IOException {
        this(invLoc, bModify, null);
    }

    public OiizStageVerifier(String invLoc) throws IOException {
        this(invLoc, true);
    }

    public void waitForInput(BufferedReader consoleBuffReader) throws IOException {
        System.out.println("...Done. ");
        System.out.println("Total memory " + Runtime.getRuntime().totalMemory());
        System.out.println("Free memory " + Runtime.getRuntime().freeMemory());
        System.out.println("Used memory " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        System.out.println("Press Enter to continue. ");
        consoleBuffReader.readLine();
    }

    @Override
    public void updateEnv(OiiiInstallInventory instInv) {
    }

    @Override
    public OiicSessionPlan getSessionPlan() {
        return null;
    }

    @Override
    public OiicSessionContext getSessionContext() {
        return null;
    }

    @Override
    public void setSessionPlan(OiicSessionPlan sessionPlan) {
    }

    @Override
    public boolean inRollbackMode() {
        return false;
    }

    @Override
    public OiisActionLibLoader getActionLibLoader(OiiiLibraryID lid, int homeIndex) throws IOException {
        return null;
    }

    @Override
    public String getInstCompName(OiiiCompInstallID cid, int OHid) {
        return "";
    }

    @Override
    public String getStgCompName(OiiiCompInstallID cid) {
        return "";
    }

    @Override
    public OiifwWizDialog getWizardDialog() {
        return null;
    }

    @Override
    public OiifmMainFrame getMainFrame() {
        return null;
    }

    @Override
    public int getOHIndex() {
        return 0;
    }

    @Override
    public int getAppltopIndex() {
        return 0;
    }

    @Override
    public boolean isInstallMode() {
        return false;
    }

    @Override
    public boolean isDeinstallMode() {
        return false;
    }

    @Override
    public boolean isCloneMode() {
        return false;
    }

    @Override
    public boolean isAddNodeMode() {
        return false;
    }

    public void setCallBack(OiizCallback cb) {
        this.m_callBack = cb;
    }

    public boolean isError() {
        return this.m_bError;
    }

    public boolean isWarning() {
        return this.m_bWarning;
    }

    public String getLocationDir() {
        return this.m_sStageLoc;
    }

    public String getLocation() {
        return this.m_sInvLoc;
    }

    private OiisDepInfo getDepInfo(OiiiStageCompInvEntry entry) {
        OiisCompInstallation oComp;
        OiisDepInfo oDepInfo = null;
        OiiiCompInstallID id = entry.getCompInstallID();
        if (id.getCompType() != 4 && (oDepInfo = entry.getDepInfo()) == null && (oComp = this.getCompInstall(id)) != null) {
            oDepInfo = oComp.getDepInfo();
        }
        return oDepInfo;
    }

    private OiisCompProperties getCompProperties(OiiiStageCompInvEntry entry) {
        OiisCompInstallation oComp;
        OiisCompProperties oCompProperties = null;
        OiiiCompInstallID id = entry.getCompInstallID();
        oCompProperties = entry.getCompProperties();
        if (oCompProperties == null && (oComp = this.getCompInstall(id)) != null) {
            oCompProperties = oComp.getProperties();
        }
        return oCompProperties;
    }

    private void processDepGraph(int iOperation, OiiiStageCompInvEntry invEntry, int iPlat) {
        int nModeSize;
        String sError = OiizResourceBundle.getString("S_ERROR");
        OiiiCompInstallID id = invEntry.getCompInstallID();
        this.callBack(OiizResourceBundle.getString("S_PROCESSING_DEPENDENCIES"));
        OiiodDepEngine depEngine = new OiiodDepEngine(this, true);
        depEngine.setErrListener(this);
        depEngine.setInventories(this.m_stageInv, new OiiiInstallInventory());
        depEngine.setCurrentPlatform(iPlat);
        depEngine.setExecutePreReq(false);
        OiiiCompInstallID[] ids = new OiiiCompInstallID[]{id};
        depEngine.setCurrentTLIDs(ids);
        try {
            depEngine.buildCompArray();
        }
        catch (OiiodDepException exp) {
            this.processError(exp.getMessage(), null);
            return;
        }
        OiisDepInfo tlDInfo = this.getDepInfo(invEntry);
        OiisDeps oDeps = tlDInfo == null ? null : tlDInfo.getDeps();
        Vector vDepModes = oDeps == null ? null : oDeps.getDepModes();
        int n = nModeSize = vDepModes == null ? 1 : vDepModes.size();
        if (nModeSize == 0) {
            this.performOperation(iOperation, invEntry, null, depEngine, tlDInfo, iPlat);
        } else {
            for (int j = 0; j < nModeSize; ++j) {
                OiisDepMode oDepMode = vDepModes == null ? null : (OiisDepMode)vDepModes.elementAt(j);
                this.performOperation(iOperation, invEntry, oDepMode, depEngine, tlDInfo, iPlat);
            }
        }
    }

    private void performOperation(int iOperation, OiiiStageCompInvEntry invEntry, OiisDepMode oDepMode, OiiodDepEngine depEngine, OiisDepInfo tlDInfo, int iPlat) {
        String modeID;
        OiiiCompInstallID id = invEntry.getCompInstallID();
        String string = modeID = oDepMode == null ? "Custom" : oDepMode.getInternalName();
        if ((iOperation & 1) != 0) {
            String sDisplayName = invEntry.getFullDisplayName(false);
            String sPlat = OiixPlatform.getPlatformName(iPlat);
            Object[] objs = null;
            String sKey = "S_SIZE_PROGRESS";
            if (oDepMode != null) {
                objs = new Object[]{sDisplayName, sPlat, oDepMode.getName()};
            } else {
                objs = new Object[]{sDisplayName, sPlat};
                sKey = "S_SIZE_PROGRESS_INSTALLTYPE_NONE";
            }
            this.callBack(OiizResourceBundle.getString(sKey, objs));
        }
        if ((iOperation & 2) != 0) {
            String sMsg;
            Object[] objs;
            if (oDepMode != null) {
                objs = new String[]{invEntry.getFullDisplayName(false), oDepMode.getName()};
                sMsg = OiizResourceBundle.getString("S_RESPONSE_FILE_PROGRESS");
                sMsg = MessageFormat.format(sMsg, objs);
                objs = null;
            } else {
                objs = new String[]{invEntry.getFullDisplayName(false), "Custom"};
                sMsg = OiizResourceBundle.getString("S_RESPONSE_FILE_PROGRESS");
                sMsg = MessageFormat.format(sMsg, objs);
                objs = null;
            }
            this.callBack(sMsg);
        }
        if (tlDInfo != null) {
            tlDInfo.setDepModeName(modeID);
        }
        try {
            depEngine.depModeApply(false);
            Vector vError = new Vector();
            depEngine.checkTreeCorrectness(vError);
            if (vError.size() > 0) {
                this.processError(vError.toString(), null);
                return;
            }
            Vector vCompIds = depEngine.calcCompsToInstall();
            if ((iOperation & 1) != 0) {
                String fileName = id.getName() + "_" + modeID + S_XML;
                this.m_TLInstallType.put(fileName, vCompIds);
                if (id.getCompType() != 4) {
                    this.calculateRequiredSpace(invEntry, vCompIds, new Integer(iPlat), modeID);
                }
            } else if ((iOperation & 2) != 0) {
                Vector vDepInfo = depEngine.getParticipatingCompsWithDependees();
                this.generateResponseFile(invEntry.getCompInstallID(), oDepMode, vDepInfo);
            }
        }
        catch (OiiodDepException exp) {
            exp.printStackTrace();
            if (this.m_IEsToComps.containsKey(invEntry)) {
                this.callBack(exp);
            }
        }
        catch (OiifbCancelException exp) {
            exp.printStackTrace();
            this.callBack(exp);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            this.callBack(exp);
        }
    }

    public boolean generateConfigMaster(OiizStageVerifier oVerify, Vector vCompIDs, OiizCallback callbak) {
        Vector compsVector = this.generateConfigMasterTemp(oVerify, vCompIDs, callbak);
        if (this.m_oConfigGenerator != null) {
            return this.m_oConfigGenerator.generateConfigMaster(compsVector);
        }
        return false;
    }

    public boolean updateConfigMaster(OiizStageVerifier oVerify, Vector vCompIDs, OiizCallback callbak) {
        if (null != this.m_oConfigGenerator || null == vCompIDs || vCompIDs.size() <= 0) {
            this.callBack("No selected components for updation of configuration aggregates");
            return false;
        }
        this.m_oConfigGenerator = new OiizConfigMasterGenerator(oVerify, callbak);
        Vector vInvComps = this.getAllComps();
        int invSize = vInvComps.size();
        if (invSize == 0) {
            this.callBack("No components in the staging area.");
            return false;
        }
        Vector<OiiiStageCompInvEntry> compsVector = new Vector<OiiiStageCompInvEntry>();
        int iSize = vCompIDs.size();
        block0: for (int i = 0; i < iSize; ++i) {
            OiiiCompInstallID oID = (OiiiCompInstallID)vCompIDs.elementAt(i);
            invSize = vInvComps.size();
            for (int k = 0; k < invSize; ++k) {
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vInvComps.elementAt(k);
                OiiiCompInstallID oInvCompID = oEntry.getCompInstallID();
                if (oID.equalsNoPlat(oInvCompID, 0) && oID.getPlatforms().size() == 0 && oInvCompID.getPlatforms().size() == 0) {
                    compsVector.addElement(oEntry);
                    continue block0;
                }
                if (!oID.equalsWithPlatInt(oInvCompID)) continue;
                compsVector.addElement(oEntry);
                continue block0;
            }
        }
        if (this.m_oConfigGenerator != null) {
            return this.m_oConfigGenerator.updateConfigMaster(compsVector, null);
        }
        return false;
    }

    private Vector generateConfigMasterTemp(OiizStageVerifier oVerify, Vector vCompIDs, OiizCallback callbak) {
        Vector vInvComps;
        int invSize;
        if (null == this.m_oConfigGenerator) {
            this.m_oConfigGenerator = new OiizConfigMasterGenerator(oVerify, callbak);
        }
        if (null != vCompIDs && vCompIDs.size() <= 0) {
            vCompIDs = this.getTopLevelComps();
        }
        if ((invSize = (vInvComps = this.getAllComps()).size()) == 0) {
            this.callBack("No components in the staging area.");
        }
        Vector<OiiiStageCompInvEntry> compsVector = new Vector<OiiiStageCompInvEntry>();
        int iSize = vCompIDs.size();
        block0: for (int i = 0; i < iSize; ++i) {
            OiiiCompInstallID oID = (OiiiCompInstallID)vCompIDs.elementAt(i);
            invSize = vInvComps.size();
            for (int k = 0; k < invSize; ++k) {
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vInvComps.elementAt(k);
                OiiiCompInstallID oInvCompID = oEntry.getCompInstallID();
                if (oID.equalsNoPlat(oInvCompID, 0) && oID.getPlatforms().size() == 0 && oInvCompID.getPlatforms().size() == 0) {
                    compsVector.addElement(oEntry);
                    continue block0;
                }
                if (!oID.equalsWithPlatInt(oInvCompID)) continue;
                compsVector.addElement(oEntry);
                continue block0;
            }
        }
        return compsVector;
    }

    public void generateAndUpdateConfigMaster(OiizStageVerifier oVerify, Vector vCompIDs, OiizCallback callbak, String sUserPropFile) {
        Vector compsVector = this.generateConfigMasterTemp(oVerify, vCompIDs, callbak);
        if (this.m_oConfigGenerator != null) {
            this.m_oConfigGenerator.generateAndUpdateConfigMaster(compsVector, sUserPropFile);
        }
    }

    public void updateSizes() {
        this.updateSizes(1);
    }

    private static String getFileName(String parDir, Properties invDetails, String keyInProp, String defFileName) {
        String sRetFileName = defFileName;
        if (invDetails != null) {
            String sNameInProp = invDetails.getProperty(keyInProp);
            if (sNameInProp != null) {
                sRetFileName = sNameInProp;
            }
            if (parDir != null) {
                sRetFileName = OiixPathOps.concatPath(parDir, sRetFileName);
            }
        }
        return sRetFileName;
    }

    public void updateSizes(int iGenFastCopyMetaData) {
        if (this.m_stageInv == null) {
            return;
        }
        if ((this.m_iOperationsPerformed & 0xFFFFFFFE) != -1) {
            this.verifyStage();
            if (!this.m_bError) {
                String sMsg;
                Object[] args;
                Properties invDetails;
                String sSHPropLoc;
                File oSHPropFile;
                Enumeration vAllComps = this.m_stageInv.getAllComps(0);
                String sError = OiizResourceBundle.getString("S_ERROR");
                OiiiVersion oInstVer = OiicInstVersion.getCompatibleInstallerVersion();
                String sInstVer = oInstVer.getVerString();
                String sDir = this.m_sourceRoot + File.separator + this.S_TOPLEVEL_SIZES_FOLDER;
                File oSizesFolder = new File(OiixPathOps.getNativeForm(sDir));
                if (!oSizesFolder.exists()) {
                    oSizesFolder.delete();
                }
                boolean bHaveTopLevelComponents = false;
                while (vAllComps.hasMoreElements()) {
                    OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                    if (!invEntry.isTopLevel()) continue;
                    bHaveTopLevelComponents = true;
                    if (invEntry.isStageVersionPostX(sInstVer)) {
                        OiiiVersion oVersion = invEntry.getStageVersion();
                        if (oVersion == null) {
                            OiiiVersion[] aoVersions = invEntry.getInstVersionsArray();
                            oVersion = this.getMinVersion(aoVersions);
                        }
                        OiiiCompInstallID cid = invEntry.getCompInstallID();
                        Object[] sArgs = new String[]{cid.getName(), cid.getVersion().toString(), oVersion.toString()};
                        String sMsg2 = OiizResourceBundle.getString("S_SKIPPING_HIGHER_INST_VER_COMP", sArgs);
                        this.processWarning(sMsg2, null);
                        continue;
                    }
                    Vector vPlat = invEntry.getPlatforms();
                    invEntry.resetSize();
                    int nSize = vPlat.size();
                    this.m_TLDepModeSizes = new HashMap();
                    this.m_TLInstallType = new HashMap();
                    this.m_CompsSizes = new HashMap();
                    for (int i = 0; i < nSize; ++i) {
                        Integer nPlat = (Integer)vPlat.elementAt(i);
                        this.processDepGraph(1, invEntry, nPlat);
                    }
                    this.writeTLSizes(this.m_TLDepModeSizes);
                    this.writeTLSizes(this.m_CompsSizes);
                    this.writeTLInstallType(this.m_TLInstallType);
                }
                vAllComps = this.m_stageInv.getAllComps(0);
                OiiiVersion oInstVersion = OiicInstVersion.getCompatibleInstallerVersion();
                String sInstVersion = oInstVer.getVerString();
                while (vAllComps.hasMoreElements()) {
                    OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                    if (!invEntry.isStageVersionPreX(sInstVersion)) continue;
                    String sMsg3 = OiizResourceBundle.getString("S_INVALID_STG_VERSION");
                    this.processError(sMsg3, null);
                }
                this.updateStageInventory(true);
                if (iGenFastCopyMetaData == 1 && bHaveTopLevelComponents) {
                    this.generateDefaultFilesMetaData();
                } else if (iGenFastCopyMetaData == 0) {
                    this.deleteFastCopyInformation();
                }
                if (m_bCheckSHPropXML && !(oSHPropFile = new File(sSHPropLoc = OiizStageVerifier.getFileName(this.m_sourceRoot, invDetails = OiiiStageInventory.readInvDetailsProps(this.m_sourceRoot), "SHPropsXML", "shiphomeproperties.xml"))).exists()) {
                    args = new Object[]{this.m_sourceRoot};
                    sMsg = OiizResourceBundle.getString("S_MISSING_SHPROPERTIES_XML", args);
                    this.processError(sMsg, null);
                }
                if (m_bCheckBugListXML) {
                    String parDir = OiixPathOps.concatPath(this.m_sourceRoot, "buglist");
                    Vector id = this.getTopLevelComps();
                    for (int i = 0; i < id.size(); ++i) {
                        String fileName;
                        String loc;
                        OiiiCompInstallID cid = (OiiiCompInstallID)id.elementAt(i);
                        if (cid.getCompType() != 4 || new File(loc = OiixPathOps.concatPath(parDir, fileName = cid.getName() + "_" + cid.getVersion().getVerString() + "_" + s_buglistXML)).exists()) continue;
                        Object[] args2 = new Object[]{fileName, parDir};
                        String sMsg4 = OiizResourceBundle.getString("S_MISSING_BUGLIST_XML", args2);
                        this.processError(sMsg4, null);
                    }
                }
                this.generateProductLanguages();
                invDetails = OiiiStageInventory.readInvDetailsProps(this.m_sourceRoot);
                String sOUIXMLLoc = OiizStageVerifier.getFileName(this.m_sourceRoot, invDetails, "OUIConfigVarXML", "OuiConfigVariables.xml");
                File oOUIXMLFile = new File(sOUIXMLLoc);
                if (!oOUIXMLFile.exists()) {
                    args = new Object[]{this.m_sourceRoot};
                    sMsg = OiizResourceBundle.getString("S_MISSING_OUICONFIGVARIABLES_XML", args);
                    this.processWarning(sMsg, null);
                }
            } else {
                this.callBack(OiizResourceBundle.getString("S_ERRORS_IN_STAGE_SKIP_UPDATE_SIZE"));
            }
            this.m_iOperationsPerformed &= 0xFFFFFFFE;
        }
    }

    private void writeTLSizes(HashMap sizes) {
        String sDir = this.m_sourceRoot + File.separator + this.S_TOPLEVEL_SIZES_FOLDER;
        File oSizesFolder = new File(OiixPathOps.getNativeForm(sDir));
        if (!oSizesFolder.exists()) {
            oSizesFolder.mkdir();
        } else if (!oSizesFolder.isDirectory()) {
            oSizesFolder.delete();
            oSizesFolder.mkdir();
        }
        for (String key : sizes.keySet()) {
            Properties p = (Properties)sizes.get(key);
            try {
                FileOutputStream fp = new FileOutputStream(sDir + File.separator + key + ".sizes.properties");
                if (null == fp) continue;
                p.store(fp, "");
                fp.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeTLInstallType(HashMap installTypes) {
        String sDir = this.m_sourceRoot + File.separator + S_TOPLEVEL_INSTALLTYPE_FOLDER;
        File oCompsFolder = new File(OiixPathOps.getNativeForm(sDir));
        if (!oCompsFolder.exists()) {
            oCompsFolder.mkdir();
        } else if (!oCompsFolder.isDirectory()) {
            oCompsFolder.delete();
            oCompsFolder.mkdir();
        }
        for (String key : installTypes.keySet()) {
            Vector ids = (Vector)installTypes.get(key);
            BufferedWriter out = null;
            PrintWriter pw = null;
            try {
                out = new BufferedWriter(new FileWriter(sDir + File.separator + key));
                pw = new PrintWriter(out);
                pw.println(OixsXMLOps.createXMLDirective(true));
                pw.println(OixsXMLOps.getStandardHeader());
                pw.println("<COMPS_LIST>");
                for (int i = 0; i < ids.size(); ++i) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)ids.get(i);
                    OiimCompInfo ci = new OiimCompInfo(cid.getName(), cid.getVersion().getVerString());
                    ci.writeXML(pw);
                }
                pw.println("</COMPS_LIST>");
                out.close();
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            System.out.println("Generated file " + sDir + File.separator + key);
        }
    }

    private void generateDefaultFilesMetaData() {
        try {
            if (this.m_stageInv != null) {
                Hashtable oCompDefFiles = new Hashtable(101);
                Hashtable oCompExpDefFiles = new Hashtable(101);
                Hashtable oCompDefJars = new Hashtable(101);
                Hashtable oOvlyPatchDefJars = new Hashtable(51);
                Hashtable oOvlyPatchExpDefFiles = new Hashtable(51);
                Hashtable<OiiiStageCompInvEntry, Object> oTLComps = new Hashtable<OiiiStageCompInvEntry, Object>(5);
                this.ensureFastCopyDirCreated();
                boolean bGenerateFastcopy = false;
                int iDiscs = this.m_stageInv.getDiskCount();
                PrintWriter[] oSetPermsScriptWriters = new PrintWriter[iDiscs];
                Vector vAllComps = this.m_stageInv.getAllCompsVect(0);
                HashSet<String> oAllCompsSet = new HashSet<String>(vAllComps.size() * 4 / 3);
                Hashtable<OiiiCompInstallID, Vector> oAllPatchsetsInfo = new Hashtable<OiiiCompInstallID, Vector>();
                Enumeration oAllCompsEnum = vAllComps.elements();
                while (oAllCompsEnum.hasMoreElements()) {
                    OiiiStageCompInvEntry oInvEntry = (OiiiStageCompInvEntry)oAllCompsEnum.nextElement();
                    OiiiCompInstallID oInstallID = oInvEntry.getCompInstallID();
                    if (oInstallID.getCompType() == 1) {
                        oAllCompsSet.add(oInstallID.getName().toLowerCase());
                    }
                    if (oInstallID.getCompType() != 4) continue;
                    Vector oPatches = this.getContainedPatches(oInstallID);
                    oAllPatchsetsInfo.put(oInstallID, oPatches);
                }
                oAllCompsEnum = vAllComps.elements();
                while (oAllCompsEnum.hasMoreElements()) {
                    OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)oAllCompsEnum.nextElement();
                    int iCompType = invEntry.getCompInstallID().getCompType();
                    if (iCompType != 4) {
                        this.readCompDefFilesInfo(invEntry, oCompDefFiles, oCompExpDefFiles, oCompDefJars, oSetPermsScriptWriters, oOvlyPatchDefJars, oOvlyPatchExpDefFiles, oAllCompsSet, oAllPatchsetsInfo);
                    }
                    if (!invEntry.isTopLevel()) continue;
                    Vector vPlats = invEntry.getPlatforms();
                    if (vPlats.size() > 1) {
                        OiiiCompInstallID oCompID = invEntry.getCompInstallID();
                        Object[] objs = new Object[]{oCompID.getName()};
                        this.callBack(OiizResourceBundle.getString("S_DEFAULT_OPTION_FASTCOPY", objs));
                        continue;
                    }
                    if (vPlats.size() == 1) {
                        oTLComps.put(invEntry, vPlats.elementAt(0));
                        bGenerateFastcopy = true;
                        continue;
                    }
                    if (vPlats.size() != 0) continue;
                    oTLComps.put(invEntry, new Integer(0));
                    bGenerateFastcopy = true;
                }
                if (bGenerateFastcopy) {
                    this.callBack(OiizResourceBundle.getString("S_GATHERING_FASTCOPY_INFORMATION"));
                    this.writeOutMetaDataForDefaultFiles(oTLComps, oCompDefJars, oCompExpDefFiles, oCompDefFiles, oOvlyPatchDefJars, oOvlyPatchExpDefFiles);
                }
                oTLComps.clear();
                oCompDefJars.clear();
                oCompExpDefFiles.clear();
                oCompDefFiles.clear();
                oOvlyPatchDefJars.clear();
                oOvlyPatchExpDefFiles.clear();
                for (int i = 0; i < oSetPermsScriptWriters.length; ++i) {
                    if (oSetPermsScriptWriters[i] == null) continue;
                    oSetPermsScriptWriters[i].close();
                }
            }
        }
        catch (Exception e) {
            if (s_debug) {
                e.printStackTrace();
            }
            this.callBack(e);
        }
    }

    private void deleteFastCopyInformation() {
        File oFastCopyFile;
        this.callBack(OiizResourceBundle.getString("S_NO_FASTCOPY_MULTI_PLATFORM_COMPONENT"));
        this.callBack(OiizResourceBundle.getString("S_DELETE_FASTCOPY_INFORMATION"));
        File oFastCopyFolder = new File(OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER));
        if (oFastCopyFolder.exists()) {
            if (!oFastCopyFolder.isDirectory()) {
                oFastCopyFolder.delete();
            } else {
                OiixFileOps.recdelete(oFastCopyFolder);
            }
        }
        if ((oFastCopyFile = new File(OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_METADATA))).exists()) {
            oFastCopyFile.delete();
        }
    }

    private void ensureFastCopyDirCreated() {
        File oFastCopyFolder = new File(OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER));
        if (oFastCopyFolder.exists()) {
            if (!oFastCopyFolder.isDirectory()) {
                oFastCopyFolder.delete();
                oFastCopyFolder.mkdir();
            } else {
                OiixFileOps.recdelete(oFastCopyFolder);
            }
        }
        oFastCopyFolder.mkdir();
    }

    private void generateProductLanguages() {
        Vector vTopComps = this.getTopLevelComps();
        int nSize = vTopComps.size();
        if (nSize == 0) {
            return;
        }
        try {
            File oFile = new File(OiixPathOps.concatPath(this.m_sourceRoot, S_PRODUCT_LANGS_FILE));
            PrintWriter pWriter = new PrintWriter(new FileOutputStream(oFile));
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)vTopComps.elementAt(i);
                Vector vLangs = this.m_stageInv.getStageCompInvEntry(cid).getLanguages();
                String[] saLangs = OiixVectorOps.langVect2StrArr(vLangs);
                String sLangs = OiixFunctionOps.implodeList(saLangs, " ");
                sLangs = sLangs.replaceAll(DELIMITER, "");
                sLangs = sLangs.replaceAll(": ", " ");
                sLangs = sLangs.replaceAll(":", "_");
                pWriter.println(cid.getName() + "_languages=" + sLangs);
            }
            pWriter.close();
        }
        catch (Exception e) {
            this.processWarning(e.getMessage(), null);
        }
    }

    private PrintWriter createSetPermsScript(int iDiscNum) {
        PrintWriter oRetWriter = null;
        try {
            File oSetPermsFile = new File(OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + S_SETPERMS_SCRIPT_BASE + iDiscNum + S_SETPERMS_SCRIPT_EXT));
            oRetWriter = new PrintWriter(new FileOutputStream(oSetPermsFile));
            oRetWriter.print("#!/bin/sh\n");
            oRetWriter.print("\n");
        }
        catch (IOException ioe) {
            if (s_debug) {
                ioe.printStackTrace();
            }
            this.callBack(ioe);
        }
        return oRetWriter;
    }

    private void readCompDefFilesInfo(OiiiStageCompInvEntry invEntry, Hashtable oCompDefFiles, Hashtable oCompExpDefFiles, Hashtable oCompDefJars, PrintWriter[] oSetPermsScriptWriters, Hashtable oOvlyPatchDefJars, Hashtable oOvlyPatchExpDefFiles, HashSet oAllCompsSet, Hashtable oAllPatchsetsInfo) {
        int iScrIdx = invEntry.getDiskNumber() - 1;
        String sInstallJarName = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + invEntry.getJarName());
        try {
            OiisCompProperties oCompProps = invEntry.getCompProperties();
            OiisCompJarInfo oCompJarInfo = oCompProps.getCompJarInfo();
            String sEntryName = oCompJarInfo.getFastCopyLogXML();
            if (sEntryName == null) {
                return;
            }
            if (!invEntry.canDefaultify()) {
                return;
            }
            ZipFile oInstallJar = new ZipFile(sInstallJarName);
            ZipEntry oEntry = oInstallJar.getEntry(sEntryName);
            if (oEntry != null) {
                Vector<String> vCompFiles = new Vector<String>(20);
                Vector<String> vCompExpFiles = null;
                Vector<String> vPatchExpFiles = null;
                Vector<String> vCompJars = null;
                Vector<String> vPatchJars = null;
                OiiiCompInstallID oCompId = invEntry.getCompInstallID();
                boolean bOverlayPatch = this.isOverlayPatch(oCompId, oAllCompsSet);
                if (!bOverlayPatch) {
                    Enumeration enum_1 = oAllPatchsetsInfo.keys();
                    while (enum_1.hasMoreElements()) {
                        OiiiCompInstallID oTempPatchsetID = (OiiiCompInstallID)enum_1.nextElement();
                        Vector oAllPatches = (Vector)oAllPatchsetsInfo.get(oTempPatchsetID);
                        if (!oAllPatches.contains(oCompId)) continue;
                        bOverlayPatch = true;
                        break;
                    }
                }
                BufferedReader oLogReader = new BufferedReader(new InputStreamReader(oInstallJar.getInputStream(oEntry)));
                String sLine = null;
                String sCurrPerms = null;
                boolean bCurrGroupArchived = false;
                StringBuffer sChmodCmdLine = new StringBuffer(65280);
                int iNumChmodArgs = 0;
                String sLastSeenPerms = null;
                String sUnArchivedLocation = null;
                while ((sLine = oLogReader.readLine()) != null) {
                    int iArchEnd;
                    if ((sLine = sLine.trim()).startsWith("<FILE STAGE_LOCATION=\"")) {
                        int iStgLocStart = sLine.indexOf(QUOTES);
                        int iStgLocEnd = sLine.indexOf(QUOTES, iStgLocStart + 1);
                        String sStageLoc = sLine.substring(iStgLocStart + 1, iStgLocEnd);
                        String sFileGrpPerms = sCurrPerms;
                        int iPermsStart = sLine.indexOf(34, iStgLocEnd + 1);
                        if (iPermsStart > 0) {
                            int iPermsEnd = sLine.indexOf(34, iPermsStart + 1);
                            sCurrPerms = sLine.substring(iPermsStart + 1, iPermsEnd);
                        }
                        int i = sLine.indexOf(62);
                        int j = sLine.indexOf(60, i);
                        String sFile = sLine.substring(i + 1, j).trim();
                        String sRelFile = sFile.substring("%ORACLE_HOME%".length() + 1);
                        vCompFiles.addElement(sFile);
                        if (!bCurrGroupArchived) {
                            if (bOverlayPatch && vPatchExpFiles == null) {
                                vPatchExpFiles = new Vector<String>(20);
                            } else if (vCompExpFiles == null) {
                                vCompExpFiles = new Vector<String>(20);
                            }
                            String sTmpPath1 = OiixPathOps.concatPath(invEntry.getGroupFilesLoc(), "Expanded");
                            String sTmpPath2 = OiixPathOps.concatPath(sUnArchivedLocation, sStageLoc);
                            String sSrcFile = OiixPathOps.concatPath(sTmpPath1, sTmpPath2);
                            if (bOverlayPatch) {
                                vPatchExpFiles.addElement(sSrcFile);
                                vPatchExpFiles.addElement(sRelFile);
                            } else {
                                vCompExpFiles.addElement(sSrcFile);
                                vCompExpFiles.addElement(sRelFile);
                            }
                        }
                        if (sCurrPerms == null) continue;
                        if (oSetPermsScriptWriters[iScrIdx] == null) {
                            oSetPermsScriptWriters[iScrIdx] = this.createSetPermsScript(iScrIdx + 1);
                        }
                        if (sCurrPerms.equals(sLastSeenPerms)) {
                            if (iNumChmodArgs == 255) {
                                oSetPermsScriptWriters[iScrIdx].print(sChmodCmdLine.toString() + "\n");
                                sChmodCmdLine.setLength(0);
                                sChmodCmdLine.append("chmod " + sCurrPerms);
                                iNumChmodArgs = 0;
                            }
                        } else {
                            if (sChmodCmdLine.length() > 0) {
                                oSetPermsScriptWriters[iScrIdx].print(sChmodCmdLine.toString() + "\n");
                            }
                            sChmodCmdLine.setLength(0);
                            sChmodCmdLine.append("chmod " + sCurrPerms);
                            sLastSeenPerms = sCurrPerms;
                            iNumChmodArgs = 0;
                        }
                        sChmodCmdLine.append(" " + sRelFile);
                        sCurrPerms = sFileGrpPerms;
                        ++iNumChmodArgs;
                        continue;
                    }
                    if (!sLine.startsWith("<FILEGROUP NAME=\"")) continue;
                    int iNameStart = sLine.indexOf(34);
                    int iNameEnd = sLine.indexOf(34, iNameStart + 1);
                    String sFileGroup = sLine.substring(iNameStart + 1, iNameEnd);
                    int iArchStart = sLine.indexOf(34, iNameEnd + 1);
                    String sArchived = sLine.substring(iArchStart + 1, iArchEnd = sLine.indexOf(34, iArchStart + 1));
                    bCurrGroupArchived = Boolean.valueOf(sArchived);
                    if (bCurrGroupArchived) {
                        if (bOverlayPatch && vPatchJars == null) {
                            vPatchJars = new Vector<String>(5);
                        } else if (vCompJars == null) {
                            vCompJars = new Vector<String>(5);
                        }
                        String sDefJar = invEntry.getGroupFilesLoc() + sFileGroup + ".jar";
                        if (bOverlayPatch) {
                            vPatchJars.addElement(sDefJar);
                        } else {
                            vCompJars.addElement(sDefJar);
                        }
                    } else {
                        int iLocStart = sLine.indexOf(34, iArchEnd + 1);
                        if (iLocStart > 0) {
                            int iLocEnd = sLine.indexOf(34, iLocStart + 1);
                            sUnArchivedLocation = sLine.substring(iLocStart + 1, iLocEnd);
                            iArchEnd = iLocEnd;
                        }
                    }
                    int iPermsStart = sLine.indexOf(34, iArchEnd + 1);
                    if (iPermsStart > 0) {
                        int iPermsEnd = sLine.indexOf(34, iPermsStart + 1);
                        sCurrPerms = sLine.substring(iPermsStart + 1, iPermsEnd);
                        continue;
                    }
                    sCurrPerms = null;
                }
                if (sChmodCmdLine.length() > 0) {
                    oSetPermsScriptWriters[iScrIdx].print(sChmodCmdLine.toString() + "\n");
                    sChmodCmdLine.setLength(0);
                    iNumChmodArgs = 0;
                }
                oLogReader.close();
                if (bOverlayPatch && vPatchJars != null) {
                    oOvlyPatchDefJars.put(oCompId, vPatchJars);
                } else if (vCompJars != null) {
                    oCompDefJars.put(oCompId, vCompJars);
                }
                if (bOverlayPatch && vPatchExpFiles != null) {
                    oOvlyPatchExpDefFiles.put(oCompId, vPatchExpFiles);
                } else if (vCompExpFiles != null) {
                    oCompExpDefFiles.put(oCompId, vCompExpFiles);
                }
                oCompDefFiles.put(oCompId, vCompFiles);
            }
            oInstallJar.close();
        }
        catch (IOException ioe) {
            if (s_debug) {
                ioe.printStackTrace();
            }
            this.callBack(ioe);
        }
    }

    private boolean isOverlayPatch(OiiiCompInstallID oPatchId, HashSet oAllCompsSet) {
        boolean bRetVal = false;
        if (oPatchId != null && oPatchId.getCompType() == 2 && oAllCompsSet.contains(oPatchId.getName().toLowerCase())) {
            bRetVal = true;
        }
        return bRetVal;
    }

    private void writeOutMetaDataForDefaultFiles(Hashtable oTLComps, Hashtable oCompDefJars, Hashtable oCompExpDefFiles, Hashtable oCompDefFiles, Hashtable oOvlyPatchDefJars, Hashtable oOvlyPatchExpDefFiles) {
        if (oCompDefJars.size() == 0 && oCompExpDefFiles.size() == 0 && oOvlyPatchDefJars.size() == 0 && oOvlyPatchExpDefFiles.size() == 0) {
            return;
        }
        try {
            File oFastCopyFolder = new File(OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER));
            int iDiscs = this.m_stageInv.getDiskCount();
            String sMetaMetaData = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_METADATA);
            FileOutputStream fos = new FileOutputStream(sMetaMetaData, false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
            PrintWriter oMetaMetaDataWriter = new PrintWriter(osw);
            Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
            String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
            oMetaMetaDataWriter.println(sXMLDir);
            Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
            String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
            oMetaMetaDataWriter.println(sXMLHdr);
            oMetaMetaDataWriter.println("");
            oMetaMetaDataWriter.println("<FASTCOPY DISKS=\"" + iDiscs + "\" DIR=\"" + S_FASTCOPY_FOLDER + "\" " + "VERSION=\"10.2\"" + " >");
            oMetaMetaDataWriter.println("");
            Vector<String> vRACFilesListFiles = new Vector<String>(10);
            Enumeration oTLKeys = oTLComps.keys();
            while (oTLKeys.hasMoreElements()) {
                OiiiStageCompInvEntry oCompInvEntry = (OiiiStageCompInvEntry)oTLKeys.nextElement();
                int iTokenPlat = (Integer)oTLComps.get(oCompInvEntry);
                String sPlat = OiixPlatform.getPlatformCommonName(iTokenPlat);
                OiiiCompInstallID oCompId = oCompInvEntry.getCompInstallID();
                String sTLCompName = oCompId.getName();
                int iCompType = oCompId.getCompType();
                OiiodDepEngine oDepEngine = new OiiodDepEngine(this, true);
                oDepEngine.setErrListener(this);
                oDepEngine.setInventories(this.m_stageInv, new OiiiInstallInventory());
                oDepEngine.setCurrentPlatform(iTokenPlat);
                oDepEngine.setExecutePreReq(false);
                OiiiCompInstallID[] oaCompIds = new OiiiCompInstallID[]{oCompId};
                oDepEngine.setCurrentTLIDs(oaCompIds);
                oDepEngine.buildCompArray();
                OiisDepInfo oTLDepInfo = this.getDepInfo(oCompInvEntry);
                OiisDeps oDeps = oTLDepInfo == null ? null : oTLDepInfo.getDeps();
                Vector vDepModes = oDeps == null ? null : oDeps.getDepModes();
                int iModeSize = vDepModes == null ? 1 : vDepModes.size();
                for (int i = 0; i < iModeSize; ++i) {
                    String sPreProcFileMapJar;
                    File oPreProcFileMapJarFile;
                    File oDirsListFile;
                    String sDirsList;
                    String sExpFilesList;
                    File oExpFilesListFile;
                    File oDefJarsListFile;
                    String sDefJarsList;
                    String sRACFilesListFile;
                    Object[] aoMsgArgs;
                    String sMsg;
                    Vector vCompDepNodes;
                    boolean bCustomMode;
                    OiisDepMode oDepMode = vDepModes == null ? null : (OiisDepMode)vDepModes.elementAt(i);
                    String sInstallType = oDepMode == null ? "Custom" : oDepMode.getInternalName();
                    boolean bl = bCustomMode = oDepMode == null || oDepMode.isCustomMode();
                    if (oTLDepInfo != null) {
                        oTLDepInfo.setDepModeName(sInstallType);
                    }
                    oDepEngine.depModeApply(false);
                    if (!bCustomMode) {
                        Vector vDepInfo = oDepEngine.getParticipatingCompsWithDependees();
                        vCompDepNodes = this.getCompsToInstallDepNodes(vDepInfo);
                    } else if (iCompType == 4) {
                        vCompDepNodes = this.getContainedPatches(oCompId);
                    } else {
                        Vector vCompNodes = oDepEngine.getDepNodes();
                        Vector vPatchNodes = oDepEngine.getDepPatchNodes();
                        vCompDepNodes = OiixVectorOps.concat(vCompNodes, vPatchNodes);
                    }
                    String sShortName = "";
                    String sTLNameIT = sTLCompName + "_" + sInstallType;
                    if (this.checkLength(sTLNameIT)) {
                        sShortName = this.getShorterInternalName(sTLCompName);
                        Object[] sArgs = new Object[]{sTLCompName, sInstallType};
                        sMsg = OiizResourceBundle.getString("TLCOMPNAME_INSTALLTYPE_TOO_LONG", sArgs);
                        this.processWarning(sMsg, null);
                        if (this.checkLength(sShortName + "_" + sInstallType)) {
                            String sMessage = OiizResourceBundle.getString("TLNAME_IT_SHORTNAME_TOO_BIG", sArgs);
                            this.processWarning(sMessage, null);
                        }
                    } else {
                        sShortName = sTLCompName;
                    }
                    if (iCompType != 4) {
                        aoMsgArgs = new Object[]{sTLCompName, sPlat, sInstallType};
                        sMsg = MessageFormat.format(OiizResourceBundle.getString("S_CREATE_FASTCOPY_METADATA"), aoMsgArgs);
                        this.callBack(sMsg);
                        this.createMetaDataForInstallType(sTLCompName, sInstallType, vCompDepNodes, oCompDefJars, oCompExpDefFiles, oCompDefFiles, oOvlyPatchDefJars, oOvlyPatchExpDefFiles, sShortName);
                        sRACFilesListFile = sTLCompName + "_" + sInstallType + "_racfiles.lst";
                        vRACFilesListFiles.addElement(sRACFilesListFile);
                        oMetaMetaDataWriter.println("  <TOPLEVEL_COMPONENT NAME=\"" + sTLCompName + "\" INSTALL_TYPE=\"" + sInstallType + "\" PLATFORM=\"" + sPlat + "\">");
                        for (int j = 0; j < iDiscs; ++j) {
                            String sPatchExpFilesList;
                            File oPatchExpFilesListFile;
                            String sPatchDefJarsList;
                            File oPatchDefJarsListFile;
                            sDefJarsList = sShortName + "_" + sInstallType + "_" + (j + 1) + S_XML;
                            oDefJarsListFile = new File(oFastCopyFolder, sDefJarsList);
                            if (oDefJarsListFile.exists()) {
                                oMetaMetaDataWriter.println("    <DEFAULT_JARS_LIST DISK=\"" + (j + 1) + "\"> " + sDefJarsList + " </DEFAULT_JARS_LIST>");
                            }
                            if ((oExpFilesListFile = new File(oFastCopyFolder, sExpFilesList = sShortName + "_" + sInstallType + "_exp_" + (j + 1) + S_XML)).exists()) {
                                oMetaMetaDataWriter.println("    <EXPANDED_FILES_LIST DISK=\"" + (j + 1) + "\"> " + sExpFilesList + " </EXPANDED_FILES_LIST>");
                            }
                            if ((oPatchDefJarsListFile = new File(oFastCopyFolder, sPatchDefJarsList = sShortName + "_" + sInstallType + "_patches_" + (j + 1) + S_XML)).exists()) {
                                oMetaMetaDataWriter.println("    <DEFAULT_PATCH_JARS_LIST DISK=\"" + (j + 1) + "\"> " + sPatchDefJarsList + " </DEFAULT_PATCH_JARS_LIST>");
                            }
                            if (!(oPatchExpFilesListFile = new File(oFastCopyFolder, sPatchExpFilesList = sShortName + "_" + sInstallType + "_patches_exp_" + (j + 1) + S_XML)).exists()) continue;
                            oMetaMetaDataWriter.println("    <EXPANDED_PATCH_FILES_LIST DISK=\"" + (j + 1) + "\"> " + sPatchExpFilesList + " </EXPANDED_PATCH_FILES_LIST>");
                        }
                        sDirsList = sShortName + "_" + sInstallType + "_dirs.lst";
                        oDirsListFile = new File(oFastCopyFolder, sDirsList);
                        if (oDirsListFile.exists()) {
                            oMetaMetaDataWriter.println("    <DIRS_LIST> " + sDirsList + " </DIRS_LIST>");
                        }
                        if ((oPreProcFileMapJarFile = new File(oFastCopyFolder, sPreProcFileMapJar = sShortName + "_" + sInstallType + S_FILEMAP_JAR_SUFFIX)).exists()) {
                            oMetaMetaDataWriter.println("    <PREPROC_FILEMAP> " + sPreProcFileMapJar + " </PREPROC_FILEMAP>");
                        }
                        oMetaMetaDataWriter.println("  </TOPLEVEL_COMPONENT>");
                        oMetaMetaDataWriter.println("");
                        continue;
                    }
                    aoMsgArgs = new Object[]{sTLCompName};
                    sMsg = MessageFormat.format(OiizResourceBundle.getString("S_CREATE_FASTCOPY_PATCHSET_METADATA"), aoMsgArgs);
                    this.callBack(sMsg);
                    this.createMetaDataForPatchset(sTLCompName, sInstallType, vCompDepNodes, oCompDefFiles, oOvlyPatchDefJars, oOvlyPatchExpDefFiles, sShortName);
                    sRACFilesListFile = sTLCompName + "_racfiles.lst";
                    vRACFilesListFiles.addElement(sRACFilesListFile);
                    oMetaMetaDataWriter.println("  <TOPLEVEL_COMPONENT NAME=\"" + sTLCompName + "\" PATCHSET=\"TRUE\">");
                    for (int j = 0; j < iDiscs; ++j) {
                        sDefJarsList = sShortName + "_" + (j + 1) + S_XML;
                        oDefJarsListFile = new File(oFastCopyFolder, sDefJarsList);
                        if (oDefJarsListFile.exists()) {
                            oMetaMetaDataWriter.println("    <DEFAULT_JARS_LIST DISK=\"" + (j + 1) + "\"> " + sDefJarsList + " </DEFAULT_JARS_LIST>");
                        }
                        if (!(oExpFilesListFile = new File(oFastCopyFolder, sExpFilesList = sShortName + "_exp_" + (j + 1) + S_XML)).exists()) continue;
                        oMetaMetaDataWriter.println("    <EXPANDED_FILES_LIST DISK=\"" + (j + 1) + "\"> " + sExpFilesList + " </EXPANDED_FILES_LIST>");
                    }
                    sDirsList = sShortName + "_dirs.lst";
                    oDirsListFile = new File(oFastCopyFolder, sDirsList);
                    if (oDirsListFile.exists()) {
                        oMetaMetaDataWriter.println("    <DIRS_LIST> " + sDirsList + " </DIRS_LIST>");
                    }
                    if ((oPreProcFileMapJarFile = new File(oFastCopyFolder, sPreProcFileMapJar = sShortName + "_" + sInstallType + S_FILEMAP_JAR_SUFFIX)).exists()) {
                        oMetaMetaDataWriter.println("    <PREPROC_FILEMAP> " + sPreProcFileMapJar + " </PREPROC_FILEMAP>");
                    }
                    oMetaMetaDataWriter.println("  </TOPLEVEL_COMPONENT>");
                    oMetaMetaDataWriter.println("");
                }
            }
            boolean bSetPermsTagWritten = false;
            for (int i = 0; i < iDiscs; ++i) {
                String sSetPerms = S_SETPERMS_SCRIPT_BASE + (i + 1) + S_SETPERMS_SCRIPT_EXT;
                File oSetPermsFile = new File(oFastCopyFolder, sSetPerms);
                if (!oSetPermsFile.exists()) continue;
                if (!bSetPermsTagWritten) {
                    oMetaMetaDataWriter.println("  <SETPERMS>");
                    bSetPermsTagWritten = true;
                }
                oMetaMetaDataWriter.println("    <SCRIPT DISK=\"" + (i + 1) + "\"> " + sSetPerms + " </SCRIPT>");
            }
            if (bSetPermsTagWritten) {
                oMetaMetaDataWriter.println("  </SETPERMS>");
                oMetaMetaDataWriter.println("");
            }
            if (vRACFilesListFiles.size() > 0) {
                String sRACFilesJarFile = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + S_RACFILES_JAR);
                File oRACFilesJarFile = new File(sRACFilesJarFile);
                if (oRACFilesJarFile.exists()) {
                    oRACFilesJarFile.delete();
                }
                OiixJarModifierPool oJMPool = OiixJarModifierPool.getJarModifierPool();
                OiixJarModifier oJarModifier = oJMPool.get(sRACFilesJarFile);
                oJarModifier.setState(1);
                Enumeration oAllRACFilesLists = vRACFilesListFiles.elements();
                while (oAllRACFilesLists.hasMoreElements()) {
                    String sRACFilesList = (String)oAllRACFilesLists.nextElement();
                    File oFile = new File(OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sRACFilesList));
                    if (!oFile.exists()) continue;
                    oJarModifier.insertEntryFromStream(oFile, sRACFilesList);
                    oFile.delete();
                }
                vRACFilesListFiles.clear();
                oJarModifier.setState(2);
                oMetaMetaDataWriter.println("  <RACFILES> racfiles.jar </RACFILES>");
                oMetaMetaDataWriter.println("");
            }
            oMetaMetaDataWriter.println("</FASTCOPY>");
            oMetaMetaDataWriter.close();
        }
        catch (Exception e) {
            if (s_debug) {
                e.printStackTrace();
            }
            this.callBack(e);
        }
    }

    private void createMetaDataForInstallType(String sTLCompName, String sInstallType, Vector vCompDepNodes, Hashtable oCompDefJars, Hashtable oCompExpDefFiles, Hashtable oCompDefFiles, Hashtable oOvlyPatchDefJars, Hashtable oOvlyPatchExpDefFiles, String sShortTLCompName) throws IOException {
        int iDiscs = this.m_stageInv.getDiskCount();
        PrintWriter[] oDefJarsListWriters = new PrintWriter[iDiscs];
        PrintWriter[] oExpFilesListWriters = new PrintWriter[iDiscs];
        PrintWriter[] oOvlyPatchDefJarsListWriters = new PrintWriter[iDiscs];
        PrintWriter[] oOvlyPatchExpFilesListWriters = new PrintWriter[iDiscs];
        String sRACFilesList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sTLCompName + "_" + sInstallType + "_racfiles.lst");
        PrintWriter oRACFilesListWriter = new PrintWriter(new FileWriter(sRACFilesList, false));
        String sOraHomePath = "%ORACLE_HOME%/";
        int iOraHomePathLen = sOraHomePath.length();
        TreeSet<String> oDirs = new TreeSet<String>();
        Hashtable oFilesMap = new Hashtable(101);
        Enumeration oCompDeps = vCompDepNodes.elements();
        String sCompType = "";
        while (oCompDeps.hasMoreElements()) {
            Vector vPatchExpDefFiles;
            Vector vPatchDefJars;
            Vector vDefFiles;
            Vector vExpDefFiles;
            OiiodDepNode oDepNode = (OiiodDepNode)oCompDeps.nextElement();
            OiiiCompInstallID oCompId = oDepNode.getCompInstallID();
            int iCompType = oCompId.getCompType();
            if (iCompType == 1) {
                sCompType = COMPONENT;
            } else if (iCompType == 2) {
                sCompType = PATCH;
            }
            OiiiStageCompInvEntry oInvEntry = oDepNode.getStageInvEntry();
            int iDiscNum = oInvEntry.getDiskNumber();
            String sCompName = oCompId.getName();
            String sCompVer = oCompId.getVersion().getVerString();
            String sCompTag = "COMP";
            sCompTag = iCompType == 1 ? "COMP" : "PATCH";
            Vector vDefJars = (Vector)oCompDefJars.get(oCompId);
            if (vDefJars != null) {
                if (oDefJarsListWriters[iDiscNum - 1] == null) {
                    String sDefJarsList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_" + sInstallType + "_" + iDiscNum + S_XML);
                    FileOutputStream fos = new FileOutputStream(sDefJarsList, false);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
                    oDefJarsListWriters[iDiscNum - 1] = new PrintWriter(osw);
                    Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
                    String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
                    oDefJarsListWriters[iDiscNum - 1].println(sXMLDir);
                    Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
                    String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
                    oDefJarsListWriters[iDiscNum - 1].println(sXMLHdr);
                    oDefJarsListWriters[iDiscNum - 1].println("");
                    oDefJarsListWriters[iDiscNum - 1].println("<FILE_LIST>");
                }
                Enumeration oJars = vDefJars.elements();
                oDefJarsListWriters[iDiscNum - 1].println(" <" + sCompTag + " NAME=\"" + sCompName + QUOTES + " VERSION=\"" + sCompVer + "\" >");
                while (oJars.hasMoreElements()) {
                    oDefJarsListWriters[iDiscNum - 1].println("  <FILE> " + oJars.nextElement() + " </FILE>");
                }
                oDefJarsListWriters[iDiscNum - 1].println(" </" + sCompTag + ">");
            }
            if ((vExpDefFiles = (Vector)oCompExpDefFiles.get(oCompId)) != null) {
                if (oExpFilesListWriters[iDiscNum - 1] == null) {
                    String sExpFilesList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_" + sInstallType + "_exp_" + iDiscNum + S_XML);
                    FileOutputStream fos = new FileOutputStream(sExpFilesList, false);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
                    oExpFilesListWriters[iDiscNum - 1] = new PrintWriter(osw);
                    Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
                    String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
                    oExpFilesListWriters[iDiscNum - 1].println(sXMLDir);
                    Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
                    String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
                    oExpFilesListWriters[iDiscNum - 1].println(sXMLHdr);
                    oExpFilesListWriters[iDiscNum - 1].println("");
                    oExpFilesListWriters[iDiscNum - 1].println("<FILE_LIST>");
                }
                oExpFilesListWriters[iDiscNum - 1].println(" <" + sCompTag + " NAME=\"" + sCompName + QUOTES + " VERSION=\"" + sCompVer + "\" >");
                Enumeration oExpFiles = vExpDefFiles.elements();
                while (oExpFiles.hasMoreElements()) {
                    String sSrc = (String)oExpFiles.nextElement();
                    String sDest = (String)oExpFiles.nextElement();
                    oExpFilesListWriters[iDiscNum - 1].println("  <FILE>");
                    oExpFilesListWriters[iDiscNum - 1].println("    <SOURCE> " + sSrc + " </SOURCE>");
                    oExpFilesListWriters[iDiscNum - 1].println("    <DEST> " + sDest + " </DEST>");
                    oExpFilesListWriters[iDiscNum - 1].println("  </FILE>");
                }
                oExpFilesListWriters[iDiscNum - 1].println(" </" + sCompTag + ">");
            }
            if ((vDefFiles = (Vector)oCompDefFiles.get(oCompId)) != null) {
                Enumeration oFiles = vDefFiles.elements();
                while (oFiles.hasMoreElements()) {
                    HashMap<String, String> oFilesMapForDir;
                    String sFile = (String)oFiles.nextElement();
                    oRACFilesListWriter.println(sFile);
                    if (sFile.startsWith(sOraHomePath)) {
                        sFile = sFile.substring(iOraHomePathLen);
                    }
                    String sFileFolder = null;
                    String sFileName = null;
                    int iLastSlashAt = sFile.lastIndexOf(47);
                    if (iLastSlashAt > 0) {
                        sFileFolder = sFile.substring(0, iLastSlashAt);
                        sFileName = sFile.substring(iLastSlashAt + 1);
                        oDirs.add(sFileFolder);
                    } else {
                        sFileFolder = "%ORACLE_HOME%";
                        sFileName = sFile;
                    }
                    boolean bEmptyFolder = true;
                    if (sFileName != null && sFileName.length() > 0) {
                        bEmptyFolder = false;
                    }
                    if ((oFilesMapForDir = (HashMap<String, String>)oFilesMap.get(sFileFolder)) == null) {
                        oFilesMapForDir = new HashMap<String, String>(11);
                        if (!bEmptyFolder) {
                            oFilesMapForDir.put(sFileName, this.createFileMapEntry(sFileName, sCompType, sCompName, sCompVer));
                        }
                        oFilesMap.put(sFileFolder, oFilesMapForDir);
                        continue;
                    }
                    String sFileMapEntries = (String)oFilesMapForDir.get(sFileName);
                    if (sFileMapEntries != null) {
                        oFilesMapForDir.put(sFileName, sFileMapEntries + this.createFileMapEntry(null, sCompType, sCompName, sCompVer));
                        continue;
                    }
                    if (bEmptyFolder) continue;
                    oFilesMapForDir.put(sFileName, this.createFileMapEntry(sFileName, sCompType, sCompName, sCompVer));
                }
            }
            if ((vPatchDefJars = (Vector)oOvlyPatchDefJars.get(oCompId)) != null) {
                if (oOvlyPatchDefJarsListWriters[iDiscNum - 1] == null) {
                    String sPatchDefJarsList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_" + sInstallType + "_patches_" + iDiscNum + S_XML);
                    FileOutputStream fos = new FileOutputStream(sPatchDefJarsList, false);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1] = new PrintWriter(osw);
                    Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
                    String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(sXMLDir);
                    Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
                    String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(sXMLHdr);
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println("");
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println("<FILE_LIST>");
                }
                oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(" <" + sCompTag + " NAME=\"" + sCompName + QUOTES + " VERSION=\"" + sCompVer + "\" >");
                Enumeration oPatchJars = vPatchDefJars.elements();
                while (oPatchJars.hasMoreElements()) {
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println("  <FILE> " + oPatchJars.nextElement() + " </FILE>");
                }
                oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(" </" + sCompTag + ">");
            }
            if ((vPatchExpDefFiles = (Vector)oOvlyPatchExpDefFiles.get(oCompId)) == null) continue;
            if (oOvlyPatchExpFilesListWriters[iDiscNum - 1] == null) {
                String sPatchExpFilesList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_" + sInstallType + "_patches_exp_" + iDiscNum + S_XML);
                FileOutputStream fos = new FileOutputStream(sPatchExpFilesList, false);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1] = new PrintWriter(osw);
                Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
                String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(sXMLDir);
                Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
                String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(sXMLHdr);
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("<FILE_LIST>");
            }
            oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(" <" + sCompTag + " NAME=\"" + sCompName + QUOTES + " VERSION=\"" + sCompVer + "\" >");
            Enumeration oPatchExpFiles = vPatchExpDefFiles.elements();
            while (oPatchExpFiles.hasMoreElements()) {
                String sSrc = (String)oPatchExpFiles.nextElement();
                String sDest = (String)oPatchExpFiles.nextElement();
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("  <FILE>");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("    <SOURCE> " + sSrc + " </SOURCE>");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("    <DEST> " + sDest + " </DEST>");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("  </FILE>");
            }
            oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(" </" + sCompTag + ">");
        }
        for (int i = 0; i < iDiscs; ++i) {
            if (oExpFilesListWriters[i] != null) {
                oExpFilesListWriters[i].println("</FILE_LIST>");
                oExpFilesListWriters[i].close();
            }
            if (oDefJarsListWriters[i] != null) {
                oDefJarsListWriters[i].println("</FILE_LIST>");
                oDefJarsListWriters[i].close();
            }
            if (oOvlyPatchExpFilesListWriters[i] != null) {
                oOvlyPatchExpFilesListWriters[i].println("</FILE_LIST>");
                oOvlyPatchExpFilesListWriters[i].close();
            }
            if (oOvlyPatchDefJarsListWriters[i] == null) continue;
            oOvlyPatchDefJarsListWriters[i].println("</FILE_LIST>");
            oOvlyPatchDefJarsListWriters[i].close();
        }
        oRACFilesListWriter.close();
        if (oDirs.size() > 0) {
            String sDirsList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_" + sInstallType + "_dirs.lst");
            PrintWriter oDirsListWriter = new PrintWriter(new FileWriter(sDirsList, false));
            for (String sDir : oDirs) {
                oDirsListWriter.println(sDir);
            }
            oDirs.clear();
            oDirsListWriter.close();
        }
        this.generatePreProcFilesMap(sShortTLCompName, sInstallType, oFilesMap);
        oFilesMap.clear();
    }

    private String createFileMapEntry(String sFileName, String sCompType, String sCompName, String sCompVersion) {
        StringBuffer sMapEntry = new StringBuffer();
        if (sFileName != null) {
            sMapEntry.append(sFileName);
            sMapEntry.append(DELIMITER);
        }
        sMapEntry.append(OPENBRACE);
        sMapEntry.append(QUOTES);
        sMapEntry.append(sCompType);
        sMapEntry.append(QUOTES);
        sMapEntry.append(COMMA);
        sMapEntry.append(QUOTES);
        sMapEntry.append(sCompName);
        sMapEntry.append(QUOTES);
        sMapEntry.append(COMMA);
        sMapEntry.append(QUOTES);
        sMapEntry.append(sCompVersion);
        sMapEntry.append(QUOTES);
        sMapEntry.append(CLOSEBRACE);
        sMapEntry.append(COMMA);
        return sMapEntry.toString();
    }

    private void generatePreProcFilesMap(String sTLCompName, String sInstallType, Hashtable oFilesMap) {
        try {
            String sFilesMapBaseDir = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + S_FILEMAP_FOLDER);
            File oFilesMapBaseDir = new File(sFilesMapBaseDir);
            oFilesMapBaseDir.mkdir();
            Vector<String> vCreatedFilesMaps = new Vector<String>(31);
            Enumeration oDirsKeys = oFilesMap.keys();
            while (oDirsKeys.hasMoreElements()) {
                String sDir = (String)oDirsKeys.nextElement();
                String sFilesMapDir = null;
                if ("%ORACLE_HOME%".equals(sDir)) {
                    sFilesMapDir = sFilesMapBaseDir;
                    vCreatedFilesMaps.addElement(OiixPathOps.getStandardForm(S_FILES_MAP));
                } else {
                    sFilesMapDir = OiixPathOps.getNativeForm(OiixPathOps.getStandardForm(sFilesMapBaseDir + File.separator + sDir));
                    new File(sFilesMapDir).mkdirs();
                    vCreatedFilesMaps.addElement(sDir + File.separator + S_FILES_MAP);
                }
                PrintWriter oFilesMapWriter = new PrintWriter(new FileWriter(sFilesMapDir + File.separator + S_FILES_MAP, true));
                HashMap oFilesMapFiles = (HashMap)oFilesMap.get(sDir);
                if (oFilesMapFiles != null) {
                    Set oFilesMapKeys = oFilesMapFiles.keySet();
                    for (String sFileName : oFilesMapKeys) {
                        oFilesMapWriter.println((String)oFilesMapFiles.get(sFileName));
                    }
                }
                oFilesMapWriter.close();
            }
            if (vCreatedFilesMaps.size() > 0) {
                String sFileMapJar = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sTLCompName + "_" + sInstallType + S_FILEMAP_JAR_SUFFIX);
                File oFileMapJarFile = new File(sFileMapJar);
                if (oFileMapJarFile.exists()) {
                    oFileMapJarFile.delete();
                }
                OiixJarModifierPool oJMPool = OiixJarModifierPool.getJarModifierPool();
                OiixJarModifier oJarModifier = oJMPool.get(sFileMapJar);
                oJarModifier.setState(1);
                Enumeration oCreatedFiles = vCreatedFilesMaps.elements();
                while (oCreatedFiles.hasMoreElements()) {
                    String sFilesMapFile = (String)oCreatedFiles.nextElement();
                    File oFile = new File(OiixPathOps.getNativeForm(sFilesMapBaseDir + File.separator + sFilesMapFile));
                    oJarModifier.insertEntryFromStream(oFile, sFilesMapFile);
                }
                oJarModifier.setState(2);
            }
            OiixFileOps.recdelete(oFilesMapBaseDir);
        }
        catch (Exception e) {
            if (s_debug) {
                e.printStackTrace();
            }
            this.callBack(e);
        }
    }

    private Vector getCompsToInstallDepNodes(Vector vDepInfo) {
        Vector<OiiodDepNode> vCompsToInstallDepNodes = new Vector<OiiodDepNode>(10, 10);
        if (vDepInfo != null) {
            Enumeration oDeps = vDepInfo.elements();
            while (oDeps.hasMoreElements()) {
                Object[] oaDepInfo = (Object[])oDeps.nextElement();
                OiiodDepNode oDepNode = (OiiodDepNode)oaDepInfo[0];
                vCompsToInstallDepNodes.addElement(oDepNode);
            }
        }
        return vCompsToInstallDepNodes;
    }

    private Vector getKnownComps(Vector vComps) {
        Vector<OiiiStageCompInvEntry> vKnownComps = null;
        if (vComps != null) {
            int nSize = vComps.size();
            vKnownComps = new Vector<OiiiStageCompInvEntry>(nSize);
            for (int i = 0; i < nSize; ++i) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vComps.elementAt(i);
                OiiiVersion[] aoVersions = scie.getInstVersionsArray();
                OiiiVersion oInstVer = OiicInstVersion.getCompatibleInstallerVersion();
                if (aoVersions != null) {
                    OiiiVersion oVersion = this.getMinVersion(aoVersions);
                    if (oVersion.laterThan(oInstVer)) continue;
                    vKnownComps.addElement(scie);
                    continue;
                }
                vKnownComps.addElement(scie);
            }
        }
        return vKnownComps;
    }

    private void fileExists(String sFile) {
        File f = new File(OiixPathOps.getNativeForm(sFile));
        if (!f.exists()) {
            Object[] args = new Object[]{f.getAbsolutePath()};
            this.processError(OiizResourceBundle.getString("S_FILE_NOT_FOUND", args), null);
        }
    }

    private void checkInstallDefnFileExistence(OiiiStageCompInvEntry scie) {
        String sName = scie.getName();
        sName = sName == null ? scie.getCompInstallID().getName() : sName;
        Object[] args = new Object[]{sName};
        this.callBack(OiizResourceBundle.getString("S_CHECKING_INSTALL_DEFN_FILES", args));
        if (scie.isStageVersionPreX("2.0")) {
            String compInsPath = OiixPathOps.concatPath(scie.getLocation(), "compIns.jar");
            compInsPath = OiixPathOps.concatPath(this.m_sStageLoc, compInsPath);
            this.fileExists(compInsPath);
            String compResPath = OiixPathOps.concatPath(scie.getLocation(), "resources/CompRes.jar");
            compResPath = OiixPathOps.concatPath(this.m_sStageLoc, compResPath);
            this.fileExists(compResPath);
        } else {
            String sJarName = scie.getJarName();
            String sJarPath = OiixPathOps.concatPath(this.m_sStageLoc, scie.getInstallDefnLoc());
            sJarPath = OiixPathOps.concatPath(sJarPath, sJarName);
            this.fileExists(sJarPath);
        }
    }

    private void checkFileGroupValidity(OiiiStageCompInvEntry scie) {
    }

    private void checkStageValidity() {
        if ((this.m_iOperationsPerformed & 0xFFFFFFEF) != -1) {
            Vector vComps = this.m_stageInv.getAllCompsVect(0);
            int nSize = vComps.size();
            for (int i = 0; i < nSize; ++i) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vComps.elementAt(i);
                this.checkInstallDefnFileExistence(scie);
                this.checkFileGroupValidity(scie);
            }
            this.m_iOperationsPerformed &= 0xFFFFFFEF;
        }
    }

    public void verifyStage() {
        this.checkStageValidity();
        this.checkForSuperfluousEntries();
    }

    private void checkForSuperfluousEntries() {
        if ((this.m_iOperationsPerformed & 0xFFFFFFDF) != -1) {
            if (!this.m_bError) {
                int nUnusedComps;
                Vector vUnusedComps = this.getSuperfluousComps();
                Vector vKnownUnusedComps = this.getKnownComps(vUnusedComps);
                if (vUnusedComps != null && (nUnusedComps = vUnusedComps.size()) > 0) {
                    String sMsg;
                    Vector vTopComps = this.getTopLevelComps();
                    if (vTopComps == null || vTopComps.size() == 0) {
                        sMsg = OiizResourceBundle.getString("S_TOP_LEVEL_COMPS_ABSENT");
                        this.processWarning(sMsg, null);
                    }
                    if (nUnusedComps > 1) {
                        Object[] asElems = new String[]{String.valueOf(nUnusedComps)};
                        sMsg = MessageFormat.format(OiizResourceBundle.getString("S_UNUSED_COMPS_LIST"), asElems);
                        asElems = null;
                    } else {
                        sMsg = OiizResourceBundle.getString("S_UNUSED_COMPONENT_LIST");
                    }
                    this.processWarning(sMsg, null);
                    int nSWDComps = 0;
                    String sMarkSWDComps = OiizResourceBundle.getString("S_UNUSED_SWD_COMPS_MARK");
                    for (int i = 0; i < nUnusedComps; ++i) {
                        OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vUnusedComps.elementAt(i);
                        OiiiCompInstallID oCID = invEntry.getCompInstallID();
                        String sName = oCID.getName();
                        if (sName.equals(s_JRE) || sName.equals(s_OUI)) {
                            this.callBack(invEntry.getFullDisplayName(false) + sMarkSWDComps);
                            ++nSWDComps;
                            continue;
                        }
                        this.callBack(invEntry.getFullDisplayName(false));
                    }
                    if (nSWDComps == 1) {
                        this.callBack(OiizResourceBundle.getString("S_UNUSED_SWD_COMP"));
                    } else if (nSWDComps > 1) {
                        this.callBack(OiizResourceBundle.getString("S_UNUSED_SWD_COMPS"));
                    }
                }
            } else {
                this.callBack(OiizResourceBundle.getString("S_ERRORS_IN_STAGE_SKIP_REPORT_SUPERFLUOUS_COMPS"));
            }
            this.m_iOperationsPerformed &= 0xFFFFFFDF;
        }
    }

    private void loadComponentsToRead(String invLoc) throws IOException {
        IOException exp;
        block10: {
            exp = null;
            String sInvLocation = invLoc;
            Vector vInstallID = new Vector(2, 2);
            String sError = OiizResourceBundle.getString("S_ERROR");
            try {
                String sInvLoc = OiixPathOps.getStandardForm(invLoc);
                String tempLoc = System.getProperty("oracle.installer.scratchPath");
                this.m_oiSourceAccess = new OiiiSourceAccess(sInvLoc, tempLoc, this.m_progListener, true);
                this.m_stageInv = this.m_oiSourceAccess.getStageInventory();
            }
            catch (StreamCorruptedException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (s_debug) {
                    e.printStackTrace();
                }
            }
            catch (OptionalDataException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (s_debug) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                this.callBack(e);
                exp = e;
                if (s_debug) {
                    e.printStackTrace();
                }
            }
            catch (OiitTargetLockNotAvailableException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (!s_debug) break block10;
                e.printStackTrace();
            }
        }
        if (this.m_stageInv == null) {
            String sMsg = OiizResourceBundle.getString("S_INVREAD_ERROR");
            this.processError(sMsg, null);
        }
        if (exp != null) {
            throw exp;
        }
    }

    private void loadComponents(String invLoc) throws IOException {
        IOException exp;
        block10: {
            exp = null;
            String sInvLocation = invLoc;
            Vector vInstallID = new Vector(2, 2);
            try {
                this.m_oiStageControl = new OiiiStageAreaControl(invLoc, this.m_progListener);
                this.m_stageInv = this.m_oiStageControl.getStageInventory();
                if (this.m_stageInv == null) {
                    String sMsg = OiizResourceBundle.getString("S_INVREAD_ERROR");
                    this.processError(sMsg, null);
                    return;
                }
            }
            catch (StreamCorruptedException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (s_debug) {
                    e.printStackTrace();
                }
            }
            catch (OptionalDataException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (s_debug) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (s_debug) {
                    e.printStackTrace();
                }
            }
            catch (OiitTargetLockNotAvailableException e) {
                this.callBack(e);
                exp = new IOException(e.getMessage());
                if (!s_debug) break block10;
                e.printStackTrace();
            }
        }
        if (exp != null) {
            throw exp;
        }
    }

    private OiiiVersion getMaxVersion(OiiiVersion[] aoVersions) {
        OiiiVersion oVersion = null;
        if (aoVersions != null) {
            for (int i = 0; i < aoVersions.length; ++i) {
                if (oVersion != null && (aoVersions[i] == null || !aoVersions[i].laterThan(oVersion))) continue;
                oVersion = aoVersions[i];
            }
        }
        return oVersion;
    }

    private OiiiVersion getMinVersion(OiiiVersion[] aoVersions) {
        OiiiVersion oVersion = null;
        if (aoVersions != null) {
            for (int i = 0; i < aoVersions.length; ++i) {
                if (oVersion != null && !oVersion.laterThan(aoVersions[i])) continue;
                oVersion = aoVersions[i];
            }
        }
        return oVersion;
    }

    private OiisCompInstallation createCompInstall(OiiiStageCompInvEntry scie) {
        OiisCompInstallation ci = null;
        if (!this.m_IEsToComps.containsKey(scie)) {
            try {
                ci = this.m_oiSourceAccess == null ? OiisStagedCompHelper.createCompInstall(scie, this.m_sourceRoot, null) : OiisStagedCompHelper.createCompInstall(scie, this.m_oiSourceAccess, null);
                if (ci != null) {
                    this.m_IEsToComps.put(scie, ci);
                }
            }
            catch (Exception exp) {
                System.err.println(exp.getMessage());
                if (s_debug) {
                    exp.printStackTrace();
                }
                ci = null;
            }
        } else {
            ci = (OiisCompInstallation)this.m_IEsToComps.get(scie);
        }
        if (ci == null) {
            String sMsg = "";
            OiiiCompInstallID cid = scie.getCompInstallID();
            OiiiVersion[] aoVersions = scie.getInstVersionsArray();
            OiiiVersion oVersion = this.getMinVersion(aoVersions);
            if (oVersion.laterThan(OiicInstaller.getInstallerVersion())) {
                Object[] sArgs = new String[]{cid.getName(), cid.getVersion().toString(), oVersion.toString()};
                sMsg = OiizResourceBundle.getString("S_REQUIRE_HIGHER_INST_VER", sArgs);
            } else if (scie.isStageVersionPreX("2.0")) {
                Object[] sArgs = new String[]{cid.getName(), cid.getVersion().toString()};
                sMsg = OiizResourceBundle.getString("S_CANNOT_ACCESS_COMPINS", sArgs);
            } else {
                Object[] sArgs = new String[]{cid.getName(), cid.getVersion().toString()};
                sMsg = MessageFormat.format(OiizResourceBundle.getString("S_CANNOT_ACCESS_INSTALL_DEFN"), sArgs);
            }
            this.processError(sMsg, null);
        }
        return ci;
    }

    @Override
    public OiisCompInstallation getCompInstall(OiiiCompInstallID cid) {
        OiisCompInstallation ci = null;
        Object sName = null;
        Object sVersion = null;
        OiiiStageCompInvEntry scie = this.m_stageInv.getStageCompInvEntry(cid, new Vector());
        ci = this.createCompInstall(scie);
        if (ci == null && cid == null) {
            String sMsg = OiizResourceBundle.getString("S_NULL_COMPID_PASSED");
            this.processError(sMsg, null);
        }
        return ci;
    }

    @Override
    public synchronized OiisPatchSetInstallation getPSetInstall(OiiiPatchSetInstallID psid) {
        OiisPatchSetInstallation psi = null;
        if (!this.m_IDsToPSets.containsKey(psid)) {
            OiiiStageCompInvEntry scie = this.m_stageInv.getStageCompInvEntry(psid);
            if (scie != null) {
                try {
                    psi = this.m_oiSourceAccess == null ? OiisStagedCompHelper.createPatchSetInstall(scie, this.m_sourceRoot) : OiisStagedCompHelper.createPatchSetInstall(scie, this.m_oiSourceAccess);
                    this.m_IDsToPSets.put(psid, psi);
                }
                catch (Exception exp) {
                    System.err.println(exp.getMessage());
                    if (s_debug) {
                        exp.printStackTrace();
                    }
                    psi = null;
                }
            }
        } else {
            psi = (OiisPatchSetInstallation)this.m_IDsToPSets.get(psid);
        }
        if (psi == null) {
            String sMsg;
            if (psid != null) {
                Object[] sArgs = new String[]{psid.getName(), psid.getVersion().toString()};
                sMsg = MessageFormat.format(OiizResourceBundle.getString("S_CANNOT_ACCESS_COMPINS"), sArgs);
            } else {
                sMsg = OiizResourceBundle.getString("S_NULL_COMPID_PASSED");
            }
            this.processError(sMsg, null);
        }
        return psi;
    }

    private synchronized OiisPatchSetContents getPSetContents(OiiiPatchSetInstallID psid) {
        if (this.m_IDsToPSets.containsKey(psid)) {
            OiiiStageCompInvEntry scie = this.m_stageInv.getStageCompInvEntry(psid);
            if (scie != null) {
                OiisPatchSetInstallation oPSetInstall;
                if (scie.getPatchSetContents() != null && (oPSetInstall = this.getPSetInstall(psid)) != null) {
                    return oPSetInstall.getContents();
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public OiiiStageInventory getStageInv() {
        return this.m_stageInv;
    }

    public void updateStageInventory() {
        this.updateStageInventory(false);
    }

    public void updateStageInventory(boolean bMarkDirty) {
        this.m_bStageModified = bMarkDirty;
        try {
            if (this.m_stageInv == null) {
                System.err.println("Stage inv. is null");
                return;
            }
            this.m_oiStageControl.updateInventory();
            if (this.m_bStageModified) {
                this.m_stageInv.setCompsOrdered(false);
                File oStageDir = new File(this.m_sourceRoot);
                OiizStageVerifier.removeFastCopyMetaData(oStageDir.getParentFile().getParent());
            }
        }
        catch (OiifbCancelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OiixJarModifyException e) {
            OiizStageVerifier.debug("Exception while staging component");
            OiizStageVerifier.debug(e.getMessage());
        }
    }

    public void dispose() {
        if (!this.m_bDisposed) {
            if (this.m_oiStageControl != null) {
                this.m_oiStageControl.cleanUpInvDir();
                this.m_oiStageControl.releaseWriterLock();
                this.m_oiStageControl.dispose();
            }
            if (this.m_oiSourceAccess != null) {
                this.m_oiSourceAccess.dispose();
            }
            this.m_bStageModified = false;
            this.m_bDisposed = true;
        }
    }

    private Enumeration getSuperfluousLibs(int iLibType) {
        Hashtable<OiiiLibInvEntry, OiiiLibInvEntry> oSuperfluousLibs = new Hashtable<OiiiLibInvEntry, OiiiLibInvEntry>();
        Vector vLibs = this.m_stageInv.getAllLibsVect(iLibType);
        int nLibs = vLibs.size();
        for (int i = 0; i < nLibs; ++i) {
            OiiiLibInvEntry libEnv = (OiiiLibInvEntry)vLibs.elementAt(i);
            oSuperfluousLibs.put(libEnv, libEnv);
        }
        Vector vAllComps = this.m_stageInv.getAllCompsVect(0);
        int nComps = vAllComps.size();
        for (int i = 0; i < nComps; ++i) {
            OiiiCompInvEntry oCompInvEntry = (OiiiCompInvEntry)vAllComps.elementAt(i);
            OiiiCompInstallID oCID = oCompInvEntry.getCompInstallID();
            if (oCID.getCompType() == 4) continue;
            OiisCompProperties ocp = this.getCompProperties((OiiiStageCompInvEntry)oCompInvEntry);
            if (ocp != null) {
                vLibs = ocp.getLibraryDeps(iLibType);
                if (vLibs == null) continue;
                nLibs = vLibs.size();
                for (int j = 0; j < nLibs; ++j) {
                    OiiiLibraryID lid = (OiiiLibraryID)vLibs.elementAt(j);
                    OiiiLibInvEntry lie = this.m_stageInv.getCompatLibEntry(lid, iLibType, lid.getInstVer());
                    if (lie != null) {
                        if (!oSuperfluousLibs.containsKey(lie)) continue;
                        oSuperfluousLibs.remove(lie);
                        continue;
                    }
                    System.err.println("Library entry not found for " + lid);
                }
                continue;
            }
            System.err.println("Error: could not load the component properties");
        }
        return oSuperfluousLibs.elements();
    }

    private int removeLibraries(Enumeration oLibs, int iLibType) {
        int nLibsRemoved = 0;
        if (oLibs != null) {
            while (oLibs.hasMoreElements()) {
                OiiiLibInvEntry libEnv = (OiiiLibInvEntry)oLibs.nextElement();
                OiiiLibraryID lid = libEnv.getLibraryID();
                this.m_stageInv.removeLibInvEntry(lid, iLibType);
                ++nLibsRemoved;
            }
        }
        return nLibsRemoved;
    }

    private int removeSuperfluousLibs() {
        int[] iLibTypes = new int[]{0, 1, 2};
        String[] sLibTypeMsg = new String[]{"S_REMOVE_SUPERFLUOUS_ACTION_LIBS", "S_REMOVE_SUPERFLUOUS_QUERY_LIBS", "S_REMOVE_SUPERFLUOUS_DIALOG_LIBS"};
        int nLibsRemoved = 0;
        for (int i = 0; i < iLibTypes.length; ++i) {
            this.callBack(OiizResourceBundle.getString(sLibTypeMsg[i]));
            Enumeration oLibs = this.getSuperfluousLibs(iLibTypes[i]);
            nLibsRemoved += this.removeLibraries(oLibs, iLibTypes[i]);
        }
        return nLibsRemoved;
    }

    private void calculateRequiredSpace(OiiiStageCompInvEntry invEntry, Vector v, Integer nPlat, String sModeId) {
        if (invEntry.isStageVersionPreX("2.2.0.3.0")) {
            this.calculateRequiredSpace2x(invEntry, v, nPlat, sModeId);
        } else {
            int nSize = v.size();
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInstallID id = (OiiiCompInstallID)v.elementAt(i);
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)this.m_stageInv.getCompatCompEntry(id, 0, nPlat);
                long nFileSize = 0L;
                OiisFileSizeInfo oSize = oEntry.getFileSizeInfoEx();
                if (oSize == null) continue;
                OiisCompInstallation oCompInstall = this.createCompInstall(oEntry);
                if (oCompInstall != null) {
                    oCompInstall.setFileSizeInfo(oSize);
                    OiisCompContext oContext = oCompInstall.loadCompContext();
                    oSize.setCompContext(oContext);
                }
                OiizInterCompLangIdxMap oLangIdxMap = this.getInterCompLangIdxMap(oEntry, invEntry);
                oSize.computeFileSizesForRollup();
                long[] lSizes = oSize.getSizesForRollup(nPlat);
                if (null != lSizes && lSizes.length > 0) {
                    lSizes = this.computeMappedSizesForRollup(lSizes, oLangIdxMap);
                    invEntry.updateSize(nPlat, sModeId, lSizes);
                } else {
                    String sPlatname = OiixPlatform.getPlatformName(nPlat);
                    String sMsg = OiizResourceBundle.getString("S_UPDATE_SIZE_NO_PLAT_INFO");
                    Object[] s = new String[]{sPlatname};
                    sMsg = MessageFormat.format(sMsg, s);
                    this.callBack(sMsg);
                }
                long lsz = oSize.getLargestFileGroupJar(nPlat);
                this.calculatePerComponentSizes(nPlat, invEntry.getCompInstallID(), id.getName(), lSizes);
                invEntry.updateLargestJarSize(nPlat, sModeId, lsz);
            }
        }
        this.setSizeProperties(invEntry, nPlat, sModeId);
    }

    private void calculatePerComponentSizes(int nPlat, OiiiCompInstallID topId, String compName, long[] lSizes) {
        String fileKey = topId.getName() + INTERNALNAME_DELIMITER + topId.getVersion().getVerString();
        Properties p = (Properties)this.m_CompsSizes.get(fileKey);
        String compKey = compName + "_" + nPlat;
        if (p == null) {
            p = new Properties();
        } else if (p.containsKey(compKey)) {
            return;
        }
        long size = 0L;
        for (int i = 0; i < lSizes.length; ++i) {
            size += lSizes[i];
        }
        p.setProperty(compKey, size + "");
        this.m_CompsSizes.put(fileKey, p);
    }

    private void setSizeProperties(OiiiStageCompInvEntry invEntry, Integer nPlat, String sModeId) {
        Properties p;
        String key = invEntry.getCompInstallID().getName();
        key = key + invEntry.getCompInstallID().getVersion().getVerString();
        if (null != sModeId) {
            key = key + sModeId;
        }
        if ((p = (Properties)this.m_TLDepModeSizes.get(key)) == null) {
            p = new Properties();
        }
        OiisSize sz = invEntry.getSizeInfo();
        sz.setLangIndexMapping(invEntry.getLangIndexMapping());
        p.setProperty("ALL_LANGUAGES_" + nPlat, sz.getSize(nPlat, sModeId).toString());
        Vector<Locale> v = new Vector<Locale>(1, 1);
        v.add(Locale.ENGLISH);
        p.setProperty("ENGLISH_" + nPlat, sz.getSize(nPlat, sModeId, v).toString());
        this.m_TLDepModeSizes.put(key, p);
    }

    private void calculateRequiredSpace2x(OiiiStageCompInvEntry invEntry, Vector v, Integer nPlat, String sModeId) {
        int nSize = v.size();
        long totalSize = 0L;
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInstallID id = (OiiiCompInstallID)v.elementAt(i);
            OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)this.m_stageInv.getCompatCompEntry(id, 0, nPlat);
            long nFileSize = 0L;
            OiisFileSizeInfo oSize = oEntry.getFileSizeInfoEx();
            if (oSize != null) {
                OiisCompInstallation oCompInstall = this.createCompInstall(oEntry);
                oCompInstall.setFileSizeInfo(oSize);
                if (oCompInstall != null) {
                    OiisCompContext oContext = oCompInstall.loadCompContext();
                    oSize.setCompContext(oContext);
                }
                Vector<Integer> plat = new Vector<Integer>();
                plat.addElement(nPlat);
                nFileSize = oSize.getSizeEx(null, plat);
            }
            totalSize += nFileSize;
        }
        String sMsg = OiizResourceBundle.getString("S_SIZE_UPDATE");
        Object[] s = new String[]{"" + totalSize};
        sMsg = MessageFormat.format(sMsg, s);
        this.callBack(sMsg);
        invEntry.setSize(nPlat, sModeId, new Long(totalSize));
    }

    private OiizInterCompLangIdxMap getInterCompLangIdxMap(OiiiStageCompInvEntry e1, OiiiStageCompInvEntry e2) {
        OiizInterCompLangIdxMap iclim;
        if (this.m_oCompLangIdxMap == null) {
            this.m_oCompLangIdxMap = new Hashtable();
        }
        if (this.m_oCompLangIdxMap.containsKey(e1)) {
            iclim = (OiizInterCompLangIdxMap)this.m_oCompLangIdxMap.get(e1);
            if (iclim.getMappingComponent() == e2) {
                return iclim;
            }
            this.m_oCompLangIdxMap.remove(e1);
        }
        iclim = new OiizInterCompLangIdxMap(e1, e2);
        this.m_oCompLangIdxMap.put(e1, iclim);
        return (OiizInterCompLangIdxMap)this.m_oCompLangIdxMap.get(e1);
    }

    private long[] computeMappedSizesForRollup(long[] alSizes, OiizInterCompLangIdxMap oLangIdxMap) {
        int i;
        OiisLangIndexMapping lim = oLangIdxMap.getTargetLangIndexMapping();
        Vector vLangSets = lim.getLangSets();
        int nLangSets = vLangSets.size();
        long[] alMappedSizes = new long[nLangSets + 1];
        for (i = 0; i < nLangSets; ++i) {
            alMappedSizes[i] = 0L;
        }
        alMappedSizes[nLangSets] = 0L;
        for (i = 0; i < alSizes.length - 1; ++i) {
            alMappedSizes[oLangIdxMap.getLangSetIdxMap((int)i)] = alSizes[i];
        }
        if (alSizes.length > 0) {
            alMappedSizes[nLangSets] = alSizes[alSizes.length - 1];
        }
        return alMappedSizes;
    }

    public static int makeTemplateStage(String stageLocation, OiizCallback callback) throws IOException {
        OiizStageVerifier verifier = null;
        stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation);
        verifier = new OiizStageVerifier(stageLocation);
        verifier.setCallBack(callback);
        try {
            verifier.makeTemplateStage();
        }
        catch (Exception e) {
            System.err.println("Error " + e.getMessage());
            verifier.dispose();
            return 1;
        }
        verifier.dispose();
        if (verifier.isError()) {
            return 1;
        }
        return 0;
    }

    public void makeTemplateStage() {
        if (this.m_stageInv == null) {
            return;
        }
        String sLocMakeTemplate = this.m_sourceRoot + File.separatorChar + "ReferenceMakeOrder";
        File oParent = new File(sLocMakeTemplate);
        try {
            OiipgFileSystem.checkWritablePath(sLocMakeTemplate);
            OiipgFileSystem.mkdirs(oParent);
        }
        catch (OiipgPathException ie) {
            this.callBack(ie);
            return;
        }
        if (this.m_oiSourceAccess == null) {
            String sInvLoc = OiixPathOps.getStandardForm(this.m_sInvLoc);
            String tempLoc = System.getProperty("oracle.installer.scratchPath");
            try {
                this.m_oiSourceAccess = new OiiiSourceAccess(sInvLoc, tempLoc, true, this.m_progListener, false, false);
            }
            catch (OiitTargetLockNotAvailableException elock) {
                this.callBack(elock);
            }
            catch (IOException io) {
                this.callBack(io);
            }
        }
        this.checkStageValidity();
        if (!this.m_bError) {
            Enumeration vAllComps = this.m_stageInv.getAllComps(0);
            String sError = OiizResourceBundle.getString("S_ERROR");
            OiiiVersion oInstVer = OiicInstVersion.getCompatibleInstallerVersion();
            String sInstVer = oInstVer.getVerString();
            while (vAllComps.hasMoreElements()) {
                OiiiStageCompInvEntry invTopEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                if (!invTopEntry.isTopLevel()) continue;
                OiiiCompInstallID idTop = invTopEntry.getCompInstallID();
                if (invTopEntry.isStageVersionPostX(sInstVer)) {
                    OiiiVersion oVersion = invTopEntry.getStageVersion();
                    if (oVersion == null) {
                        OiiiVersion[] aoVersions = invTopEntry.getInstVersionsArray();
                        oVersion = this.getMinVersion(aoVersions);
                    }
                    Object[] sArgs = new String[]{idTop.getName(), idTop.getVersion().toString(), oVersion.toString()};
                    String sMsg = OiizResourceBundle.getString("S_SKIPPING_HIGHER_INST_VER_COMP", sArgs);
                    this.processWarning(sMsg, null);
                    continue;
                }
                this.callBack(OiizResourceBundle.getString("S_PROCESSING_DEPENDENCIES"));
                OiiodDepEngine depEngine = new OiiodDepEngine(this, true);
                depEngine.setErrListener(this);
                depEngine.setInventories(this.m_stageInv, new OiiiInstallInventory());
                depEngine.setCurrentPlatform(0);
                depEngine.setExecutePreReq(false);
                OiiiCompInstallID[] ids = new OiiiCompInstallID[]{idTop};
                depEngine.setCurrentTLIDs(ids);
                try {
                    depEngine.buildCompArray();
                }
                catch (OiiodDepException exp) {
                    this.processError(exp.getMessage(), null);
                    return;
                }
                String modeID = "Custom";
                try {
                    depEngine.depModeApply(false);
                    OiisDepInfo tlDInfo = this.getDepInfo(invTopEntry);
                    if (tlDInfo != null) {
                        tlDInfo.setDepModeName(modeID);
                    }
                    depEngine.depModeApply(false);
                    Vector vError = new Vector();
                    depEngine.checkTreeCorrectness(vError);
                    if (vError.size() > 0) {
                        this.processError(vError.toString(), null);
                        return;
                    }
                    Vector vDepInfo = depEngine.getParticipatingCompsWithDependees();
                    Vector vCompsToInstall = null;
                    boolean bGenerateForPatchset = false;
                    if (idTop.getCompType() == 4) {
                        vCompsToInstall = this.getContainedPatches(idTop);
                        bGenerateForPatchset = true;
                    } else {
                        vCompsToInstall = this.getCompsToInstall(vDepInfo);
                        bGenerateForPatchset = false;
                    }
                    int nCompsToInstall = vCompsToInstall.size();
                    Vector vPlats = new Vector(0);
                    ArrayList vTargets = new ArrayList();
                    HashMap<OiisRelinkInfo, ArrayList> targetMap = new HashMap<OiisRelinkInfo, ArrayList>();
                    ArrayList<OiiiCompInstallID> vOldComps = new ArrayList<OiiiCompInstallID>();
                    for (int k = 0; k < nCompsToInstall; ++k) {
                        OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)this.m_stageInv.getCompInvEntry((OiiiCompInstallID)vCompsToInstall.elementAt(k), 0, vPlats);
                        OiiiCompInstallID id = invEntry.getCompInstallID();
                        if (id.getCompType() == 4) continue;
                        OiisCompProperties oCompProps = invEntry.getCompProperties();
                        if (invEntry.isStageVersionPreX("10.2")) {
                            vOldComps.add(id);
                            continue;
                        }
                        OiisCompJarInfo oCompJarInfo = oCompProps.getCompJarInfo();
                        String[] makedeps = oCompJarInfo.getActionPhaseClasses();
                        String sInstallJarName = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + invEntry.getJarName());
                        ZipFile oInstallJar = new ZipFile(sInstallJarName);
                        if (makedeps == null) continue;
                        for (int j = 0; j < makedeps.length; ++j) {
                            String makedep = makedeps[j];
                            String makeFileName = OiixPathOps.getStandardForm(makedep);
                            makeFileName = OiixPathOps.getFileName(makedep);
                            if (!makeFileName.startsWith("makedeps")) continue;
                            ZipEntry oEntry = oInstallJar.getEntry(makedep);
                            String scratch = System.getProperty("SCRATCH_PATH_LOCATION");
                            try {
                                String sLine;
                                BufferedReader omakeReader = new BufferedReader(new InputStreamReader(oInstallJar.getInputStream(oEntry)));
                                File newFile = new File(scratch + File.separatorChar + "MakeDeps.xml");
                                if (newFile.exists()) {
                                    newFile.delete();
                                    newFile.createNewFile();
                                }
                                FileWriter fw = new FileWriter(newFile);
                                PrintWriter pw = new PrintWriter(fw);
                                while ((sLine = omakeReader.readLine()) != null) {
                                    sLine = sLine.trim();
                                    pw.println(sLine);
                                    if (!sLine.startsWith("</ohmd:MAKE_LIST")) continue;
                                }
                                pw.close();
                                fw.close();
                                omakeReader.close();
                                OiisMakeDepsReader mdr = new OiisMakeDepsReader(scratch + File.separatorChar + "MakeDeps.xml", "", true);
                                mdr.loadFromFile();
                            }
                            catch (Exception expAny) {
                                this.callBack("Eror in loading " + oEntry.getName());
                                continue;
                            }
                            ArrayList ret = OiisMakeDeps.getTable();
                            for (OiisMakeDeps md : ret) {
                                OiisRelinkInfo ri = md.getRelinkInfo();
                                ArrayList stored = null;
                                OiisRelinkInfo riI2 = null;
                                boolean found = false;
                                for (OiisRelinkInfo riI2 : targetMap.keySet()) {
                                    if (!riI2.getMakeFileName().equals(ri.getMakeFileName()) || !riI2.getTarget().equals(ri.getTarget())) continue;
                                    stored = (ArrayList)targetMap.get(riI2);
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    riI2 = ri;
                                }
                                if (stored == null) {
                                    stored = new ArrayList();
                                }
                                stored.add(oCompProps.getCompInstallID());
                                targetMap.put(riI2, stored);
                            }
                            OiisMakeDeps.clearCommandTable();
                        }
                        oInstallJar.close();
                    }
                    this.writeTemplateMakeDeps(sLocMakeTemplate, idTop, targetMap, vOldComps);
                }
                catch (OiiodDepException exp) {
                    exp.printStackTrace();
                    if (!this.m_IEsToComps.containsKey(invTopEntry)) continue;
                    this.callBack(exp);
                }
                catch (OiifbCancelException exp) {
                    exp.printStackTrace();
                    this.callBack(exp);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    this.callBack(exp);
                }
            }
        } else {
            this.callBack(OiizResourceBundle.getString("S_ERRORS_IN_STAGE_SKIP_MAKE_TEMPLATE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplateMakeDeps(String Location2, OiiiCompInstallID id, HashMap targetMap, ArrayList vOldComps) {
        OutputStreamWriter fWriter = null;
        PrintWriter pWriter = null;
        try {
            fWriter = new FileWriter(Location2 + File.separatorChar + id.getName() + "_MakeDeps.xml");
            pWriter = new PrintWriter(fWriter);
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            pWriter.println("<ohmd:MAKE_LIST xmlns:ohmd=\"make_desc.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"make_desc.xsd make_desc.xsd\">");
            StringBuffer sMakedeps = new StringBuffer();
            for (OiisRelinkInfo ri : targetMap.keySet()) {
                String fileName;
                ArrayList comps = (ArrayList)targetMap.get(ri);
                sMakedeps.append("\n<ohmd:MAKE");
                String makePath = ri.getMakePath();
                if (makePath != null && !makePath.equals("")) {
                    sMakedeps.append(" MAKEPATH=\"" + OixwXmlWriterOps.encodeSplChars(makePath) + QUOTES);
                }
                if ((fileName = ri.getMakeFileName()) != null && !fileName.equals("")) {
                    sMakedeps.append(" FILENAME=\"" + OixwXmlWriterOps.encodeSplChars(fileName) + "\">");
                }
                sMakedeps.append("\n<ohmd:TARGET TARGETNAME=\"" + ri.getTarget() + "\" ");
                String actionType = ri.getActionType();
                if (actionType != null && actionType.length() > 0) {
                    sMakedeps.append("ACTIONTYPE=\"" + OixwXmlWriterOps.encodeSplChars(actionType) + "\" ");
                }
                sMakedeps.append(">");
                String[] args = ri.getParamArguments();
                if (args == null) {
                    args = ri.getArguments();
                }
                if (args != null) {
                    if (args.length > 0) {
                        sMakedeps.append("\n<ohmd:INPUT_LIST>");
                    }
                    for (int i = 0; i < args.length; ++i) {
                        String expStr = args[i];
                        sMakedeps.append("\n<ohmd:INPUT VAL=\"" + OixwXmlWriterOps.encodeSplChars(expStr) + "\"/>");
                    }
                    if (args.length > 0) {
                        sMakedeps.append("\n</ohmd:INPUT_LIST>");
                    }
                }
                sMakedeps.append("\n<ohmd:COMP_LIST>");
                for (OiiiCompInstallID compId : comps) {
                    sMakedeps.append("\n<");
                    if (compId.getCompType() == 2) {
                        sMakedeps.append("ohmd:PATCH");
                    } else {
                        sMakedeps.append("ohmd:COMP");
                    }
                    sMakedeps.append(" NAME=\"" + compId.getName() + "\" " + "VERSION=\"" + compId.getVersion().getVerString() + "\"/>");
                }
                sMakedeps.append("\n</ohmd:COMP_LIST>");
                sMakedeps.append("\n</ohmd:TARGET>");
                sMakedeps.append("\n</ohmd:MAKE>");
            }
            pWriter.println(sMakedeps.toString());
            for (int g = 0; g < vOldComps.size(); ++g) {
                OiiiCompInstallID compId = (OiiiCompInstallID)vOldComps.get(g);
                pWriter.println("\n<!-- Pre 11.1 component, please add targets, COMP = " + compId.getName() + " VERSION = " + compId.getVersion().getVerString() + " -->");
            }
            pWriter.println("</ohmd:MAKE_LIST>");
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (pWriter != null) {
                    pWriter.close();
                }
                if (fWriter != null) {
                    fWriter.close();
                }
            }
            catch (Exception e) {
                this.callBack("Error in closing " + Location2);
            }
        }
    }

    public void mergeStage() {
        boolean bStgInvModified = false;
        if (this.m_stageInv == null) {
            return;
        }
        Vector vAllPatches = this.m_stageInv.getAllPatches(0);
        if (this.m_oiSourceAccess == null) {
            String sInvLoc = OiixPathOps.getStandardForm(this.m_sInvLoc);
            String tempLoc = System.getProperty("oracle.installer.scratchPath");
            try {
                this.m_oiSourceAccess = new OiiiSourceAccess(sInvLoc, tempLoc, true, this.m_progListener, false, false);
            }
            catch (OiitTargetLockNotAvailableException elock) {
                this.callBack(elock);
            }
            catch (IOException io) {
                this.callBack(io);
            }
        }
        int nPatSize = vAllPatches.size();
        for (int i = 0; i < nPatSize; ++i) {
            OiiiStageCompInvEntry entry;
            OiiiStagePatchInvEntry oEntry = (OiiiStagePatchInvEntry)vAllPatches.elementAt(i);
            OiiiPatchInstallID oPatchID = (OiiiPatchInstallID)oEntry.getCompInstallID();
            if (oEntry.isMerged() && (entry = (OiiiStageCompInvEntry)this.m_stageInv.getCompatCompEntry(oPatchID.getCompInstallID())) != null && entry.isMerged()) continue;
            OiiiCompInstallID oPatCompID = oPatchID.getCompInstallID();
            boolean bMerge = true;
            for (int j = 0; j < nPatSize; ++j) {
                if (j == i) continue;
                OiiiStagePatchInvEntry oHigherEntry = (OiiiStagePatchInvEntry)vAllPatches.elementAt(j);
                OiiiPatchInstallID oHigherPatchID = (OiiiPatchInstallID)oHigherEntry.getCompInstallID();
                OiiiCompInstallID oHigherPatCompID = oHigherPatchID.getCompInstallID();
                if (oPatCompID == null || oHigherPatCompID == null || !oPatCompID.isCompatible(oHigherPatCompID) || !oHigherPatchID.getVersion().laterThan(oPatchID.getVersion())) continue;
                Object[] args = new Object[]{oEntry.getFullDisplayName()};
                this.callBack(OiizResourceBundle.getString("S_HIGHER_PATCH_AVBL", args));
                bMerge = false;
                break;
            }
            if (!bMerge) continue;
            OiisStagedCompRep oPat = null;
            try {
                oPat = (OiisPatchInstallation)OiisStagedCompHelper.createCompInstall(oEntry, this.m_oiSourceAccess);
            }
            catch (OiifbCancelException oHigherEntry) {
                // empty catch block
            }
            OiisFileMap oPatFileMap = oPat.getFileMap();
            ArrayList<OiisFileEntry> aListOfPatchFiles = new ArrayList<OiisFileEntry>();
            Enumeration ePat = oPatFileMap.getFileGroupNames();
            while (ePat.hasMoreElements()) {
                String sGroupName = (String)ePat.nextElement();
                OiisFileGroup fg = oPatFileMap.getFileGroup(sGroupName);
                Vector fileEntries = fg.getEntries();
                for (int z = 0; z < fileEntries.size(); ++z) {
                    OiisFileEntry fl = (OiisFileEntry)fileEntries.elementAt(z);
                    aListOfPatchFiles.add(fl);
                }
            }
            if (aListOfPatchFiles.size() <= 0) continue;
            Vector vAllComps = this.m_stageInv.getAllCompsVect(0);
            int nComps = vAllComps.size();
            for (int j = 0; j < nComps; ++j) {
                OiiiCompInstallID oid = null;
                OiiiStageCompInvEntry osEntry = (OiiiStageCompInvEntry)vAllComps.elementAt(j);
                if (osEntry != null && (oid = osEntry.getCompInstallID()).getCompType() != 1 || oid == null || !oid.isCompatible(oPatCompID) || !oPatchID.getVersion().laterThan(oid.getVersion())) continue;
                boolean bCompModified = false;
                OiisStagedCompRep oComp = null;
                try {
                    oComp = OiisStagedCompHelper.createCompInstall(osEntry, this.m_oiSourceAccess);
                }
                catch (OiifbCancelException oiifbCancelException) {
                    // empty catch block
                }
                OiisFileMap oFileMap = oComp.getFileMap();
                Enumeration e = oFileMap.getFileGroupNames();
                while (e.hasMoreElements()) {
                    String sGroupName = (String)e.nextElement();
                    OiisFileGroup fg = oFileMap.getFileGroup(sGroupName);
                    String jarFile = null;
                    try {
                        jarFile = this.m_oiSourceAccess.fetchCompFilesJar(oid, osEntry.getPlatforms(), sGroupName, null);
                    }
                    catch (OiifbCancelException oiifbCancelException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Vector fileEntries = fg.getEntries();
                    Hashtable jarsToModify = new Hashtable(10);
                    for (int z = 0; z < fileEntries.size(); ++z) {
                        OiisFileEntry fl = (OiisFileEntry)fileEntries.elementAt(z);
                        for (OiisFileEntry flPat : aListOfPatchFiles) {
                            if (!flPat.getDestination().equals(fl.getDestination()) || fl.isDirectoryEntry()) continue;
                            Vector vPatLang = OiixVectorOps.arrayToVect(flPat.getLanguages());
                            Vector vPatPlat = OiixVectorOps.arrayToVect(flPat.getPlatforms());
                            Vector vLang = OiixVectorOps.arrayToVect(fl.getLanguages());
                            Vector vPlat = OiixVectorOps.arrayToVect(fl.getPlatforms());
                            if (!OiixVectorOps.vectorSubset(vPlat, vPatPlat) || !OiixVectorOps.vectorSubset(vLang, vPatLang)) {
                                // empty if block
                            }
                            try {
                                if (!fg.isGroupArchived()) {
                                    String groupRelLoc = fg.getGroupLocation();
                                    String fileLoc = this.m_oiSourceAccess.fetchCompFileForExpandedGroup(oid, groupRelLoc, fl.getSource(), null);
                                    File oFile = new File(fileLoc);
                                    oFile.delete();
                                    oFile.createNewFile();
                                    continue;
                                }
                                int pBitPos = fl.getPlatBitSetRefPos();
                                int lBitPos = fl.getLangBitSetRefPos();
                                String groupJarName = jarFile;
                                if (pBitPos >= 0 && lBitPos >= 0) {
                                    groupJarName = groupJarName + INTERNALNAME_DELIMITER + lBitPos + INTERNALNAME_DELIMITER + pBitPos;
                                }
                                groupJarName = groupJarName + ".jar";
                                Vector<OiisFileEntry> files = null;
                                files = jarsToModify.containsKey(groupJarName) ? (Vector<OiisFileEntry>)jarsToModify.get(groupJarName) : new Vector<OiisFileEntry>(5, 5);
                                if (files != null) {
                                    files.add(fl);
                                    jarsToModify.put(groupJarName, files);
                                }
                                osEntry.getFileSizeInfoEx().updateSize(lBitPos, pBitPos, fl.getTargetVolume(), -fl.getSizeEx());
                                fl.setSizeEx(0L);
                                osEntry.setMerged(true);
                                osEntry.setMergedVersion(oPatchID.getVersion());
                                oEntry.setMerged(true);
                                bStgInvModified = true;
                                bCompModified = true;
                            }
                            catch (Exception jarModExp) {
                                if (s_debug) {
                                    jarModExp.printStackTrace();
                                }
                                this.callBack(jarModExp);
                            }
                        }
                    }
                    Enumeration enum_1 = jarsToModify.keys();
                    while (enum_1.hasMoreElements()) {
                        try {
                            ZipEntry ze;
                            String groupJarName = (String)enum_1.nextElement();
                            String groupJarNameNew = groupJarName + ".new";
                            File oNewFile = new File(groupJarNameNew);
                            if (oNewFile.exists()) {
                                oNewFile.delete();
                            }
                            FileInputStream fis = new FileInputStream(groupJarName);
                            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                            FileOutputStream fos = new FileOutputStream(groupJarNameNew);
                            ZipOutputStream targetStream = new ZipOutputStream(fos);
                            targetStream.setMethod(8);
                            targetStream.setLevel(9);
                            while ((ze = zis.getNextEntry()) != null) {
                                int readD;
                                String sFullNameZE;
                                ZipEntry nze = new ZipEntry(ze.getName());
                                nze.setMethod(ze.getMethod());
                                if (ze.getComment() != null) {
                                    nze.setComment(ze.getComment());
                                }
                                nze.setTime(ze.getTime());
                                String sNameZE = sFullNameZE = ze.getName();
                                int idx = 0;
                                idx = sNameZE.lastIndexOf("/");
                                if (idx != -1) {
                                    sNameZE = sNameZE.substring(idx + 1);
                                }
                                Vector files = (Vector)jarsToModify.get(groupJarName);
                                int sz = files.size();
                                boolean merge = false;
                                for (int count = 0; count < sz; ++count) {
                                    OiisFileEntry fl = (OiisFileEntry)files.elementAt(count);
                                    if (!sNameZE.equals(fl.getSource()) || !fl.getDestination().endsWith(sFullNameZE)) continue;
                                    merge = true;
                                    break;
                                }
                                if (merge) {
                                    nze.setSize(0L);
                                    nze.setCompressedSize(0L);
                                }
                                targetStream.putNextEntry(nze);
                                if (merge) continue;
                                byte[] data = new byte[2048];
                                while ((readD = zis.read(data, 0, 2048)) != -1) {
                                    targetStream.write(data, 0, readD);
                                }
                            }
                            zis.close();
                            targetStream.close();
                            File oJarFile = new File(groupJarName);
                            oJarFile.delete();
                            File oJarNewFile = new File(groupJarNameNew);
                            oJarNewFile.renameTo(oJarFile);
                        }
                        catch (Exception jarExcpns) {
                            if (s_debug) {
                                jarExcpns.printStackTrace();
                            }
                            this.callBack(jarExcpns);
                        }
                    }
                }
                if (!bCompModified) continue;
                Object[] objs = new Object[]{osEntry.getFullDisplayName(), oEntry.getFullDisplayName()};
                String sKey = "S_MERGING_COMP";
                this.callBack(OiizResourceBundle.getString(sKey, objs));
            }
        }
        try {
            if (bStgInvModified) {
                this.updateStageInventory(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private String updateNewLine(String sStr) {
        String sReplacee = "\n";
        String sReplacer = sNewLine + this.sCommentChar;
        String sVar = OiixFunctionOps.replaceStr(sStr, sReplacer, sReplacee);
        sVar = OiixFunctionOps.replaceStr(sVar, sReplacee, sReplacer);
        if (sStr.endsWith(sReplacee) && sVar.endsWith(sReplacer)) {
            sVar = sVar.substring(0, sVar.length() - 1);
        }
        return sVar;
    }

    private void generateVariableBlock(OiixIniSection oSection, OiisVariable oVar) throws IOException {
        String sAllValues;
        String sVarName = oVar.getName();
        int nType = oVar.getType();
        OiisAdvisedValue oVal = oVar.getInitialValue();
        String sValue = oVal != null ? (String)oVal.getValue() : (oVar.isCalcMethodPresent() ? OiizResourceBundle.getString("S_RSP_DEF_VAL1") : OiizResourceBundle.getString("S_RSP_DEF_VAL2"));
        Vector<String> vComments = new Vector<String>(4);
        boolean i = false;
        vComments.addElement(this.sCommentChar + OiizResourceBundle.getString("S_RSP_PARAM_STR") + sVarName);
        vComments.addElement(this.sCommentChar + OiizResourceBundle.getString("S_RSP_TYPE_STR") + OiisVariable.getTypeString(nType));
        String sVarDesc = oVar.getDescription();
        if (sVarDesc != null) {
            sVarDesc = this.updateNewLine(sVarDesc);
        }
        if (sVarDesc != null) {
            vComments.addElement(this.sCommentChar + OiizResourceBundle.getString("S_RSP_DESC_STR") + sVarDesc);
        }
        if ((sAllValues = oVar.getAllValueList()) != null) {
            vComments.addElement(sAllValues);
        }
        Object[] asComments = new String[vComments.size()];
        vComments.copyInto(asComments);
        this.updateSection(oSection, sVarName, sValue, (String[])asComments);
    }

    private OiixIniFile getResponseFileObject(OiiiCompInstallID oCompID, OiisDepMode oDepMode) {
        File file = new File(this.m_sInvLoc);
        String sDir = file.getParent() + File.separator + "Response";
        String sRespLocation = sDir + File.separator + oCompID.getName() + INTERNALNAME_DELIMITER + (oDepMode != null ? oDepMode.getInternalName() : "Custom") + ".rsp";
        File oParent = new File(sDir);
        try {
            OiipgFileSystem.checkWritablePath(sDir);
            OiipgFileSystem.mkdirs(oParent);
        }
        catch (OiipgPathException ie) {
            this.callBack(ie);
            return null;
        }
        OiixIniFile oIniFile = new OiixIniFile(sRespLocation, true);
        File f = new File(sRespLocation);
        this.m_bRespFileExists = f.exists();
        if (!this.m_bRespFileExists) {
            this.setHeader(oIniFile);
        } else {
            try {
                oIniFile.readFile();
            }
            catch (OiixIniParsingException e) {
                oIniFile = null;
                f.delete();
                oIniFile = new OiixIniFile(sRespLocation, true);
                this.m_bRespFileExists = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setGeneralSection(oIniFile);
        return oIniFile;
    }

    private void updateSection(OiixIniSection oSection, String sName, String sValue, String sDesc) {
        String[] asComments = null;
        if (sDesc != null) {
            asComments = new String[1];
            asComments[1] = sDesc;
        }
        this.updateSection(oSection, sName, sValue, asComments);
    }

    private void updateSection(OiixIniSection oSection, String sName, String sValue, String[] asComments) {
        OiixIniPair oPair = oSection.getPair(sName);
        if (oPair == null) {
            if (asComments != null && asComments.length > 0) {
                int i = 0;
                String sHdr = asComments[i];
                OiixIniComment oComment = new OiixIniComment(sHdr);
                if (asComments.length > 1) {
                    for (i = 1; i < asComments.length; ++i) {
                        oComment.addLine(asComments[i]);
                    }
                    oSection.addItem(oComment);
                }
            }
            try {
                oPair = new OiixIniPair(sName, sValue);
                oSection.addItem(oPair);
                oSection.addItem(new OiixIniRawText(sNewLine));
            }
            catch (OiixIniParsingException e) {
                e.printStackTrace();
            }
        } else {
            String sOrigVal = oPair.getValue();
            if (sValue != null && sOrigVal != null && oPair.getValue().equals("")) {
                oPair.setValue(sValue);
            }
        }
    }

    private void setGeneralSection(OiixIniFile oIniFile) {
        String sSection = OiizResourceBundle.getString("S_RSP_GENERAL");
        OiixIniSection oSection = oIniFile.addSection(sSection);
        String[] asComments = new String[]{};
        this.updateSection(oSection, OiizResourceBundle.getString("S_RSP_VERSTR"), OiizResourceBundle.getString("S_RSP_VERSION"), asComments);
    }

    public void generateResponseFile() {
        if (this.m_stageInv == null) {
            return;
        }
        Locale.setDefault(OiixLanguage.ENGLISH);
        if ((this.m_iOperationsPerformed & 0xFFFFFFFD) != -1) {
            this.checkStageValidity();
            if (!this.m_bError) {
                Enumeration vAllComps = this.m_stageInv.getAllComps(0);
                String sError = OiizResourceBundle.getString("S_ERROR");
                OiiiVersion oInstVer = OiicInstVersion.getCompatibleInstallerVersion();
                String sInstVer = oInstVer.getVerString();
                while (vAllComps.hasMoreElements()) {
                    OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                    if (!invEntry.isTopLevel()) continue;
                    if (invEntry.isStageVersionPostX(sInstVer)) {
                        OiiiVersion oVersion = invEntry.getStageVersion();
                        if (oVersion == null) {
                            OiiiVersion[] aoVersions = invEntry.getInstVersionsArray();
                            oVersion = this.getMinVersion(aoVersions);
                        }
                        OiiiCompInstallID cid = invEntry.getCompInstallID();
                        Object[] sArgs = new String[]{cid.getName(), cid.getVersion().toString(), oVersion.toString()};
                        String sMsg = OiizResourceBundle.getString("S_SKIPPING_HIGHER_INST_VER_COMP", sArgs);
                        this.processWarning(sMsg, null);
                        continue;
                    }
                    this.processDepGraph(2, invEntry, 0);
                }
            } else {
                this.callBack(OiizResourceBundle.getString("S_ERRORS_IN_STAGE_SKIP_GENERATE_RESP_FILE"));
            }
            this.m_iOperationsPerformed &= 0xFFFFFFFD;
        }
    }

    private void setHeader(OiixIniFile oIniFile) {
        OiixIniComment oComment = null;
        int i = 1;
        String sHdr = OiizResourceBundle.getString("S_RSP_HEADING" + i);
        oComment = new OiixIniComment(sHdr);
        for (i = 2; i < 25; ++i) {
            oComment.addLine(OiizResourceBundle.getString("S_RSP_HEADING" + i));
        }
        oIniFile.addItem(oComment);
    }

    private boolean customizeDependeeList(OiisVariable oVar, OiiiCompInstallID oCompID, Vector vDepNodes) {
        String sVal = "";
        int nDepNodes = vDepNodes.size();
        String sDepList = "";
        String sMsg = "";
        boolean bRetVal = true;
        for (int i = 0; i < nDepNodes; ++i) {
            OiiodDepNode oDepNode = (OiiodDepNode)vDepNodes.elementAt(i);
            OiiiCompInstallID oCID = oDepNode.getCompInstallID();
            Object[] sData = new String[]{oCID.getName(), oCID.getVersion().getVerString()};
            sMsg = i < nDepNodes - 1 ? MessageFormat.format(OiixResourceBundle.getString("S_DEPENDEE_FORMAT1"), sData) : MessageFormat.format(OiixResourceBundle.getString("S_DEPENDEE_FORMAT2"), sData);
            sDepList = sDepList + sMsg;
        }
        if (!sDepList.equals("")) {
            Object[] sData = new String[]{sDepList};
            sDepList = MessageFormat.format(OiixResourceBundle.getString("S_DEPENDEE_LIST_FORMAT"), sData);
            oVar.setInitialValue(new OiisAdvisedValue(sDepList, false));
        } else {
            oVar.setCalcMethodPresent(true);
            bRetVal = false;
        }
        return bRetVal;
    }

    private void generateResponseFile(OiiiCompInstallID oCompID, OiisDepMode oDepMode, Vector vDepInfo) throws OiifbCancelException {
        if (this.m_stageInv == null) {
            return;
        }
        File file = new File(this.m_sInvLoc);
        String sDir = file.getParent() + File.separator + m_sRspDirName;
        String sRespLocation = sDir + File.separator + oCompID.getName() + INTERNALNAME_DELIMITER + (oDepMode != null ? oDepMode.getInternalName() : "Custom") + m_sRspExt;
        if (this.m_vGeneratedRSPFiles == null) {
            this.m_vGeneratedRSPFiles = new Vector();
        }
        if (this.m_vGeneratedRSPFiles.contains(sRespLocation)) {
            return;
        }
        File oParent = new File(sDir);
        File f = new File(sRespLocation);
        try {
            OiipgFileSystem.checkWritablePath(sDir);
            OiipgFileSystem.mkdirs(oParent);
        }
        catch (OiipgPathException ie) {
            this.callBack(ie);
            return;
        }
        FileOutputStream fStream = null;
        PrintWriter out = null;
        this.m_bRespFileExists = f.exists();
        if (this.m_bRespFileExists) {
            String strBakLoc = sRespLocation + m_sRspBakExt;
            File fBak = new File(strBakLoc);
            if (fBak.exists()) {
                fBak.delete();
            }
            File foriginal = new File(sRespLocation);
            foriginal.renameTo(fBak);
        }
        try {
            fStream = new FileOutputStream(f);
            out = new PrintWriter(fStream);
        }
        catch (FileNotFoundException e) {
            this.callBack(e);
            return;
        }
        catch (IOException e) {
            this.callBack(e);
            return;
        }
        Enumeration vAllComps = this.m_stageInv.getAllComps(0);
        OiiozResponseFileWriter oRespWriter = new OiiozResponseFileWriter();
        oRespWriter.setHeader(out);
        out.println();
        out.println();
        out.println(OiizResourceBundle.getString("S_RSP_VERSTR") + "=" + OiizResourceBundle.getString("S_RSP_VERSION_2.2.1"));
        Vector varsSession = OiicSessionContext.getSessionVariablesList(this.m_stageInv);
        varsSession.addAll(OiicSessionContext.getGlobalVariablesList(this.m_sInvLoc));
        int nVarsSize = varsSession.size();
        this.callBack(OiizResourceBundle.getString("S_RSP_PROG_MSG1"));
        String sTopLevelValue = OiixResourceBundle.getString("S_TOPLEVEL_COMP_FORMAT");
        Object[] topLevelArgs = new Object[]{oCompID.getName(), oCompID.getVersion().toString()};
        sTopLevelValue = MessageFormat.format(sTopLevelValue, topLevelArgs);
        Vector<String> vVarnames = new Vector<String>();
        OiisVariable oVarApplTop = null;
        OiisVariable oVarApplTopName = null;
        for (int i = 0; i < nVarsSize; ++i) {
            OiisVariable oVar = (OiisVariable)varsSession.elementAt(i);
            if ((oVar.getName().equals("APPLTOP") || oVar.getName().equals("APPLTOP_NAME")) && oCompID.getHomeType() != 3) {
                if (oVar.getName().equals("APPLTOP")) {
                    oVarApplTop = oVar;
                }
                if (!oVar.getName().equals("APPLTOP_NAME")) continue;
                oVarApplTopName = oVar;
                continue;
            }
            if (oVar.getName().equals("TOPLEVEL_COMPONENT")) {
                oVar.setInitialValue(new OiisAdvisedValue(sTopLevelValue, false));
            }
            if (oVar.getName().equals("DEINSTALL_LIST")) {
                oVar.setInitialValue(new OiisAdvisedValue(sTopLevelValue, false));
            }
            if (oVar.getName().equals("FROM_LOCATION_CD_LABEL")) {
                OiiiCdLabel oCDLabel = new OiiiCdLabel();
                try {
                    File fileTmp = new File(this.m_sInvLoc);
                    String sDirTmp = fileTmp.getParent();
                    oCDLabel.readLabelFile(sDirTmp);
                    String sInitialValue = OiixResourceBundle.getString("S_STR_FROMAT");
                    Object[] args = new Object[]{oCDLabel.getLabel()};
                    sInitialValue = MessageFormat.format(sInitialValue, args);
                    oVar.setInitialValue(new OiisAdvisedValue(sInitialValue, false));
                }
                catch (NumberFormatException fileTmp) {
                }
                catch (IOException fileTmp) {
                    // empty catch block
                }
            }
            oRespWriter.writeVariableBlock(out, oVar, false);
        }
        Vector vCompsToInstall = null;
        boolean bGenerateForPatchset = false;
        if (oCompID.getCompType() == 4) {
            vCompsToInstall = this.getContainedPatches(oCompID);
            bGenerateForPatchset = true;
        } else {
            vCompsToInstall = this.getCompsToInstall(vDepInfo);
            bGenerateForPatchset = false;
        }
        int nCompsToInstall = vCompsToInstall.size();
        boolean bApplTopPrinted = false;
        Vector vPlats = new Vector(0);
        for (int i = 0; i < nCompsToInstall; ++i) {
            OiisVariable oVar;
            OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)this.m_stageInv.getCompInvEntry((OiiiCompInstallID)vCompsToInstall.elementAt(i), 0, vPlats);
            OiiiCompInstallID id = invEntry.getCompInstallID();
            String sMsg = OiizResourceBundle.getString("S_RSP_PROG_MSG2");
            Object[] obj = new String[]{invEntry.getFullDisplayName(false)};
            sMsg = MessageFormat.format(sMsg, obj);
            this.callBack(sMsg);
            if (id.getCompType() == 4) continue;
            Object[] aoDepInfo = null;
            OiiodDepNode oDepNode = null;
            if (!bGenerateForPatchset) {
                aoDepInfo = (Object[])vDepInfo.elementAt(i);
                oDepNode = (OiiodDepNode)aoDepInfo[0];
            }
            OiisCompInstallation oCompInstall = this.createCompInstall(invEntry);
            if (id.getOracleHomeType() == 3 && !bApplTopPrinted) {
                if (oVarApplTop != null) {
                    oRespWriter.writeVariableBlock(out, oVarApplTop, false);
                }
                if (oVarApplTopName != null) {
                    oRespWriter.writeVariableBlock(out, oVarApplTopName, false);
                }
                bApplTopPrinted = true;
            }
            if (oCompInstall == null) continue;
            OiisCompContext oContext = oCompInstall.loadCompContext();
            if (id.equals(oCompID)) {
                boolean bCustom = true;
                if (!bGenerateForPatchset && oDepMode != null) {
                    bCustom = oDepMode.getInternalName().equalsIgnoreCase("Custom");
                }
                Vector vVars = OiicSessionContext.getToplevelCompVarsList(invEntry, bCustom);
                Enumeration enum_1 = vVars.elements();
                try {
                    OiisVariable selLangsVar = OiicSessionContext.getSelLangsVar(invEntry);
                    oRespWriter.writeVariableBlock(out, selLangsVar, false, true);
                }
                catch (Exception selLangsVar) {
                    // empty catch block
                }
                while (enum_1.hasMoreElements()) {
                    OiisVariable oVar2 = (OiisVariable)enum_1.nextElement();
                    if (oVar2.getName().equalsIgnoreCase("INSTALL_TYPE")) {
                        String sInitialValue = OiixResourceBundle.getString("S_STR_FROMAT");
                        Object[] args = new Object[]{oDepMode == null ? "Custom" : oDepMode.getInternalName()};
                        sInitialValue = MessageFormat.format(sInitialValue, args);
                        oVar2.setInitialValue(new OiisAdvisedValue(sInitialValue, false));
                    }
                    oRespWriter.addToVarTable(oVar2, id, false);
                    if (vVarnames.contains(oVar2.getName().toLowerCase())) continue;
                    vVarnames.add(oVar2.getName().toLowerCase());
                }
            }
            Vector vVars = OiisCompContext.getROVariablesList(this.m_stageInv, oCompInstall);
            Enumeration enum_1 = vVars.elements();
            while (enum_1.hasMoreElements()) {
                oVar = (OiisVariable)enum_1.nextElement();
                if (!oVar.getExported()) continue;
                boolean bGenerateVar = true;
                if (oVar.getName().equalsIgnoreCase("DEPENDENCY_LIST")) {
                    oDepNode.hasVisbileDependees();
                    bGenerateVar = this.customizeDependeeList(oVar, id, (Vector)aoDepInfo[1]);
                }
                if (bGenerateVar) {
                    oRespWriter.addToVarTable(oVar, id, false);
                }
                if (vVarnames.contains(oVar.getName().toLowerCase())) continue;
                vVarnames.add(oVar.getName().toLowerCase());
            }
            enum_1 = oContext.getAllVariables();
            while (enum_1.hasMoreElements()) {
                oVar = (OiisVariable)enum_1.nextElement();
                if (!oVar.getGenerateRSP() || !oVar.getExported()) continue;
                oRespWriter.addToVarTable(oVar, id, false);
                if (vVarnames.contains(oVar.getName().toLowerCase())) continue;
                vVarnames.add(oVar.getName().toLowerCase());
            }
        }
        oRespWriter.generateRSPVariables(out, vVarnames);
        String[] arrSession = OiicSessionContext.getSessionVariablesArray();
        try {
            out.flush();
            fStream.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            this.callBack(e);
            return;
        }
        catch (IOException e) {
            this.callBack(e);
            return;
        }
        out.flush();
        out.close();
        ++this.m_nResponseFiles;
        this.m_vGeneratedRSPFiles.addElement(sRespLocation);
    }

    public int getResponseFilesGeneratedCount() {
        return this.m_nResponseFiles;
    }

    private Vector getCompsToInstall(Vector vDepInfo) {
        Vector<OiiiCompInstallID> vCompsToInstall = new Vector<OiiiCompInstallID>(5, 5);
        if (vDepInfo != null) {
            int nDeps = vDepInfo.size();
            for (int i = 0; i < nDeps; ++i) {
                Object[] aoDepInfo = (Object[])vDepInfo.elementAt(i);
                OiiodDepNode oDepNode = (OiiodDepNode)aoDepInfo[0];
                vCompsToInstall.addElement(oDepNode.getCompInstallID());
            }
        }
        return vCompsToInstall;
    }

    private Vector getContainedPatches(OiiiCompInstallID oCompID) {
        Vector<OiiiCompInstallID> vCompsToInstall = new Vector<OiiiCompInstallID>(5, 5);
        if (oCompID.getCompType() == 4) {
            vCompsToInstall.addElement(oCompID);
            OiisPatchSetContents oPSetContents = this.getPSetContents((OiiiPatchSetInstallID)oCompID);
            if (oPSetContents != null) {
                Vector vPatches = oPSetContents.getContainedPatches();
                int nSize = vPatches.size();
                for (int i = 0; i < nSize; ++i) {
                    OiiiPatchInstallID pID = (OiiiPatchInstallID)vPatches.elementAt(i);
                    Vector oMatchingEntry = this.m_stageInv.getCompInvEntries(pID);
                    if (oMatchingEntry.size() <= 0) continue;
                    vCompsToInstall.addElement(pID);
                }
            }
        }
        return vCompsToInstall;
    }

    public Vector getTopLevelComps() {
        if (this.m_stageInv == null) {
            return null;
        }
        return this.m_stageInv.getTopLevelComps(0);
    }

    public Vector getAllComps() {
        if (this.m_stageInv == null) {
            return null;
        }
        return this.m_stageInv.getAllCompsVect(0);
    }

    public String getStgCompDisplayName(OiiiCompInstallID cid) {
        OiiiStageCompInvEntry cie = this.m_stageInv.getStageCompInvEntry(cid, new Vector());
        return cie.getFullDisplayName(false);
    }

    public void modifyToplevelCompsOrder(Vector vTopLevelComps) {
        Vector v = this.m_stageInv.getAllCompsVect(0);
        int nSize = vTopLevelComps.size();
        for (int i = nSize - 1; i >= 0; --i) {
            OiiiCompInstallID id = (OiiiCompInstallID)vTopLevelComps.elementAt(i);
            int nIndex = OiixVectorOps.vectIndexOf(v, (Object)id);
            if (nIndex != -1) {
                OiiiCompInvEntry ie = (OiiiCompInvEntry)v.elementAt(nIndex);
                if (!ie.isTopLevel()) continue;
                v.removeElementAt(nIndex);
                v.insertElementAt(ie, 0);
                continue;
            }
            System.err.println("Component:" + id.getName() + " ,version : " + id.getVersion().getVerString() + " is not present in the staging area.");
        }
        OiizStageVerifier.debug("Top level components ordered in " + v);
        this.updateStageInventory(false);
        this.m_stageInv.setCompsOrdered(false);
    }

    public static String getProdJarLocation(String sLoc) {
        String sPath = OiixPathOps.getStandardForm(sLoc);
        String sTempPath = sPath;
        if (!(sTempPath.endsWith("products.jar") || sTempPath.endsWith("stgInv.jar") || sTempPath.endsWith("products.xml"))) {
            sPath = OiiiTargetAreaControl.genStageLocation(sTempPath);
            sPath = sPath + "products.xml";
        }
        sPath = OiixPathOps.getNativeForm(sPath);
        return sPath;
    }

    public static void validateProdJarLocation(String location) throws IOException {
        if (location.length() == 0) {
            throw new IOException(OiizResourceBundle.getString("S_STAGE_LOCATION_EMPTY"));
        }
        File path = new File(location);
        if (!path.exists() || path.isDirectory()) {
            throw new IOException(OiizResourceBundle.getString("S_STAGE_LOCATION_ERROR"));
        }
    }

    public static int generateRSPFile(String stageLocation, OiizCallback callback) throws IOException {
        OiizStageVerifier verifier = null;
        stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation);
        try {
            OiizStageVerifier.validateProdJarLocation(stageLocation);
            verifier = new OiizStageVerifier(stageLocation, false);
            verifier.setCallBack(callback);
            File file = new File(stageLocation);
            String sParent = file.getParent();
            verifier.generateResponseFile();
            int respCount = verifier.getResponseFilesGeneratedCount();
            File fl = new File(stageLocation);
            String rspFilesPath = fl.getParent() + File.separator + "Response";
            Object[] args = new Object[]{String.valueOf(respCount), rspFilesPath};
            String sMsg = OiizResourceBundle.getString("S_RSP_SUCCESS", args);
            callback.appendToMessage(sMsg);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            if (s_debug) {
                e.printStackTrace();
            }
            System.err.println("Error " + e.getMessage());
            verifier.dispose();
            return 1;
        }
        verifier.dispose();
        if (verifier.isError()) {
            return 1;
        }
        return 0;
    }

    public static int updateProductSizes(String stageLocation, OiizCallback callback) throws IOException {
        return OiizStageVerifier.updateProductSizes(stageLocation, callback, 1);
    }

    public static int updateProductSizes(String stageLocation, OiizCallback callback, int iGenFastCopyMetaData) throws IOException {
        OiizStageVerifier verifier = null;
        stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation);
        verifier = new OiizStageVerifier(stageLocation);
        verifier.setCallBack(callback);
        try {
            verifier.updateSizes(iGenFastCopyMetaData);
        }
        catch (Exception e) {
            System.err.println("Error " + e.getMessage());
            verifier.dispose();
            return 1;
        }
        verifier.dispose();
        if (verifier.isError()) {
            return 1;
        }
        return 0;
    }

    public static int mergeStage(String stageLocation, OiizCallback callback) throws IOException {
        OiizStageVerifier verifier = null;
        stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation);
        verifier = new OiizStageVerifier(stageLocation);
        verifier.setCallBack(callback);
        try {
            verifier.mergeStage();
        }
        catch (Exception e) {
            System.err.println("Error " + e.getMessage());
            verifier.dispose();
            return 1;
        }
        verifier.dispose();
        if (verifier.isError()) {
            return 1;
        }
        return 0;
    }

    public static void validateCDStageInput(String sText, float nDiskSpace, float nReservedDiskSpace) throws IOException {
        String sError = "";
        boolean bRet = true;
        if (sText == null || sText.trim().equals("")) {
            sError = sError + OiizResourceBundle.getString("S_CD_LABEL_EMPTY");
            bRet = false;
        }
        if (nDiskSpace == 0.0f) {
            if (!bRet) {
                sError = sError + "\n";
            }
            sError = sError + OiizResourceBundle.getString("S_CD_SIZE_ZERO");
            bRet = false;
        }
        if (nDiskSpace < 0.0f) {
            if (!bRet) {
                sError = sError + "\n";
            }
            sError = sError + OiizResourceBundle.getString("S_CD_SIZE_NEGATIVE");
            bRet = false;
        }
        if (nReservedDiskSpace < 0.0f) {
            if (!bRet) {
                sError = sError + "\n";
            }
            sError = sError + OiizResourceBundle.getString("S_CD_RESERVE_SIZE_NEGATIVE");
            bRet = false;
        }
        if (nDiskSpace > 0.0f && nReservedDiskSpace >= 0.0f && nDiskSpace <= nReservedDiskSpace) {
            if (!bRet) {
                sError = sError + "\n";
            }
            sError = sError + OiizResourceBundle.getString("S_FIRST_CD_SIZE");
            bRet = false;
        }
        if (!bRet) {
            throw new IOException(sError);
        }
    }

    public static int createCDStagingArea(String stageLocation, String sLabel, float nDiskSize, float nReservedDiskSize, int iGenFastCopyMetaData, OiizCallback callback) {
        return OiizStageVerifier.createCDStagingArea(stageLocation, sLabel, nDiskSize, nReservedDiskSize, null, iGenFastCopyMetaData, callback);
    }

    public static int createCDStagingArea(String stageLocation, String sLabel, float nDiskSize, float nReservedDiskSize, String[] sBootStrapcomp, int iGenFastCopyMetaData, OiizCallback callback) {
        Hashtable oTable = new Hashtable(10);
        int nDisk = 0;
        try {
            stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation);
            OiizStageVerifier.validateProdJarLocation(stageLocation);
            nDisk = OiizStageVerifier.createCDStagingArea(stageLocation, sLabel, nDiskSize, nReservedDiskSize, sBootStrapcomp, oTable, null, callback, iGenFastCopyMetaData);
        }
        catch (IOException ie) {
            System.err.println("Error " + ie.getMessage());
            return 1;
        }
        return 0;
    }

    OiiiVersion getMinInstVersion() {
        Vector v = this.m_stageInv.getAllCompsVect(0);
        int nSize = v.size();
        OiiiVersion[] aoVersions = new OiiiVersion[nSize];
        for (int i = 0; i < nSize; ++i) {
            OiiiStageCompInvEntry ie = (OiiiStageCompInvEntry)v.elementAt(i);
            OiiiVersion[] aoScieVersions = ie.getInstVersionsArray();
            aoVersions[i] = this.getMaxVersion(aoScieVersions);
        }
        return this.getMaxVersion(aoVersions);
    }

    public static int createCDStagingArea(String stageLocation, String sLabel, float nDiskSize, float nReservedDiskSize, String[] sBootStrapcomp, Hashtable oTable, OiixProgressListener l, OiizCallback callBack, int iGenFastCopyMetaData) throws IOException {
        OiizStageVerifier verifier = null;
        int nDisk = 0;
        try {
            if (l != null) {
                l.setStatus(OiizResourceBundle.getString("S_LOADING_COMPS_LIST"));
                l.setTotalBytes(5L);
            }
            if ((verifier = new OiizStageVerifier(stageLocation, true, callBack, l)).isError()) {
                throw new IOException(OiizResourceBundle.getString("S_STAGE_LOCATION_ERROR"));
            }
            OiiiVersion oVersion = verifier.getMinInstVersion();
            if (oVersion != null && oVersion.laterThan(OiicInstaller.getInstallerVersion())) {
                Object[] args = new Object[]{oVersion.getVerString()};
                throw new IOException(OiizResourceBundle.getString("S_CD_REQUIRES_HIGHER_INSTALLER_VER", args));
            }
            verifier.checkStageValidity();
            if (!verifier.isError()) {
                String sRoot;
                OiizCDStager oCDStager = new OiizCDStager(verifier, callBack);
                oCDStager.verifyExistingDisks();
                verifier.callBack(OiizResourceBundle.getString("S_PROCESSING_DEPENDENCIES"));
                if (l != null) {
                    Vector v = verifier.getStageInv().getAllCompsVect(0);
                    int nSize = v.size();
                    l.setTotalBytes(nSize + 5);
                    l.setStatus(OiizResourceBundle.getString("S_PROCESSING_DEPENDENCIES"));
                    l.addBytes(1);
                }
                Vector vOrder = oCDStager.calculateOrdering(sBootStrapcomp);
                verifier.updateStageInvOrder(vOrder);
                Vector vChangeComps = new Vector();
                long nRestSize = (long)((double)nDiskSize * 1024.0 * 1024.0);
                long nStartSize = nRestSize - (long)((double)nReservedDiskSize * 1024.0 * 1024.0);
                verifier.callBack(OiizResourceBundle.getString("S_CALCULATING_SPACE_REQUIREMENTS"));
                if (l != null) {
                    l.setStatus(OiizResourceBundle.getString("S_CALCULATING_SPACE_REQUIREMENTS"));
                    l.addBytes(1);
                }
                nDisk = oCDStager.allotSpace(nStartSize, nRestSize, vOrder, oTable, vChangeComps);
                verifier.callBack(OiizResourceBundle.getString("S_REARRANGING_COMPS"));
                if (l != null) {
                    l.setStatus(OiizResourceBundle.getString("S_REARRANGING_COMPS"));
                    l.addBytes(1);
                }
                File f = new File(stageLocation);
                String sNewLoc = sRoot = f.getParent();
                if (vChangeComps.size() > 0) {
                    sNewLoc = oCDStager.rearrangeComps(vChangeComps, nDisk);
                    String sNewJarLoc = sNewLoc + "/" + "products.xml";
                    sNewJarLoc = OiixPathOps.getNativeForm(sNewJarLoc);
                    verifier.updateStageInventory();
                    verifier.dispose();
                    if (!f.renameTo(new File(sNewJarLoc))) {
                        Object[] args = new String[]{stageLocation, sNewJarLoc};
                        String sMsg = OiizResourceBundle.getString("S_ERROR_MOVING_COMPS");
                        sMsg = MessageFormat.format(sMsg, args);
                        args = null;
                        throw new IOException(sMsg);
                    }
                    OiipgFileSystem fs = new OiipgFileSystem();
                    if (!fs.areLocsSame(sNewJarLoc, stageLocation)) {
                        verifier.callBack(OiizResourceBundle.getString("S_UPDATING_INV"));
                        if (l != null) {
                            l.setStatus(OiizResourceBundle.getString("S_UPDATING_INV"));
                            l.addBytes(1);
                        }
                        String sLocks = sRoot + "/locks";
                        sLocks = OiixPathOps.getNativeForm(sLocks);
                        f = new File(sLocks);
                        f.delete();
                        f = new File(sRoot);
                        f.delete();
                    }
                } else {
                    verifier.updateStageInventory();
                    verifier.dispose();
                }
                if (iGenFastCopyMetaData == 1) {
                    verifier.generateDefaultFilesMetaData();
                } else if (iGenFastCopyMetaData == 0) {
                    verifier.deleteFastCopyInformation();
                }
                for (int j = 1; j <= nDisk; ++j) {
                    OiiiCdLabel label = new OiiiCdLabel();
                    label.setLabel(sLabel);
                    label.setDiskNumber(j);
                    label.setSize(nDiskSize);
                    label.setReservedSize(nReservedDiskSize);
                    String sDiskLoc = OiiiTargetAreaControl.getDefaultDiskLocation(sNewLoc, j);
                    if (l != null) {
                        Object[] args = new String[]{sDiskLoc};
                        String sMsg = OiizResourceBundle.getString("S_WRITING_DISK_LABEL");
                        sMsg = MessageFormat.format(sMsg, args);
                        args = null;
                        l.setStatus(sMsg);
                        verifier.callBack(sMsg);
                    }
                    label.writeLabelFile(sDiskLoc);
                }
                verifier.callBack(OiizResourceBundle.getString("S_CD_REARRANGE_COMPLETE"));
                if (l != null) {
                    l.setStatus(OiizResourceBundle.getString("S_CD_REARRANGE_COMPLETE"));
                    l.addBytes(1);
                    l.onDoneProgress();
                }
            } else {
                verifier.callBack(OiizResourceBundle.getString("S_ERRORS_IN_STAGE_SKIP_CREATE_MULTIDISK_STAGE"));
            }
        }
        catch (Exception ie) {
            if (l != null) {
                l.onDoneProgress();
            }
            if (verifier != null) {
                verifier.dispose();
            }
            if (s_debug) {
                ie.printStackTrace();
            }
            String sMsg = OiizResourceBundle.getString("S_ERROR") + ie.getMessage();
            System.err.println(sMsg);
            throw new IOException(sMsg);
        }
        return nDisk;
    }

    private void updateStageInvOrder(Vector vCompIDs) {
        Vector<OiiiStageCompInvEntry> vOrderedComps = new Vector<OiiiStageCompInvEntry>(vCompIDs.size());
        for (int i = 0; i < vCompIDs.size(); ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)vCompIDs.elementAt(i);
            Vector vInvEntries = this.m_stageInv.getCompInvEntries(cid);
            if (vInvEntries == null) continue;
            for (int j = 0; j < vInvEntries.size(); ++j) {
                OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vInvEntries.elementAt(j);
                vOrderedComps.addElement(invEntry);
            }
        }
        this.m_stageInv.setAllCompsVect(0, vOrderedComps);
        this.m_stageInv.setCompsOrdered(true);
    }

    public static void printInvContents(String stageLocation) throws IOException {
        OiizStageVerifier verifier = null;
        stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation);
        verifier = new OiizStageVerifier(stageLocation, false);
        try {
            OiiiStageInventory stageInv = verifier.getStageInv();
            if (stageInv == null) {
                System.out.println("Could not read Stage Inventory at " + stageLocation);
                return;
            }
            System.out.println("Components List : ");
            Enumeration vAllComps = stageInv.getAllComps(0);
            while (vAllComps.hasMoreElements()) {
                OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                System.out.println("\t Name : " + invEntry.getFullDisplayName(false));
                System.out.println("\t Internal Name : " + invEntry.getCompInstallID().getName());
                System.out.print("\t Platforms staged for : ");
                Vector vPlatforms = invEntry.getPlatforms();
                int nSize = vPlatforms.size();
                for (int i = 0; i < nSize; ++i) {
                    Integer plat = (Integer)vPlatforms.elementAt(i);
                    System.out.print(OiixPlatform.getPlatformName(plat) + COMMA);
                }
                System.out.println("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Vector getSuperfluousComps() {
        Vector<OiiiStageCompInvEntry> vUnusedComps = new Vector<OiiiStageCompInvEntry>(5, 5);
        if (this.m_stageInv == null) {
            System.out.println("Could not read Stage Inventory.");
            return vUnusedComps;
        }
        Vector vTopComps = this.getTopLevelComps();
        int nSize = vTopComps.size();
        if (nSize > 0) {
            Object[] ids = new OiiiCompInstallID[nSize];
            vTopComps.copyInto(ids);
            OiiodDepEngine depEngine = new OiiodDepEngine(this, true);
            depEngine.setErrListener(this);
            depEngine.setInventories(this.m_stageInv, new OiiiInstallInventory());
            depEngine.setCurrentPlatform(0);
            depEngine.setExecutePreReq(false);
            depEngine.setCurrentTLIDs((OiiiCompInstallID[])ids);
            try {
                depEngine.buildCompArray();
            }
            catch (OiiodDepException oiiodDepException) {
                // empty catch block
            }
            Enumeration vAllComps = this.m_stageInv.getAllComps(0);
            OiiodDepNode oNode = null;
            while (vAllComps.hasMoreElements()) {
                OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                switch (invEntry.getCompInstallID().getCompType()) {
                    case 1: {
                        oNode = depEngine.getDepNode(invEntry.getCompInstallID());
                        break;
                    }
                    case 2: {
                        oNode = depEngine.getDepPatchNode(invEntry.getCompInstallID());
                        break;
                    }
                    case 4: {
                        oNode = depEngine.getPatchSetNode(invEntry.getCompInstallID());
                    }
                }
                if (oNode != null) continue;
                vUnusedComps.addElement(invEntry);
            }
        } else {
            Enumeration vAllComps = this.m_stageInv.getAllComps(0);
            while (vAllComps.hasMoreElements()) {
                vUnusedComps.addElement((OiiiStageCompInvEntry)vAllComps.nextElement());
            }
        }
        return vUnusedComps;
    }

    public static void printDepGraph(String stageLocation) throws IOException {
        OiizStageVerifier verifier = null;
        verifier = new OiizStageVerifier(stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation), false);
        OiiiStageInventory stageInv = verifier.getStageInv();
        if (stageInv == null) {
            System.out.println("Could not read Stage Inventory at " + stageLocation);
            return;
        }
        Vector vTopComps = verifier.getTopLevelComps();
        int nSize = vTopComps.size();
        if (nSize > 0) {
            Object[] ids = new OiiiCompInstallID[nSize];
            vTopComps.copyInto(ids);
            OiiodDepEngine depEngine = new OiiodDepEngine(verifier, true);
            depEngine.setErrListener(verifier);
            depEngine.setInventories(stageInv, new OiiiInstallInventory());
            depEngine.setCurrentPlatform(0);
            depEngine.setExecutePreReq(false);
            depEngine.setCurrentTLIDs((OiiiCompInstallID[])ids);
            try {
                depEngine.buildCompArray();
            }
            catch (OiiodDepException oiiodDepException) {
                // empty catch block
            }
            for (int i = 0; i < nSize; ++i) {
                OiiodDepNode oNode = depEngine.getDepNode((OiiiCompInstallID)ids[i]);
                System.out.println("Dependency Graph for " + oNode);
                OiizStageVerifier.printDepGraph("", oNode);
            }
            Enumeration vAllComps = stageInv.getAllComps(0);
            System.out.println("The following comps are not referred by any components ");
            while (vAllComps.hasMoreElements()) {
                OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                OiiodDepNode oNode = depEngine.getDepNode(invEntry.getCompInstallID());
                if (oNode != null) continue;
                System.out.println(invEntry.getFullDisplayName(false));
            }
        }
    }

    private static void printDepGraph(String sTab, OiiodDepNode oNode) {
        sTab = sTab + "  ";
        Vector vNodes = oNode.getRules();
        int nNodes = vNodes.size();
        for (int i = 0; i < nNodes; ++i) {
            OiiodDepRuleNode oRule = (OiiodDepRuleNode)vNodes.elementAt(i);
            System.out.println(sTab + oRule.toString());
            Vector vComps = oRule.getDepNodes();
            int nComps = vComps.size();
            for (int j = 0; j < nComps; ++j) {
                OiiodDepNode oChildNode = (OiiodDepNode)vComps.elementAt(j);
                System.out.println(sTab + "  " + oChildNode.toString());
                OiizStageVerifier.printDepGraph(sTab + "  ", oChildNode);
            }
        }
    }

    public static void printPlatformListInFileGroups(String stageLocation) throws OiifbCancelException, IOException {
        OiizStageVerifier verifier = null;
        verifier = new OiizStageVerifier(stageLocation = OiizStageVerifier.getProdJarLocation(stageLocation), false);
        OiiiStageInventory stageInv = verifier.getStageInv();
        if (stageInv == null) {
            System.out.println("Could not read Stage Inventory at " + stageLocation);
            return;
        }
        Enumeration vAllComps = stageInv.getAllComps(0);
        while (vAllComps.hasMoreElements()) {
            OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
            System.out.println("Component Languages : \n" + invEntry.getLanguages());
            System.out.println("Component Platforms : \n" + invEntry.getPlatforms());
            System.out.println("File map Entries for " + invEntry.getFullDisplayName(false));
            OiisCompInstallation oComp = OiisStagedCompHelper.createCompInstall(invEntry, verifier.getSourceAccess());
            OiisFileMap oFileMap = oComp.getFileMap();
            Enumeration e = oFileMap.getFileGroupNames();
            while (e.hasMoreElements()) {
                String sGroupName = (String)e.nextElement();
                OiisFileGroup fg = oFileMap.getFileGroup(sGroupName);
                System.out.println("Group Name : " + sGroupName);
                System.out.println("Platform list : \n" + fg.getPlatforms());
                System.out.println("Languages list : \n" + fg.getLanguages());
            }
        }
    }

    private OiiiSourceAccess getSourceAccess() {
        return this.m_oiSourceAccess;
    }

    @Override
    public void processError(String errmsg, Vector oDetails) {
        this.m_bError = true;
        String sMsg = OiizResourceBundle.getString("S_LOG_ALERT_ERROR");
        this.callBack(sMsg + errmsg);
        if (errmsg == null) {
            new Throwable().printStackTrace(System.err);
        }
    }

    @Override
    public int processWarning(String errmsg, Vector oDetails) {
        this.m_bWarning = true;
        String sMsg = OiizResourceBundle.getString("S_WARNING");
        this.callBack(sMsg + errmsg);
        return 0;
    }

    private void callBack(Exception exp) {
        String sError = OiizResourceBundle.getString("S_ERROR");
        this.m_bError = true;
        if (exp.getMessage() != null) {
            this.callBack(sError + exp.getMessage());
        } else {
            exp.printStackTrace();
        }
    }

    private void callBack(String msg) {
        if (this.m_callBack != null) {
            this.m_callBack.appendToMessage(msg);
        }
    }

    private static void debug(String msg) {
        if (s_debug) {
            System.err.println("OiizStageVerifier::" + msg);
        }
    }

    public void deleteComponents(Vector vCompIDs, OiizCallback callbak) {
        this.setCallBack(callbak);
        if (vCompIDs == null || vCompIDs.size() == 0) {
            this.callBack("No Components to delete");
            return;
        }
        if (this.m_stageInv == null) {
            this.callBack("Staging area is invalid");
            return;
        }
        Vector vInvComps = this.getAllComps();
        int invSize = vInvComps.size();
        if (invSize == 0) {
            this.callBack("No components in the staging area.");
            return;
        }
        int iSize = vCompIDs.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiCompInstallID oID = (OiiiCompInstallID)vCompIDs.elementAt(i);
            invSize = vInvComps.size();
            boolean bDelete = false;
            for (int k = 0; k < invSize; ++k) {
                Vector idPlats;
                Vector stagePlats;
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vInvComps.elementAt(k);
                OiiiCompInstallID oInvCompID = oEntry.getCompInstallID();
                if (oID.equalsNoPlat(oInvCompID, 0) && oID.getPlatforms().size() == 0 && oInvCompID.getPlatforms().size() == 0) {
                    if (oEntry.isMerged() && oInvCompID.getCompType() != 1) {
                        this.callBack("Unable to delete Component : " + oID + ", Component is merged in stage.");
                        break;
                    }
                    OiiiVersion pVer = oEntry.getMergedVersion();
                    if (pVer != null) {
                        OiiiCompInstallID pID = new OiiiCompInstallID(oID.getName(), pVer, oID.getPlatforms());
                        OiiiStageCompInvEntry pEntry = this.getStageInv().getStageCompInvEntry(pID);
                        if (pEntry != null) {
                            pEntry.setMerged(false);
                        }
                    }
                    this.callBack("Deleted Component :" + oID);
                    vInvComps.removeElementAt(k);
                    bDelete = true;
                    break;
                }
                if (!oID.equalsWithPlatInt(oInvCompID) || !OiixVectorOps.checkIntersection(stagePlats = oEntry.getPlatforms(), idPlats = oID.getPlatforms())) continue;
                if (oEntry.isMerged() && oInvCompID.getCompType() != 1) {
                    this.callBack("Unable to delete Component : " + oID + ", Component is merged in stage.");
                    break;
                }
                OiiiVersion pVer = oEntry.getMergedVersion();
                if (pVer != null) {
                    OiiiCompInstallID pID = new OiiiCompInstallID(oID.getName(), pVer, oID.getPlatforms());
                    OiiiStageCompInvEntry pEntry = this.getStageInv().getStageCompInvEntry(pID);
                    if (pEntry != null) {
                        pEntry.setMerged(false);
                    }
                }
                this.callBack("Deleted Component :" + oID);
                vInvComps.removeElementAt(k);
                bDelete = true;
                break;
            }
            if (bDelete) continue;
            this.callBack("Unable to delete Component : " + oID + ", Component is not in stage.");
        }
        this.updateStageInventory(true);
        this.callBack("Delete Operation over.");
    }

    public void copyLibrary(String sSourceLibLoc, OiiiLibraryID oiLid, int iLibType) {
        String sStgCannonPath = null;
        String sStgCannonDir = null;
        String sTargetLibLoc = null;
        try {
            sTargetLibLoc = this.m_oiStageControl.genLibLocation(oiLid, iLibType);
        }
        catch (IOException e) {
            this.callBack(e.getMessage());
        }
        if (!sTargetLibLoc.endsWith("/")) {
            sTargetLibLoc = sTargetLibLoc + "/";
        }
        sSourceLibLoc = sSourceLibLoc.replace('\\', '/');
        File oFile = new File(sSourceLibLoc);
        String sFileName = oFile.getName();
        sTargetLibLoc = sTargetLibLoc + sFileName;
        try {
            sStgCannonPath = new File(this.getLocation()).getCanonicalPath();
        }
        catch (IOException e) {
            sStgCannonPath = sTargetLibLoc;
        }
        sStgCannonPath = sStgCannonPath.replace('\\', '/');
        sStgCannonDir = sStgCannonPath.substring(0, sStgCannonPath.lastIndexOf(47) + 1);
        String sDestLoc = sStgCannonDir + sTargetLibLoc.replace('\\', '/');
        try {
            OiixFileOps.copyFile(sSourceLibLoc, sDestLoc, true, true, true, "0644", null, null);
            OiiiLibInvEntry oLie = new OiiiLibInvEntry(oiLid, sTargetLibLoc);
            this.m_stageInv.addLibInvEntry(oLie, iLibType);
        }
        catch (IOException e) {
            this.callBack("IOException occured while copying " + sSourceLibLoc + " to " + sDestLoc);
        }
        catch (OiifbCancelException e) {
            this.callBack("OiifbCancelException occured while copying " + sSourceLibLoc + " to " + sDestLoc);
        }
    }

    public static void removeFastCopyMetaData(String sStageLocation) {
        File oFastCopyFile;
        String sFastCopyBaseDir = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sStageLocation, OiixPathOps.getStandardForm("Disk1" + File.separator + "stage")));
        File oFastCopyFolder = new File(sFastCopyBaseDir + File.separator + S_FASTCOPY_FOLDER);
        if (oFastCopyFolder.exists()) {
            OiixFileOps.recdelete(oFastCopyFolder);
        }
        if ((oFastCopyFile = new File(sFastCopyBaseDir + File.separator + S_FASTCOPY_METADATA)).exists()) {
            oFastCopyFile.delete();
        }
    }

    public static void setSHPropXMLCheck(boolean bCheckSHPropXML) {
        m_bCheckSHPropXML = bCheckSHPropXML;
    }

    public static void setBugListXMLCheck(boolean bCheckBugListXML) {
        m_bCheckBugListXML = bCheckBugListXML;
    }

    private void createMetaDataForPatchset(String sTLCompName, String sInstallType, Vector vCompDepNodes, Hashtable oCompDefFiles, Hashtable oOvlyPatchDefJars, Hashtable oOvlyPatchExpDefFiles, String sShortTLCompName) throws IOException {
        int iDiscs = this.m_stageInv.getDiskCount();
        PrintWriter[] oOvlyPatchDefJarsListWriters = new PrintWriter[iDiscs];
        PrintWriter[] oOvlyPatchExpFilesListWriters = new PrintWriter[iDiscs];
        String sRACFilesList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sTLCompName + "_racfiles.lst");
        PrintWriter oRACFilesListWriter = new PrintWriter(new FileWriter(sRACFilesList, false));
        String sOraHomePath = "%ORACLE_HOME%/";
        int iOraHomePathLen = sOraHomePath.length();
        TreeSet<String> oDirs = new TreeSet<String>();
        Hashtable oFilesMap = new Hashtable(101);
        Enumeration oCompDeps = vCompDepNodes.elements();
        String sCompType = PATCH;
        String sCompTag = "PATCH";
        while (oCompDeps.hasMoreElements()) {
            Vector vPatchExpDefFiles;
            Vector vPatchDefJars;
            OiiiCompInstallID oCompId = (OiiiCompInstallID)oCompDeps.nextElement();
            int iCompType = oCompId.getCompType();
            Vector oMatchingEntry = this.m_stageInv.getCompInvEntries(oCompId);
            if (oMatchingEntry.size() == 0) {
                System.out.println("No stage Enry for :" + oCompId.toString());
                continue;
            }
            OiiiStageCompInvEntry oInvEntry = (OiiiStageCompInvEntry)oMatchingEntry.elementAt(0);
            int iDiscNum = oInvEntry.getDiskNumber();
            String sCompName = oCompId.getName();
            String sCompVer = oCompId.getVersion().getVerString();
            Vector vDefFiles = (Vector)oCompDefFiles.get(oCompId);
            if (vDefFiles != null) {
                Enumeration oFiles = vDefFiles.elements();
                while (oFiles.hasMoreElements()) {
                    HashMap<String, String> oFilesMapForDir;
                    String sFile = (String)oFiles.nextElement();
                    oRACFilesListWriter.println(sFile);
                    if (sFile.startsWith(sOraHomePath)) {
                        sFile = sFile.substring(iOraHomePathLen);
                    }
                    String sFileFolder = null;
                    String sFileName = null;
                    int iLastSlashAt = sFile.lastIndexOf(47);
                    if (iLastSlashAt > 0) {
                        sFileFolder = sFile.substring(0, iLastSlashAt);
                        sFileName = sFile.substring(iLastSlashAt + 1);
                        oDirs.add(sFileFolder);
                    } else {
                        sFileFolder = "%ORACLE_HOME%";
                        sFileName = sFile;
                    }
                    boolean bEmptyFolder = true;
                    if (sFileName != null && sFileName.length() > 0) {
                        bEmptyFolder = false;
                    }
                    if ((oFilesMapForDir = (HashMap<String, String>)oFilesMap.get(sFileFolder)) == null) {
                        oFilesMapForDir = new HashMap<String, String>(11);
                        if (!bEmptyFolder) {
                            oFilesMapForDir.put(sFileName, this.createFileMapEntry(sFileName, sCompType, sCompName, sCompVer));
                        }
                        oFilesMap.put(sFileFolder, oFilesMapForDir);
                        continue;
                    }
                    String sFileMapEntries = (String)oFilesMapForDir.get(sFileName);
                    if (sFileMapEntries != null) {
                        oFilesMapForDir.put(sFileName, sFileMapEntries + this.createFileMapEntry(null, sCompType, sCompName, sCompVer));
                        continue;
                    }
                    if (bEmptyFolder) continue;
                    oFilesMapForDir.put(sFileName, this.createFileMapEntry(sFileName, sCompType, sCompName, sCompVer));
                }
            }
            if ((vPatchDefJars = (Vector)oOvlyPatchDefJars.get(oCompId)) != null) {
                if (oOvlyPatchDefJarsListWriters[iDiscNum - 1] == null) {
                    String sPatchDefJarsList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_" + iDiscNum + S_XML);
                    FileOutputStream fos = new FileOutputStream(sPatchDefJarsList, false);
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1] = new PrintWriter(osw);
                    Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
                    String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(sXMLDir);
                    Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
                    String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(sXMLHdr);
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println("");
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println("<FILE_LIST>");
                }
                oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(" <" + sCompTag + " NAME=\"" + sCompName + QUOTES + " VERSION=\"" + sCompVer + "\" >");
                Enumeration oPatchJars = vPatchDefJars.elements();
                while (oPatchJars.hasMoreElements()) {
                    oOvlyPatchDefJarsListWriters[iDiscNum - 1].println("  <FILE> " + oPatchJars.nextElement() + " </FILE>");
                }
                oOvlyPatchDefJarsListWriters[iDiscNum - 1].println(" </" + sCompTag + ">");
            }
            if ((vPatchExpDefFiles = (Vector)oOvlyPatchExpDefFiles.get(oCompId)) == null) continue;
            if (oOvlyPatchExpFilesListWriters[iDiscNum - 1] == null) {
                String sPatchExpFilesList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_exp_" + iDiscNum + S_XML);
                FileOutputStream fos = new FileOutputStream(sPatchExpFilesList, false);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "US-ASCII");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1] = new PrintWriter(osw);
                Object[] oXMLDirArgs = new Object[]{"US-ASCII", "yes"};
                String sXMLDir = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" standalone=\"{1}\"?>", oXMLDirArgs);
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(sXMLDir);
                Object[] oXMLHdrArgs = new Object[]{new Integer(Calendar.getInstance().get(1))};
                String sXMLHdr = MessageFormat.format(OixsXMLConstants.HEADER_EX, oXMLHdrArgs);
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(sXMLHdr);
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("<FILE_LIST>");
            }
            oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(" <" + sCompTag + " NAME=\"" + sCompName + QUOTES + " VERSION=\"" + sCompVer + "\" >");
            Enumeration oPatchExpFiles = vPatchExpDefFiles.elements();
            while (oPatchExpFiles.hasMoreElements()) {
                String sSrc = (String)oPatchExpFiles.nextElement();
                String sDest = (String)oPatchExpFiles.nextElement();
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("  <FILE>");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("    <SOURCE> " + sSrc + " </SOURCE>");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("    <DEST> " + sDest + " </DEST>");
                oOvlyPatchExpFilesListWriters[iDiscNum - 1].println("  </FILE>");
            }
            oOvlyPatchExpFilesListWriters[iDiscNum - 1].println(" </" + sCompTag + ">");
        }
        for (int i = 0; i < iDiscs; ++i) {
            if (oOvlyPatchExpFilesListWriters[i] != null) {
                oOvlyPatchExpFilesListWriters[i].println("</FILE_LIST>");
                oOvlyPatchExpFilesListWriters[i].close();
            }
            if (oOvlyPatchDefJarsListWriters[i] == null) continue;
            oOvlyPatchDefJarsListWriters[i].println("</FILE_LIST>");
            oOvlyPatchDefJarsListWriters[i].close();
        }
        oRACFilesListWriter.close();
        if (oDirs.size() > 0) {
            String sDirsList = OiixPathOps.getNativeForm(this.m_sourceRoot + File.separator + S_FASTCOPY_FOLDER + File.separator + sShortTLCompName + "_dirs.lst");
            PrintWriter oDirsListWriter = new PrintWriter(new FileWriter(sDirsList, false));
            for (String sDir : oDirs) {
                oDirsListWriter.println(sDir);
            }
            oDirs.clear();
            oDirsListWriter.close();
        }
        this.generatePreProcFilesMap(sShortTLCompName, sInstallType, oFilesMap);
        oFilesMap.clear();
    }

    private boolean checkLength(String data) {
        boolean bLargeFileName = false;
        if (data != null && data.length() > 45) {
            bLargeFileName = true;
        }
        return bLargeFileName;
    }

    private String getShorterInternalName(String sIntName) {
        String sShortName = "";
        StringTokenizer tokenizer = new StringTokenizer(sIntName, INTERNALNAME_DELIMITER);
        if (tokenizer.countTokens() == 1) {
            sShortName = sIntName.length() >= 3 ? sIntName.substring(0, 3) : sIntName;
        } else {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                sShortName = token.length() >= 3 ? sShortName + token.substring(0, 3) : sShortName + token;
                sShortName = sShortName + INTERNALNAME_DELIMITER;
            }
            if (sShortName != null) {
                sShortName = sShortName.substring(0, sShortName.length() - 1);
            }
        }
        return sShortName;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage : OiizStageVerifier stagingAreaLocation [-print, -depGraph] ");
            System.exit(0);
        }
        Vector<Integer> plat = new Vector<Integer>();
        plat.addElement(new Integer(912));
        OiiiCompInstallID oID = new OiiiCompInstallID("noh", new OiiiVersion("1"), plat);
        Vector<OiiiCompInstallID> vIDs = new Vector<OiiiCompInstallID>();
        vIDs.addElement(oID);
        System.exit(0);
    }
}

