/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixEqualityComparator;
import oracle.sysman.oii.oiix.OiixLanguage;

public class OiixVectorOps {
    public static boolean vectorsEqual(Vector vect1, Vector vect2) {
        return OiixVectorOps.vectorSubset(vect1, vect2) && OiixVectorOps.vectorSubset(vect2, vect1);
    }

    public static boolean arraysEqual(Object array1, Object array2) {
        Vector vect2;
        Vector vect1 = OiixVectorOps.arrayToVect(array1);
        return OiixVectorOps.vectorSubset(vect1, vect2 = OiixVectorOps.arrayToVect(array2)) && OiixVectorOps.vectorSubset(vect2, vect1);
    }

    public static boolean vectorSubset(List vect1, List vect2) {
        boolean isSubset = true;
        if (vect1 != null && vect2 != null) {
            Iterator v1els = vect1.iterator();
            while (v1els.hasNext()) {
                if (vect2.contains(v1els.next())) continue;
                isSubset = false;
                break;
            }
        } else if (vect1 != null || vect2 != null) {
            isSubset = false;
        }
        return isSubset;
    }

    public static boolean vectorSubset(Vector vect1, Vector vect2) {
        return OiixVectorOps.vectorSubset((List)vect1, (List)vect2);
    }

    public static int vectIndexOf(List vect, Object obj) {
        return OiixVectorOps.vectIndexOf(vect, obj, 0);
    }

    public static int vectIndexOf(Vector vect, Object obj) {
        return OiixVectorOps.vectIndexOf((List)vect, obj, 0);
    }

    public static int vectIndexOf(Vector vect, Object obj, int initPos) {
        return OiixVectorOps.vectIndexOf((List)vect, obj, initPos);
    }

    public static int vectIndexOf(List vect, Object obj, int initPos) {
        int pos = -1;
        int vectSiz = vect.size();
        for (int i = initPos; i < vectSiz; ++i) {
            Object elem = vect.get(i);
            if (elem == null || !elem.equals(obj)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public static int vectIndexOf(Vector vect, Object obj, int initPos, OiixEqualityComparator comparator) {
        int vectSize = vect.size();
        if (comparator != null) {
            for (int i = initPos; i < vectSize; ++i) {
                if (!comparator.equals(obj, vect.elementAt(i))) continue;
                return i;
            }
        } else {
            for (int i = initPos; i < vectSize; ++i) {
                if (!vect.elementAt(i).equals(obj)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean checkIntersection(Vector l1, Vector l2) {
        boolean retVal = false;
        Vector intVect = new Vector();
        int l1siz = l1.size();
        for (int i = 0; i < l1siz; ++i) {
            Object obj = l1.elementAt(i);
            if (!l2.contains(obj)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static Vector intersect(Vector l1, Vector l2) {
        Vector intVect = new Vector();
        int l1siz = l1.size();
        for (int i = 0; i < l1siz; ++i) {
            Object obj = l1.elementAt(i);
            if (!l2.contains(obj)) continue;
            intVect.addElement(obj);
        }
        return intVect;
    }

    public static Vector reverse(Vector l1) {
        Vector revVect = new Vector();
        int l1siz = l1.size();
        for (int i = l1siz - 1; i >= 0; --i) {
            Object obj = l1.elementAt(i);
            revVect.addElement(obj);
        }
        return revVect;
    }

    public static Vector sort(Vector l1) {
        int sortType = 1;
        Object firstEl = l1.firstElement();
        if (firstEl instanceof String) {
            sortType = 1;
        } else if (firstEl instanceof Integer) {
            sortType = 2;
        } else {
            return l1;
        }
        Vector retLst = (Vector)l1.clone();
        int vectSize = retLst.size();
        for (int i = 0; i < vectSize - 1; ++i) {
            for (int j = i + 1; j < vectSize; ++j) {
                Object earlEl = retLst.elementAt(i);
                Object laterEl = retLst.elementAt(j);
                boolean largerThan = false;
                switch (sortType) {
                    case 1: {
                        largerThan = OiixVectorOps.stringGreaterThan(earlEl, laterEl);
                        break;
                    }
                    case 2: {
                        largerThan = OiixVectorOps.intGreaterThan(earlEl, laterEl);
                    }
                }
                if (!largerThan) continue;
                retLst.setElementAt(laterEl, i);
                retLst.setElementAt(earlEl, j);
            }
        }
        return retLst;
    }

    private static boolean stringGreaterThan(Object s1, Object s2) {
        return ((String)s1).compareTo((String)s2) > 0;
    }

    private static boolean intGreaterThan(Object i1, Object i2) {
        return (Integer)i1 > (Integer)i2;
    }

    public static Vector subtract(Vector l1, Vector l2) {
        Vector subVect = null;
        if (l1 != null) {
            subVect = (Vector)l1.clone();
            int l2siz = l2.size();
            for (int i = 0; i < l2siz; ++i) {
                subVect.removeElement(l2.elementAt(i));
            }
        }
        return subVect;
    }

    public static void subtractInPlace(Vector l1, Vector l2) {
        if (l1 != null && l2 != null) {
            int l2siz = l2.size();
            for (int i = 0; i < l2siz; ++i) {
                l1.removeElement(l2.elementAt(i));
            }
        }
    }

    public static Vector union(Vector l1, Vector l2) {
        Vector uniVect;
        Vector vector = uniVect = l1 != null ? (Vector)l1.clone() : new Vector();
        if (l2 != null) {
            int l2siz = l2.size();
            for (int i = 0; i < l2siz; ++i) {
                Object obj = l2.elementAt(i);
                if (uniVect.contains(obj)) continue;
                uniVect.addElement(obj);
            }
        }
        return uniVect;
    }

    public static void unionInPlace(Vector l1, Vector l2) {
        OiixVectorOps.unionInPlace((List)l1, (List)l2);
    }

    public static void unionInPlace(List l1, List l2) {
        if (l1 != null && l2 != null) {
            int l2siz = l2.size();
            for (int i = 0; i < l2siz; ++i) {
                Object obj = l2.get(i);
                if (l1.contains(obj)) continue;
                l1.add(obj);
            }
        }
    }

    public static Vector concat(Vector v1, Vector v2) {
        Vector vRet = new Vector(v1.size() + v2.size());
        vRet.addAll(v1);
        vRet.addAll(v2);
        return vRet;
    }

    public static Vector intArr2Vect(int[] intarr) {
        int arrLen = intarr != null ? intarr.length : 0;
        Vector<Integer> retVect = new Vector<Integer>(arrLen);
        for (int i = 0; i < arrLen; ++i) {
            retVect.addElement(new Integer(intarr[i]));
        }
        return retVect;
    }

    public static int[] vect2IntArr(Vector vect) {
        int vectsiz = vect != null ? vect.size() : 0;
        int[] retIntArr = new int[vectsiz];
        for (int i = 0; i < vectsiz; ++i) {
            retIntArr[i] = (Integer)vect.elementAt(i);
        }
        return retIntArr;
    }

    public static Vector strArr2Vect(String[] strarr) {
        int arrLen = strarr != null ? strarr.length : 0;
        Vector<String> retVect = new Vector<String>(arrLen);
        for (int i = 0; i < arrLen; ++i) {
            retVect.addElement(strarr[i]);
        }
        return retVect;
    }

    public static String[] list2StrArr(List oList) {
        int nListSize = oList != null ? oList.size() : 0;
        String[] retStrArr = new String[nListSize];
        for (int i = 0; i < nListSize; ++i) {
            retStrArr[i] = (String)oList.get(i);
        }
        return retStrArr;
    }

    public static String[] vect2StrArr(Vector vect) {
        return OiixVectorOps.list2StrArr(vect);
    }

    public static Vector strArr2LangVect(String[] strarr) {
        int arrLen = strarr != null ? strarr.length : 0;
        Vector<Locale> retVect = new Vector<Locale>(arrLen);
        for (int i = 0; i < arrLen; ++i) {
            retVect.addElement(OiixLanguage.fromEncStr(strarr[i]));
        }
        return retVect;
    }

    public static String[] langVect2StrArr(Vector vect) {
        int vectsiz = vect != null ? vect.size() : 0;
        String[] retStrArr = new String[vectsiz];
        for (int i = 0; i < vectsiz; ++i) {
            retStrArr[i] = OiixLanguage.toEncStr((Locale)vect.elementAt(i));
        }
        return retStrArr;
    }

    public static Vector arrayToVect(Object arrayObj) {
        if (arrayObj == null) {
            return new Vector();
        }
        boolean isArr = arrayObj.getClass().isArray();
        if (!isArr) {
            throw new IllegalArgumentException("Not an array object : " + arrayObj.getClass());
        }
        int arrLength = Array.getLength(arrayObj);
        Vector<Object> retVect = new Vector<Object>(arrLength);
        for (int i = 0; i < arrLength; ++i) {
            retVect.addElement(Array.get(arrayObj, i));
        }
        return retVect;
    }

    public static String[] parseStringArrFromString(String str, String delims) {
        Vector<String> els = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(str, delims);
        while (stok.hasMoreTokens()) {
            els.addElement(stok.nextToken());
        }
        Object[] retArr = new String[els.size()];
        els.copyInto(retArr);
        return retArr;
    }

    public static String composeStringArrayIntoString(String[] strs, String delim) {
        StringBuffer sbuf = new StringBuffer();
        int numEls = strs != null ? strs.length : 0;
        for (int i = 0; i < numEls - 1; ++i) {
            sbuf.append(strs[i]).append(delim);
        }
        if (numEls > 0) {
            sbuf.append(strs[numEls - 1]);
        }
        return sbuf.toString();
    }

    public static String objToString(Object obj) {
        String retStr;
        if (obj == null) {
            return String.valueOf(obj);
        }
        boolean isArr = obj.getClass().isArray();
        if (isArr) {
            StringBuffer objStr = new StringBuffer();
            objStr.append("[ ");
            int arrLength = Array.getLength(obj);
            for (int i = 0; i < arrLength; ++i) {
                objStr.append(OiixVectorOps.objToString(Array.get(obj, i)));
                objStr.append(" ");
            }
            objStr.append("]");
            retStr = objStr.toString();
        } else if (obj instanceof Vector) {
            StringBuffer objStr = new StringBuffer();
            objStr.append("[ ");
            int vectLength = ((Vector)obj).size();
            for (int i = 0; i < vectLength; ++i) {
                objStr.append(OiixVectorOps.objToString(((Vector)obj).elementAt(i)));
                objStr.append(" ");
            }
            objStr.append("]");
            retStr = objStr.toString();
        } else {
            retStr = obj.toString();
        }
        return retStr;
    }

    public static String[] getUnionOfStringLists(String[] saList1, String[] saList2) {
        int nList1 = 0;
        int nList2 = 0;
        if (saList1 != null) {
            nList1 = saList1.length;
        }
        if (saList2 != null) {
            nList2 = saList2.length;
        }
        ArrayList<String> aUnion = new ArrayList<String>(nList1 + nList2);
        for (int i = 0; i < nList1; ++i) {
            aUnion.add(saList1[i]);
        }
        for (int j = 0; j < nList2; ++j) {
            if (aUnion.contains(saList2[j])) continue;
            aUnion.add(saList2[j]);
        }
        String[] sRetList = new String[aUnion.size()];
        for (int k = 0; k < aUnion.size(); ++k) {
            sRetList[k] = (String)aUnion.get(k);
        }
        return sRetList;
    }

    public static boolean vectorSubset(List vect1, List vect2, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return OiixVectorOps.vectorSubset(vect1, vect2);
        }
        boolean isSubset = true;
        if (vect1 != null && vect2 != null) {
            Iterator v1els = vect1.iterator();
            while (v1els.hasNext()) {
                String element = v1els.next().toString();
                boolean found = true;
                for (int i = 0; i < vect2.size(); ++i) {
                    if (!vect2.get(i).toString().equalsIgnoreCase(element)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                isSubset = false;
                break;
            }
        } else if (vect1 != null || vect2 != null) {
            isSubset = false;
        }
        return isSubset;
    }
}

