/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import oracle.sysman.oii.oiix.OiixRunnableCmd;
import oracle.sysman.oii.oiix.OiixThreadLaunchException;
import oracle.sysman.oii.oiix.OiixWorkNotifiable;
import oracle.sysman.oii.oiix.WorkerThread;

public class OiixThreadLauncher {
    private WorkerThread workerThread = new WorkerThread(this);
    private OiixRunnableCmd work = null;
    private OiixWorkNotifiable myClient = null;
    private static final boolean s_debug = false;

    public OiixThreadLauncher() {
        this.workerThread.start();
    }

    public synchronized void setWork(OiixRunnableCmd work) throws OiixThreadLaunchException {
        if (this.work == null) {
            if (this.myClient != null) {
                this.myClient.workStarted(this);
            }
        } else {
            throw new OiixThreadLaunchException("Worker is busy");
        }
        this.work = work;
        this.notifyAll();
    }

    public synchronized OiixRunnableCmd getWork() {
        try {
            while (this.work == null) {
                this.wait();
            }
            return this.work;
        }
        catch (InterruptedException e) {
            System.err.println(e);
            return null;
        }
    }

    public synchronized void setWorkNotifiable(OiixWorkNotifiable c) throws OiixThreadLaunchException {
        if (this.myClient != null) {
            throw new OiixThreadLaunchException("Too many listeners");
        }
        this.myClient = c;
    }

    public void clearClient() {
        this.myClient = null;
        this.work = null;
    }

    public void destroy() {
        this.workerThread.stop();
    }

    public synchronized void done() {
        if (this.myClient == null) {
            return;
        }
        OiixWorkNotifiable temp = this.myClient;
        temp.workCompleted(this);
        this.myClient = null;
        this.work = null;
    }
}

