/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiixTeePrintStream
extends PrintStream {
    PrintStream m_primary;
    PrintWriter m_secondary = null;
    Vector m_secondaryStrs;
    private static PrintStream s_systemOut = System.out;
    private static PrintStream s_systemErr = System.err;
    private static String s_sErrFileLoc = "";
    private static String s_sOutFileLoc = "";

    public OiixTeePrintStream(PrintStream primary) {
        super(primary);
        this.m_primary = primary;
        this.m_secondaryStrs = new Vector();
    }

    public OiixTeePrintStream(PrintStream primary, String fileLoc) throws IOException {
        this(primary);
        this.m_secondary = new PrintWriter(new FileOutputStream(fileLoc, true), true);
    }

    public PrintStream getPrimary() {
        return this.m_primary;
    }

    public void setSecondary(String fileLoc) throws IOException {
        if (this.m_secondary != null) {
            this.m_secondary.close();
        }
        this.m_secondary = new PrintWriter(new FileOutputStream(fileLoc, true), true);
    }

    public void addSecondary(String fileLoc) throws IOException {
        if (OiixVectorOps.vectIndexOf(this.m_secondaryStrs, (Object)fileLoc) == -1) {
            FileLocStream fls = new FileLocStream(fileLoc);
            this.m_secondaryStrs.addElement(fls);
        }
    }

    public void removeSecondary(String fileLoc) {
        int locpos = -1;
        locpos = OiixVectorOps.vectIndexOf(this.m_secondaryStrs, (Object)fileLoc);
        if (locpos != -1) {
            FileLocStream fls = (FileLocStream)this.m_secondaryStrs.elementAt(locpos);
            fls.close();
            this.m_secondaryStrs.removeElementAt(locpos);
        }
    }

    @Override
    public void flush() {
        super.flush();
        this.flushSecondaries();
    }

    protected void flushSecondaries() {
        if (this.m_secondary != null) {
            this.m_secondary.flush();
        }
        int numSecs = this.m_secondaryStrs.size();
        for (int i = 0; i < numSecs; ++i) {
            FileLocStream fls = (FileLocStream)this.m_secondaryStrs.elementAt(i);
            fls.getPrintWriter().flush();
        }
    }

    @Override
    public void close() {
        super.close();
        this.closeSecondaries();
    }

    protected void closeSecondaries() {
        if (this.m_secondary != null) {
            this.m_secondary.close();
        }
        int numSecs = this.m_secondaryStrs.size();
        for (int i = 0; i < numSecs; ++i) {
            FileLocStream fls = (FileLocStream)this.m_secondaryStrs.elementAt(i);
            fls.getPrintWriter().close();
        }
    }

    @Override
    public boolean checkError() {
        boolean ce2 = false;
        boolean ce1 = super.checkError();
        if (this.m_secondary != null) {
            ce2 = this.m_secondary.checkError();
        }
        int numSecs = this.m_secondaryStrs.size();
        for (int i = 0; i < numSecs; ++i) {
            FileLocStream fls = (FileLocStream)this.m_secondaryStrs.elementAt(i);
            ce2 = ce2 || fls.getPrintWriter().checkError();
        }
        return ce1 || ce2;
    }

    @Override
    public void write(int b) {
        super.write(b);
        if (this.m_secondary != null) {
            this.m_secondary.write(b);
        }
        int numSecs = this.m_secondaryStrs.size();
        for (int i = 0; i < numSecs; ++i) {
            FileLocStream fls = (FileLocStream)this.m_secondaryStrs.elementAt(i);
            fls.getPrintWriter().write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        if (this.m_secondary != null) {
            this.m_secondary.write(new String(buf, off, len));
        }
        int numSecs = this.m_secondaryStrs.size();
        for (int i = 0; i < numSecs; ++i) {
            FileLocStream fls = (FileLocStream)this.m_secondaryStrs.elementAt(i);
            fls.getPrintWriter().write(new String(buf, off, len));
        }
    }

    @Override
    public void println() {
        super.println();
        this.flushSecondaries();
    }

    @Override
    public void println(boolean x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(char x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(int x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(long x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(float x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(double x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(char[] x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(String x) {
        super.println(x);
        this.flushSecondaries();
    }

    @Override
    public void println(Object x) {
        super.println(x);
        this.flushSecondaries();
    }

    public static synchronized void setOutputTee(String fileLoc) throws IOException {
        PrintStream ops = System.out;
        s_sOutFileLoc = OiixPathOps.getNativeForm(fileLoc);
        String sConsole = System.getProperty("oracle.installer.console");
        if (sConsole != null && sConsole.equalsIgnoreCase("true")) {
            if (ops instanceof OiixTeePrintStream) {
                ((OiixTeePrintStream)ops).setSecondary(fileLoc);
            } else {
                ops = new OiixTeePrintStream(ops, fileLoc);
                System.setOut(ops);
            }
        } else if (ops instanceof OiixTeePrintStream) {
            ((OiixTeePrintStream)ops).setSecondary(fileLoc);
        } else {
            ops = new OiixTeePrintStream(new PrintStream(new FileOutputStream(s_sOutFileLoc, true), true));
            System.setOut(ops);
        }
    }

    public static synchronized void resetOutputTee() throws IOException {
        PrintStream ops = System.out;
        while (ops instanceof OiixTeePrintStream) {
            OiixTeePrintStream tops = (OiixTeePrintStream)ops;
            tops.closeSecondaries();
            ops = tops.getPrimary();
        }
        System.setOut(ops);
    }

    public static synchronized void setErrorTee(String fileLoc) throws IOException {
        PrintStream eps = System.err;
        s_sErrFileLoc = OiixPathOps.getNativeForm(fileLoc);
        if (eps instanceof OiixTeePrintStream) {
            ((OiixTeePrintStream)eps).setSecondary(fileLoc);
        } else {
            eps = new OiixTeePrintStream(new PrintStream(new FileOutputStream(fileLoc, true)));
            System.setErr(eps);
        }
    }

    public static synchronized void resetErrorTee() throws IOException {
        PrintStream eps = System.err;
        while (eps instanceof OiixTeePrintStream) {
            OiixTeePrintStream teps = (OiixTeePrintStream)eps;
            teps.closeSecondaries();
            eps = teps.getPrimary();
        }
        System.setErr(eps);
    }

    public static void restoreSystemOut() throws IOException {
        OiixTeePrintStream.resetOutputTee();
        PrintStream ops = System.out;
        if (ops != s_systemOut) {
            ops.close();
        }
        System.setOut(s_systemOut);
    }

    public static void restoreSystemErr() throws IOException {
        OiixTeePrintStream.resetErrorTee();
        PrintStream eps = System.err;
        if (eps != s_systemErr) {
            eps.close();
        }
        System.setErr(s_systemErr);
    }

    public static synchronized void addOutputTee(String fileLoc) throws IOException {
        PrintStream ops = System.out;
        if (ops instanceof OiixTeePrintStream) {
            ((OiixTeePrintStream)ops).addSecondary(fileLoc);
        } else {
            OiixTeePrintStream tops = new OiixTeePrintStream(ops);
            tops.addSecondary(fileLoc);
            System.setOut(tops);
        }
    }

    public static String getErrFileLoc() {
        return s_sErrFileLoc;
    }

    public static String getOutFileLoc() {
        return s_sOutFileLoc;
    }

    public static synchronized void removeOutputTee(String fileLoc) throws IOException {
        PrintStream ops = System.out;
        if (ops instanceof OiixTeePrintStream) {
            ((OiixTeePrintStream)ops).removeSecondary(fileLoc);
        }
    }

    public static synchronized void addErrorTee(String fileLoc) throws IOException {
        PrintStream eps = System.err;
        if (eps instanceof OiixTeePrintStream) {
            ((OiixTeePrintStream)eps).addSecondary(fileLoc);
        } else {
            OiixTeePrintStream teps = new OiixTeePrintStream(eps);
            teps.addSecondary(fileLoc);
            System.setErr(teps);
        }
    }

    public static synchronized void addStackTrace(Exception e) throws IOException {
        PrintStream eps = System.err;
        if (eps instanceof OiixTeePrintStream) {
            System.err.println("Tee stream, printing stack trace");
            e.printStackTrace((OiixTeePrintStream)eps);
        } else {
            System.err.println("not a Tee stream, not printing stack trace");
        }
    }

    public static synchronized void removeErrorTee(String fileLoc) throws IOException {
        PrintStream eps = System.err;
        if (eps instanceof OiixTeePrintStream) {
            ((OiixTeePrintStream)eps).removeSecondary(fileLoc);
        }
    }

    private static void usage() {
        System.out.println("Usage : java oracle.sysman.oii.oiix.OiixTeePrintStream 0 <outfile> <errfile>");
        System.out.println("                 OR ");
        System.out.println("Usage : java oracle.sysman.oii.oiix.OiixTeePrintStream 1 <outfile1> <outfile2> <outfile3> ...");
        System.out.println("                 OR ");
        System.out.println("Usage : java oracle.sysman.oii.oiix.OiixTeePrintStream 2 <errfile1> <errfile2> <errfile3> ...");
    }

    private static void test0(String arg0, String arg1) {
        try {
            int i;
            OiixTeePrintStream.setOutputTee(arg0);
            OiixTeePrintStream.setErrorTee(arg1);
            for (i = 0; i < 10; ++i) {
                System.out.println("Printing to output " + i);
                System.err.println("Printing to error  " + i);
            }
            OiixTeePrintStream.addStackTrace(new IOException("testing"));
            OiixTeePrintStream.resetOutputTee();
            OiixTeePrintStream.resetErrorTee();
            for (i = 11; i < 20; ++i) {
                System.out.println("Printing to output " + i);
                System.err.println("Printing to error  " + i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test1(String[] argsList) {
        try {
            int i;
            for (i = 0; i < argsList.length; ++i) {
                OiixTeePrintStream.addOutputTee(argsList[i]);
            }
            for (i = 0; i < 10; ++i) {
                System.out.println("Printing to output " + i);
                System.err.println("Printing to error  " + i);
            }
            for (i = 0; i < argsList.length; ++i) {
                OiixTeePrintStream.removeOutputTee(argsList[i]);
            }
            for (i = 10; i < 20; ++i) {
                System.out.println("Printing to output " + i);
                System.err.println("Printing to error  " + i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test2(String[] argsList) {
        try {
            int i;
            for (i = 0; i < argsList.length; ++i) {
                OiixTeePrintStream.addErrorTee(argsList[i]);
            }
            for (i = 0; i < 10; ++i) {
                System.out.println("Printing to output " + i);
                System.err.println("Printing to error  " + i);
            }
            for (i = 0; i < argsList.length; ++i) {
                OiixTeePrintStream.removeErrorTee(argsList[i]);
            }
            for (i = 10; i < 20; ++i) {
                System.out.println("Printing to output " + i);
                System.err.println("Printing to error  " + i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FileLocStream {
        private String m_fileLoc;
        private PrintWriter m_printWriter;

        FileLocStream(String fileLoc) throws IOException {
            this.m_fileLoc = fileLoc;
            this.m_printWriter = new PrintWriter(new FileOutputStream(this.m_fileLoc, true), true);
        }

        String getFileLoc() {
            return this.m_fileLoc;
        }

        PrintWriter getPrintWriter() {
            return this.m_printWriter;
        }

        void close() {
            this.m_printWriter.close();
        }

        public boolean equals(String str) {
            return this.m_fileLoc.equals(str);
        }

        public boolean equals(FileLocStream fls) {
            if (fls != null) {
                return this.m_fileLoc.equals(fls.getFileLoc());
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                if (obj instanceof FileLocStream) {
                    return this.equals((FileLocStream)obj);
                }
                if (obj instanceof String) {
                    return this.equals((String)obj);
                }
                return super.equals(obj);
            }
            return false;
        }
    }
}

