/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiixSparseMatrix
implements Cloneable,
Serializable {
    private Hashtable m_oMatrix;
    private String m_sRowElementType;
    private String m_sColumnElementType;
    private Class m_oRowElementTypeClass;
    private Class m_oColumnElementTypeClass;
    private int m_iStartSize = 5;
    private int m_iIncrSize = 5;
    private Comparator m_oRowComparator;
    private Comparator m_oColumnComparator;

    public OiixSparseMatrix(String sRowType, String sColumnType, int iStartSize, int iIncrSize) throws OiixInvalidDataException {
        this(sRowType, sColumnType, null, null, iStartSize, iIncrSize);
    }

    public OiixSparseMatrix(String sRowType, String sColumnType, Comparator oRowComparator, Comparator oColComparator) throws OiixInvalidDataException {
        this(sRowType, sColumnType, oRowComparator, oColComparator, 5, 5);
    }

    public OiixSparseMatrix(String sRowType, String sColumnType, Comparator oRowComparator, Comparator oColComparator, int iStartSize, int iIncrSize) throws OiixInvalidDataException {
        this.m_sRowElementType = sRowType;
        this.m_oRowElementTypeClass = OiixUtilityOps.getClassForName(this.m_sRowElementType);
        this.m_sColumnElementType = sColumnType;
        this.m_oColumnElementTypeClass = OiixUtilityOps.getClassForName(this.m_sColumnElementType);
        this.m_oRowComparator = oRowComparator;
        this.m_oColumnComparator = oColComparator;
        this.m_iStartSize = iStartSize;
        this.m_iIncrSize = iIncrSize;
        this.m_oMatrix = new Hashtable();
    }

    public synchronized void addElement(Object row, Object column) throws OiixInvalidDataException {
        OiixUtilityOps.validateElementType(row, this.m_oRowElementTypeClass);
        OiixSet oRow = (OiixSet)this.m_oMatrix.get(row);
        boolean bNewRow = false;
        if (oRow == null) {
            bNewRow = true;
            try {
                oRow = new OiixSet(this.m_sColumnElementType, this.m_oColumnComparator, this.m_iStartSize, this.m_iIncrSize);
            }
            catch (OiixInvalidDataException oiixInvalidDataException) {
                // empty catch block
            }
        }
        try {
            oRow.addElement(column);
            if (bNewRow) {
                this.m_oMatrix.put(row, oRow);
            }
        }
        catch (OiixInvalidDataException e) {
            System.err.println(e.getMessage());
        }
    }

    public synchronized void removeElement(Object row, Object column) throws OiixInvalidDataException {
        OiixUtilityOps.validateElementType(row, this.m_oRowElementTypeClass);
        OiixSet oRow = (OiixSet)this.m_oMatrix.get(row);
        if (oRow != null) {
            oRow.removeElement(column);
            if (oRow.size() == 0) {
                this.m_oMatrix.remove(row);
            }
        }
    }

    public synchronized Vector getRowElements(Object o) {
        OiixSet oRow = (OiixSet)this.m_oMatrix.get(o);
        return oRow == null ? null : oRow.elementsVect();
    }

    public synchronized OiixSet getRow(Object o) {
        return (OiixSet)this.m_oMatrix.get(o);
    }

    public synchronized boolean containsRowElement(Object o) {
        return this.m_oMatrix.containsKey(o);
    }

    public synchronized OiixSparseMatrix transpose() {
        OiixSparseMatrix oTranspose = null;
        try {
            oTranspose = new OiixSparseMatrix(this.m_sColumnElementType, this.m_sRowElementType, this.m_oColumnComparator, this.m_oRowComparator, this.m_iStartSize, this.m_iIncrSize);
            Enumeration keys = this.m_oMatrix.keys();
            while (keys.hasMoreElements()) {
                Object oRow = keys.nextElement();
                OiixSet oCol = (OiixSet)this.m_oMatrix.get(oRow);
                int nSize = oCol.size();
                Vector oColVect = oCol.elementsVect();
                for (int i = 0; i < nSize; ++i) {
                    oTranspose.addElement(oColVect.elementAt(i), oRow);
                }
            }
        }
        catch (OiixInvalidDataException oiixInvalidDataException) {
            // empty catch block
        }
        return oTranspose;
    }

    public synchronized Vector getColumnElements(Object o) {
        OiixSparseMatrix oTranspose = this.transpose();
        return oTranspose.getRowElements(o);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        Enumeration keys = this.m_oMatrix.keys();
        while (keys.hasMoreElements()) {
            Object elem = keys.nextElement();
            sb.append(elem.toString());
            OiixSet oRow = this.getRow(elem);
            sb.append(oRow.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof OiixSparseMatrix) {
            OiixSparseMatrix oOtherMatrix = (OiixSparseMatrix)o;
            Enumeration enum_1 = this.m_oMatrix.keys();
            while (enum_1.hasMoreElements()) {
                Object key = enum_1.nextElement();
                if (!oOtherMatrix.containsRowElement(key)) {
                    return false;
                }
                OiixSet oRow = oOtherMatrix.getRow(key);
                if (oRow.equals(this.m_oMatrix.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

