/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.LexiComparator;
import oracle.sysman.oii.oiix.OiixComparable;
import oracle.sysman.oii.oiix.OiixEqualityComparator;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSearch;
import oracle.sysman.oii.oiix.OiixSort;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiixSet
implements Cloneable,
Serializable {
    public static final int ITEM_NOT_ADDED = -1;
    public static final int ITEM_NOT_FOUND = -1;
    private Vector m_oList;
    private String m_sElementType;
    private Class m_oElementTypeClass;
    private Comparator m_oComparator;
    private OiixEqualityComparator m_oEqualityComparator;

    public OiixSet(String sElemType) throws OiixInvalidDataException {
        this(sElemType, null, 5, 5);
    }

    public OiixSet(String sElemType, Comparator oComparator) throws OiixInvalidDataException {
        this(sElemType, oComparator, 5, 5);
    }

    public OiixSet(String sElemType, Comparator oComparator, int startSize, int inc) throws OiixInvalidDataException {
        this.m_sElementType = sElemType;
        this.m_oElementTypeClass = OiixUtilityOps.getClassForName(sElemType);
        this.m_oComparator = oComparator;
        this.m_oList = new Vector(startSize, inc);
    }

    public OiixSet(String sElemType, OiixEqualityComparator equalityComparator) throws OiixInvalidDataException {
        this(sElemType);
        this.m_oEqualityComparator = equalityComparator;
    }

    public synchronized void setComparator(Comparator oComparator) {
        boolean bShouldSort;
        boolean bSorted = this.m_oComparator != null;
        boolean bl = bShouldSort = oComparator != null;
        if (!(!bShouldSort || bSorted && oComparator.equals(this.m_oComparator))) {
            OiixSort.qSort(this.m_oList, oComparator);
        }
        this.m_oComparator = oComparator;
    }

    public synchronized Object clone() {
        try {
            OiixSet oSet = (OiixSet)super.clone();
            oSet.m_oList = (Vector)this.m_oList.clone();
            return oSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int size() {
        return this.m_oList.size();
    }

    public String getElementType() {
        return this.m_sElementType;
    }

    public String toString() {
        return this.m_oList.toString();
    }

    public int hashCode() {
        return this.m_oList.hashCode();
    }

    public boolean equals(Object o) {
        int nListSize;
        OiixSet oOtherSet;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof OiixSet && (oOtherSet = (OiixSet)o).getElementType().equals(this.m_sElementType) && (nListSize = this.m_oList.size()) == oOtherSet.size()) {
            for (int i = 0; i < nListSize; ++i) {
                Object elem = this.m_oList.elementAt(i);
                Object otherElem = oOtherSet.getElementLike(elem);
                if (otherElem != null && otherElem.equals(elem)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean similar(Object o) {
        int nListSize;
        OiixSet oOtherSet;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof OiixSet && (oOtherSet = (OiixSet)o).getElementType().equals(this.m_sElementType) && (nListSize = this.m_oList.size()) == oOtherSet.size()) {
            for (int i = 0; i < nListSize; ++i) {
                Object elem = this.m_oList.elementAt(i);
                Object otherElem = oOtherSet.getElementLike(elem);
                if (otherElem != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object getElementLike(Object o) {
        int index = this.m_oComparator != null ? this.searchSortedElement(o) : this.searchElement(o);
        return index == -1 ? null : this.m_oList.elementAt(index);
    }

    public synchronized Object addElement(Object o) throws OiixInvalidDataException {
        if (o != null) {
            this.validateElementType(o);
            return this.addElementInternal(o);
        }
        throw new OiixInvalidDataException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVALID_DATA_SPECIFIED"));
    }

    public synchronized Object removeElement(Object o) {
        Object objToRemove = null;
        try {
            this.validateElementType(o);
            int index = this.m_oComparator != null ? this.searchSortedElement(o) : this.searchElement(o);
            if (index != -1) {
                objToRemove = this.m_oList.elementAt(index);
                this.m_oList.removeElementAt(index);
            }
        }
        catch (OiixInvalidDataException e) {
            int index = -1;
        }
        return objToRemove;
    }

    public synchronized void removeAllElements() {
        this.m_oList.removeAllElements();
    }

    public synchronized Enumeration elements() {
        return this.m_oList.elements();
    }

    public synchronized Vector elementsVect() {
        return (Vector)this.m_oList.clone();
    }

    public Iterator iterator() {
        return this.m_oList == null ? new ArrayList().iterator() : this.m_oList.iterator();
    }

    private Object addElementInternal(Object o) throws OiixInvalidDataException {
        int index = this.m_oComparator != null ? this.searchAndInsertElement(o) : this.insertElement(o);
        Object oInserted = this.m_oList.elementAt(index);
        return oInserted;
    }

    private int searchAndInsertElement(Object o) throws OiixInvalidDataException {
        int index = OiixSearch.bSearchAndInsert(o, this.m_oList, this.m_oComparator, false);
        if (index == -1) {
            Object[] args = new Object[]{o};
            throw new OiixInvalidDataException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ITEM_CANNOT_BE_ADDED", args));
        }
        return index;
    }

    private int insertElement(Object o) throws OiixInvalidDataException {
        int index = this.searchElement(o);
        if (index == -1) {
            this.m_oList.addElement(o);
            index = this.m_oList.size() - 1;
        }
        return index;
    }

    private int searchSortedElement(Object o) {
        return OiixSearch.bSearch(o, this.m_oList, this.m_oComparator);
    }

    private int searchElement(Object obj) {
        int idx = -1;
        idx = OiixVectorOps.vectIndexOf(this.m_oList, obj, 0, this.m_oEqualityComparator);
        return idx;
    }

    private void validateElementType(Object oObject) throws OiixInvalidDataException {
        OiixUtilityOps.validateElementType(oObject, this.m_oElementTypeClass);
    }

    public class Test
    implements OiixComparable {
        String m_sKey;
        String m_sValue;

        public Test(String sKey, String sValue) {
            this.m_sKey = sKey;
            this.m_sValue = sValue;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Test oOther = (Test)o;
            return oOther.m_sKey.equals(this.m_sKey) && oOther.m_sValue.equals(this.m_sValue);
        }

        @Override
        public int compare(OiixComparable o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            Test oOther = (Test)o;
            Comparator oComparator = LexiComparator.getComparator();
            return oComparator.compare((Object)this.m_sKey, (Object)oOther.m_sKey);
        }

        public String toString() {
            return "(" + this.m_sKey + ": " + this.m_sValue + ")";
        }
    }
}

