/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgPlatformNotSupportedException;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiixServiceOps {
    private static void checkPlatform() throws OiipgPlatformNotSupportedException {
        int nPlat = OiixPlatform.getCurrentPlatform();
        if (!OiixPlatform.isPlatInGroup(-3, nPlat)) {
            throw new OiipgPlatformNotSupportedException(nPlat);
        }
    }

    public static Object[] getAllServices() throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntGetAllServicesw32();
    }

    public static Object[] getAllOracleServices() throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntGetAllOracleServicesw32();
    }

    public static int queryService(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntQueryServicew32(sServiceName);
    }

    public static String getServiceExeName(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntGetServiceExeNamew32(sServiceName);
    }

    public static int getServiceType(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntGetServiceTypew32(sServiceName);
    }

    public static int getServiceStartType(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntGetServiceStartTypew32(sServiceName);
    }

    public static int getServiceErrorControl(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        return OiipwWin32NativeCalls.ssntGetServiceErrorControlw32(sServiceName);
    }

    public static void ntCreateService(String sExeName, String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        OiipwWin32NativeCalls.ntCreateService(sExeName, sServiceName);
    }

    public static void ntCreateService(String sExeName, String sServiceName, String sSelectedNodes) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        if (sSelectedNodes == null || sSelectedNodes.equals("")) {
            OiipwWin32NativeCalls.ntCreateService(sExeName, sServiceName);
        } else {
            OiipwWin32NativeCalls.ntCreateService(sExeName, sServiceName, sSelectedNodes);
        }
    }

    public static void ntCreateServiceAdvanced(String sExeName, String sServiceName, int saccess, int stype, int ttype, int econtrol, String deps, String startname, String pwd, String sDisplayName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        OiipwWin32NativeCalls.ntCreateServiceAdvanced(sExeName, sServiceName, saccess, stype, ttype, econtrol, deps, startname, pwd, sDisplayName);
    }

    public static void ntCreateServiceAdvanced(String sExeName, String sServiceName, int saccess, int stype, int ttype, int econtrol, String deps, String startname, String pwd, String sDisplayName, String sSelectedNodes) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        if (sSelectedNodes == null || sSelectedNodes.equals("")) {
            OiipwWin32NativeCalls.ntCreateServiceAdvanced(sExeName, sServiceName, saccess, stype, ttype, econtrol, deps, startname, pwd, sDisplayName);
        } else {
            OiipwWin32NativeCalls.ntCreateServiceAdvanced(sExeName, sServiceName, saccess, stype, ttype, econtrol, deps, startname, pwd, sDisplayName, sSelectedNodes);
        }
    }

    public static void ntDeleteService(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        OiipwWin32NativeCalls.ntDeleteService(sServiceName);
    }

    public static void ntDeleteService(String sServiceName, String sSelectedNodes) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        if (sSelectedNodes == null || sSelectedNodes.equals("")) {
            OiipwWin32NativeCalls.ntDeleteService(sServiceName);
        } else {
            OiipwWin32NativeCalls.ntDeleteService(sServiceName, sSelectedNodes);
        }
    }

    public static void ntStartService(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        OiipwWin32NativeCalls.ntStartService(sServiceName);
    }

    public static void ntStartService(String sServiceName, String sSelectedNodes) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        if (sSelectedNodes == null || sSelectedNodes.equals("")) {
            OiipwWin32NativeCalls.ntStartService(sServiceName);
        } else {
            OiipwWin32NativeCalls.ntStartService(sServiceName, sSelectedNodes);
        }
    }

    public static void ntStopService(String sServiceName) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        OiipwWin32NativeCalls.ntStopService(sServiceName);
    }

    public static void ntStopService(String sServiceName, String sSelectedNodes) throws OiilNativeException, OiipgPlatformNotSupportedException {
        OiixServiceOps.checkPlatform();
        if (sSelectedNodes == null || sSelectedNodes.equals("")) {
            OiipwWin32NativeCalls.ntStopService(sServiceName);
        } else {
            OiipwWin32NativeCalls.ntStopService(sServiceName, sSelectedNodes);
        }
    }
}

