/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiixRunnableCmd
implements Runnable {
    String m_sCmd = "";
    private String[] m_sCmdLineArgs = null;
    private boolean m_bUseCommandArray = false;
    OiixSpawner m_process = null;
    Exception m_exception = null;
    private static final boolean s_debug = false;

    public OiixRunnableCmd(String cmd) {
        this(cmd, System.out, System.err);
    }

    public OiixRunnableCmd(String cmd, OutputStream out, OutputStream err) {
        this(cmd, null, out, err);
    }

    public OiixRunnableCmd(String cmd, String[] cmdLineArgs, OutputStream out, OutputStream err) {
        this(cmd, cmdLineArgs, out, err, false);
    }

    public OiixRunnableCmd(String cmd, String[] cmdLineArgs, OutputStream out, OutputStream err, boolean bUseCommandArray) {
        this.m_sCmd = cmd;
        this.m_sCmdLineArgs = cmdLineArgs;
        ArrayList<OutputStream> outs = new ArrayList<OutputStream>(1);
        outs.add(out);
        ArrayList<OutputStream> errs = new ArrayList<OutputStream>(1);
        errs.add(err);
        this.m_bUseCommandArray = bUseCommandArray;
        this.m_process = new OiixSpawner(outs, errs);
    }

    public OiixRunnableCmd(String cmd, String[] cmdLineArgs, List outs, List errs) {
        this(cmd, cmdLineArgs, outs, errs, false);
    }

    public OiixRunnableCmd(String cmd, String[] cmdLineArgs, List outs, List errs, boolean bUseCommandArray) {
        this.m_sCmd = cmd;
        this.m_sCmdLineArgs = cmdLineArgs;
        this.m_bUseCommandArray = bUseCommandArray;
        this.m_process = new OiixSpawner(outs, errs);
    }

    @Override
    public void run() {
        this.m_exception = null;
        try {
            this.m_process.execute(this.m_sCmd, this.m_sCmdLineArgs, null, this.m_bUseCommandArray);
        }
        catch (OiixSpawnException e) {
            this.m_exception = e;
        }
    }

    public void stopRunningProcess() {
        if (this.m_process != null) {
            this.m_process.killProcess();
        }
    }

    public void setCommand(String cmd) {
        this.m_sCmd = cmd;
    }

    public String getCommand() {
        return this.m_sCmd;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public void setRuntimeException(RuntimeException re) {
        this.m_exception = re;
    }

    public boolean isExceptionThrown() {
        return this.m_exception != null;
    }

    public void throwException() throws Exception {
        throw this.m_exception;
    }

    public int getResultCode() {
        return this.m_process.getResultCode();
    }
}

