/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixLanguage;

public class OiixResourceBundle {
    private static final String RESOURCE_FIELD_SEPARATOR = "@";

    public static String getFont() {
        return System.getProperty("oracle.installer.font", OiixResourceBundle.getString("S_DEFAULT_FONT"));
    }

    public static String getString(String sResourceClass, String key) {
        try {
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle(sResourceClass);
            }
            catch (MissingResourceException e) {
                try {
                    rb = OiixJarResourceBundle.extractLanguageBundle(null, null, null, sResourceClass);
                }
                catch (ClassNotFoundException ex) {
                    throw e;
                }
                catch (InstantiationException ex) {
                    throw e;
                }
                catch (IllegalAccessException ex) {
                    throw e;
                }
            }
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            return OiixResourceBundle.getEnglishString(sResourceClass, key);
        }
    }

    public static String getEnglishString(String sResourceClass, String key) {
        try {
            return OiixResourceBundle.getEnglishBundle(sResourceClass).getString(key);
        }
        catch (MissingResourceException mse) {
            if (!sResourceClass.equals("oracle.sysman.oii.oiir.OiirRuntimeRes")) {
                return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", key);
            }
            return key;
        }
    }

    private static ResourceBundle getEnglishBundle(String sResourceClass) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(sResourceClass, OiixLanguage.DEFAULT_LOCALE);
        }
        catch (MissingResourceException e) {
            try {
                rb = OiixJarResourceBundle.extractLanguageBundle(null, null, OiixLanguage.DEFAULT_LOCALE, sResourceClass);
            }
            catch (ClassNotFoundException ex) {
                throw e;
            }
            catch (InstantiationException ex) {
                throw e;
            }
            catch (IllegalAccessException ex) {
                throw e;
            }
        }
        return rb;
    }

    public static String getString(String sResourceClass, String key, Object[] args) {
        String str = key;
        try {
            str = MessageFormat.format(OiixResourceBundle.getString(sResourceClass, key), args);
        }
        catch (IllegalArgumentException e) {
            str = key;
        }
        return str;
    }

    public static String getStringFromFullyQualifiedID(String sResourceSpec) {
        String key = OiixResourceBundle.getKey(sResourceSpec);
        String sResourceClass = OiixResourceBundle.getResourceClassName(sResourceSpec);
        return OiixResourceBundle.getString(sResourceClass, key);
    }

    public static String getStringFromFullyQualifiedID(String sResourceSpec, Object[] args) {
        String key = OiixResourceBundle.getKey(sResourceSpec);
        String sResourceClass = OiixResourceBundle.getResourceClassName(sResourceSpec);
        return OiixResourceBundle.getString(sResourceClass, key, args);
    }

    private static String getKey(String sResourceSpec) {
        String key = sResourceSpec;
        int index = sResourceSpec.indexOf(RESOURCE_FIELD_SEPARATOR);
        if (index != -1) {
            key = sResourceSpec.substring(0, index);
        }
        return key;
    }

    private static String getResourceClassName(String sResourceSpec) {
        String sResourceClassName = "oracle.sysman.oii.oiir.OiirRuntimeRes";
        int index = sResourceSpec.indexOf(RESOURCE_FIELD_SEPARATOR);
        if (index != -1) {
            sResourceClassName = sResourceSpec.substring(index + 1);
        }
        return sResourceClassName;
    }

    public static synchronized String getString(String key) {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", key);
    }

    public static synchronized String getString(String key, Object[] args) {
        String str = key;
        try {
            str = MessageFormat.format(OiixResourceBundle.getString(key), args);
        }
        catch (IllegalArgumentException e) {
            str = key;
        }
        return str;
    }

    public static ResourceBundle getBundle() {
        return OiixResourceBundle.getBundle("oracle.sysman.oii.oiir.OiirRuntimeRes");
    }

    public static ResourceBundle getBundle(String sResourceClass) {
        return ResourceBundle.getBundle(sResourceClass);
    }

    private static ResourceBundle getEnglishBundle() {
        return OiixResourceBundle.getEnglishBundle("oracle.sysman.oii.oiir.OiirRuntimeRes");
    }

    private static String getEnglishString(String key) {
        return OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", key);
    }
}

