/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixProgressComputor;

public class OiixProgressComputorFactory {
    private static final String S_PROGRESS_COMPUTOR = "oracle.sysman.oii.oiix.OiixProgressComputor";

    private static boolean isValidClass(Class oClass) {
        boolean bValidClass = false;
        Class<?>[] aoInterfaces = oClass.getInterfaces();
        if (aoInterfaces != null) {
            int i = 0;
            while (i < aoInterfaces.length && !bValidClass) {
                bValidClass = aoInterfaces[i].getName().equals(S_PROGRESS_COMPUTOR);
            }
        }
        return bValidClass;
    }

    public static OiixProgressComputor getProgressComputor(String sClass, long millis) {
        OiixProgressComputor oComputor;
        block8: {
            oComputor = null;
            try {
                Class<?> oClass = Class.forName(sClass);
                if (!OiixProgressComputorFactory.isValidClass(oClass)) break block8;
                try {
                    Constructor<?> oConstr = oClass.getDeclaredConstructor(new Class[0]);
                    try {
                        oComputor = (OiixProgressComputor)oConstr.newInstance(new Object[0]);
                        oComputor.setInitialFrequency(millis);
                    }
                    catch (InstantiationException e) {
                        OiiolTextLogger.appendErrorText(e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        OiiolTextLogger.appendErrorText(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        OiiolTextLogger.appendErrorText(e.getMessage());
                    }
                }
                catch (NoSuchMethodException e) {
                    OiiolTextLogger.appendErrorText(e.getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                OiiolTextLogger.appendErrorText(e.getMessage());
            }
        }
        return oComputor;
    }
}

