/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.util.Vector;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

class OiixPlatformGroupInfo {
    private int m_groupID;
    private String m_commonName;
    private Vector m_contents;

    public OiixPlatformGroupInfo(int groupID, String commonName) {
        this.m_groupID = groupID;
        this.m_commonName = commonName;
        this.m_contents = new Vector();
    }

    public int getGroupID() {
        return this.m_groupID;
    }

    public String getCommonName() {
        return this.m_commonName;
    }

    public void addElement(int ID) {
        this.m_contents.addElement(new Integer(ID));
    }

    public boolean containsPlat(int platID) {
        return OiixPlatform.platInVector(this.m_contents, platID);
    }

    public Vector allContainedPlats() {
        Vector<Integer> retVect = new Vector<Integer>();
        int numConts = this.m_contents.size();
        for (int i = 0; i < numConts; ++i) {
            int conti = (Integer)this.m_contents.elementAt(i);
            if (conti < 0) {
                OiixPlatformGroupInfo pgi = OiixPlatform.getPlatGroupInfo(conti);
                if (pgi == null) continue;
                OiixVectorOps.unionInPlace(retVect, pgi.containedPlats());
                continue;
            }
            retVect.addElement(new Integer(conti));
        }
        return retVect;
    }

    public Vector containedPlats() {
        Vector<Integer> retVect = new Vector<Integer>();
        int numConts = this.m_contents.size();
        for (int i = 0; i < numConts; ++i) {
            int conti = (Integer)this.m_contents.elementAt(i);
            if (conti <= 0) continue;
            retVect.addElement(new Integer(conti));
        }
        return retVect;
    }

    public Vector containedPlatGroups() {
        Vector<Integer> retVect = new Vector<Integer>();
        int numConts = this.m_contents.size();
        for (int i = 0; i < numConts; ++i) {
            int conti = (Integer)this.m_contents.elementAt(i);
            if (conti >= 0) continue;
            retVect.addElement(new Integer(conti));
        }
        return retVect;
    }
}

