/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.util.Vector;
import oracle.sysman.oii.oiix.OiixEnumException;
import oracle.sysman.oii.oiix.OiixPlatformGroupInfo;
import oracle.sysman.oii.oiix.OiixPlatformInfo;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixPlatform {
    public static final int WINDOWS_NT = 912;
    private static final String WINDOWS_NT_COMMON_NAME = "NT_X86";
    private static final String WINDOWS_NT_DIRECTORY_NAME = "win32";
    private static final String WINDOWS_NT_OS_NAME = "Windows NT";
    private static final String WINDOWS_NT_OS_ARCH = "x86";
    private static final String WINDOWS_NT_OS_VER = "4.0";
    private static final String WINDOWS_GENERIC_OS_NAME = "Windows";
    public static final int WINDOWS_64 = 208;
    private static final String WINDOWS_64_COMMON_NAME = "NT_IA64";
    private static final String WINDOWS_64_DIRECTORY_NAME = "win64";
    private static final String WINDOWS_64_OS_NAME = "Windows 64-bit";
    private static final String WINDOWS_64_OS_ARCH = "ia64";
    private static final String WINDOWS_64_OS_VER = "5.1";
    public static final int WINDOWS_AMD64 = 233;
    private static final String WINDOWS_AMD64_COMMON_NAME = "NT_AMD64";
    private static final String WINDOWS_AMD64_DIRECTORY_NAME = "win64";
    private static final String WINDOWS_AMD64_OS_NAME = "Windows 64-bit";
    private static final String WINDOWS_AMD64_OS_ARCH = "amd64";
    private static final String WINDOWS_AMD64_OS_VER = "5.2";
    private static final String WINDOWS_2000_OS_NAME = "Windows 2000";
    private static final String WINDOWS_XP_64_OS_NAME = "Windows XP";
    private static final String WINDOWS_VISTA_OS_NAME = "Windows Vista";
    private static final String WINDOWS_XP_64_DATA_MODEL = "64";
    public static final int WINDOWS_95 = 615;
    private static final String WINDOWS_95_COMMON_NAME = "W95";
    private static final String WINDOWS_95_DIRECTORY_NAME = "win32";
    private static final String WINDOWS_95_OS_NAME = "Windows 95";
    private static final String WINDOWS_95_OS_ARCH = "x86";
    private static final String WINDOWS_95_OS_VER = "4.0";
    private static final String WINDOWS_ME_OS_NAME = "Windows Me";
    private static final String WINDOWS_2003_OS_NAME = "Windows 2003";
    private static final String WINDOWS_2003_SERVER_OS_NAME = "Windows Server 2003";
    public static final int WINDOWS_98 = 50;
    private static final String WINDOWS_98_COMMON_NAME = "W98";
    private static final String WINDOWS_98_DIRECTORY_NAME = "win32";
    private static final String WINDOWS_98_OS_NAME = "Windows 98";
    private static final String WINDOWS_98_OS_ARCH = "x86";
    private static final String WINDOWS_98_OS_VER = "4.1";
    public static final int LINUX = 46;
    private static final String LINUX_COMMON_NAME = "Linux";
    private static final String LINUX_DIRECTORY_NAME = "linux";
    private static final String LINUX_OS_NAME = "Linux";
    private static final String LINUX_OS_ARCH = "x86";
    private static final String LINUX_OS_ARCH64 = "amd64";
    private static final String LINUX_DIRECTORY_NAME_64 = "linux64";
    public static final int LINUX_AMD64 = 226;
    private static final String LINUX_AMD64_COMMON_NAME = "Linux_AMD64";
    private static final String LINUX_AMD64_DIRECTORY_NAME = "linux_x64";
    private static final String LINUX_AMD64_OS_NAME = "Linux";
    private static final String LINUX_AMD64_OS_ARCH = "amd64";
    public static final int LINUX_S390 = 211;
    private static final String LINUX_S390_COMMON_NAME = "Linux_S390";
    private static final String LINUX_S390_DIRECTORY_NAME = "linuxS390";
    private static final String LINUX_S390_OS_NAME = "Linux";
    private static final String LINUX_S390_OS_ARCH = "s390";
    public static final int LINUX_PPC = 227;
    private static final String LINUX_PPC_COMMON_NAME = "Linux_PPC";
    private static final String LINUX_PPC_DIRECTORY_NAME = "linuxppc64";
    private static final String LINUX_PPC_OS_NAME = "Linux";
    private static final String LINUX_PPC_OS_ARCH = "ppc";
    private static final String LINUX_PPC_OS_ARCH64 = "ppc64";
    public static final int LINUX_LOP = 249;
    private static final String LINUX_LOP_COMMON_NAME = "Linux_LOP";
    private static final String LINUX_LOP_DIRECTORY_NAME = "linux_ppc64";
    private static final String LINUX_LOP_OS_NAME = "Linux";
    private static final String LINUX_LOP_OS_ARCH = "ppc64";
    public static final int LINUX_SPARC64 = 525;
    private static final String LINUX_SPARC64_COMMON_NAME = "Linux_SPARC64";
    private static final String LINUX_SPARC64_DIRECTORY_NAME = "linuxS64";
    private static final String LINUX_SPARC64_OS_NAME = "Linux";
    private static final String LINUX_SPARC64_OS_ARCH = "sparcv9";
    public static final int HP_IA64 = 197;
    private static final String HP_IA64_COMMON_NAME = "HP_IA64";
    private static final String HP_IA64_DIRECTORY_NAME = "hpia64";
    private static final String HP_IA64_OS_NAME = "HP-UX";
    private static final String HP_IA64_OS_ARCH = "IA64W";
    private static final String HP_IA64_OS_ARCH_OLD = "IA64";
    private static final String HP_IA64_OS_ARCH64 = "IA64N";
    public static final int MACOSX = 421;
    private static final String MAC_COMMON_NAME = "MACOSX";
    private static final String MAC_DIRECTORY_NAME = "mac_osx";
    private static final String MAC_OS_NAME = "Mac OS X";
    private static final String MAC_OS_ARCH = "ppc";
    public static final int LINUX_IA64 = 110;
    private static final String LINUX_IA64_COMMON_NAME = "Linux_IA64";
    private static final String LINUX_IA64_DIRECTORY_NAME = "ia64";
    private static final String LINUX_IA64_OS_NAME = "Linux";
    private static final String LINUX_IA64_OS_ARCH = "ia64";
    public static final int LINUX_ITANIUM = 214;
    private static final String LINUX_ITANIUM_COMMON_NAME = "Linux_Itanium";
    private static final String LINUX_ITANIUM_DIRECTORY_NAME = "linux_ia64";
    private static final String LINUX_ITANIUM_OS_NAME = "Linux";
    private static final String LINUX_ITANIUM_OS_ARCH = "ia64";
    public static final int SOLARIS = 453;
    private static final String SOLARIS_COMMON_NAME = "Solaris";
    private static final String SOLARIS_DIRECTORY_NAME = "solaris";
    private static final String SOLARIS_OS_NAME = "Solaris";
    private static final String SUNOS_OS_NAME = "SunOS";
    private static final String SOLARIS_OS_ARCH = "sparc";
    private static final String SOLARIS_OS_ARCH64 = "sparcv9";
    public static final int SOLARIS_SPARC64 = 23;
    private static final String SOLARIS_SPARC64_COMMON_NAME = "Solaris_SPARC64";
    private static final String SOLARIS_SPARC64_DIRECTORY_NAME = "solaris_sparc64";
    private static final String SOLARIS_SPARC64_OS_NAME = "Solaris";
    private static final String SUNOS_SPARC64_OS_NAME = "SunOS";
    private static final String SOLARIS_SPARC64_OS_ARCH = "sparcv9";
    public static final int DEC_ALPHA_NT = 601;
    private static final String DEC_ALPHA_NT_COMMON_NAME = "NT_Alpha";
    private static final String DEC_ALPHA_NT_DIRECTORY_NAME = "win32_alpha";
    private static final String DEC_ALPHA_NT_OS_NAME = "Windows NT";
    private static final String DEC_ALPHA_NT_OS_ARCH = "Alpha";
    public static final int SOLARIS_INTEL = 173;
    private static final String SOLARIS_INTEL_COMMON_NAME = "Intel_Solaris";
    private static final String SOLARIS_INTEL_DIRECTORY_NAME = "intelsolaris";
    private static final String SOLARIS_INTEL_OS_NAME = "Solaris";
    private static final String SOLARIS_INTEL_OS_ARCH = "x86";
    private static final String SOLARIS_INTEL_OS_ARCH64 = "amd64";
    public static final int SIEMENS_NIXDORF = 467;
    private static final String SIEMENS_NIXDORF_COMMON_NAME = "SINIX_Y";
    private static final String SIEMENS_NIXDORF_DIRECTORY_NAME = "SINIX_Y";
    private static final String SIEMENS_NIXDORF_OS_NAME = "SINIX-Y";
    private static final String SIEMENS_NIXDORF_OS_ARCH = "mips";
    public static final int SIEMENS_PYRAMID = 295;
    private static final String SIEMENS_PYRAMID_COMMON_NAME = "ReliantUNIX_M";
    private static final String SIEMENS_PYRAMID_DIRECTORY_NAME = "ReliantUNIX_M";
    private static final String SIEMENS_PYRAMID_OS_NAME = "ReliantUNIX-M";
    private static final String SIEMENS_PYRAMID_OS_ARCH = "mips";
    public static final int DIGITAL_UNIX = 87;
    private static final String DIGITAL_UNIX_COMMON_NAME = "UNIX_Alpha";
    private static final String DIGITAL_UNIX_DIRECTORY_NAME = "decunix";
    private static final String DIGITAL_UNIX_OS_NAME = "OSF1";
    private static final String DIGITAL_UNIX_OS_ARCH = "alpha";
    public static final int AIX = 610;
    private static final String AIX_COMMON_NAME = "IBM_AIX";
    private static final String AIX_DIRECTORY_NAME = "aix";
    private static final String AIX_OS_NAME = "AIX";
    public static final int AIX_PPC64 = 212;
    private static final String AIX_PPC64_COMMON_NAME = "IBM_AIXPPC64";
    private static final String AIX_PPC64_DIRECTORY_NAME = "aix_ppc64";
    private static final String AIX_PPC64_OS_NAME = "AIX";
    public static final int SEQUENT = 198;
    private static final String SEQUENT_COMMON_NAME = "Dynix";
    private static final String SEQUENT_DIRECTORY_NAME = "sequent";
    private static final String SEQUENT_OS_NAME = "DYNIX/ptx";
    private static final String SEQUENT_OS_ARCH = "x86";
    public static final int UNIXWARE = 918;
    private static final String UNIXWARE_COMMON_NAME = "UnixWare";
    private static final String UNIXWARE_DIRECTORY_NAME = "unixware";
    private static final String UNIXWARE_OS_NAME = "UnixWare";
    private static final String UNIXWARE_OS_ARCH = "IA32";
    public static final int DEC_ALPHA_VMS = 913;
    private static final String DEC_ALPHA_VMS_COMMON_NAME = "OpenVMS";
    private static final String DEC_ALPHA_VMS_DIRECTORY_NAME = "openVMS";
    private static final String DEC_ALPHA_VMS_OS_NAME = "OpenVMS";
    private static final String DEC_ALPHA_VMS_OS_ARCH = "alpha";
    public static final int DATA_GENERAL = 162;
    private static final String DATA_GENERAL_COMMON_NAME = "DG_UX";
    private static final String DATA_GENERAL_DIRECTORY_NAME = "DG_UX";
    private static final String DATA_GENERAL_OS_NAME = "DG/UX";
    private static final String DATA_GENERAL_OS_ARCH = "Pentium";
    public static final int HP_UX = 2;
    private static final String HP_UX_COMMON_NAME = "HP_UX";
    private static final String HP_UX_DIRECTORY_NAME = "hpunix";
    private static final String HP_UX_OS_NAME = "HP-UX";
    private static final String HP_UX_OS_ARCH = "PA_RISC2.0";
    private static final String HP_UX_OS_ARCH_OLD = "PA_RISC";
    private static final String HP_UX_OS_ARCH_64 = "PA_RISC2.0W";
    public static final int HP_UX64 = 59;
    private static final String HP_UX64_COMMON_NAME = "HP_UX64";
    private static final String HP_UX64_DIRECTORY_NAME = "hpunix_parisc64";
    private static final String HP_UX64_OS_NAME = "HP-UX";
    private static final String HP_UX64_OS_ARCH = "PA_RISC2.0";
    private static final String HP_UX64_OS_ARCH_OLD = "PA_RISC";
    public static final int OS_390 = 30;
    public static final int Z_OS = 30;
    private static final String Z_OS_COMMON_NAME = "IBM_MVS";
    private static final String Z_OS_DIRECTORY_NAME = "IBM_MVS";
    private static final String Z_OS_OS_NAME = "z/OS";
    private static final String Z_OS_OS_ARCH = "390";
    private static final String OS_390_OS_NAME = "OS/390";
    public static final int NETWARE_411 = 21;
    private static final String NETWARE_411_COMMON_NAME = "NetWare_411";
    private static final String NETWARE_411_DIRECTORY_NAME = "NetWare_411";
    private static final String NETWARE_411_OS_NAME = "NetWare 4.11";
    private static final String NETWARE_411_OS_ARCH = "x86";
    public static final int NETWARE_500 = 10021;
    private static final String NETWARE_500_COMMON_NAME = "NetWare_500";
    private static final String NETWARE_500_DIRECTORY_NAME = "NetWare_500";
    private static final String NETWARE_500_OS_NAME = "NetWare 5.00";
    private static final String NETWARE_500_OS_ARCH = "x86";
    public static final int NEC_UX_4800 = 111;
    private static final String NEC_UX_4800_COMMON_NAME = "NEC";
    private static final String NEC_UX_4800_DIRECTORY_NAME = "nec";
    private static final String NEC_UX_4800_OS_NAME = "UX/4800";
    public static final int HITACHI = 90;
    private static final String HITACHI_COMMON_NAME = "Hitachi_UX";
    private static final String HITACHI_DIRECTORY_NAME = "Hitachi_UX";
    private static final String HITACHI_OS_NAME = "HI-UX/WE2";
    private static final String HITACHI_OS_ARCH = "pa-risc";
    public static final int SGI = 168;
    private static final String SGI_COMMON_NAME = "Iris";
    private static final String SGI_DIRECTORY_NAME = "Iris";
    private static final String SGI_OS_NAME = "Irix";
    private static final String SGI_OS_ARCH = "mips";
    public static final int NCOS = 888;
    private static final String NCOS_COMMON_NAME = "NCOS";
    private static final String NCOS_DIRECTORY_NAME = "NCOS";
    private static final String NCOS_OS_NAME = "NCOS";
    private static final String NCOS_OS_ARCH = "i386";
    public static final int UNKNOWN = 0;
    public static final int WORDTYPE_NA = 0;
    public static final int WORDTYPE_32 = 1;
    public static final int WORDTYPE_64 = 2;
    public static final int MISCINFO_NA = 0;
    public static final int MISCINFO_SECURE = 1;
    public static final int MISCINFO_XXX = 2;
    private static Vector m_oSupportedPlatformsInfo;
    private static int[] m_oSupportedPlatforms;
    private static int PLATFORM_COUNT;
    private static String s_forcedPlat;
    private static String s_forcedPlatID;
    private static String s_osname;
    private static String s_osarch;
    private static String s_osver;
    private static String s_osdatamodel;
    private static Vector m_currentPlatformVector;
    private static Integer m_currentPlatInteger;
    public static final int UNIX = -1;
    private static final String UNIX_COMMON_NAME = "UNIX";
    public static final int DESKTOP = -2;
    private static final String DESKTOP_COMMON_NAME = "Desktop";
    public static final int MS_PLATS = -3;
    private static final String MS_PLATS_COMMON_NAME = "WINDOWS";
    public static final int ALL_PLATFORMS = -10;
    private static final String ALL_PLATFORMS_COMMON_NAME = "ALL";
    private static Vector m_oSupportedPlatGroupsInfo;
    private static int[] m_oSupportedPlatGroups;
    private static int PLATGROUP_COUNT;
    private static int[] m_oTopLevelPlatGroups;
    private static OiixPlatformInfo s_curPlatformInfo;

    static OiixPlatformGroupInfo getPlatGroupInfo(int groupID) {
        OiixPlatformGroupInfo retPgi = null;
        for (int i = 0; i < PLATGROUP_COUNT; ++i) {
            OiixPlatformGroupInfo pgi = (OiixPlatformGroupInfo)m_oSupportedPlatGroupsInfo.elementAt(i);
            if (pgi.getGroupID() != groupID) continue;
            return pgi;
        }
        return retPgi;
    }

    static OiixPlatformGroupInfo getPlatGroupInfo(String commonName) {
        OiixPlatformGroupInfo retPgi = null;
        for (int i = 0; i < PLATGROUP_COUNT; ++i) {
            OiixPlatformGroupInfo pgi = (OiixPlatformGroupInfo)m_oSupportedPlatGroupsInfo.elementAt(i);
            if (!pgi.getCommonName().equalsIgnoreCase(commonName)) continue;
            return pgi;
        }
        return retPgi;
    }

    private static OiixPlatformInfo getPlatformInfo(int platID) {
        OiixPlatformInfo retPi = null;
        int nSize = m_oSupportedPlatformsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiixPlatformInfo pi = (OiixPlatformInfo)m_oSupportedPlatformsInfo.elementAt(i);
            if (pi.getPlatID() != platID) continue;
            return pi;
        }
        return retPi;
    }

    private static OiixPlatformInfo getPlatformInfo(String commonName) {
        OiixPlatformInfo retPi = null;
        int nSize = m_oSupportedPlatformsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiixPlatformInfo pi = (OiixPlatformInfo)m_oSupportedPlatformsInfo.elementAt(i);
            if (!pi.getCommonName().equalsIgnoreCase(commonName) && !pi.getOSName().equalsIgnoreCase(commonName)) continue;
            return pi;
        }
        return retPi;
    }

    public static String getPlatformName(int ID) {
        return OiixPlatform.getPlatformDisplayName(ID);
    }

    public static String getPlatformDisplayName(int ID) {
        try {
            OiixPlatform.validatePlatform(ID);
            String s = "S_PLATFORM_" + String.valueOf(ID);
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPlatformCommonName(int platID) {
        String retName = null;
        OiixPlatformInfo pi = OiixPlatform.getPlatformInfo(platID);
        if (pi != null) {
            retName = pi.getCommonName();
        }
        return retName;
    }

    public static String getPlatformDirectoryName(int platID) {
        String retName = null;
        OiixPlatformInfo pi = OiixPlatform.getPlatformInfo(platID);
        if (pi != null) {
            retName = pi.getDirectoryName();
        }
        return retName;
    }

    public static String getPlatformOSName(int platID) {
        String retName = null;
        OiixPlatformInfo pi = OiixPlatform.getPlatformInfo(platID);
        if (pi != null) {
            retName = pi.getOSName();
        }
        return retName;
    }

    public static int getPlatformID(String sPlatform) {
        return OiixPlatform.getPlatformIDFromDisplayName(sPlatform);
    }

    public static int getPlatformIDFromDisplayName(String dispName) {
        int retID = 0;
        for (int i = 0; i < PLATFORM_COUNT; ++i) {
            String s = "S_PLATFORM_" + String.valueOf(m_oSupportedPlatforms[i]);
            String oPlatform = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", s);
            if (!oPlatform.equalsIgnoreCase(dispName)) continue;
            return m_oSupportedPlatforms[i];
        }
        return retID;
    }

    public static int getPlatformIDFromCommonName(String commonName) {
        int retID = 0;
        Object retPi = null;
        String s = commonName.equalsIgnoreCase("Windows NT") ? WINDOWS_NT_COMMON_NAME : (commonName.equalsIgnoreCase(WINDOWS_95_OS_NAME) || commonName.equalsIgnoreCase(WINDOWS_ME_OS_NAME) ? WINDOWS_95_COMMON_NAME : (commonName.equalsIgnoreCase(WINDOWS_95_OS_NAME) ? WINDOWS_98_COMMON_NAME : (commonName.equalsIgnoreCase("Solaris") ? "Solaris" : commonName)));
        int nSize = m_oSupportedPlatformsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiixPlatformInfo pi = (OiixPlatformInfo)m_oSupportedPlatformsInfo.elementAt(i);
            if (!pi.getCommonName().equalsIgnoreCase(s)) continue;
            retID = pi.getPlatID();
            break;
        }
        return retID;
    }

    public static int getPlatformIDFromDirectoryName(String directoryName) {
        int retID = 0;
        Object retPi = null;
        int nSize = m_oSupportedPlatformsInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiixPlatformInfo pi = (OiixPlatformInfo)m_oSupportedPlatformsInfo.elementAt(i);
            if (!pi.getDirectoryName().equalsIgnoreCase(directoryName)) continue;
            retID = pi.getPlatID();
            break;
        }
        return retID;
    }

    public static String getPlatGroupCommonName(int groupID) {
        String retName = null;
        OiixPlatformGroupInfo pgi = OiixPlatform.getPlatGroupInfo(groupID);
        if (pgi != null) {
            retName = pgi.getCommonName();
        }
        return retName;
    }

    public static int getPlatGroupIDFromCommonName(String commonName) {
        int retID = 0;
        Object retPgi = null;
        for (int i = 0; i < PLATGROUP_COUNT; ++i) {
            OiixPlatformGroupInfo pgi = (OiixPlatformGroupInfo)m_oSupportedPlatGroupsInfo.elementAt(i);
            if (!pgi.getCommonName().equalsIgnoreCase(commonName)) continue;
            retID = pgi.getGroupID();
            break;
        }
        return retID;
    }

    public static int getPlatOrGroupIDFromCommonName(String commonName) {
        int retID = OiixPlatform.getPlatformIDFromCommonName(commonName);
        if (retID == 0) {
            retID = OiixPlatform.getPlatGroupIDFromCommonName(commonName);
        }
        return retID;
    }

    public static boolean isPlatInGroup(int groupID, int platID) {
        boolean retVal = false;
        OiixPlatformGroupInfo pgi = OiixPlatform.getPlatGroupInfo(groupID);
        if (pgi != null) {
            retVal = pgi.containsPlat(platID);
        }
        return retVal;
    }

    public static Vector getPlatsInGroup(int groupID) {
        Vector retVect = new Vector();
        OiixPlatformGroupInfo pgi = OiixPlatform.getPlatGroupInfo(groupID);
        if (pgi != null) {
            retVect = pgi.containedPlats();
        }
        return retVect;
    }

    public static Vector getPlatGroupsInGroup(int groupID) {
        Vector retVect = new Vector();
        OiixPlatformGroupInfo pgi = OiixPlatform.getPlatGroupInfo(groupID);
        if (pgi != null) {
            retVect = pgi.containedPlatGroups();
        }
        return retVect;
    }

    public static Vector getAllPlatsInGroup(int groupID) {
        Vector retVect = new Vector();
        OiixPlatformGroupInfo pgi = OiixPlatform.getPlatGroupInfo(groupID);
        if (pgi != null) {
            retVect = pgi.allContainedPlats();
        }
        return retVect;
    }

    public static String getPlatGroupDisplayName(int groupID) {
        int absGID = -1 * groupID;
        if (absGID <= PLATGROUP_COUNT) {
            String s = "S_PLATGROUP_" + String.valueOf(absGID);
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", s);
        }
        return null;
    }

    public static int getPlatGroup(int platId) {
        int retId = 0;
        if (OiixPlatform.isPlatInGroup(-1, platId)) {
            retId = -1;
        } else if (OiixPlatform.isPlatInGroup(-3, platId)) {
            retId = -3;
        } else if (OiixPlatform.isPlatInGroup(-2, platId)) {
            retId = -2;
        }
        return retId;
    }

    public static void validatePlatform(int nID) throws OiixEnumException {
        for (int i = 0; i < m_oSupportedPlatforms.length; ++i) {
            if (nID != m_oSupportedPlatforms[i]) continue;
            return;
        }
        throw new OiixEnumException("S_PLATFORM_RANGE");
    }

    public static int[] getPlatforms() {
        return m_oSupportedPlatforms;
    }

    public static Vector getPlatformsAsVect() {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < m_oSupportedPlatforms.length; ++i) {
            v.addElement(new Integer(m_oSupportedPlatforms[i]));
        }
        return v;
    }

    public static int[] getPlatGroups() {
        return m_oSupportedPlatGroups;
    }

    public static int[] getTLPlatGroups() {
        return m_oTopLevelPlatGroups;
    }

    public static int getCurrentPlatform() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo == null) {
            return 0;
        }
        return s_curPlatformInfo.getPlatID();
    }

    public static String getCurrentPlatformArch() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo == null) {
            return null;
        }
        return s_curPlatformInfo.getOSArch();
    }

    public static Vector getCurrentPlatformVector() {
        if (m_currentPlatformVector == null) {
            m_currentPlatformVector = new Vector(1, 1);
            m_currentPlatformVector.addElement(new Integer(OiixPlatform.getCurrentPlatform()));
        }
        return m_currentPlatformVector;
    }

    public static Vector getOptimizedPlatformVector(Vector vPlats) {
        int currentPlatId = OiixPlatform.getCurrentPlatform();
        Vector v = vPlats;
        if (vPlats.indexOf(new Integer(currentPlatId)) != -1) {
            v = OiixPlatform.getCurrentPlatformVector();
        }
        return v;
    }

    public static String getCurrentPlatformCommonName() {
        return OiixPlatform.getCurrentPlatformOSName();
    }

    public static String getCurrentPlatformCommonNameEx() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo == null) {
            return null;
        }
        return s_curPlatformInfo.getCommonName();
    }

    public static String getCurrentPlatformDirectoryName() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo == null) {
            return null;
        }
        if (s_curPlatformInfo.getPlatID() == 46 && s_curPlatformInfo.getOSArch().equals("amd64")) {
            return LINUX_DIRECTORY_NAME_64;
        }
        return s_curPlatformInfo.getDirectoryName();
    }

    public static String getCurrentPlatformOSVer() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo == null) {
            return null;
        }
        return s_curPlatformInfo.getOSVer();
    }

    public static String getCurrentPlatformOSName() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo == null) {
            return null;
        }
        return s_curPlatformInfo.getOSName();
    }

    public static void setSysProps(String forcedPlat, String osname, String osarch, String osver) {
        s_forcedPlat = forcedPlat;
        s_osname = osname;
        s_osarch = osarch;
        s_osver = osver;
    }

    private static void checkSysProps() {
        if (s_forcedPlat == null) {
            s_forcedPlat = System.getProperty("oracle.installer.platform", null);
        }
        if (s_forcedPlatID == null) {
            s_forcedPlatID = System.getProperty("oracle.installer.platformID", null);
        }
        if (s_osname == null) {
            s_osname = System.getProperty("os.name", "");
        }
        if (s_osarch == null) {
            s_osarch = System.getProperty("os.arch", "");
        }
        if (s_osver == null) {
            s_osver = System.getProperty("os.version", "");
        }
        if (s_osdatamodel == null && (s_osdatamodel = System.getProperty("sun.arch.data.model", "")) == "" && s_osname.equals(WINDOWS_2003_SERVER_OS_NAME) && s_osarch.equals("ia64")) {
            s_osdatamodel = WINDOWS_XP_64_DATA_MODEL;
        }
    }

    public static void optimize() {
        if (s_curPlatformInfo == null) {
            s_curPlatformInfo = OiixPlatform.computeCurPlatformInfo();
        }
        if (s_curPlatformInfo != null) {
            m_oSupportedPlatformsInfo = new Vector(1);
            m_oSupportedPlatformsInfo.addElement(s_curPlatformInfo);
        }
    }

    private static OiixPlatformInfo computeCurPlatformInfo() {
        Integer forcedPlatID;
        OiixPlatformInfo retInfo = null;
        OiixPlatform.checkSysProps();
        String forcedPlat = s_forcedPlat;
        String osname = s_osname;
        String osarch = s_osarch;
        String osver = s_osver;
        String osdatamodel = s_osdatamodel;
        if (s_forcedPlatID != null && s_forcedPlatID != "" && (forcedPlatID = new Integer(s_forcedPlatID)) != null && (retInfo = OiixPlatform.getPlatformInfo(forcedPlatID)) != null) {
            return retInfo;
        }
        retInfo = OiixPlatform.getPlatformInfo(forcedPlat);
        if (retInfo == null) {
            int platID = 0;
            if (osname.equals(WINDOWS_95_OS_NAME) || osname.equals(WINDOWS_ME_OS_NAME)) {
                platID = 615;
            } else if (osname.equals(WINDOWS_98_OS_NAME)) {
                platID = 50;
            } else if (osname.equals(WINDOWS_XP_64_OS_NAME)) {
                if (osdatamodel.equals(WINDOWS_XP_64_DATA_MODEL)) {
                    if (osarch.equals("ia64")) {
                        platID = 208;
                    } else if (osarch.equals("amd64")) {
                        platID = 233;
                    }
                } else {
                    platID = osarch.equals("x86") ? 912 : 208;
                }
            } else if (osname.equals("Windows NT") || osname.equals(WINDOWS_2000_OS_NAME) || osname.equals(WINDOWS_2003_OS_NAME) || osname.equals(WINDOWS_2003_SERVER_OS_NAME) || osname.startsWith(WINDOWS_VISTA_OS_NAME) || osname.startsWith("Windows NT") || osname.startsWith(WINDOWS_GENERIC_OS_NAME)) {
                if (osarch.equals("x86")) {
                    platID = 912;
                } else if (osarch.equals(DEC_ALPHA_NT_OS_ARCH)) {
                    platID = 601;
                } else if (osarch.equals("ia64")) {
                    platID = 208;
                } else if (osarch.equals("amd64")) {
                    platID = 233;
                }
            } else {
                if (osname.equals(MAC_OS_NAME)) {
                    platID = 421;
                }
                if (osname.equals("Solaris") || osname.equals("SunOS")) {
                    if (osarch.equals(SOLARIS_OS_ARCH) || osarch.equals("sparcv9")) {
                        platID = 453;
                        if (osname.equals("Solaris")) {
                            osver = OiixPlatform.getCorrectedVersion(osname);
                        }
                    } else if (osarch.equals("x86") || osarch.equals("amd64")) {
                        platID = 173;
                    }
                } else if (osname.equals(SIEMENS_NIXDORF_OS_NAME)) {
                    platID = 467;
                } else if (osname.equals(SIEMENS_PYRAMID_OS_NAME)) {
                    platID = 295;
                } else if (osname.equals(DIGITAL_UNIX_OS_NAME)) {
                    platID = 87;
                } else if (osname.equals("AIX")) {
                    platID = 610;
                } else if (osname.equals(SEQUENT_OS_NAME)) {
                    platID = 198;
                } else if (osname.equals("UnixWare")) {
                    platID = 918;
                } else if (osname.equals("OpenVMS")) {
                    platID = 913;
                } else if (osname.equals(DATA_GENERAL_OS_NAME)) {
                    platID = 162;
                } else if (osname.equals("HP-UX")) {
                    if (osarch.equals("PA_RISC2.0") || osarch.equals("PA_RISC") || osarch.equals(HP_UX_OS_ARCH_64)) {
                        platID = 2;
                    }
                    if (osarch.equals(HP_IA64_OS_ARCH) || osarch.equals(HP_IA64_OS_ARCH_OLD) || osarch.equals(HP_IA64_OS_ARCH64)) {
                        platID = 197;
                    }
                } else if (osname.equals(Z_OS_OS_NAME) || osname.equals(OS_390_OS_NAME)) {
                    platID = 30;
                } else if (osname.equals(NETWARE_411_OS_NAME)) {
                    platID = 21;
                } else if (osname.equals(NETWARE_500_OS_NAME)) {
                    platID = 10021;
                } else if (osname.equals(NEC_UX_4800_OS_NAME)) {
                    platID = 111;
                } else if (osname.equals(HITACHI_OS_NAME)) {
                    platID = 90;
                } else if (osname.equals(SGI_OS_NAME)) {
                    platID = 168;
                } else if (osname.equals("NCOS")) {
                    platID = 888;
                } else if (osname.equals("Linux")) {
                    if (osarch.equals("x86") || osarch.endsWith("86") || osarch.equals("amd64")) {
                        platID = 46;
                    }
                    if (osarch.startsWith(LINUX_S390_OS_ARCH)) {
                        platID = 211;
                    }
                    if (osarch.equals("ia64")) {
                        platID = 110;
                    }
                    if (osarch.equals("ppc") || osarch.equals("ppc64")) {
                        platID = 227;
                    }
                    if (osarch.equals("sparcv9")) {
                        platID = 525;
                    }
                }
            }
            retInfo = OiixPlatform.getPlatformInfo(platID);
            if (retInfo != null) {
                retInfo = (OiixPlatformInfo)retInfo.clone();
                retInfo.setOSArch(osarch);
                retInfo.setOSVer(osver);
                retInfo.setOSName(osname);
            }
        }
        return retInfo;
    }

    private static String getCorrectedVersion(String osname) {
        String osver = s_osver;
        if (osname.equals("Solaris") && (osver = System.getProperty("oracle.installer.unixVersion")) != null) {
            int i = osver.indexOf(46);
            String osMajorVer = osver.substring(0, i);
            String osMinVer = osver.substring(i);
            int iMajorVersion = 0;
            int iCorrectedMajorVersion = 0;
            try {
                iMajorVersion = Integer.valueOf(osMajorVer);
                iCorrectedMajorVersion = iMajorVersion > 3 ? iMajorVersion - 3 : iMajorVersion;
                osver = "" + iCorrectedMajorVersion + osMinVer;
            }
            catch (NumberFormatException e) {
                System.err.println("Cannot correct " + osver);
            }
        }
        return osver;
    }

    public static boolean platInVector(Vector platOrGroupIDs, int platID) {
        int numConts = platOrGroupIDs.size();
        for (int i = 0; i < numConts; ++i) {
            OiixPlatformGroupInfo pgi;
            int conti = (Integer)platOrGroupIDs.elementAt(i);
            if (conti == platID) {
                return true;
            }
            if (conti >= 0 || (pgi = OiixPlatform.getPlatGroupInfo(conti)) == null || !pgi.containsPlat(platID)) continue;
            return true;
        }
        return false;
    }

    public static String[] platIDsToCommonNameArray(Vector plats) {
        if (plats == null) {
            return null;
        }
        int numPlats = plats != null ? plats.size() : 0;
        String[] sArr = new String[numPlats];
        for (int i = 0; i < numPlats; ++i) {
            int platId = (Integer)plats.elementAt(i);
            sArr[i] = OiixPlatform.getPlatformCommonName(platId);
        }
        return sArr;
    }

    public static Vector platCommonNamesToIDVect(String[] commonNames) {
        if (commonNames == null) {
            return null;
        }
        int numPlats = commonNames != null ? commonNames.length : 0;
        Vector<Integer> platIds = new Vector<Integer>();
        for (int i = 0; i < numPlats; ++i) {
            int platId = OiixPlatform.getPlatformIDFromCommonName(commonNames[i]);
            platIds.addElement(new Integer(platId));
        }
        return platIds;
    }

    static {
        int i;
        s_forcedPlat = null;
        s_forcedPlatID = null;
        s_osname = null;
        s_osarch = null;
        s_osver = null;
        s_osdatamodel = null;
        m_currentPlatformVector = null;
        m_oSupportedPlatformsInfo = new Vector(25, 5);
        OiixPlatformInfo pi = new OiixPlatformInfo(912, WINDOWS_NT_COMMON_NAME, "win32", "Windows NT", "x86", "4.0", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(208, WINDOWS_64_COMMON_NAME, "win64", "Windows 64-bit", "ia64", WINDOWS_64_OS_VER, 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(233, WINDOWS_AMD64_COMMON_NAME, "win64", "Windows 64-bit", "amd64", WINDOWS_AMD64_OS_VER, 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(615, WINDOWS_95_COMMON_NAME, "win32", WINDOWS_95_OS_NAME, "x86", "4.0", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(50, WINDOWS_98_COMMON_NAME, "win32", WINDOWS_98_OS_NAME, "x86", WINDOWS_98_OS_VER, 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(453, "Solaris", SOLARIS_DIRECTORY_NAME, "Solaris", SOLARIS_OS_ARCH, "2.x", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(23, SOLARIS_SPARC64_COMMON_NAME, SOLARIS_SPARC64_DIRECTORY_NAME, "Solaris", "sparcv9", "2.x", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(601, DEC_ALPHA_NT_COMMON_NAME, DEC_ALPHA_NT_DIRECTORY_NAME, "Windows NT", DEC_ALPHA_NT_OS_ARCH, "4.0", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(173, SOLARIS_INTEL_COMMON_NAME, SOLARIS_INTEL_DIRECTORY_NAME, "Solaris", "x86", "2.x", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(467, "SINIX_Y", "SINIX_Y", SIEMENS_NIXDORF_OS_NAME, "mips", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(295, "ReliantUNIX_M", "ReliantUNIX_M", SIEMENS_PYRAMID_OS_NAME, "mips", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(87, DIGITAL_UNIX_COMMON_NAME, DIGITAL_UNIX_DIRECTORY_NAME, DIGITAL_UNIX_OS_NAME, "alpha", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(610, AIX_COMMON_NAME, AIX_DIRECTORY_NAME, "AIX", "", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(212, AIX_PPC64_COMMON_NAME, AIX_PPC64_DIRECTORY_NAME, "AIX", "", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(198, SEQUENT_COMMON_NAME, SEQUENT_DIRECTORY_NAME, SEQUENT_OS_NAME, "x86", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(918, "UnixWare", UNIXWARE_DIRECTORY_NAME, "UnixWare", UNIXWARE_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(913, "OpenVMS", DEC_ALPHA_VMS_DIRECTORY_NAME, "OpenVMS", "alpha", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(162, "DG_UX", "DG_UX", DATA_GENERAL_OS_NAME, DATA_GENERAL_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(2, HP_UX_COMMON_NAME, HP_UX_DIRECTORY_NAME, "HP-UX", HP_UX_OS_ARCH_64, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(59, HP_UX64_COMMON_NAME, HP_UX64_DIRECTORY_NAME, "HP-UX", "PA_RISC2.0", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(46, "Linux", LINUX_DIRECTORY_NAME, "Linux", "x86", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(226, LINUX_AMD64_COMMON_NAME, LINUX_AMD64_DIRECTORY_NAME, "Linux", "amd64", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(211, LINUX_S390_COMMON_NAME, LINUX_S390_DIRECTORY_NAME, "Linux", LINUX_S390_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(227, LINUX_PPC_COMMON_NAME, LINUX_PPC_DIRECTORY_NAME, "Linux", "ppc", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(249, LINUX_LOP_COMMON_NAME, LINUX_LOP_DIRECTORY_NAME, "Linux", "ppc64", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(197, HP_IA64_COMMON_NAME, HP_IA64_DIRECTORY_NAME, "HP-UX", HP_IA64_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(421, MAC_COMMON_NAME, MAC_DIRECTORY_NAME, MAC_OS_NAME, "ppc", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(110, LINUX_IA64_COMMON_NAME, "ia64", "Linux", "ia64", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(214, LINUX_ITANIUM_COMMON_NAME, LINUX_ITANIUM_DIRECTORY_NAME, "Linux", "ia64", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(30, "IBM_MVS", "IBM_MVS", Z_OS_OS_NAME, Z_OS_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(21, "NetWare_411", "NetWare_411", NETWARE_411_OS_NAME, "x86", "4.11", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(10021, "NetWare_500", "NetWare_500", NETWARE_500_OS_NAME, "x86", "5.00", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(111, NEC_UX_4800_COMMON_NAME, NEC_UX_4800_DIRECTORY_NAME, NEC_UX_4800_OS_NAME, "", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(90, "Hitachi_UX", "Hitachi_UX", HITACHI_OS_NAME, HITACHI_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(168, "Iris", "Iris", SGI_OS_NAME, "mips", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(888, "NCOS", "NCOS", "NCOS", NCOS_OS_ARCH, "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        pi = new OiixPlatformInfo(525, LINUX_SPARC64_COMMON_NAME, LINUX_SPARC64_DIRECTORY_NAME, "Linux", "sparcv9", "", 0, 0);
        m_oSupportedPlatformsInfo.addElement(pi);
        PLATFORM_COUNT = m_oSupportedPlatformsInfo.size();
        m_oSupportedPlatforms = new int[PLATFORM_COUNT];
        for (i = 0; i < PLATFORM_COUNT; ++i) {
            pi = (OiixPlatformInfo)m_oSupportedPlatformsInfo.elementAt(i);
            OiixPlatform.m_oSupportedPlatforms[i] = pi.getPlatID();
        }
        m_oTopLevelPlatGroups = new int[]{-1, -2};
        m_oSupportedPlatGroupsInfo = new Vector(5, 5);
        OiixPlatformGroupInfo pgi = new OiixPlatformGroupInfo(-1, UNIX_COMMON_NAME);
        pgi.addElement(453);
        pgi.addElement(23);
        pgi.addElement(173);
        pgi.addElement(467);
        pgi.addElement(295);
        pgi.addElement(87);
        pgi.addElement(610);
        pgi.addElement(212);
        pgi.addElement(198);
        pgi.addElement(918);
        pgi.addElement(162);
        pgi.addElement(2);
        pgi.addElement(59);
        pgi.addElement(111);
        pgi.addElement(90);
        pgi.addElement(168);
        pgi.addElement(888);
        pgi.addElement(913);
        pgi.addElement(30);
        pgi.addElement(46);
        pgi.addElement(226);
        pgi.addElement(211);
        pgi.addElement(197);
        pgi.addElement(421);
        pgi.addElement(110);
        pgi.addElement(214);
        pgi.addElement(227);
        pgi.addElement(249);
        pgi.addElement(525);
        m_oSupportedPlatGroupsInfo.addElement(pgi);
        pgi = new OiixPlatformGroupInfo(-3, MS_PLATS_COMMON_NAME);
        pgi.addElement(912);
        pgi.addElement(208);
        pgi.addElement(233);
        pgi.addElement(615);
        pgi.addElement(50);
        pgi.addElement(601);
        m_oSupportedPlatGroupsInfo.addElement(pgi);
        pgi = new OiixPlatformGroupInfo(-2, DESKTOP_COMMON_NAME);
        pgi.addElement(-3);
        pgi.addElement(21);
        pgi.addElement(10021);
        m_oSupportedPlatGroupsInfo.addElement(pgi);
        pgi = new OiixPlatformGroupInfo(-10, ALL_PLATFORMS_COMMON_NAME);
        pgi.addElement(-1);
        pgi.addElement(-2);
        m_oSupportedPlatGroupsInfo.addElement(pgi);
        PLATGROUP_COUNT = m_oSupportedPlatGroupsInfo.size();
        m_oSupportedPlatGroups = new int[PLATGROUP_COUNT];
        for (i = 0; i < PLATGROUP_COUNT; ++i) {
            pgi = (OiixPlatformGroupInfo)m_oSupportedPlatGroupsInfo.elementAt(i);
            OiixPlatform.m_oSupportedPlatGroups[i] = pgi.getGroupID();
        }
        s_curPlatformInfo = null;
    }
}

