/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStageSession;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixLanguage;

public class OiixOuiOpatchIntegration {
    private OiiiInstallAreaControl iac = null;
    private OiiiInstallInventory inventory = null;
    private OiicStandardInventorySession oSession = null;
    private int homeIndex;
    private String homeLoc;

    public OiixOuiOpatchIntegration(String homeLoc) {
        this.homeLoc = homeLoc;
        this.oSession = new OiicStandardInventorySession("patcher", "1");
        try {
            this.oSession.initSession(0);
            this.iac = this.oSession.getInstallAreaControl();
            this.inventory = this.iac.getInstallInventory();
            OiiiOracleHomeInfo homeInfo = this.inventory.getHomeWithLocation(homeLoc);
            this.homeIndex = homeInfo.getIndex();
        }
        catch (OiitTargetLockNotAvailableException ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
        catch (IOException ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
        catch (OiiiInventoryDoesNotExistException ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
        catch (Exception ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
    }

    public void addOneoffEntries(int patchNumber, int compIndex) {
        try {
            OiiiCompInvEntry compInvEntry;
            OiiiCompInstallID compInstallId;
            if (this.homeIndex <= 0 || compIndex <= 0) {
                return;
            }
            Vector vComponents = this.inventory.getAllCompsVect(this.homeIndex);
            int componentsSize = vComponents.size();
            if (vComponents != null && componentsSize > 0 && compIndex < componentsSize && (compInstallId = (compInvEntry = (OiiiCompInvEntry)vComponents.get(compIndex)).getCompInstallID()) != null) {
                OiiiCompIdOhPair compIdOhPair = new OiiiCompIdOhPair(compInstallId, this.homeIndex);
                Vector offSets = new Vector();
                Vector<Locale> langs = new Vector<Locale>();
                langs.addElement(OiixLanguage.ENGLISH);
                Vector prereqs = new Vector();
                for (int i = 0; i < patchNumber; ++i) {
                    Vector<String> bugFixes = new Vector<String>();
                    bugFixes.add(Integer.toString(i));
                    Vector<String> filesToPatch = new Vector<String>();
                    filesToPatch.add("file" + Integer.toString(i));
                    OiiiInstallOneoffInvEntry offEntry = new OiiiInstallOneoffInvEntry("offset" + i, bugFixes, true, this.homeIndex, "offset" + i, prereqs, langs, "UNQ-" + i);
                    offEntry.addBaseComp(compIdOhPair);
                    this.inventory.addOneoffInvEntry(offEntry, this.homeIndex);
                }
                this.inventory.saveInventory();
            }
        }
        catch (Exception ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
    }

    public int retrieveOneOffEntries() {
        if (this.homeIndex < 0) {
            return -1;
        }
        Vector oneOffs = this.inventory.getAllOneoffInvEntries(this.homeIndex);
        int entrySize = oneOffs.size();
        for (int i = 0; i < entrySize; ++i) {
            OiiiInstallOneoffInvEntry oneOff = (OiiiInstallOneoffInvEntry)oneOffs.elementAt(i);
            String string = oneOff.getDisplayString();
        }
        return entrySize;
    }

    public Vector getHomeIndices(String patchName, String patchVersion) {
        int index = -1;
        Vector<Integer> vIndices = new Vector<Integer>();
        if (patchName == null || patchVersion == null || patchName.equals("") || patchVersion.equals("")) {
            return null;
        }
        try {
            Vector ohs = this.inventory.getHomes();
            for (int i = 0; i < ohs.size(); ++i) {
                OiiiOracleHomeInfo o = (OiiiOracleHomeInfo)ohs.elementAt(i);
                if (o == null) continue;
                int ohIndex = o.getIndex();
                Vector comps = this.inventory.getAllCompsVect(ohIndex);
                for (int j = 0; j < comps.size(); ++j) {
                    OiiiCompInvEntry compInvEntry1 = (OiiiCompInvEntry)comps.get(j);
                    String compName = compInvEntry1.getName();
                    String version = compInvEntry1.getVersion().getVerString();
                    if (!compName.equals(patchName) || !patchVersion.equals(version)) continue;
                    index = o.getIndex();
                    vIndices.addElement(new Integer(index));
                }
            }
        }
        catch (Exception ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
        return vIndices;
    }

    public void updateComponent(OiicSessionContext mContext) {
        try {
            OiisVariable topLevelComp;
            if (mContext != null && (topLevelComp = mContext.getVariable("ToplevelComp")) != null) {
                OiiiCompInstallID id = (OiiiCompInstallID)topLevelComp.getValue();
                OiicStageSession oSession = (OiicStageSession)mContext.getSession();
                if (id != null) {
                    OiiiVersion version = id.getVersion();
                    String compName = id.getName();
                    Vector comps = this.inventory.getAllCompsVect(this.homeIndex);
                    for (int j = 0; j < comps.size(); ++j) {
                        OiiiVersion tempVersion;
                        OiiiInstallCompInvEntry compInvEntry = (OiiiInstallCompInvEntry)comps.get(j);
                        String tempName = compInvEntry.getName();
                        if (!compName.equals(tempName) || version.laterThan(tempVersion = compInvEntry.getHighestCompVersion())) continue;
                        oSession.saveInventoryWithUpdate();
                    }
                }
            }
        }
        catch (Exception ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
        }
    }
}

