/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiixOraparam {
    public static final String DEFAULT_ORAPARAM_NAME = "oraparam.ini";
    public static final String SECTION_NAME = "ORACLE";
    public static final String SOURCE_VARIABLE_NAME = "SOURCE";
    public static final String LIC_VARIABLE_NAME = "LICENSE_LOCATION";
    public static final String LIC_TITLE_VARIABLE_NAME = "LICENSE_TITLE";
    public static final String DEFAULT_HOME_LOCATION_NAME = "DEFAULT_HOME_LOCATION";
    public static final String DEFAULT_APPLTOP_LOCATION_NAME = "DEFAULT_APPLTOP_LOCATION";
    public static final String DEFAULT_HOME_NAME = "DEFAULT_HOME_NAME";
    public static final String IMAGE_SECTION_NAME = "IMAGES";
    public static final String NLS_ENABLED_NAME = "NLS_ENABLED";
    public static final String NO_BROWSE = "NO_BROWSE";
    public static final String BOOTSTRAP = "BOOTSTRAP";
    public static final String BOOTSTRAP_SIZE = "BOOTSTRAP_SIZE";
    public static final String USE_BUILD_NUMBER = "USE_BUILD_NUMBER";
    public static final String APPLTOP_STAGE = "APPLTOP_STAGE";
    public static final String REGISTRATION_URL = "REGISTRATION_URL";
    public static final String REGISTRATION_KEYWORD = "REGISTRATION_KEYWORD";
    public static final String DISPLAY_VERSION = "DISPLAY_VERSION";
    public static final String CLUSTERWARE = "CLUSTERWARE";
    public static final String VENDORCLUSTERWARE = "VENDORCLUSTERWARE";
    public static final String OUI_LOCATION = "OUI_LOCATION";
    public static final String RUN_RECOMMENDED_CONFIGTOOLS_FIRST = "RUN_RECOMMENDED_CONFIGTOOLS_FIRST";
    public static final String RUN_OUICA = "RUN_OUICA";
    public static final String SHOW_HOSTNAME = "SHOW_HOSTNAME";
    public static final String CREATE_OLD_STYLE_REGENTRIES = "CREATE_OLD_STYLE_REGENTRIES";
    public static final String USE_RUNNING_COUNT_FOR_DEFAULTS = "USE_RUNNING_COUNT_FOR_DEFAULTS";
    public static final String USE_PREREQ_CHECKER = "USE_PREREQ_CHECKER";
    public static final String USE_OLD_INSTALL_PREREQS = "USE_OLD_INSTALL_PREREQS";
    public static final String ALWAYS_RUN_CONFIG = "ALWAYS_RUN_CONFIG";
    public static final String SUPPRESS_IGNORE_WARNINGS = "SUPPRESS_IGNORE_WARNINGS";
    public static final String S_ALWAYS_SHOW_HOSTNAME = "ALWAYS_SHOW";
    public static final String S_NEVER_SHOW_HOSTNAME = "NEVER_SHOW";
    public static final String S_CONDITION_SHOW_HOSTNAME = "CONDITION_SHOW";
    public static final int NUM_NEVER_SHOW_HOSTNAME = 0;
    public static final int NUM_ALWAYS_SHOW_HOSTNAME = 1;
    public static final int NUM_CONDITION_SHOW_HOSTNAME = 2;
    public static final String SHOW_VERSION_SUMMARY = "SHOW_VERSION_SUMMARY";
    public static final String AUTOOUI = "AUTOOUI";
    public static final String S_AUTOOUI_DEFAULT = "DEFAULT";
    public static final String S_AUTOOUI_ALWAYS = "ALWAYS";
    public static final String S_AUTOOUI_NEVER = "NEVER";
    public static final String S_ALWAYS_IF_NEW_OR_VERSION_GTE = "ALWAYS_IF_NEW_OR_VERSION_GTE";
    public static final String S_DEINSTALL_COMPONENTS = "DEINSTALL_COMPONENTS";
    public static final String S_BACKGROUND_IMAGE = "BACKGROUND_IMAGE";
    public static final String S_SPLASH_IMAGE = "SPLASH_IMAGE";
    public static final String S_EXT_JLIB = "EXT_JLIB";
    public static final String S_EXT_BIN = "EXT_BIN";
    public static final String S_EXT_LIB = "EXT_LIB";
    public static final String S_SILENT_VARIABLE_VALIDATION = "SILENT_VARIABLE_VALIDATION";
    private static OiixIniFile m_OraparamIniFile = null;
    private static Boolean _bSuppressWarningFlag = null;
    public static final String S_HTTP_RETRY_COUNT = "HTTP_RETRY_COUNT";
    public static final String S_HTTP_RETRY_INTERVAL = "HTTP_RETRY_INTERVAL";
    public static final String DEFAULT_HTTP_RETRY_COUNT = "3";
    public static final String DEFAULT_HTTP_RETRY_INTERVAL = "1000";
    public static final String SUPPORT_POLICY_LOCATION = "SUPPORT_POLICY_LOCATION";
    public static final String SUPPORT_POLICY_NAME = "SUPPORT_POLICY_NAME";
    public static final String SUPPORT_POLICY_DEFAULT_NAME = "Oracle Technical Support Policy";
    public static final String SUPPORT_POLICY_LOCATION_DEFAULT = "http://www.oracle.com/support/policies.html";

    private OiixOraparam() {
    }

    private static OiixIniFile getOraparamObject() {
        if (m_OraparamIniFile == null) {
            String iniFile = System.getProperty("oracle.installer.paramFile");
            if (null != iniFile) {
                try {
                    iniFile = OiixPathOps.getCanonicalPath(iniFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (iniFile == null || !new File(iniFile).exists()) {
                String dir = System.getProperty("oracle.installer.startup_location");
                if (dir != null) {
                    iniFile = OiixPathOps.concatPath(dir, DEFAULT_ORAPARAM_NAME);
                    File f = new File(iniFile);
                    if (!f.exists()) {
                        File fStartupDir = new File(dir);
                        String sParentDir = fStartupDir.getParent();
                        iniFile = sParentDir != null ? OiixPathOps.concatPath(sParentDir, DEFAULT_ORAPARAM_NAME) : DEFAULT_ORAPARAM_NAME;
                    }
                } else {
                    iniFile = DEFAULT_ORAPARAM_NAME;
                }
            }
            m_OraparamIniFile = new OiixIniFile(iniFile);
        }
        return m_OraparamIniFile;
    }

    public static void reset() {
        m_OraparamIniFile = null;
        if (System.getProperty("oracle.installer.paramFile", null) != null) {
            System.getProperties().remove("oracle.installer.paramFile");
        }
    }

    public static Vector getOraparamSectionVarNames(String sectionName) {
        Vector value = null;
        try {
            OiixIniFile oraparamIni = OiixOraparam.getOraparamObject();
            value = oraparamIni.getVarsInSection(sectionName);
        }
        catch (IOException e) {
            value = null;
        }
        return value;
    }

    public static String getOraparamProfileString(String name, String sDefValue) {
        return OiixOraparam.getOraparamProfileString(SECTION_NAME, name, sDefValue);
    }

    public static String[] getOraparamProfileStringList(String name, String[] sDefValue) {
        return OiixOraparam.getOraparamProfileStringList(SECTION_NAME, name, sDefValue);
    }

    public static String getOraparamProfileString(String sectionName, String name, String sDefValue) {
        String value = sDefValue;
        try {
            OiixIniFile oraparamIni = OiixOraparam.getOraparamObject();
            value = oraparamIni.getProfileString(sectionName, name, sDefValue);
        }
        catch (IOException e) {
            value = sDefValue;
        }
        return value;
    }

    public static String[] getOraparamProfileStringList(String sectionName, String name, String[] sDefValue) {
        String[] value = sDefValue;
        try {
            OiixIniFile oraparamIni = OiixOraparam.getOraparamObject();
            value = oraparamIni.getProfileStringList(sectionName, name, sDefValue);
        }
        catch (IOException e) {
            value = sDefValue;
        }
        return value;
    }

    public static boolean alwaysRunConfig() {
        String sAlwaysExecuteConfig = OiixOraparam.getOraparamProfileString(ALWAYS_RUN_CONFIG, "false");
        return sAlwaysExecuteConfig.equalsIgnoreCase("true");
    }

    public static boolean useOldInstallPrereqs() {
        String sUseOldInstallPrereqs = OiixOraparam.getOraparamProfileString(USE_OLD_INSTALL_PREREQS, "false");
        return sUseOldInstallPrereqs.equalsIgnoreCase("true");
    }

    public static boolean usePrereqChecker() {
        String sUsePrereqChecker = OiixOraparam.getOraparamProfileString(USE_PREREQ_CHECKER, "true");
        return sUsePrereqChecker.equalsIgnoreCase("true");
    }

    public static boolean useRunningCountForDefaults() {
        String sUseRunningCount = OiixOraparam.getOraparamProfileString(USE_RUNNING_COUNT_FOR_DEFAULTS, "true");
        return sUseRunningCount.equalsIgnoreCase("true");
    }

    public static boolean createOldStyleRegEntries() {
        String sCreateOldStyleRegEntries = OiixOraparam.getOraparamProfileString(CREATE_OLD_STYLE_REGENTRIES, "false");
        return sCreateOldStyleRegEntries.equalsIgnoreCase("true");
    }

    public static boolean showVersion() {
        String sDisplayVersion = OiixOraparam.getOraparamProfileString(DISPLAY_VERSION, "true");
        return sDisplayVersion.equalsIgnoreCase("true");
    }

    public static boolean isBootstrapMode() {
        String sBootstrap = OiixOraparam.getOraparamProfileString(BOOTSTRAP, "false");
        return sBootstrap.equalsIgnoreCase("true");
    }

    public static long getBootstrapSize() {
        long lBootStrapSize = 0L;
        if (OiixOraparam.isBootstrapMode()) {
            String sBootstrapSize = OiixOraparam.getOraparamProfileString(BOOTSTRAP_SIZE, "0");
            try {
                lBootStrapSize = Long.parseLong(sBootstrapSize) * 1024L * 1024L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lBootStrapSize;
    }

    public static ArrayList getDeinstallComponents() {
        String[] sDeinstallComps = OiixOraparam.getOraparamProfileStringList(S_DEINSTALL_COMPONENTS, null);
        ArrayList<String> deinstallCompsList = new ArrayList<String>();
        if (sDeinstallComps != null && sDeinstallComps.length != 0) {
            for (int i = 0; i < sDeinstallComps.length; ++i) {
                deinstallCompsList.add(sDeinstallComps[i].trim());
            }
        }
        return deinstallCompsList;
    }

    public static String[] getClusterwareInfo() {
        return OiixOraparam.getOraparamProfileStringList(CLUSTERWARE, null);
    }

    public static boolean isVendorClusterware() {
        String sVendorClusterware = OiixOraparam.getOraparamProfileString(VENDORCLUSTERWARE, "false");
        return Boolean.valueOf(sVendorClusterware);
    }

    public static boolean canIgnoreBuildNumber() {
        String sUseBuildNumber = OiixOraparam.getOraparamProfileString(USE_BUILD_NUMBER, "false");
        return sUseBuildNumber.equalsIgnoreCase("false");
    }

    public static boolean isApplTopStage() {
        String sApplTopFlag = OiixOraparam.getOraparamProfileString(APPLTOP_STAGE, "false");
        return Boolean.valueOf(sApplTopFlag);
    }

    public static boolean isRegisterBeforeUse() {
        String sURL = OiixOraparam.getRegistrationURL();
        sURL = sURL.trim();
        String sKeyword = OiixOraparam.getRegistrationKeyword();
        return !(sKeyword = sKeyword.trim()).equals("");
    }

    public static String getRegistrationURL() {
        String sRegister = OiixOraparam.getOraparamProfileString(REGISTRATION_URL, "");
        return sRegister;
    }

    public static String getRegistrationKeyword() {
        String sRegister = OiixOraparam.getOraparamProfileString(REGISTRATION_KEYWORD, "");
        return sRegister;
    }

    public static boolean runRecommendedConfigToolsFirst() {
        String configFlag = OiixOraparam.getOraparamProfileString(RUN_RECOMMENDED_CONFIGTOOLS_FIRST, "false");
        return Boolean.valueOf(configFlag);
    }

    public static String getOuicaScriptName() {
        String sRunOuica = OiixOraparam.getOraparamProfileString(RUN_OUICA, "");
        return sRunOuica;
    }

    public static int getShowHostNameValue() {
        String sShowHostName = OiixOraparam.getOraparamProfileString(SHOW_HOSTNAME, S_NEVER_SHOW_HOSTNAME);
        if (sShowHostName.equalsIgnoreCase(S_NEVER_SHOW_HOSTNAME)) {
            return 0;
        }
        if (sShowHostName.equalsIgnoreCase(S_ALWAYS_SHOW_HOSTNAME)) {
            return 1;
        }
        if (sShowHostName.equalsIgnoreCase(S_CONDITION_SHOW_HOSTNAME)) {
            return 2;
        }
        return 0;
    }

    public static boolean isSuppressIgnoreWarnings() {
        if (_bSuppressWarningFlag == null) {
            String sFlag = OiixOraparam.getOraparamProfileString(SUPPRESS_IGNORE_WARNINGS, "false");
            _bSuppressWarningFlag = Boolean.valueOf(sFlag);
        }
        return _bSuppressWarningFlag;
    }

    public static boolean canShowSummaryVersion() {
        String sFlag = OiixOraparam.getOraparamProfileString(SHOW_VERSION_SUMMARY, "true");
        return Boolean.valueOf(sFlag);
    }

    public static String getAutoOUIInstall() {
        String sAutooui = OiixOraparam.getOraparamProfileString(AUTOOUI, S_AUTOOUI_DEFAULT);
        return sAutooui;
    }

    public static boolean ifExtPathSet() {
        String sJlib = OiixOraparam.getOraparamProfileString(S_EXT_JLIB, null);
        String sLib = OiixOraparam.getOraparamProfileString(S_EXT_LIB, null);
        String sBin = OiixOraparam.getOraparamProfileString(S_EXT_BIN, null);
        return sJlib != null || sLib != null || sBin != null;
    }

    public static String getBackgroundImage() {
        String sBgImage = OiixOraparam.getOraparamProfileString(S_BACKGROUND_IMAGE, null);
        return sBgImage;
    }

    public static String getSplashImage() {
        String sSplashImage = OiixOraparam.getOraparamProfileString(S_SPLASH_IMAGE, null);
        return sSplashImage;
    }

    public static String isSilentVarValidation() {
        String sVariableValidationFlag = OiixOraparam.getOraparamProfileString(S_SILENT_VARIABLE_VALIDATION, "false");
        return sVariableValidationFlag;
    }

    public static String getHttpRetryCount() {
        return OiixOraparam.getOraparamProfileString(S_HTTP_RETRY_COUNT, DEFAULT_HTTP_RETRY_COUNT);
    }

    public static String getHttpRetryInterval() {
        return OiixOraparam.getOraparamProfileString(S_HTTP_RETRY_INTERVAL, DEFAULT_HTTP_RETRY_INTERVAL);
    }
}

