/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixInstallUtil {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String OUI_EXEC_UNIX = "runInstaller";
    private static final String OUI_EXEC_WINDOWS = "setup.exe";

    public static boolean isAPIMode() {
        return OiixInstallUtil.isOptionSet("oracle.installer.ouiApiMode");
    }

    public static boolean isUnix() {
        return OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform());
    }

    public static boolean isWindows() {
        return OiixPlatform.isPlatInGroup(-3, OiixPlatform.getCurrentPlatform());
    }

    public static boolean isSilent() {
        return OiixInstallUtil.isOptionSet("oracle.installer.silent");
    }

    public static boolean isAddNodeMode() {
        return OiixInstallUtil.isOptionSet("oracle.installer.addNode");
    }

    public static boolean isAttachHomeMode() {
        return OiixInstallUtil.isOptionSet("oracle.installer.attachHome");
    }

    public static boolean isDebug() {
        return OiixInstallUtil.isOptionSet("oracle.installer.debug");
    }

    public static boolean isInstallAddOn() {
        return OiixInstallUtil.isOptionSet("oracle.installer.installaddons");
    }

    public static boolean isOptionSet(String key) {
        return Boolean.getBoolean(key);
    }

    public static boolean isOptionSetInOraparam(String key) {
        String val = OiixOraparam.getOraparamProfileString(key, FALSE);
        return TRUE.equalsIgnoreCase(val);
    }

    public static void setOption(String key) {
        System.setProperty(key, TRUE);
    }

    public static void unsetOption(String key) {
        System.setProperty(key, FALSE);
    }

    public static String getInventoryLocation(String invLoc) throws OiifbEndIterateException {
        if (invLoc == null) {
            try {
                invLoc = OiipgPropertyLoader.getLocationFileLoc();
            }
            catch (IOException e) {
                invLoc = null;
            }
            try {
                if (invLoc != null) {
                    OiipgFileSystem.checkWritablePath(invLoc);
                }
            }
            catch (OiipgPathException pge) {
                if (pge.getLevel() == OiipgPathException.INVALID_PATH) {
                    File f = new File(invLoc);
                    f.delete();
                }
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_INVALID_ERR");
                throw new OiifbEndIterateException(sMsg);
            }
        }
        return invLoc;
    }

    public static boolean isDefaultsOverriddenPropSet(String key) {
        Properties props = OiixInstallUtil.getDefaultsOverriddenProps();
        if (props != null) {
            return props.getProperty(key) != null;
        }
        return false;
    }

    public static Properties getDefaultsOverriddenProps() {
        OiicBaseApp oInstaller = OiixInstallUtil.getInstallerInstance();
        return oInstaller.getDefaultsOverriden();
    }

    private static OiicBaseApp getInstallerInstance() {
        if (OiixInstallUtil.isAPIMode()) {
            return OiicAPIInstaller.getAPIInstallerInstance();
        }
        return OiicInstaller.getOiicInstallerInstance();
    }

    public static String getOUILoc(String sOUILoc) {
        String sOUIExecLoc = null;
        int s_curPlatformGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (s_curPlatformGroup == -1) {
            sOUIExecLoc = OiixPathOps.concatPath(sOUILoc, OUI_EXEC_UNIX);
        } else if (s_curPlatformGroup == -3) {
            sOUIExecLoc = OiixPathOps.concatPath(sOUILoc, OUI_EXEC_WINDOWS);
        }
        return OiixPathOps.getNativeForm(sOUIExecLoc);
    }
}

