/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.text.MessageFormat;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixIniObject;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixIniPair
extends OiixIniObject {
    private String m_sName;
    private String m_sValue;
    private static final String EQUAL = "=";
    private boolean m_bValueFinal = true;
    private boolean m_bPreserveFormat = false;
    private static final String RHS_TERMINATOR = " \\";
    private static final char ENV_VAR_SEPARATOR = '%';
    private static final String DOUBLE_PERCENT_SIGN = "%%";

    public OiixIniPair(String name, String value) throws OiixIniParsingException {
        this(name, value, false);
    }

    public OiixIniPair(String name, String value, boolean bPreserveFormat) throws OiixIniParsingException {
        this(name, value, bPreserveFormat, 0);
    }

    public OiixIniPair(String name, String value, boolean bPreserveFormat, int lineNumber) throws OiixIniParsingException {
        if (null != name) {
            this.m_sName = name.trim();
        }
        if (null != value) {
            this.m_sValue = value.trim();
        }
        this.m_bPreserveFormat = bPreserveFormat;
        this.setStartLineNumber(lineNumber);
        this.updateValue();
    }

    public String getName() {
        return this.m_sName;
    }

    public String getValue() {
        return this.m_sValue;
    }

    public void setValue(String sValue) {
        this.m_sValue = sValue.trim();
    }

    public boolean isValueFinal() {
        return this.m_bValueFinal;
    }

    public void addValueLine(String value) throws OiixIniParsingException {
        if (this.m_bValueFinal) {
            return;
        }
        this.m_sValue = this.m_sValue + value;
        this.updateValue();
    }

    private void updateValue() throws OiixIniParsingException {
        if (this.m_sValue.endsWith(RHS_TERMINATOR)) {
            this.m_bValueFinal = false;
            this.m_sValue = !this.m_bPreserveFormat ? this.m_sValue.substring(0, this.m_sValue.length() - RHS_TERMINATOR.length()) : this.m_sValue + OiixIniObject.NEW_LINE;
        } else {
            this.m_bValueFinal = true;
            if (!this.m_bPreserveFormat) {
                this.m_sValue = this.instantiateEnvVars(this.m_sValue);
            }
        }
    }

    private String instantiateEnvVars(String sText) throws OiixIniParsingException {
        StringBuffer sbOutput = new StringBuffer();
        int idx1 = -1;
        int idx2 = -1;
        for (int i = 0; i < sText.length(); ++i) {
            idx1 = sText.indexOf(37, i);
            if (idx1 == -1) {
                sbOutput.append(sText.substring(i));
                break;
            }
            if (idx1 + 1 < sText.length() && sText.charAt(idx1 + 1) == '%') {
                sbOutput.append(sText.substring(i, idx1 + 2));
                i = idx1 + 1;
                continue;
            }
            idx2 = sText.indexOf(37, idx1 + 1);
            if (idx2 == -1) {
                Object[] envVarName = new String[]{sText.substring(idx1)};
                Object[] args = new String[envVarName.length];
                for (int k = 0; k < envVarName.length; ++k) {
                    args[k] = envVarName[k];
                }
                String sMsg = OiixResourceBundle.getString("S_ENV_VAR_NOT_FOUND", args);
                sMsg = MessageFormat.format(sMsg, envVarName);
                throw new OiixIniParsingException(sMsg);
            }
            sbOutput.append(sText.substring(i, idx1));
            String sEnvVarName = sText.substring(idx1 + 1, idx2);
            String sEnvVarValue = OiipgEnvironment.getEnv(sEnvVarName);
            if (sEnvVarValue == null) {
                Object[] envVarName = new String[]{sEnvVarName};
                String sMsg = OiixResourceBundle.getString("S_ENV_VAR_NOT_FOUND");
                sMsg = MessageFormat.format(sMsg, envVarName);
                throw new OiixIniParsingException(sMsg);
            }
            sbOutput.append(sEnvVarValue);
            i = idx2;
        }
        String sOutput = OiixFunctionOps.replaceStr(sbOutput.toString(), DOUBLE_PERCENT_SIGN, "%");
        return sOutput;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sName);
        sb.append(EQUAL);
        sb.append(this.m_sValue);
        return sb.toString();
    }
}

