/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiixFileChangeMonitor
implements Runnable {
    private Hashtable m_files = new Hashtable();
    private long m_interval;
    private Vector m_modifiedFiles;

    public OiixFileChangeMonitor() {
        this(5000L);
    }

    public OiixFileChangeMonitor(long interval) {
        this.m_interval = interval;
        this.m_modifiedFiles = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFile(String filename, long timestamp) throws FileNotFoundException {
        File f = new File(filename = OiixPathOps.getNativeForm(filename));
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot monitor file: " + filename);
        }
        OiixFileChangeMonitor oiixFileChangeMonitor = this;
        synchronized (oiixFileChangeMonitor) {
            this.m_files.put(filename, new Long(timestamp));
        }
    }

    public synchronized void unregisterAllFiles() {
        this.m_files = new Hashtable();
        this.m_modifiedFiles.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFile(String filename) {
        filename = OiixPathOps.getNativeForm(filename);
        OiixFileChangeMonitor oiixFileChangeMonitor = this;
        synchronized (oiixFileChangeMonitor) {
            this.m_files.remove(filename);
            this.m_modifiedFiles.removeElement(filename);
        }
    }

    public synchronized Vector getModifiedFiles() {
        Vector to_return = this.m_modifiedFiles;
        this.m_modifiedFiles = new Vector();
        return to_return;
    }

    public synchronized Vector getModifiedFilesNow() {
        this.updateModifiedFiles();
        return this.getModifiedFiles();
    }

    @Override
    public void run() {
        while (true) {
            this.updateModifiedFiles();
            try {
                Thread.sleep(this.m_interval);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void updateModifiedFiles() {
        Enumeration files = this.m_files.keys();
        while (files.hasMoreElements()) {
            String filename = (String)files.nextElement();
            File f = new File(filename);
            long registeredTime = (Long)this.m_files.get(filename);
            if (f.exists() && f.lastModified() <= registeredTime) continue;
            this.m_modifiedFiles.addElement(filename);
            this.m_files.remove(filename);
        }
    }
}

