/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiix.OiixOraparam;

public class OiixAreasQueries {
    public static boolean anyVersionOfProductInstalled(String name, int OHIndex, int nAppltopIndex) {
        OiiiInstallAreaControl instArea = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory areaInv = instArea.getInstallInventory();
        OiiiInstallCompInvEntry entry = areaInv.findCompInRange(OHIndex, name, null, null);
        if (entry == null && nAppltopIndex != 0) {
            entry = areaInv.findCompInRange(nAppltopIndex, name, null, null);
        }
        return entry != null;
    }

    public static OiiiOracleHomeInfo getMatchingHome(String homeName) {
        OiiiOracleHomeInfo installedHome = null;
        OiiiInstallInventory installInv = null;
        OiiiInstallAreaControl installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (installAreaControl != null) {
            installInv = installAreaControl.getInstallInventory();
        }
        if (installInv != null) {
            installedHome = installInv.getHomeWithName(homeName);
        }
        return installedHome;
    }

    public static String[] getAllAppltopNames() {
        return OiipgOracleHomes.getAllAppltopNames();
    }

    public static String[] getAllAppltops() {
        return OiipgOracleHomes.getAllAppltops();
    }

    public static String[] getAllOracleHomeNames() throws OiilNativeException {
        return OiipgOracleHomes.getAllOracleHomeNames();
    }

    public static String[] getAllOracleHomes() throws OiilNativeException {
        return OiipgOracleHomes.getAllOracleHomes();
    }

    public static String getHomeName(String sHomePath) throws OiilNativeException {
        return OiipgOracleHomes.getHomeName(sHomePath);
    }

    public static String getHomePath(String sHomeName) throws OiilNativeException {
        return OiipgOracleHomes.getHomePath(sHomeName);
    }

    public static boolean isProductInstalled(String ohLoc, String name, String startVersion, String endVersion, int OHIndex, int AppltopIndex, boolean isCloneMode, Boolean isCompatible) {
        OiiiInstallCompInvEntry entry;
        OiiiInstallAreaControl instArea = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory areaInv = instArea.getInstallInventory();
        if (ohLoc != null) {
            Vector ohList = areaInv.getHomes();
            int index = OiiiOracleHomeInfo.getOHIndex(ohList, ohLoc);
            if (index == -1) {
                return false;
            }
            if (isCloneMode && index == OHIndex) {
                return false;
            }
            entry = areaInv.findCompInRange(index, name, startVersion, endVersion);
        } else {
            int nAppltopIndex;
            int nOhIndex = OHIndex;
            entry = areaInv.findCompInRange(nOhIndex, name, startVersion, endVersion);
            if (entry == null && (nAppltopIndex = AppltopIndex) != 0) {
                entry = areaInv.findCompInRange(nAppltopIndex, name, startVersion, endVersion);
            }
        }
        if (!isCompatible.booleanValue() && entry != null && entry.getCompInstallID().getVersion().laterThan(new OiiiVersion(endVersion))) {
            entry = null;
        }
        return entry != null;
    }

    public static String getOraparamProfileString(String sectionName, String name, String sDefValue) {
        return OiixOraparam.getOraparamProfileString(sectionName, name, "");
    }

    public static String getProductVersion(String ohLoc, String name, OiicPullSession installSession) throws Exception {
        Vector compEntries;
        OiiiInstallAreaControl instArea = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory areaInv = instArea.getInstallInventory();
        OiiiVersion oVersion = null;
        if (ohLoc != null) {
            Vector ohList = areaInv.getHomes();
            int index = OiiiOracleHomeInfo.getOHIndex(ohList, ohLoc);
            if (index == -1) {
                throw new Exception("Home not found");
            }
            compEntries = areaInv.getCompInvEntries(name, index);
        } else {
            int nAppltopIndex;
            int nOhIndex = installSession.getOHIndex();
            compEntries = areaInv.getCompInvEntries(name, nOhIndex);
            if (compEntries.size() == 0 && (nAppltopIndex = installSession.getAppltopIndex()) != 0) {
                compEntries = areaInv.getCompInvEntries(name, nAppltopIndex);
            }
        }
        if (compEntries.size() == 0) {
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(name);
            throw new Exception("Product not found");
        }
        if (compEntries.size() != 1) {
            int nSize = compEntries.size();
            int nComps = 0;
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInvEntry cie = (OiiiCompInvEntry)compEntries.elementAt(i);
                OiiiCompInstallID id = cie.getCompInstallID();
                if (id.getCompType() == 1 && ++nComps > 1) {
                    String[] variables = new String[1];
                    String[] values = new String[1];
                    variables[0] = new String("%1%");
                    values[0] = new String(name);
                    throw new Exception("Multiple versions of product found");
                }
                if (oVersion != null && !cie.getVersion().laterThan(oVersion)) continue;
                oVersion = id.getVersion();
            }
        }
        if (oVersion == null) {
            OiiiCompInvEntry entry = (OiiiCompInvEntry)compEntries.elementAt(0);
            oVersion = entry.getVersion();
        }
        return oVersion.getVerString();
    }
}

