/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiit;

import oracle.sysman.oii.oiit.OiitConflictResolver;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiit.OiitTargetLocker;

class TestLockerThread
extends Thread {
    static final boolean s_debug = false;
    static final int s_debugCategory = 0x400000;
    private String m_areaRoot;
    private boolean m_writerLock;
    private int m_duration;
    private OiitConflictResolver m_cresolver;
    private Exception m_exception;

    TestLockerThread(String areaRoot, boolean writerLock, int duration, OiitConflictResolver cresolver) {
        this.m_areaRoot = areaRoot;
        this.m_writerLock = writerLock;
        this.m_duration = duration;
        this.m_cresolver = cresolver;
        this.m_exception = null;
    }

    @Override
    public void run() {
        try {
            OiitTargetLocker tl = new OiitTargetLocker(this.m_areaRoot, this.m_cresolver);
            OiitLockHeartbeat lhb = this.m_writerLock ? tl.getWriterLock() : tl.getReaderLock();
            try {
                TestLockerThread.sleep(this.m_duration);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            lhb.releaseLock();
        }
        catch (Exception e) {
            if (!(e instanceof OiitTargetLockNotAvailableException) || !((OiitTargetLockNotAvailableException)e).containsStandardReason()) {
                e.printStackTrace();
            }
            this.m_exception = e;
        }
    }

    public Exception getException() {
        return this.m_exception;
    }
}

