/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiit.OiitConflictResolver;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;
import oracle.sysman.oii.oiit.OiitLockMonitor;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiitTargetLocker {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x400000;
    public static final int READY = 0;
    public static final int WRITING_IN_PROGRESS = 1;
    public static final int READING_IN_PROGRESS = 2;
    public static final int WRITING_CANCELLED = 3;
    private static final String TARGET_LOCKS_DIR = "locks";
    private static final String WRITER_LOCK_NAME = "writer.lock";
    private static final String READER_LOCKS_START = "reader";
    private static final String READER_LOCKS_EXT = ".lock";
    private static final int ACTIVE_WRITER = 0;
    private static final int INACTIVE_WRITER = 1;
    private static final int FREED_WRITER = 2;
    private int m_nMaxRetries = 10;
    private String m_targetAreaRoot;
    private File m_locksDir;
    private OiitConflictResolver m_resolver;

    public OiitTargetLocker(String targetAreaRoot, OiitConflictResolver resolver) throws IOException {
        this.m_targetAreaRoot = OiixPathOps.getNativeForm(targetAreaRoot);
        this.m_locksDir = new File(this.m_targetAreaRoot, TARGET_LOCKS_DIR);
        this.m_resolver = resolver;
    }

    public synchronized OiitLockHeartbeat getWriterLock() throws OiitTargetLockNotAvailableException {
        return this.getWriterLock(false);
    }

    public synchronized OiitLockHeartbeat getWriterLock(boolean bWriteDateInFile) throws OiitTargetLockNotAvailableException {
        return this.getWriterLock(null, bWriteDateInFile);
    }

    private synchronized OiitLockHeartbeat getWriterLock(OiitLockHeartbeat readHb, boolean bMonitor) throws OiitTargetLockNotAvailableException {
        boolean retryWritersLock = false;
        OiitLockHeartbeat lhb = null;
        if (!bMonitor) {
            this.createLocksDir();
        }
        block13: do {
            retryWritersLock = false;
            File writerLockFile = new File(this.m_locksDir, WRITER_LOCK_NAME);
            String writerLockPath = writerLockFile.getPath();
            if (writerLockFile.exists()) {
                int writerState = this.isWriterCurrent(writerLockPath);
                switch (writerState) {
                    case 0: {
                        retryWritersLock = this.handleActiveWriter();
                        break;
                    }
                    case 1: {
                        if (bMonitor) {
                            lhb = new OiitLockMonitor(writerLockPath);
                            lhb.startHeartbeat();
                            retryWritersLock = false;
                        }
                        try {
                            retryWritersLock = this.handleInactiveWriter(writerLockPath);
                            break;
                        }
                        catch (OiitTargetLockNotAvailableException e) {
                            if (bMonitor) continue block13;
                            throw e;
                        }
                    }
                    case 2: {
                        retryWritersLock = true;
                    }
                }
                continue;
            }
            try {
                lhb = bMonitor ? new OiitLockMonitor(writerLockPath) : new OiitLockHeartbeat(writerLockPath);
                lhb.startHeartbeat();
                if (readHb != null) {
                    readHb.releaseLock();
                }
            }
            catch (IOException ioe) {
                throw new OiitTargetLockNotAvailableException(-1, this.m_targetAreaRoot);
            }
            if (bMonitor) continue;
            boolean retryReaders = false;
            Hashtable readerDates = this.initReaderDatesTable();
            try {
                do {
                    retryReaders = false;
                    try {
                        Thread.currentThread();
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                } while (retryReaders = this.updateReaderDatesTable(readerDates));
            }
            catch (OiitTargetLockNotAvailableException tlnae) {
                lhb.stopHeartbeat();
                lhb.releaseLock();
                lhb = null;
                throw tlnae;
            }
        } while (retryWritersLock);
        return lhb;
    }

    public synchronized OiitLockHeartbeat getWriterLockMonitor() throws OiitTargetLockNotAvailableException {
        return this.getWriterLock(null, true);
    }

    public synchronized OiitLockHeartbeat getReaderLock() throws OiitTargetLockNotAvailableException {
        boolean retryWritersLock = false;
        OiitLockHeartbeat lhb = null;
        this.createLocksDir();
        do {
            retryWritersLock = false;
            File writerLockFile = new File(this.m_locksDir, WRITER_LOCK_NAME);
            String writerLockPath = writerLockFile.getPath();
            if (writerLockFile.exists()) {
                int writerState = this.isWriterCurrent(writerLockPath);
                switch (writerState) {
                    case 0: {
                        retryWritersLock = this.handleActiveWriterInRL();
                        break;
                    }
                    case 1: {
                        retryWritersLock = this.handleInactiveWriter(writerLockPath);
                        break;
                    }
                    case 2: {
                        retryWritersLock = true;
                    }
                }
                continue;
            }
            String[] fileList = this.m_locksDir.list(new ReaderLockFileFilter());
            int numFiles = 0;
            if (fileList != null) {
                numFiles = fileList.length;
            }
            int readerNum = numFiles;
            if (numFiles > 0) {
                int i;
                Vector<String> fileVect = new Vector<String>();
                for (i = 0; i < numFiles; ++i) {
                    fileVect.addElement(fileList[i]);
                }
                for (i = 0; i < numFiles; ++i) {
                    String readerName = READER_LOCKS_START + i + READER_LOCKS_EXT;
                    if (fileVect.contains(readerName)) continue;
                    readerNum = i;
                    break;
                }
            }
            String readerName = READER_LOCKS_START + readerNum + READER_LOCKS_EXT;
            String readerPath = new File(this.m_locksDir, readerName).getPath();
            try {
                lhb = new OiitLockHeartbeat(readerPath);
                lhb.startHeartbeat();
            }
            catch (IOException ioe) {
                throw new OiitTargetLockNotAvailableException(-1, this.m_targetAreaRoot);
            }
        } while (retryWritersLock);
        return lhb;
    }

    public synchronized OiitLockHeartbeat upgradeToWriterLock(OiitLockHeartbeat readHb, boolean bWriteDateInFile) throws OiitTargetLockNotAvailableException {
        return this.getWriterLock(readHb, bWriteDateInFile);
    }

    public synchronized OiitLockHeartbeat downgradeToReaderLock(OiitLockHeartbeat writeHb) throws OiitTargetLockNotAvailableException {
        boolean retryWritersLock = false;
        OiitLockHeartbeat lhb = null;
        String[] fileList = this.m_locksDir.list(new ReaderLockFileFilter());
        int numFiles = 0;
        if (fileList != null) {
            numFiles = fileList.length;
        }
        int readerNum = numFiles;
        if (numFiles > 0) {
            int i;
            Vector<String> fileVect = new Vector<String>();
            for (i = 0; i < numFiles; ++i) {
                fileVect.addElement(fileList[i]);
            }
            for (i = 0; i < numFiles; ++i) {
                String readerName = READER_LOCKS_START + i + READER_LOCKS_EXT;
                if (fileVect.contains(readerName)) continue;
                readerNum = i;
                break;
            }
        }
        String readerName = READER_LOCKS_START + readerNum + READER_LOCKS_EXT;
        String readerPath = new File(this.m_locksDir, readerName).getPath();
        try {
            lhb = new OiitLockHeartbeat(readerPath);
            lhb.startHeartbeat();
            if (writeHb != null) {
                writeHb.releaseLock();
            }
        }
        catch (IOException ioe) {
            throw new OiitTargetLockNotAvailableException(-1, this.m_targetAreaRoot);
        }
        return lhb;
    }

    private int isWriterCurrent(String filePath) {
        int retVal = 1;
        for (int i = 0; i < this.getMaxRetries(); ++i) {
            try {
                long timeStamp1 = this.getLastModifiedTime(filePath);
                try {
                    Thread.currentThread();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                long timeStamp2 = this.getLastModifiedTime(filePath);
                if (timeStamp2 - timeStamp1 >= 1000L && timeStamp2 - timeStamp1 < 3000L) {
                    retVal = 0;
                }
            }
            catch (FileNotFoundException fnfe) {
                retVal = 2;
            }
            catch (IOException ioe) {
                retVal = 1;
            }
            if (retVal != 0) break;
        }
        return retVal;
    }

    private synchronized boolean handleActiveWriter() throws OiitTargetLockNotAvailableException {
        boolean retryWritersLock = false;
        int wwl = this.m_resolver.checkWaitForWriterForWL();
        switch (wwl) {
            case 2: {
                int err = 2;
                throw new OiitTargetLockNotAvailableException(err, this.m_targetAreaRoot);
            }
            case 1: {
                try {
                    int sleepInt = 2000;
                    Thread.currentThread();
                    Thread.sleep(sleepInt);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                retryWritersLock = true;
                break;
            }
            case 0: {
                retryWritersLock = true;
            }
        }
        return retryWritersLock;
    }

    private synchronized boolean handleActiveWriterInRL() throws OiitTargetLockNotAvailableException {
        boolean retryWritersLock = false;
        int wrl = this.m_resolver.checkWaitForWriterForRL();
        switch (wrl) {
            case 2: {
                int err = 4;
                throw new OiitTargetLockNotAvailableException(err, this.m_targetAreaRoot);
            }
            case 1: {
                try {
                    int sleepInt = 2000;
                    Thread.currentThread();
                    Thread.sleep(sleepInt);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                retryWritersLock = true;
                break;
            }
            case 0: {
                retryWritersLock = true;
            }
        }
        return retryWritersLock;
    }

    private synchronized boolean handleActiveReader(String filePath) throws OiitTargetLockNotAvailableException {
        boolean retryReaders = false;
        int wrl = this.m_resolver.checkWaitForReadersForWL();
        switch (wrl) {
            case 2: {
                int err = 3;
                throw new OiitTargetLockNotAvailableException(err, this.m_targetAreaRoot);
            }
            case 1: {
                try {
                    int sleepInt = 2000;
                    Thread.currentThread();
                    Thread.sleep(sleepInt);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                retryReaders = true;
                break;
            }
            case 0: {
                retryReaders = true;
            }
        }
        return retryReaders;
    }

    private synchronized boolean handleInactiveWriter(String filePath) throws OiitTargetLockNotAvailableException {
        boolean retryWritersLock = false;
        boolean iwl = this.m_resolver.checkIgnoreCancelledWriteSession();
        if (!iwl) {
            int err = 0;
            throw new OiitTargetLockNotAvailableException(err, this.m_targetAreaRoot);
        }
        boolean bDelete = new File(filePath).delete();
        if (!bDelete) {
            int err = 5;
            throw new OiitTargetLockNotAvailableException(err, this.m_targetAreaRoot);
        }
        retryWritersLock = true;
        return retryWritersLock;
    }

    private synchronized boolean handleInactiveReader(String filePath) throws OiitTargetLockNotAvailableException {
        boolean retryReaders = false;
        boolean irl = this.m_resolver.checkIgnoreCancelledReadSession();
        if (!irl) {
            int err = 1;
            throw new OiitTargetLockNotAvailableException(err, this.m_targetAreaRoot);
        }
        new File(filePath).delete();
        retryReaders = true;
        return retryReaders;
    }

    private Date getTimeInFile(String filePath) throws IOException {
        Date retDate = null;
        FileReader fr = new FileReader(filePath);
        BufferedReader br = new BufferedReader(fr);
        String dateStr = br.readLine();
        br.close();
        fr.close();
        DateFormat df = DateFormat.getDateTimeInstance(3, 1);
        try {
            retDate = df.parse(dateStr);
        }
        catch (NullPointerException npe) {
            throw new IOException(npe.toString());
        }
        catch (ParseException pe) {
            throw new IOException(pe.getMessage());
        }
        return retDate;
    }

    private long getLastModifiedTime(String filePath) throws IOException {
        File f = new File(filePath);
        return f.lastModified();
    }

    private Hashtable initReaderDatesTable() {
        Hashtable<String, Long> readerDates = new Hashtable<String, Long>();
        String[] fileList = this.m_locksDir.list(new ReaderLockFileFilter());
        int numFiles = 0;
        if (fileList != null) {
            numFiles = fileList.length;
        }
        for (int i = 0; i < numFiles; ++i) {
            String fileLoc = new File(this.m_locksDir, fileList[i]).getPath();
            try {
                long timeStamp = this.getLastModifiedTime(fileLoc);
                readerDates.put(fileLoc, new Long(timeStamp));
                continue;
            }
            catch (IOException ioe) {
                new File(fileLoc).delete();
            }
        }
        return readerDates;
    }

    private boolean updateReaderDatesTable(Hashtable readerDates) throws OiitTargetLockNotAvailableException {
        boolean retryReaders = false;
        String[] fileList = this.m_locksDir.list(new ReaderLockFileFilter());
        int numFiles = 0;
        if (fileList != null) {
            numFiles = fileList.length;
        }
        for (int i = 0; i < numFiles; ++i) {
            String fileLoc = new File(this.m_locksDir, fileList[i]).getPath();
            try {
                Long timeStamp = new Long(this.getLastModifiedTime(fileLoc));
                Long lastTimeStamp = (Long)readerDates.get(fileLoc);
                if (lastTimeStamp != null) {
                    retryReaders = timeStamp - lastTimeStamp < 1000L ? this.handleInactiveReader(fileLoc) : this.handleActiveReader(fileLoc);
                }
                readerDates.put(fileLoc, timeStamp);
                continue;
            }
            catch (IOException ioe) {
                new File(fileLoc).delete();
            }
        }
        return retryReaders;
    }

    public void setMaxRetries(int maxRetries) {
        this.m_nMaxRetries = maxRetries;
    }

    public int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    private synchronized void createLocksDir() throws OiitTargetLockNotAvailableException {
        if (!this.m_locksDir.exists()) {
            if (!OiixFileOps.mkdirs(this.m_locksDir)) {
                throw new OiitTargetLockNotAvailableException(-1, this.m_targetAreaRoot);
            }
            OiixFileOps.changePermissions(this.m_locksDir.getPath(), "0770");
        }
    }

    private class ReaderLockFileFilter
    implements FilenameFilter {
        private ReaderLockFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(OiitTargetLocker.READER_LOCKS_START) && name.endsWith(OiitTargetLocker.READER_LOCKS_EXT);
        }
    }
}

