/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiitLockHeartbeat {
    public static final int HEARTBEAT_INTERVAL = 1000;
    private String m_lockFileName;
    private File m_oLockFile;
    private HeartBeatThread m_heartbeatThread;

    protected OiitLockHeartbeat() {
    }

    public OiitLockHeartbeat(String lockFileName) throws IOException {
        this.m_lockFileName = lockFileName;
        FileOutputStream fos = new FileOutputStream(this.m_lockFileName);
        this.writeStackTrace(fos);
        OiixFileOps.changePermissions(lockFileName, "0660");
        fos.close();
    }

    private void writeStackTrace(FileOutputStream fos) {
        PrintWriter pw = new PrintWriter(fos, true);
        pw.write("\n#### START: Below stack traces are not because of any error/exception. They are added for debugging purpose. #### \n\n");
        pw.write("Time: " + OiixUtilityOps.getSessionTimeStamp() + "\n");
        pw.write("Lock File Name: " + this.m_lockFileName + "\n\n");
        pw.write("StackTrace: \n");
        pw.write("-----------\n");
        pw.flush();
        new Throwable().printStackTrace(pw);
        pw.flush();
        pw.write("\n#### END: End of the debugging stack trace #### \n");
        pw.flush();
    }

    public OiitLockHeartbeat(String lockFileName, boolean bWriteDateInFile) throws IOException {
        this(lockFileName);
    }

    public void startHeartbeat() {
        this.stopHeartbeat();
        this.m_oLockFile = new File(this.m_lockFileName);
        this.m_heartbeatThread = new HeartBeatThread();
        this.m_heartbeatThread.start();
    }

    public void stopHeartbeat() {
        if (this.m_heartbeatThread != null) {
            if (this.m_heartbeatThread.isAlive()) {
                this.m_heartbeatThread.setStopFlag(true);
            }
            this.m_heartbeatThread = null;
        }
    }

    public void releaseLock() {
        String[] filesList;
        this.stopHeartbeat();
        String sParent = this.m_oLockFile.getParent();
        this.m_oLockFile.delete();
        File lockDir = new File(sParent);
        if (lockDir.exists() && (filesList = lockDir.getAbsoluteFile().list()) != null && filesList.length == 0) {
            lockDir.delete();
        }
        this.m_oLockFile = null;
    }

    protected void touchFile() throws IOException {
        if (this.m_oLockFile != null) {
            this.m_oLockFile.setLastModified(System.currentTimeMillis());
        } else {
            System.err.println("Lock file object is null");
        }
    }

    protected void update() throws IOException {
        this.touchFile();
    }

    protected File getLockFile() {
        return this.m_oLockFile;
    }

    protected void setLockFileName(String sLockFileName) {
        this.m_lockFileName = sLockFileName;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage : java oracle.sysman.oii.oiit.OiitLockHeartbeat <lock file name>");
        } else {
            try {
                OiitLockHeartbeat lhb = new OiitLockHeartbeat(args[0]);
                System.out.println("Press return to start heartbeat ...");
                lhb.startHeartbeat();
                System.out.println("Press return to stop heartbeat ...");
                OiitLockHeartbeat.waitForKeyStroke();
                lhb.stopHeartbeat();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void waitForKeyStroke() {
        try {
            int ch;
            while ((ch = System.in.read()) <= 0) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class HeartBeatThread
    extends Thread {
        private boolean m_stopFlag = false;

        HeartBeatThread() {
            this.setPriority(10);
            this.setDaemon(true);
        }

        private synchronized void setStopFlag(boolean stopFlag) {
            this.m_stopFlag = stopFlag;
        }

        private synchronized boolean isStopFlag() {
            return this.m_stopFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                HeartBeatThread heartBeatThread = this;
                synchronized (heartBeatThread) {
                    if (this.isStopFlag()) {
                        break;
                    }
                    try {
                        OiitLockHeartbeat.this.update();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        break;
                    }
                }
                try {
                    HeartBeatThread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    break;
                }
            }
        }
    }
}

