/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiObjectInputStream;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiil.OiilExceptionHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFile;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFileManager;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisChildVarElem;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisIdentifierOps;
import oracle.sysman.oii.oiis.OiisInvalidValueException;
import oracle.sysman.oii.oiis.OiisPlatformSpecificConstant;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRetryException;

public class OiisVariable {
    private Object m_val;
    protected String m_name;
    private boolean m_advice;
    protected Object defVal1;
    protected Object defVal2;
    protected OiisAdvisedValue m_hcDef;
    protected OiisVariableOwner m_owner;
    private boolean m_exported;
    private boolean m_secure;
    private boolean m_forceTranslate;
    private boolean m_calcMethodPresent;
    private boolean m_validationMethodPresent;
    private String m_descriptionID;
    private String m_description;
    private HashMap m_hmCloneDesc;
    private String m_sAllValsString;
    private OiixJarResourceBundle m_rb;
    private boolean m_computeAtClone;
    public static final int STRING = OiisDataTypes.STRING.getID();
    public static final int NUMBER = OiisDataTypes.NUMBER.getID();
    public static final int BOOL = OiisDataTypes.BOOL.getID();
    public static final int STRINGLIST = OiisDataTypes.STRINGLIST.getID();
    public static final int STRING_TYPE_ID = 1;
    public static final int NUMBER_TYPE_ID = 2;
    public static final int BOOL_TYPE_ID = 3;
    public static final int STRINGLIST_TYPE_ID = 4;
    public static final String SESSION = "session";
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private boolean m_bProtected = false;
    public static final String STRING_DEFAULT = "";
    public static final Integer NUMBER_DEFAULT = new Integer(0);
    public static final Boolean BOOL_DEFAULT = Boolean.TRUE;
    public static final String[] STRINGLIST_DEFAULT = new String[0];
    private static final String s_varName = null;
    protected Vector m_childVarElems;
    private Vector m_derivedVarNames;
    private boolean m_bGenerateRSP = true;
    public static final int VAL_CMDLINE = 0;
    public static final int VAL_RSP = 1;
    public static final int VAL_CODEBLOCK = 2;
    public static final int VAL_DEFAULT = 3;
    public static final int VAL_CALC = 4;
    public static final int VAL_PARENT = 5;
    public static final int VAL_GUI = 6;
    private boolean m_bInvalidatedValue = false;
    public static final int VAL_CLONE = 7;
    private static String[] VALUE_TYPE_LOG = new String[]{"S_LOG_VAR_VALTYPE_CMD", "S_LOG_VAR_VALTYPE_RSP", "S_LOG_VAR_VALTYPE_CODEBLOCK", "S_LOG_VAR_VALTYPE_DEFAULT", "S_LOG_VAR_VALTYPE_CALC", "S_LOG_VAR_VALTYPE_PARENT", "S_LOG_VAR_VALTYPE_GUI", "S_LOG_VAR_VALTYPE_CLONE"};
    private static final String[] VALUE_TYPE = new String[]{"CMD", "RSP", "CODEBLOCK", "DEFAULT", "CALC", "PARENT", "GUI", "CLONE"};
    private static String LOG_VAR_RESOURCE = "S_LOG_SETTING_VAR_VALUE";
    private static String LOG_VAR_PROTECTED_RESOURCE = "S_LOG_PROTECTED_VALUE";
    private int m_nValueType = 3;
    private int m_nValueInputType = 3;
    private boolean m_bUserInput = true;
    private transient String m_nExtendsFrom = null;
    private transient boolean m_nPublish = false;
    private transient boolean m_nAllowAssignment = false;
    private transient boolean m_nHandleErrors = false;
    private transient boolean m_nShowInOSP = false;
    private transient boolean m_nValueReqd = false;
    private transient boolean m_nSuppressedOnSilent = true;
    private boolean m_bIsGlobalVar = false;
    private static boolean m_bLogRuntimeException = true;
    private int m_type = -1;

    public OiisVariable(OiisVariableOwner vo, String name) {
        this.m_owner = vo;
        this.m_name = name;
        this.m_childVarElems = new Vector();
        this.m_exported = false;
        this.m_type = -1;
        this.m_validationMethodPresent = true;
    }

    public void setValueInputType(int valueInputType) {
        this.m_nValueInputType = valueInputType;
    }

    public int getValueInputType() {
        return this.m_nValueInputType;
    }

    public String getValueTypeString() {
        if (this.m_owner != null && this.m_owner.getSession() != null && this.m_owner.getSession().isCloneMode()) {
            return VALUE_TYPE[this.m_nValueInputType];
        }
        return VALUE_TYPE[this.m_nValueType];
    }

    public static int getValueTypeInt(String type) {
        for (int i = 0; i < VALUE_TYPE.length; ++i) {
            if (!VALUE_TYPE[i].equals(type)) continue;
            return i;
        }
        new OiisVarSettingException(null, null, "An error has occured when trying map the string value of the variable input type read from context.xml to one of a predefined set. ").printStackTrace();
        return 3;
    }

    private boolean isUserInput() {
        return this.m_nValueInputType == 0 || this.m_nValueInputType == 1 || this.m_nValueInputType == 6;
    }

    public final void setExported(boolean exported) {
        this.m_exported = exported;
    }

    public final boolean getExported() {
        return this.m_exported;
    }

    public final boolean isValueSet() {
        return this.m_val != null;
    }

    public final String getName() {
        return this.m_name;
    }

    public final Object getValue() {
        return this.m_val;
    }

    public final Object getLogValue() {
        if (this.m_secure) {
            return OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE");
        }
        return this.m_val;
    }

    public void setResourceBundle(OiixJarResourceBundle rb) {
        this.m_rb = rb;
    }

    private String getResource(String key) {
        if (this.m_rb != null) {
            return this.m_rb.getString(key);
        }
        return key;
    }

    public String getDescription() {
        if (this.getDescriptionID() != null) {
            if (this.m_description == null) {
                OiisCompConstants oCompConstants = this.m_owner.getCompConstants();
                OiisGenericConstant oConst = oCompConstants.getConstant(this.getDescriptionID());
                this.m_description = oConst instanceof OiisPlatformSpecificConstant ? (String)((OiisPlatformSpecificConstant)oConst).getValue(OiixPlatform.getCurrentPlatform()) : (String)oConst.getValue();
            }
        } else {
            this.m_description = this.getResource(this.m_description);
        }
        return this.m_description;
    }

    private String getEnglishDescription() {
        if (this.getDescriptionID() != null) {
            if (this.m_description == null) {
                OiisCompConstants oCompConstants = this.m_owner.getCompConstants();
                OiisGenericConstant oConst = oCompConstants.getConstant(this.getDescriptionID());
                this.m_description = oConst instanceof OiisPlatformSpecificConstant ? (String)((OiisPlatformSpecificConstant)oConst).getValue(OiixPlatform.getCurrentPlatform()) : (String)oConst.getEnglishValue();
            }
        } else {
            this.m_description = this.getResource(this.m_description);
        }
        return this.m_description;
    }

    public String getCloneDescription() {
        return this.getCloneDescription(OiixLanguage.getDefaultLocale());
    }

    public String getCloneDescription(Locale locale) {
        String sDesc;
        if (this.m_hmCloneDesc == null) {
            return null;
        }
        Locale lang = OiixLanguage.getLocaleInstance(locale);
        if (lang == null) {
            lang = OiixLanguage.ENGLISH;
        }
        if ((sDesc = (String)this.m_hmCloneDesc.get(lang)) == null && !lang.equals(OiixLanguage.ENGLISH)) {
            sDesc = (String)this.m_hmCloneDesc.get(OiixLanguage.ENGLISH);
        }
        return sDesc;
    }

    public void setCloneDescription(String sDesc, Locale lang) {
        if (this.m_hmCloneDesc == null) {
            this.m_hmCloneDesc = new HashMap(2);
        }
        Locale locale = OiixLanguage.getLocaleInstance(lang);
        this.m_hmCloneDesc.put(locale, sDesc);
    }

    public HashMap getAllDescriptionTranslations() {
        HashMap<Locale, String> hmDescs = null;
        if (this.m_hmCloneDesc != null) {
            hmDescs = this.m_hmCloneDesc;
        } else {
            hmDescs = new HashMap<Locale, String>(2);
            Locale curLocale = OiixLanguage.getDefaultLocale();
            hmDescs.put(curLocale, this.getDescription());
            if (curLocale != OiixLanguage.ENGLISH) {
                hmDescs.put(OiixLanguage.ENGLISH, this.getEnglishDescription());
            }
        }
        return hmDescs;
    }

    public void setGenerateRSP(boolean bFlag) {
        this.m_bGenerateRSP = bFlag;
    }

    public boolean getGenerateRSP() {
        return this.m_bGenerateRSP;
    }

    public void setDescription(String sDesc) {
        this.m_description = sDesc;
    }

    public String getDescriptionID() {
        return this.m_descriptionID;
    }

    public void setDescriptionID(String descID) {
        this.m_descriptionID = descID;
    }

    public boolean isGlobalVar() {
        return this.m_bIsGlobalVar;
    }

    public void setGlobal(boolean bIsGlobal) {
        this.m_bIsGlobalVar = bIsGlobal;
    }

    public boolean isSecure() {
        return this.m_secure;
    }

    public void setSecure(boolean secure) {
        this.m_secure = secure;
    }

    public boolean isForceTranslate() {
        return this.m_forceTranslate;
    }

    public void setForceTranslate(boolean translate) {
        this.m_forceTranslate = translate;
    }

    public boolean isComputeAtClone() {
        return this.m_computeAtClone;
    }

    public int getTypeOfVariableInput() {
        return this.m_nValueType;
    }

    private void setComputeAtClone(boolean computeAtClone, boolean propagate) {
        boolean prevComputeAtClone = this.m_computeAtClone;
        this.m_computeAtClone = computeAtClone;
        if (propagate && this.m_computeAtClone && !prevComputeAtClone && this.m_owner.getSession().isCloneMode() && null != this.m_derivedVarNames && 0 != this.m_derivedVarNames.size()) {
            Enumeration edvn = this.getDerivedVarNames();
            if (null != edvn) {
                while (edvn.hasMoreElements()) {
                    OiisVariable v = this.m_owner.getVariable((String)edvn.nextElement());
                    if (null == v || v.isComputeAtClone()) continue;
                    v.setComputeAtClone(computeAtClone, propagate);
                }
            }
            this.m_derivedVarNames = null;
        }
    }

    public void setComputeAtClone(boolean computeAtClone) {
        this.setComputeAtClone(computeAtClone, false);
    }

    public Enumeration getDerivedVarNames() {
        return null == this.m_derivedVarNames ? null : this.m_derivedVarNames.elements();
    }

    public void setDerivedVarNames(Vector varNamesVector) {
        this.m_derivedVarNames = varNamesVector;
    }

    public void setCalcMethodPresent(boolean bFlag) {
        this.m_calcMethodPresent = bFlag;
    }

    public boolean isCalcMethodPresent() {
        return this.m_calcMethodPresent;
    }

    public void setValidationMethodPresent(boolean bFlag) {
        this.m_validationMethodPresent = bFlag;
    }

    public boolean isValidationMethodPresent() {
        return this.m_validationMethodPresent;
    }

    public void setProtected(boolean val) {
        this.m_bProtected = val;
    }

    public boolean isProtected() {
        return this.m_bProtected;
    }

    public final void setValueForAPIMode(Object val) throws OiisVarSettingException, OiifbCancelException {
        block2: {
            this.m_nValueType = 0;
            try {
                this.setValue(val, true);
            }
            catch (OiisVarSettingException vse) {
                if (!this.isValueReqd()) break block2;
                String sMsg = null;
                sMsg = OiixResourceBundle.getString("S_LOG_VAR_SETTING_EXCEPTION");
                Object[] args = new Object[]{this.m_name, vse.getMessage()};
                sMsg = MessageFormat.format(sMsg, args);
                OiiolTextLogger.appendText(sMsg);
            }
        }
    }

    public final void setValue(Object val) throws OiisVarSettingException, OiifbCancelException {
        this.m_nValueType = 2;
        this.setValue(val, true);
    }

    public void setValue(Object val, boolean bLog) throws OiisVarSettingException, OiifbCancelException {
        block3: {
            try {
                m_bLogRuntimeException = false;
                this.validateChildVariables(val);
                m_bLogRuntimeException = true;
            }
            catch (OiisVarSettingException vse) {
                m_bLogRuntimeException = true;
                this.setVarValue(val);
                if (!OiicPullSession.isDebugMode()) break block3;
                OiiolTextLogger.appendText(vse.getMessage());
                vse.printStackTrace();
            }
        }
        this.m_owner.getSession();
        if (this.m_nValueType != 3 && bLog || OiicPullSession.isDebugMode()) {
            this.logValue(val);
        }
        this.setVarValue(val);
    }

    protected void logValue(Object val) {
        if (val != null) {
            String sValue = null;
            sValue = !this.isProtected() && !this.isSecure() ? (val instanceof String[] ? OiiolTextLogger.StringArrayToStringBuf((String[])val).toString() : val.toString()) : OiixResourceBundle.getString(LOG_VAR_PROTECTED_RESOURCE);
            Object[] args = new Object[]{this.m_name, sValue, this.getValueTypeLogString()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString(LOG_VAR_RESOURCE, args), OiiolTextLogger.LOG_BASIC);
        }
    }

    private void debugBlock() {
    }

    private void setVarValue(Object val) throws OiisVarSettingException, OiifbCancelException {
        this.validate(val);
        this.setValueImpl(val);
        this.m_advice = true;
        if (s_varName != null) {
            this.debugBlock();
        }
    }

    public final void unsetValue() {
        this.setValueImpl(null);
        this.m_advice = true;
        if (s_varName != null) {
            this.debugBlock();
        }
    }

    public void setValueWithoutValidation(Object val) {
        this.setValueImpl(val);
    }

    public void setVariableValue(Object value) throws OiisVarSettingException {
        if (!this.checkObjectType(value)) {
            throw new OiisVarSettingException(this.m_owner, this, "Incorrect data type while setting variable: " + this.getName() + ". Expected: " + OiisDataTypes.findTypeWithID(this.getType()).getTypeClass() + ". Found: " + value.getClass());
        }
        this.setValueImpl(value);
    }

    public Object getVariableValue() {
        return this.m_val;
    }

    public final void setValue(OiisAdvisedValue val) throws OiisVarSettingException, OiifbCancelException {
        this.m_nValueType = 2;
        this.setValue(val, true);
    }

    public final void setValue(OiisAdvisedValue val, boolean bLog) throws OiisVarSettingException, OiifbCancelException {
        this.setValue(val.getValue(), bLog);
        this.m_advice = val.getAdvice();
        if (s_varName != null) {
            this.debugBlock();
        }
    }

    public final boolean getAdvice() {
        return this.m_advice;
    }

    public final void setAdvice(boolean adv) {
        this.m_advice = adv;
        if (s_varName != null) {
            this.debugBlock();
        }
    }

    public final OiisAdvisedValue getInitialValue() {
        return this.m_hcDef;
    }

    public final void setInitialValue(OiisAdvisedValue oVal) {
        this.m_hcDef = oVal;
    }

    public void validate(Object val) throws OiisVarSettingException, OiifbCancelException {
        if (val == null) {
            String sMsg = OiixResourceBundle.getString("S_LOG_VARIABLE_CANT_SETTO_NULL");
            Object[] sObj = new Object[]{this.getName()};
            sMsg = MessageFormat.format(sMsg, sObj);
            throw new OiisVarSettingException(this.m_owner, this, sMsg);
        }
        if (this.m_owner instanceof OiisCompContext && this.m_validationMethodPresent) {
            OiisCompContext mo = (OiisCompContext)this.m_owner;
            try {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
                    OiiolTextLogger.appendText("Validating variable :" + this.m_name + " , from install scripts");
                }
                mo.validate(this.m_name, val);
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
                    OiiolTextLogger.appendText("DONE Validating variable :" + this.m_name + " , from install scripts");
                }
            }
            catch (OiixRetryException re) {
                this.validate(val);
            }
            catch (RuntimeException re) {
                if (m_bLogRuntimeException) {
                    System.err.println("Runtime exception during validation of variable :" + this.getName());
                    re.printStackTrace();
                }
                Object[] msgArr = new Object[]{this.getName()};
                String exMsg = MessageFormat.format(OiixResourceBundle.getString("S_UNCAUGHT_RUNTIME_VARIABLE"), msgArr);
                exMsg = exMsg + " " + re.getMessage();
                throw new OiisVarSettingException(this.m_owner, this, exMsg);
            }
        }
    }

    public OiisAdvisedValue getCalculatedValue() throws OiisVarSettingException, OiifbCancelException {
        if (this.m_owner instanceof OiisCompContext) {
            OiisCompContext mo = (OiisCompContext)this.m_owner;
            try {
                return mo.getCalculatedValue(this.m_name);
            }
            catch (OiixRetryException oiixRetryException) {
                // empty catch block
            }
        }
        return null;
    }

    public final String getValueAsString() {
        return OiisDataTypes.getStringValue(this.m_val, OiisVariable.getTypeString(this.m_type));
    }

    public final Object getValueForDisplay() {
        String[] sl2;
        String[] sl1;
        if (this.m_val == null) {
            return this.defVal2;
        }
        if (this.m_val instanceof String[] && this.defVal1 instanceof String[] ? this.m_val != null && this.defVal1 != null && this.equalStringLists(sl1 = (String[])this.m_val, sl2 = (String[])this.defVal1) && this.defVal2 != null : this.m_val.equals(this.defVal1) && this.defVal2 != null) {
            return this.defVal2;
        }
        this.defVal1 = this.m_val;
        return this.defVal1;
    }

    private boolean equalStringLists(String[] sl1, String[] sl2) {
        boolean bEqualStringLists = true;
        if (sl1 == null || sl2 == null) {
            return false;
        }
        if (sl1.length != sl2.length) {
            return false;
        }
        for (int i = 0; i < sl1.length && i < sl2.length; ++i) {
            if (sl1[i].equals(sl2[i])) continue;
            bEqualStringLists = false;
            break;
        }
        return bEqualStringLists;
    }

    public final void setValueFromDisplay(Object v, boolean onlyBackup) throws OiisVarSettingException, OiifbCancelException {
        this.m_nValueType = 6;
        this.m_nValueInputType = 6;
        if (!onlyBackup) {
            this.setValue(v, false);
        }
        this.defVal2 = v;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj != null && obj instanceof OiisVariable) {
            return this.m_name.equals(((OiisVariable)obj).getName());
        }
        return false;
    }

    public void setChildVarElems(String sFileName, OiixJarClassLoader jcl) {
        this.m_childVarElems = this.loadChildVarElems(sFileName, jcl);
        if (this.m_childVarElems == null) {
            this.m_childVarElems = new Vector();
        }
    }

    public void setChildVarElem(OiisChildVarElem oChild) {
        if (this.m_childVarElems == null) {
            this.m_childVarElems = new Vector();
        }
        this.m_childVarElems.addElement(oChild);
    }

    public Enumeration getChildVarElems() {
        return this.m_childVarElems.elements();
    }

    protected void setChildVariables() {
        OiicPullSession pullSession = this.m_owner.getSession();
        if (this.m_childVarElems.isEmpty()) {
            return;
        }
        Enumeration e = this.m_childVarElems.elements();
        while (e.hasMoreElements()) {
            OiisChildVarElem elem = (OiisChildVarElem)e.nextElement();
            try {
                OiiiCompInstallID id = elem.getCompInstallID();
                OiiiStageInventory stageInv = pullSession.getSourceAccess().getStageInventory();
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)stageInv.getCompatCompEntry(id, 0, OiixPlatform.getCurrentPlatform());
                if (oEntry == null) continue;
                id = oEntry.getCompInstallID();
                Object val = this.getValue();
                if (val != null) {
                    String logTextStr = OiixResourceBundle.getString("S_LOG_SETTING_CHILDVAR") + elem.getChildVarName() + OiixResourceBundle.getString("S_LOG_OF") + id.getName() + " " + id.getVersion() + OiixResourceBundle.getString("S_LOG_TO");
                    logTextStr = !this.isProtected() && !this.isSecure() ? (val instanceof String[] ? logTextStr + OiiolTextLogger.StringArrayToStringBuf((String[])val).toString() : logTextStr + val.toString()) : logTextStr + OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE");
                    OiiolTextLogger.appendText(logTextStr, OiiolTextLogger.LOG_BASIC);
                }
                pullSession.bindVariable(id, elem.getChildVarName(), new OiisAdvisedValue(val, true), false);
            }
            catch (OiisVarSettingException vse) {
                OiiolTextLogger.appendText(vse.getMessage());
                if (!OiicPullSession.isDebugMode()) continue;
                vse.printStackTrace();
            }
            catch (OiifbCancelException ce) {
                ce.printStackTrace();
            }
        }
    }

    protected void validateChildVariables(Object value) throws OiisVarSettingException, OiifbCancelException {
        OiicPullSession pullSession = this.m_owner.getSession();
        if (this.m_childVarElems.isEmpty()) {
            return;
        }
        boolean cloneMode = this.m_owner.getSession().isCloneMode();
        Enumeration e = this.m_childVarElems.elements();
        while (e.hasMoreElements()) {
            OiisVariable childVar;
            OiisCompInstallation oCompInstall;
            OiisChildVarElem elem = (OiisChildVarElem)e.nextElement();
            OiiiCompInstallID id = elem.getCompInstallID();
            OiiiStageInventory stageInv = pullSession.getSourceAccess().getStageInventory();
            OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)stageInv.getCompatCompEntry(id, 0, OiixPlatform.getCurrentPlatform());
            if (oEntry == null || (oCompInstall = pullSession.getCompInstall(id = oEntry.getCompInstallID())) == null || (childVar = oCompInstall.getContext().getVariable(elem.getChildVarName())) == null) continue;
            childVar.validate(value);
            if (!cloneMode || !this.m_computeAtClone || childVar.isComputeAtClone()) continue;
            childVar.setComputeAtClone(this.m_computeAtClone, true);
        }
    }

    protected void unsetChildVariables() {
        OiicPullSession pullSession = this.m_owner.getSession();
        if (this.m_childVarElems.isEmpty()) {
            return;
        }
        OiiiStageInventory stageInv = pullSession.getSourceAccess().getStageInventory();
        Enumeration e = this.m_childVarElems.elements();
        while (e.hasMoreElements()) {
            OiisChildVarElem elem = (OiisChildVarElem)e.nextElement();
            OiiiCompInstallID id = elem.getCompInstallID();
            OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)stageInv.getCompatCompEntry(id, 0, OiixPlatform.getCurrentPlatform());
            if (oEntry == null) continue;
            id = oEntry.getCompInstallID();
            pullSession.unbindVariable(id, elem.getChildVarName());
        }
    }

    public Vector getChildCompIDs(String filename) {
        Vector retIDs = null;
        try {
            OiixJarClassLoader jcl = (OiixJarClassLoader)this.getClass().getClassLoader();
            InputStream is = jcl.getLocalResourceAsStream(filename);
            ObjectInputStream ois = new ObjectInputStream(is);
            retIDs = (Vector)ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            retIDs = null;
        }
        return retIDs;
    }

    public Vector getChildVarElems(String filename) {
        return this.loadChildVarElems(filename, (OiixJarClassLoader)this.m_owner.getClass().getClassLoader());
    }

    public Vector loadChildVarElems(String filename, OiixJarClassLoader jcl) {
        Vector retElems = null;
        try {
            InputStream is = jcl.getLocalResourceAsStream(filename);
            OiiiObjectInputStream ois = new OiiiObjectInputStream(is);
            retElems = (Vector)ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            retElems = null;
        }
        return retElems;
    }

    private boolean checkObjectType(Object val) {
        int nType = this.getType();
        return OiisDataTypes.checkObjectType(nType, val);
    }

    public void setVariable() throws OiifbCancelException, OiisVarSettingException {
        OiicPullSession session = this.m_owner.getSession();
        try {
            OiisAdvisedValue val = session.getVariableBinding(this.m_owner, this);
            try {
                this.validate(val);
            }
            catch (OiisVarSettingException vse) {
                if (this.m_owner.getSession().isCloneMode()) {
                    String sMsg = null;
                    sMsg = OiixResourceBundle.getString("S_LOG_VAR_SETTING_EXCEPTION");
                    Object[] args = new Object[]{this.m_name, vse.getMessage()};
                    sMsg = MessageFormat.format(sMsg, args);
                    OiiolTextLogger.appendText(sMsg);
                }
                if (OiicPullSession.isDebugMode()) {
                    vse.printStackTrace();
                }
                val = null;
            }
            if (val == null) {
                val = this.getCalculatedValue();
                if (val == null) {
                    val = this.getInitialValue();
                    if (val != null) {
                        this.m_nValueType = 3;
                    }
                } else {
                    this.m_nValueType = 4;
                }
            }
            if (val != null) {
                this.setValue(val, true);
            }
        }
        catch (OiisVarSettingException ve) {
            this.unsetValue();
            throw ve;
        }
    }

    public void setVariable(OiiiCompInstallID cid) throws OiifbCancelException, OiisVarSettingException, OiifbEndIterateException {
        this.setVariable(cid, null, false);
    }

    public void setVariable(OiiiCompInstallID cid, OiisCompContext ownerInstallContext, boolean useOldAlgorithm) throws OiifbCancelException, OiisVarSettingException, OiifbEndIterateException {
        OiisVariable installTimeVar;
        Object[] args;
        String sMsg;
        Object[] args2;
        String sMsg2;
        if (null != ownerInstallContext && this.m_owner.getSession().isCloneMode() && !this.m_computeAtClone && useOldAlgorithm) {
            OiisVariable installTimeVar2 = ownerInstallContext.getVariable(this.getName());
            if (null != installTimeVar2 && installTimeVar2.isValueSet()) {
                this.setValue(installTimeVar2.getValue(), true);
                this.setAdvice(true);
                return;
            }
            Object[] msgArr = new Object[]{this.getName()};
            String exMsg = MessageFormat.format(OiixResourceBundle.getString("S_UNCAUGHT_RUNTIME_VARIABLE"), msgArr);
            throw new OiisVarSettingException(this.m_owner, this, exMsg);
        }
        OiicPullSession session = this.m_owner.getSession();
        boolean bFirst = true;
        OiisAdvisedValue defVal = null;
        boolean bCommandLineLookup = false;
        OiisAdvisedValue val = OiisVariable.getValueFromCommandLine(cid, this.m_name);
        if (val != null) {
            bCommandLineLookup = true;
            this.m_nValueType = 0;
            this.m_nValueInputType = 0;
            if (this.getType() == 1 && !(val.getValue() instanceof String)) {
                val = new OiisAdvisedValue(val.getValue().toString(), val.getAdvice());
            }
        }
        if (val == null) {
            OiicAPIInstaller apiInstaller;
            Object apiVal = null;
            if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") && null != (apiInstaller = OiicAPIInstaller.getHandleToAPIInstaller())) {
                apiVal = this.m_name.equals("CLUSTER_NEW_NODES") ? OiixFunctionOps.explodeString(System.getProperty(this.m_name), ",") : (null == cid ? apiInstaller.getUnassignedVarValue(this.m_name) : apiInstaller.getUnassignedVarValue(cid.getName() + ":" + this.m_name));
            }
            if (apiVal != null) {
                val = new OiisAdvisedValue(apiVal, true);
                bCommandLineLookup = true;
                this.m_nValueType = 0;
                this.m_nValueInputType = 0;
            }
        }
        while (val != null || (val = this.getValueFromRF(cid, bFirst)) != null) {
            if (bCommandLineLookup) {
                bCommandLineLookup = false;
            } else {
                this.m_nValueType = 1;
                this.m_nValueInputType = 1;
                bFirst = false;
            }
            if (!this.checkObjectType(val.getValue())) {
                val = null;
                continue;
            }
            if (val.getAdvice()) {
                try {
                    this.setValue(val.getValue(), true);
                    break;
                }
                catch (OiisVarSettingException ve) {
                    this.unsetValue();
                    val = null;
                    sMsg2 = null;
                    if (OiicPullSession.isSilentMode()) {
                        sMsg2 = OiixResourceBundle.getString("S_LOG_VAR_SETTING_EXCEPTION");
                        args2 = new Object[]{this.m_name, ve.getMessage()};
                        sMsg2 = MessageFormat.format(sMsg2, args2);
                    } else {
                        sMsg2 = ve.getMessage();
                    }
                    OiiolTextLogger.appendText(sMsg2);
                    if (OiicPullSession.isDebugMode()) {
                        ve.printStackTrace();
                    }
                    if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true") && (this.m_nValueInputType == 1 || this.m_nValueInputType == 0)) {
                        OiifmAlert.displayError(sMsg2);
                        OiicExitCode.setExitCode(-2);
                        OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                        if (sSessionInterfaceManager != null) {
                            sSessionInterfaceManager.dispose();
                        }
                        throw new OiifbEndIterateException(ve.getMessage());
                    }
                    if (!this.m_owner.getSession().isCloneMode() && !System.getProperty("oracle.installer.silentVariableValidation", "false").toLowerCase().equals("true")) continue;
                    OiicExitCode.setExitCode(-2);
                    if (!OiicPullSession.isSilentMode()) {
                        OiifmAlert.displayError(sMsg2);
                    } else {
                        OiiolTextLogger.writeMessageToConsole("\n" + sMsg2);
                    }
                    throw new OiifbEndIterateException(ve);
                }
            }
            defVal = val;
            val = null;
            break;
        }
        if (val == null) {
            OiisAdvisedValue valFromParent = null;
            if (session != null && (valFromParent = session.getVariableBinding(this.m_owner, this)) != null) {
                if (valFromParent.getAdvice()) {
                    val = valFromParent;
                    this.m_nValueType = 5;
                    try {
                        this.setValue(val, true);
                    }
                    catch (OiisVarSettingException ve) {
                        if (this.m_owner.getSession().isCloneMode()) {
                            sMsg = null;
                            sMsg = OiixResourceBundle.getString("S_LOG_VAR_SETTING_EXCEPTION");
                            args = new Object[]{this.m_name, ve.getMessage()};
                            sMsg = MessageFormat.format(sMsg, args);
                            OiiolTextLogger.appendText(sMsg);
                        }
                        if (OiicPullSession.isDebugMode()) {
                            ve.printStackTrace();
                        }
                        this.unsetValue();
                        val = null;
                    }
                } else if (defVal == null) {
                    defVal = valFromParent;
                }
            }
        }
        if (val == null && this.m_owner != null && this.m_owner.getSession() != null && this.m_owner.getSession().isCloneMode() && null != ownerInstallContext && null != (installTimeVar = ownerInstallContext.getVariable(this.getName())) && installTimeVar.isValueSet() && installTimeVar.isUserInput()) {
            try {
                this.setValue(installTimeVar.getValue(), true);
                this.m_nValueType = installTimeVar.getTypeOfVariableInput();
                this.m_nValueInputType = installTimeVar.getValueInputType();
                this.setAdvice(true);
                return;
            }
            catch (OiisVarSettingException vse) {
                if (this.m_owner.getSession().isCloneMode()) {
                    sMsg = null;
                    sMsg = OiixResourceBundle.getString("S_LOG_VAR_SETTING_EXCEPTION");
                    args = new Object[]{this.m_name, vse.getMessage()};
                    sMsg = MessageFormat.format(sMsg, args);
                    OiiolTextLogger.appendText(sMsg);
                    if (OiicPullSession.isDebugMode()) {
                        vse.printStackTrace();
                    }
                }
                this.m_val = null;
            }
        }
        if (val == null && defVal != null) {
            val = defVal;
            try {
                this.setValue(val, true);
            }
            catch (OiisVarSettingException ve) {
                if (this.m_owner.getSession().isCloneMode()) {
                    sMsg2 = null;
                    sMsg2 = OiixResourceBundle.getString("S_LOG_VAR_SETTING_EXCEPTION");
                    args2 = new Object[]{this.m_name, ve.getMessage()};
                    sMsg2 = MessageFormat.format(sMsg2, args2);
                    OiiolTextLogger.appendText(sMsg2);
                }
                if (OiicPullSession.isDebugMode()) {
                    ve.printStackTrace();
                }
                this.unsetValue();
                val = null;
            }
            if (session != null && OiicPullSession.isSilentMode()) {
                this.setAdvice(true);
            }
        }
        if (val == null) {
            try {
                val = this.getCalculatedValue();
                if (val != null) {
                    this.m_nValueType = 4;
                }
            }
            catch (RuntimeException re) {
                if (m_bLogRuntimeException) {
                    System.err.println("Runtime exception during validation of variable :" + this.getName());
                    re.printStackTrace();
                }
                Object[] msgArr = new Object[]{this.getName()};
                String exMsg = MessageFormat.format(OiixResourceBundle.getString("S_UNCAUGHT_RUNTIME_VARIABLE"), msgArr);
                exMsg = exMsg + re.getMessage();
                throw new OiisVarSettingException(this.m_owner, this, exMsg);
            }
            if (val == null && (val = this.getInitialValue()) != null) {
                this.m_nValueType = 3;
            }
            if (val != null) {
                try {
                    this.setValue(val, true);
                    if (OiicPullSession.isSilentMode()) {
                        this.setAdvice(true);
                    }
                }
                catch (OiisVarSettingException ie) {
                    this.unsetValue();
                    throw ie;
                }
            }
        }
        if (null != ownerInstallContext && this.m_owner.getSession().isCloneMode()) {
            if (null != val) {
                this.setAdvice(true);
            } else {
                Object[] msgArr = new Object[]{this.getName()};
                String exMsg = MessageFormat.format(OiixResourceBundle.getString("S_UNCAUGHT_RUNTIME_VARIABLE"), msgArr);
                throw new OiisVarSettingException(this.m_owner, this, exMsg);
            }
        }
    }

    public static OiisAdvisedValue getValueFromCommandLine(OiiiCompInstallID cid, String sVariableName) {
        OiicBaseApp o_baseApp = OiicBaseApp.getBaseApp();
        if (o_baseApp == null) {
            return null;
        }
        Hashtable argsTable = o_baseApp.getCommandLineArgsTable();
        if (argsTable == null) {
            return null;
        }
        String[] varLookup = cid == null ? new String[]{"session:" + sVariableName, sVariableName} : new String[]{cid.getName() + ":" + cid.getVersion() + ":" + sVariableName, cid.getName() + ":" + sVariableName, sVariableName};
        String sValue = null;
        for (int i = 0; i < varLookup.length && (sValue = (String)argsTable.get(varLookup[i].toLowerCase())) == null; ++i) {
        }
        OiisAdvisedValue retval = null;
        if (sValue != null) {
            OiiozResponseFile valueValidator = new OiiozResponseFile();
            try {
                retval = (OiisAdvisedValue)valueValidator.validateValue(sVariableName, sValue, null);
            }
            catch (OiisInvalidValueException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    public static boolean isSpecifiedInCmdLine(String sVariableName, OiiiCompInstallID cid) {
        Hashtable argsTable;
        OiicBaseApp o_baseApp = OiicInstaller.getHandleToOiicInstaller();
        o_baseApp = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("false") ? OiicInstaller.getHandleToOiicInstaller() : OiicAPIInstaller.getHandleToAPIInstaller();
        if (o_baseApp == null) {
            o_baseApp = OiicBaseInventoryApp.getOiicBaseInventoryApp();
            if (o_baseApp == null) {
                o_baseApp = OiicBaseApp.getOiicBaseApp();
            }
            if (o_baseApp == null) {
                return false;
            }
        }
        if ((argsTable = o_baseApp.getCommandLineArgsTable()) == null) {
            return false;
        }
        String[] varLookup = cid == null ? new String[]{"session:" + sVariableName, sVariableName} : new String[]{cid.getName() + ":" + cid.getVersion() + ":" + sVariableName, cid.getName() + ":" + sVariableName, sVariableName};
        boolean retVal = false;
        String sValue = null;
        for (int i = 0; i < varLookup.length; ++i) {
            sValue = (String)argsTable.get(varLookup[i].toLowerCase());
            if (sValue == null || sValue.equals(STRING_DEFAULT)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private OiisAdvisedValue getValueFromRF(OiiiCompInstallID cid, boolean bFirst) {
        OiiozResponseFileManager rf = this.m_owner.getResponseFileManager();
        if (rf != null) {
            OiisAdvisedValue retval = rf.getValue(this.m_name, cid, bFirst);
            return retval;
        }
        return null;
    }

    public Object doQuery(OiiiLibraryID lid, String queryName, Vector inputs) throws OiifbCancelException {
        return ((OiisCompContext)this.m_owner).doQuery(lid, queryName, inputs);
    }

    public Object doQuery(OiiiLibraryID lid, String queryName, Vector inputs, Object defaultVal, OiilExceptionHandler[] queryExcHandlerArr) throws OiifbCancelException {
        return ((OiisCompContext)this.m_owner).doQuery(lid, queryName, inputs, defaultVal, queryExcHandlerArr);
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public int getType() {
        return this.m_type;
    }

    public static String getTypeString(int nType) {
        String sType = OiisDataTypes.STRING.getName();
        switch (nType) {
            case 1: {
                sType = OiisDataTypes.STRING.getName();
                break;
            }
            case 2: {
                sType = OiisDataTypes.NUMBER.getName();
                break;
            }
            case 3: {
                sType = OiisDataTypes.BOOL.getName();
                break;
            }
            case 4: {
                sType = OiisDataTypes.STRINGLIST.getName();
            }
        }
        return sType;
    }

    public void computeType() {
        if (this.m_type == -1 && this.m_val != null) {
            if (this.m_val.getClass().equals(OiisDataTypes.BOOL.getTypeClass())) {
                this.m_type = 3;
            } else if (this.m_val.getClass().equals(OiisDataTypes.NUMBER.getTypeClass())) {
                this.m_type = 2;
            } else if (this.m_val.getClass().equals(OiisDataTypes.STRING.getTypeClass())) {
                this.m_type = 1;
            } else if (this.m_val.getClass().equals(OiisDataTypes.STRINGLIST.getTypeClass())) {
                this.m_type = 4;
            }
        }
    }

    public void setAllValueList(String sVal) {
        this.m_sAllValsString = sVal;
    }

    public String getAllValueList() {
        return this.m_sAllValsString;
    }

    public static String instantiate(String sText, OiisVariableOwner vo) {
        return OiisIdentifierOps.instantiateString(sText, vo);
    }

    public int getValueType() {
        return this.m_nValueType;
    }

    public void invalidateValue() {
        this.m_bInvalidatedValue = true;
    }

    public boolean isInvalidatedValue() {
        return this.m_bInvalidatedValue;
    }

    public boolean isValueSetByUser() {
        return this.m_nValueType == 6 || this.m_nValueType == 1 || this.m_nValueType == 0;
    }

    public boolean isValueFromCloneXML() {
        return this.m_nValueType == 7;
    }

    public void setSecureVariableTypeFromCloneXML(boolean bUserInput) {
        if (bUserInput) {
            this.m_nValueType = 7;
        }
    }

    public void setUserInputFromCloneXML(boolean bUserInput) {
        this.m_bUserInput = bUserInput;
    }

    public boolean getUserInputFromCloneXML() {
        return this.m_bUserInput;
    }

    public void setValueTypeAsCloneXML() {
        this.m_nValueType = 7;
    }

    public String getValueTypeLogString() {
        return OiixResourceBundle.getString(VALUE_TYPE_LOG[this.m_nValueType]);
    }

    private void setValueImpl(Object val) {
        this.m_val = val instanceof String ? OiisDataTypes.getValueObject((String)val, OiisVariable.getTypeString(this.m_type)) : val;
        this.m_bInvalidatedValue = false;
    }

    public String toString() {
        return "name:" + this.getName() + ":val:" + this.m_val + ":advice:" + this.getAdvice() + ":invalid:" + this.isInvalidatedValue() + ":isValueSet:" + this.isValueSet();
    }

    public void setExtendsFrom(String sExtendsFrom) {
        this.m_nExtendsFrom = sExtendsFrom;
    }

    public String getExtendsFrom() {
        if (this.m_nExtendsFrom == null) {
            this.m_nExtendsFrom = STRING_DEFAULT;
        }
        return this.m_nExtendsFrom;
    }

    public void setPublish(boolean bPublish) {
        this.m_nPublish = bPublish;
    }

    public boolean isPublish() {
        return this.m_nPublish;
    }

    public void setAllowAssignment(boolean bAllowAssignment) {
        this.m_nAllowAssignment = bAllowAssignment;
    }

    public boolean isAllowAssignment() {
        return this.m_nAllowAssignment;
    }

    public void setHandleErrors(boolean bHandleErrors) {
        this.m_nHandleErrors = bHandleErrors;
    }

    public boolean isHandleErrors() {
        return this.m_nHandleErrors;
    }

    public void setShowInOSP(boolean bShowInOSP) {
        this.m_nShowInOSP = bShowInOSP;
    }

    public boolean isShowInOSP() {
        return this.m_nShowInOSP;
    }

    public void setValueReqd(boolean bValueReqd) {
        this.m_nValueReqd = bValueReqd;
    }

    public boolean isValueReqd() {
        return this.m_nValueReqd;
    }

    public void setSuppressedOnSilent(boolean bSuppress) {
        this.m_nSuppressedOnSilent = bSuppress;
    }

    public boolean isSuppressedOnSilent() {
        return this.m_nSuppressedOnSilent;
    }
}

