/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.Vector;
import oracle.sysman.oii.oiis.OiisDepMode;

public class OiisSingleSize {
    static final long serialVersionUID = 3680346486784692890L;
    private Long m_nSize;
    private Integer m_nPlat;
    private Vector m_oLang;
    private Integer m_nDepMode;
    private String m_sDepMode;
    private long[] m_alSizes;
    private Long m_lFileGrpJarSz;

    public OiisSingleSize(Integer nPlat, Vector oLang, Long nSize) {
        this.m_nPlat = nPlat;
        this.m_oLang = oLang;
        this.m_nSize = nSize;
        this.m_lFileGrpJarSz = new Long(0L);
    }

    public OiisSingleSize(Integer nPlat, Vector oLang, Integer nDepMode, Long nSize) {
        this.m_nPlat = nPlat;
        this.m_oLang = oLang;
        this.m_nSize = nSize;
        this.m_nDepMode = nDepMode;
    }

    public OiisSingleSize(Integer nPlat, Vector oLang, String sDepMode, Long nSize) {
        this.m_nPlat = nPlat;
        this.m_oLang = oLang;
        this.m_nSize = nSize;
        this.m_sDepMode = sDepMode;
        this.m_nDepMode = new Integer(0);
    }

    public OiisSingleSize(Integer nPlat, String sDepMode, long[] alSizes) {
        this.m_nPlat = nPlat;
        this.m_sDepMode = sDepMode;
        this.m_alSizes = alSizes;
        this.m_lFileGrpJarSz = new Long(0L);
        this.m_oLang = null;
        this.m_nSize = null;
        this.m_nDepMode = null;
    }

    public void setSize(Long nSize) {
        this.m_nSize = nSize;
    }

    public long getLargestFileGroupJarSize() {
        if (this.m_lFileGrpJarSz == null) {
            return 0L;
        }
        return this.m_lFileGrpJarSz;
    }

    public void updateLargestFileGroupJarSize(long lSz) {
        if (lSz > this.m_lFileGrpJarSz) {
            this.m_lFileGrpJarSz = new Long(lSz);
        }
    }

    public void updateSize(long[] alSizes) {
        int i;
        long[] alTmpSizes = this.m_alSizes;
        if (this.m_alSizes == null) {
            this.m_alSizes = new long[alSizes.length];
            for (i = 0; i < this.m_alSizes.length; ++i) {
                this.m_alSizes[i] = 0L;
            }
        } else if (alSizes.length > this.m_alSizes.length) {
            this.m_alSizes = new long[alSizes.length];
            for (i = 0; i < alTmpSizes.length - 1; ++i) {
                this.m_alSizes[i] = alTmpSizes[i];
            }
            for (i = alTmpSizes.length - 1; i < this.m_alSizes.length - 1; ++i) {
                this.m_alSizes[i] = 0L;
            }
            this.m_alSizes[this.m_alSizes.length - 1] = alTmpSizes[alTmpSizes.length - 1];
        }
        for (i = 0; i < alSizes.length; ++i) {
            int n = i;
            this.m_alSizes[n] = this.m_alSizes[n] + alSizes[i];
        }
    }

    public Long getSize() {
        if (this.m_nSize != null) {
            return this.m_nSize;
        }
        if (this.m_alSizes != null) {
            long lSize = 0L;
            for (int i = 0; i < this.m_alSizes.length; ++i) {
                lSize += this.m_alSizes[i];
            }
            return new Long(lSize);
        }
        return new Long(0L);
    }

    public long[] getSizes() {
        return this.m_alSizes;
    }

    public Vector getLanguages() {
        return this.m_oLang;
    }

    public Integer getPlatform() {
        return this.m_nPlat;
    }

    public Integer getDepMode() {
        return this.m_nDepMode;
    }

    public String getDepModeName() {
        if (this.m_sDepMode == null) {
            this.m_sDepMode = OiisDepMode.getInternalNameForID(this.m_nDepMode);
        }
        return this.m_sDepMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null) {
            OiisSingleSize other;
            if (o instanceof OiisSingleSize && (other = (OiisSingleSize)o).getPlatform().equals(this.m_nPlat) && other.getDepModeName().equals(this.getDepModeName())) {
                return true;
            }
            return super.equals(o);
        }
        return false;
    }

    public String toString() {
        return this.m_nDepMode.toString() + " : " + this.m_nPlat.toString() + ": " + this.m_alSizes;
    }
}

