/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisCompActions;
import oracle.sysman.oii.oiis.OiisMakeConfig;
import oracle.sysman.oii.oiis.OiisMakeDeps;
import oracle.sysman.oii.oiis.OiisRelinkInfo;
import oracle.sysman.oii.oiis.OiisTargetStructure;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisRelinkActions
extends OiisCompActions {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private static List m_commandTable = new ArrayList(5);
    private static long m_totalBytes;
    private static OiicInstallTimeSession m_installTimeSession;
    private static Hashtable m_ohCommandTables;
    private static ArrayList m_writeXMLTable;
    private static int m_nCount;

    public static void setInstTimeSession(OiicInstallTimeSession session) {
        m_installTimeSession = session;
    }

    public static void add(OiisRelinkInfo newInfo) {
        if (m_installTimeSession != null) {
            String sBackedUpName;
            int iHomeIdx;
            ArrayList<OiisRelinkInfo> commandTable;
            if (m_ohCommandTables == null) {
                m_ohCommandTables = new Hashtable();
            }
            if ((commandTable = (ArrayList<OiisRelinkInfo>)m_ohCommandTables.get(new Integer(iHomeIdx = m_installTimeSession.getOHIndex()))) == null) {
                commandTable = new ArrayList<OiisRelinkInfo>();
                m_ohCommandTables.put(new Integer(iHomeIdx), commandTable);
            }
            if (OiixVectorOps.vectIndexOf(commandTable, (Object)newInfo) == -1) {
                if (newInfo.isBackUpMakeFile()) {
                    sBackedUpName = OiisRelinkActions.backupFile(newInfo.getMakeFileName());
                    newInfo.setBackedUpName(sBackedUpName);
                }
                commandTable.add(newInfo);
            }
            if (newInfo.isBackUpMakeFile()) {
                sBackedUpName = OiisRelinkActions.backupFile(newInfo.getMakeFileName());
                newInfo.setBackedUpName(sBackedUpName);
            }
            ArrayList ret = OiisMakeDeps.retrieveFromHash(new Integer(iHomeIdx));
            OiisMakeDeps.setTable(ret);
            OiisMakeDeps.registerForMake(newInfo);
            OiisMakeDeps.storeInHash(iHomeIdx);
            OiisMakeDeps.clearCommandTable();
        } else {
            String sBackedUpName;
            if (OiixVectorOps.vectIndexOf(m_commandTable, (Object)newInfo) == -1) {
                if (newInfo.isBackUpMakeFile()) {
                    sBackedUpName = OiisRelinkActions.backupFile(newInfo.getMakeFileName());
                    newInfo.setBackedUpName(sBackedUpName);
                }
                m_commandTable.add(newInfo);
            }
            if (newInfo.isBackUpMakeFile()) {
                sBackedUpName = OiisRelinkActions.backupFile(newInfo.getMakeFileName());
                newInfo.setBackedUpName(sBackedUpName);
            }
            OiisMakeDeps.registerForMake(newInfo);
        }
    }

    public static void addTarget(OiisRelinkInfo newInfo) {
        if (m_installTimeSession != null) {
            if (newInfo.isBackUpMakeFile()) {
                String sBackedUpName = OiisRelinkActions.backupFile(newInfo.getMakeFileName());
                newInfo.setBackedUpName(sBackedUpName);
            }
            int iHomeIdx = m_installTimeSession.getOHIndex();
            ArrayList ret = OiisMakeDeps.retrieveFromHash(new Integer(iHomeIdx));
            OiisMakeDeps.setTable(ret);
            OiisMakeDeps.registerTargetForMake(newInfo);
            OiisMakeDeps.storeInHash(iHomeIdx);
            OiisMakeDeps.clearCommandTable();
        } else {
            if (newInfo.isBackUpMakeFile()) {
                String sBackedUpName = OiisRelinkActions.backupFile(newInfo.getMakeFileName());
                newInfo.setBackedUpName(sBackedUpName);
            }
            OiisMakeDeps.registerTargetForMake(newInfo);
        }
    }

    public static void remove(OiisRelinkInfo newInfo) {
        if (m_installTimeSession != null) {
            ArrayList commandTable;
            int pos;
            int iHomeIdx = m_installTimeSession.getOHIndex();
            if (m_ohCommandTables != null && (pos = OiixVectorOps.vectIndexOf(commandTable = (ArrayList)m_ohCommandTables.get(new Integer(iHomeIdx)), (Object)newInfo)) != -1) {
                commandTable.remove(pos);
            }
        } else {
            int pos = OiixVectorOps.vectIndexOf(m_commandTable, (Object)newInfo);
            if (pos != -1) {
                m_commandTable.remove(pos);
            }
        }
    }

    public List getAll() {
        if (m_installTimeSession != null) {
            ArrayList commandTable = null;
            int iHomeIdx = m_installTimeSession.getOHIndex();
            if (m_ohCommandTables != null) {
                commandTable = (ArrayList)m_ohCommandTables.get(new Integer(iHomeIdx));
            }
            return commandTable;
        }
        return m_commandTable;
    }

    public static void removeAll() {
        if (m_installTimeSession != null) {
            int iHomeIdx = m_installTimeSession.getOHIndex();
            if (m_ohCommandTables != null) {
                ArrayList commandTable = (ArrayList)m_ohCommandTables.get(new Integer(iHomeIdx));
                commandTable.clear();
            }
        } else {
            m_commandTable.clear();
        }
    }

    private static String backupFile(String sMakeFile) {
        String sBackedupName = sMakeFile;
        File f = new File(sMakeFile);
        if (f.getParent() != null) {
            try {
                sBackedupName = OiisRelinkActions.getBackupFileName(sMakeFile, OiisRelinkActions.getTempLoc());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sBackedupName;
    }

    private static String getBackupFileName(String sOrigFile, String sRoot) {
        File tempF;
        boolean exists = false;
        String tempPath = null;
        do {
            tempF = new File(sRoot, "Makefile" + m_nCount++);
            tempPath = tempF.getPath();
        } while (exists = tempF.exists());
        try {
            OiixFileOps.copyFile(sOrigFile, tempPath, true);
        }
        catch (IOException iOException) {
        }
        catch (OiifbCancelException oiifbCancelException) {
            // empty catch block
        }
        return tempPath;
    }

    private static String getTempLoc() {
        return System.getProperty("oracle.installer.scratchPath");
    }

    @Override
    public void init(OiicInstallTimeSession instSession) {
        super.init(instSession);
    }

    @Override
    public void stateChangeActions() throws OiilActionException, OiifbCancelException, OiisVarSettingException {
    }

    public void writeToXML(ArrayList retLst) {
        ArrayList<OiisTargetStructure> actions = new ArrayList<OiisTargetStructure>();
        int nLinks = retLst == null ? 0 : retLst.size();
        for (int i = 0; i < nLinks; ++i) {
            OiisRelinkInfo linkInfo = (OiisRelinkInfo)retLst.get(i);
            actions.add(new OiisTargetStructure(linkInfo));
        }
        OiisMakeConfig mc = new OiisMakeConfig();
        mc.saveToFile(actions);
    }

    public void doReLinkGroupByOH() throws OiifbCancelException {
        Enumeration homes = m_ohCommandTables.keys();
        while (homes.hasMoreElements()) {
            Integer hIdx = (Integer)homes.nextElement();
            int intVal = hIdx;
            ArrayList commandTable = null;
            if (this.m_instTimeSession instanceof OiicDeinstallSession) {
                ((OiicDeinstallSession)this.m_instTimeSession).setOHIndex(intVal);
            }
            commandTable = (ArrayList)m_ohCommandTables.get(hIdx);
            OiisMakeDeps.setTable(OiisMakeDeps.retrieveFromHash(new Integer(intVal)));
            ArrayList table = new ArrayList(OiisMakeDeps.getSelectedTargets());
            if (commandTable == null) continue;
            this.doReLinkFromTable(table, false);
        }
        m_ohCommandTables = null;
    }

    private void doReLinkFromTable(List commandTable, boolean bWriteFlag) throws OiifbCancelException {
        OiiiLibraryID lid = OiicInstallSession.getCurrentPlatformLinkLibraryID();
        String actionName = "make";
        String MAKEFLAGS = "MAKEFLAGS";
        int nLinks = commandTable.size();
        ArrayList<OiisRelinkInfo> retLst = new ArrayList<OiisRelinkInfo>();
        for (int i = 0; i < nLinks; ++i) {
            boolean bBackup;
            OiisRelinkInfo linkInfo = (OiisRelinkInfo)commandTable.get(i);
            Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>(8);
            String installMakePath = linkInfo.getMakePath();
            String installMakeFileName = linkInfo.getMakeFileName();
            String installTarget = linkInfo.getTarget();
            String[] installArguments = linkInfo.getArguments();
            String[] paramArguments = linkInfo.getParamArguments();
            String logFile = linkInfo.getLogFileName();
            String actionType = linkInfo.getActionType();
            OiiiCompInstallID cid = linkInfo.getCID();
            ArrayList cidList = linkInfo.getCIDList();
            boolean bDelete = bBackup = linkInfo.isBackUpMakeFile();
            if (bBackup) {
                String parentDir;
                File f = new File(installMakeFileName);
                if (f.exists()) {
                    bDelete = false;
                }
                if ((parentDir = f.getParent()) != null) {
                    File fParent = new File(parentDir);
                    OiixFileOps.mkdirs(fParent);
                }
                try {
                    OiixFileOps.copyFile(linkInfo.getBackedUpName(), installMakeFileName, true);
                }
                catch (IOException fParent) {
                    // empty catch block
                }
                if (!f.exists()) continue;
            }
            boolean bConsolidateTargets = true;
            while (bConsolidateTargets) {
                if (i < nLinks - 1) {
                    OiisRelinkInfo linkInfo2 = (OiisRelinkInfo)commandTable.get(i + 1);
                    if (this.canConsolidateTargets(linkInfo, linkInfo2)) {
                        installTarget = installTarget + " " + linkInfo2.getTarget();
                        ++i;
                        continue;
                    }
                    bConsolidateTargets = false;
                    continue;
                }
                bConsolidateTargets = false;
            }
            OiisRelinkInfo re = new OiisRelinkInfo();
            OiilActionInputElement aie = new OiilActionInputElement("registerOnly", Boolean.FALSE);
            inputs.addElement(aie);
            aie = new OiilActionInputElement("installMakePath", installMakePath);
            inputs.addElement(aie);
            re.setMakePath(installMakePath);
            aie = new OiilActionInputElement("installMakeFileName", installMakeFileName);
            inputs.addElement(aie);
            re.setMakeFileName(installMakeFileName);
            aie = new OiilActionInputElement("installTarget", installTarget);
            inputs.addElement(aie);
            re.setTarget(installTarget);
            re.setActionType(actionType);
            re.setCIDList(cidList);
            re.setParamArguments(paramArguments);
            aie = new OiilActionInputElement("undoMakeFileName", "");
            inputs.addElement(aie);
            String makeFlags = System.getProperty("oracle.installer.makeflags", null);
            if (makeFlags != null) {
                if (installArguments == null) {
                    installArguments = new String[]{};
                }
                int len = installArguments.length;
                String[] temp = new String[len + 1];
                System.arraycopy(installArguments, 0, temp, 0, len);
                temp[len] = MAKEFLAGS + "=" + makeFlags;
                installArguments = temp;
            }
            aie = new OiilActionInputElement("installArguments", installArguments);
            inputs.addElement(aie);
            re.setArguments(installArguments);
            aie = new OiilActionInputElement("logFile", logFile);
            inputs.addElement(aie);
            aie = new OiilActionInputElement("undoTarget", "");
            inputs.addElement(aie);
            aie = new OiilActionInputElement("progMsg", linkInfo.getProgMsg());
            inputs.addElement(aie);
            retLst.add(re);
            try {
                System.setProperty("oracle.installer.handleExitForRegisterForMake", "true");
                this.doActionImpl(lid, actionName, inputs, null, true, true, true);
            }
            catch (OiilActionException len) {
                // empty catch block
            }
            if (!bDelete) continue;
            File f = new File(installMakeFileName);
            File fParent = new File(f.getParent());
            f.delete();
            fParent.delete();
        }
        try {
            if (bWriteFlag) {
                this.writeToXML(retLst);
            }
        }
        catch (Exception e) {
            String sMsg = e.getMessage();
            OiiolTextLogger.appendText(sMsg);
        }
        OiisRelinkActions.removeAll();
    }

    public void doReLink() throws OiifbCancelException {
        this.doReLinkFromTable(OiisMakeDeps.getSelectedTargets(), true);
        OiisMakeDeps.clearCommandTable();
    }

    private boolean canConsolidateTargets(OiisRelinkInfo oLinkInfo1, OiisRelinkInfo oLinkInfo2) {
        String[] asArgs1 = oLinkInfo1.getArguments();
        String[] asArgs2 = oLinkInfo2.getArguments();
        return OiipgFileSystem.equalPathStrs(oLinkInfo1.getMakePath(), oLinkInfo2.getMakePath()) && OiipgFileSystem.equalPathStrs(oLinkInfo1.getMakeFileName(), oLinkInfo2.getMakeFileName()) && (asArgs1 == null && asArgs2 == null || asArgs1 != null && asArgs2 != null && asArgs1.length == asArgs2.length) && OiipgFileSystem.equalPathStrs(oLinkInfo1.getLogFileName(), oLinkInfo2.getLogFileName()) && oLinkInfo1.isBackUpMakeFile() == oLinkInfo2.isBackUpMakeFile();
    }

    public static int getCount() {
        return m_commandTable.size();
    }

    public static void setTotalBytes(long totalBytes) {
        m_totalBytes = totalBytes;
    }

    static {
        m_installTimeSession = null;
        m_ohCommandTables = null;
        m_writeXMLTable = new ArrayList();
        m_nCount = 0;
    }
}

