/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.MissingResourceException;
import oracle.sysman.oii.oiii.OiiiReadmeID;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiisReadmeDetails {
    static final long serialVersionUID = 810308377396792619L;
    OiiiReadmeID m_readmeID;
    String m_externalName;
    String m_description;
    String m_location;
    int m_type;
    String m_preferredDisplayTool;
    boolean m_applicableOnAllPlatforms = true;
    transient boolean m_notApplicableOnThisPlatform = false;
    int[] m_setOfPlatforms;
    String m_visibilityCheckVariable;
    transient OiixJarResourceBundle m_resBundle;
    public static final int NATIVE_TOOL = 0;
    public static final int INSTALLER_GUI = 1;

    public OiisReadmeDetails(OiiiReadmeID readmeID, String externalName, String description, String location, int type) {
        this(readmeID, externalName, description, location, type, "");
    }

    public OiisReadmeDetails(OiiiReadmeID readmeID, String externalName, String description, String location, int type, String preferredDisplayTool) {
        this.m_readmeID = readmeID;
        this.m_externalName = externalName;
        this.m_description = description;
        this.m_location = location;
        this.m_type = type;
        this.m_preferredDisplayTool = preferredDisplayTool;
        this.m_applicableOnAllPlatforms = true;
        this.m_notApplicableOnThisPlatform = false;
    }

    public void setPlatforms(int[] a) {
        int size = a.length;
        this.m_setOfPlatforms = new int[size];
        this.m_applicableOnAllPlatforms = false;
        for (int i = 0; i < size; ++i) {
            this.m_setOfPlatforms[i] = a[i];
        }
    }

    public int[] getPlatforms() {
        return this.m_setOfPlatforms;
    }

    public boolean isApplicableOnAllPlatforms() {
        return this.m_applicableOnAllPlatforms;
    }

    public boolean isApplicableOnThisPlatform() {
        if (this.isApplicableOnAllPlatforms()) {
            return true;
        }
        this.m_notApplicableOnThisPlatform = true;
        int currPlat = OiixPlatform.getCurrentPlatform();
        int size = this.m_setOfPlatforms.length;
        for (int i = 0; i < size; ++i) {
            if (currPlat != this.m_setOfPlatforms[i]) continue;
            this.m_notApplicableOnThisPlatform = false;
        }
        return !this.m_notApplicableOnThisPlatform;
    }

    public void setBundle(OiixJarResourceBundle res) {
        this.m_resBundle = res;
    }

    public int getType() {
        return this.m_type;
    }

    public OiiiReadmeID getReadmeID() {
        return this.m_readmeID;
    }

    public String getExternalName() {
        if (this.m_resBundle == null) {
            return this.m_externalName;
        }
        try {
            String ret = this.m_resBundle.getString(this.m_externalName);
            return ret;
        }
        catch (MissingResourceException e) {
            return this.m_externalName;
        }
    }

    public String getExternalNameID() {
        return this.m_externalName;
    }

    public String getDescription() {
        if (this.m_resBundle == null) {
            return this.m_description;
        }
        try {
            String ret = this.m_resBundle.getString(this.m_description);
            return ret;
        }
        catch (MissingResourceException e) {
            return this.m_description;
        }
    }

    public String getDescriptionID() {
        return this.m_description;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String s) {
        this.m_location = new String(s);
    }

    public void setPreferredDisplayTool(String s) {
        this.m_preferredDisplayTool = s;
    }

    public String getPreferredDisplayTool() {
        return this.m_preferredDisplayTool;
    }

    public void setVisibilityCheckVariable(String s) {
        this.m_visibilityCheckVariable = s;
    }

    public String getVisibilityCheckVariable() {
        return this.m_visibilityCheckVariable;
    }
}

