/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.text.MessageFormat;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRetryException;

public class OiisProdHomeVar
extends OiisVariable {
    protected OiisCompContext component;
    private OiiiCompInstallID m_oID;
    private boolean m_bEditable = true;
    private static String LOG_VAR_RESOURCE_PRODHOME = "S_LOG_SETTING_PRODHOME_VAR_VALUE";
    private boolean m_bProdHomeSpecified = true;

    public OiisProdHomeVar() {
        super(null, "PROD_HOME");
        this.setComputeAtClone(true);
    }

    public void setOwner(OiisVariableOwner owner) {
        this.m_owner = owner;
        this.component = (OiisCompContext)owner;
    }

    public void init(OiisVariableOwner owner, OiiiCompInstallID id, OiicInstallSession oSession) {
        this.init(owner, id, (OiicPullSession)oSession);
    }

    public void init(OiisVariableOwner owner, OiiiCompInstallID id, OiicPullSession oSession) {
        this.m_owner = owner;
        this.component = new OiisCompContext();
        this.component.setParContext(owner);
        this.component.init(id, oSession);
        if (id.isOracleHomeComp()) {
            this.setEditable(false);
        }
        this.m_oID = id;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setEditable(boolean bVal) {
        this.m_bEditable = bVal;
    }

    private OiisAdvisedValue getDefProdHome() {
        OiiiCompInstallID id = this.m_oID;
        if (id == null) {
            id = this.component.getCompInstallID();
        }
        OiisVariable oh = this.component.getVariable("ORACLE_HOME");
        String sProdHome = (String)oh.getValue();
        sProdHome = OiixPathOps.getStandardForm(sProdHome);
        sProdHome = OiixPathOps.directorify(sProdHome);
        sProdHome = sProdHome + id.getName();
        sProdHome = OiixPathOps.getAbsolutePath(sProdHome);
        sProdHome = OiixPathOps.getNativeForm(sProdHome);
        return new OiisAdvisedValue(sProdHome, false);
    }

    @Override
    public OiisAdvisedValue getCalculatedValue() throws OiisVarSettingException, OiifbCancelException {
        if (this.isCalcMethodPresent()) {
            try {
                return this.component.getCalculatedValue(this.getName());
            }
            catch (OiixRetryException re) {
                return this.getDefProdHome();
            }
        }
        return this.getDefProdHome();
    }

    @Override
    public void validate(Object val) throws OiisVarSettingException, OiifbCancelException {
        String sProdHome = (String)val;
        try {
            super.validate(val);
        }
        catch (OiisVarSettingException exp) {
            Object[] msgArr = new String[]{OiixResourceBundle.getString("S_PATH_EMPTY")};
            String sError = MessageFormat.format(OiixResourceBundle.getString("S_PROD_HOME"), msgArr);
            throw new OiisVarSettingException(this.m_owner, this, sError);
        }
        try {
            sProdHome = OiipgFileSystem.validatePath(sProdHome);
        }
        catch (OiipgPathException pg) {
            Object[] msgArr = new String[]{pg.getMessage()};
            String sError = MessageFormat.format(OiixResourceBundle.getString("S_PROD_HOME"), msgArr);
            throw new OiisVarSettingException(this.m_owner, this, sError);
        }
        OiiiCompInstallID id = this.m_oID;
        if (id == null) {
            this.m_oID = id = this.component.getCompInstallID();
        }
        if (id.isOracleHomeComp()) {
            String sOracleHome = (String)this.component.getVariable("ORACLE_HOME").getValue();
            OiipgFileSystem pgf = new OiipgFileSystem();
            File oh = new File(sOracleHome);
            if (!(sOracleHome = oh.getAbsolutePath()).endsWith(File.separator)) {
                sOracleHome = sOracleHome + File.separator;
            }
            if (!pgf.isCaseSensitive()) {
                sOracleHome = sOracleHome.toUpperCase();
                sProdHome = sProdHome.toUpperCase();
            }
            if (!sProdHome.endsWith(File.separator)) {
                sProdHome = sProdHome + File.separator;
            }
            if (!sProdHome.startsWith(sOracleHome)) {
                String sError = OiixResourceBundle.getString("S_PROD_HOME_ORACLE");
                Object[] obj = new Object[]{sProdHome, sOracleHome};
                sError = MessageFormat.format(sError, obj);
                throw new OiisVarSettingException(this.m_owner, this, sError);
            }
        } else {
            try {
                sProdHome = OiipgFileSystem.checkWritablePath(sProdHome);
            }
            catch (OiipgPathException exp) {
                Object[] msgArr = new String[]{exp.getMessage()};
                String sError = MessageFormat.format(OiixResourceBundle.getString("S_PROD_HOME"), msgArr);
                throw new OiisVarSettingException(this.m_owner, this, sError);
            }
        }
        try {
            this.component.validate(this.getName(), val);
        }
        catch (OiixRetryException re) {
            this.validate(val);
        }
    }

    public void computeVarValue(OiiiCompInstallID cid) throws OiifbCancelException {
        try {
            this.setVariable(cid);
        }
        catch (OiifbCancelException ce) {
            throw ce;
        }
        catch (OiifbEndIterateException ce) {
        }
        catch (OiisVarSettingException vse) {
            OiiolTextLogger.appendText(cid.getName() + " " + vse.getMessage());
            this.unsetValue();
        }
        this.fixValue(cid);
    }

    private void fixValue(OiiiCompInstallID cid) {
        try {
            String sProdHome = (String)this.getValue();
            if (sProdHome == null || sProdHome.trim().length() == 0) {
                sProdHome = (String)this.getDefProdHome().getValue();
                this.setValue(sProdHome, false);
            }
            sProdHome = OiixPathOps.unEscape(sProdHome);
            sProdHome = OiixPathOps.getUnexpandedCanonicalPath(sProdHome);
            sProdHome = OiixPathOps.getNativeForm(sProdHome);
            this.setValueWithoutValidation(sProdHome);
        }
        catch (OiisVarSettingException vse) {
            OiiolTextLogger.appendText(cid.getName() + " " + vse.getMessage());
        }
        catch (OiifbCancelException ce) {
            OiiolTextLogger.appendText(cid.getName() + " " + ce.getMessage());
        }
    }

    @Override
    protected void logValue(Object val) {
        if (val != null && this.isCalcMethodPresent() && this.isProdHomeSpecified()) {
            String sValue = val.toString();
            Object[] args = new Object[]{this.m_oID.getName(), this.m_oID.getVersion().toString(), sValue, this.getValueTypeLogString()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString(LOG_VAR_RESOURCE_PRODHOME, args), OiiolTextLogger.LOG_BASIC);
        }
    }

    private boolean isProdHomeSpecified() {
        OiiiStageInventory stageInv = this.m_owner.getSession().getSourceAccess().getStageInventory();
        OiiiStageCompInvEntry sc = stageInv.getStageCompInvEntry(this.component.getCompInstallID());
        if (sc != null) {
            return !sc.isNoProdHome();
        }
        return true;
    }
}

