/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisConfigArgElem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiisPostInstallTool {
    private OiisVariable m_autoLaunchVar = null;
    private boolean m_bVisible;
    private boolean m_bAutoLaunch;
    private boolean m_bRequired;
    private boolean m_bJavaToolType;
    private Hashtable platCommands = new Hashtable();
    private OiisVariable m_autoLaunchDeinstallVar = null;
    private boolean m_bAutoLaunchForDeinstall;
    private boolean m_bInvokeAtInstall = true;
    private boolean m_bInvokeAtDeinstall = true;
    private String m_sJavaToolClassName;
    private boolean m_bInteractiveInstall;
    private boolean m_bSilentInstall;
    private boolean m_bInteractiveDeinstall;
    private boolean m_bSilentDeinstall;
    private Vector m_configArgVect = new Vector();
    protected OiisCompContext m_compContext;
    private boolean m_bClone;
    private boolean m_bDeinstall;
    private boolean m_bAddNode;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    public static final int interactiveInstallMode = 1;
    public static final int interactiveDeinstallMode = 2;
    public static final int silentInstallMode = 3;
    public static final int silentDeinstallMode = 4;
    public static final int cloneMode = 5;
    public static final int addNodeMode = 6;
    private boolean m_bUseCmdArray = false;
    private static final String JRE_EXECUTABLE = "java";
    private String m_sName = "";

    public void init() {
    }

    public void interactiveInstallInitialize() {
    }

    public void interactiveDeinstallInitialize() {
    }

    public void silentInstallInitialize() {
    }

    public void silentDeinstallInitialize() {
    }

    public void cloneInitialize() {
        this.m_compContext.getSession();
        if (OiicPullSession.isSilentMode()) {
            this.silentInstallInitialize();
        } else {
            this.interactiveInstallInitialize();
        }
    }

    public void addNodeInitialize() {
    }

    public void initToolProperties() {
    }

    public String getName() {
        return this.m_sName;
    }

    public void setCompContext(OiisCompContext compContext) {
        this.m_compContext = compContext;
    }

    public OiisCompContext getCompContext() {
        return this.m_compContext;
    }

    public void setAutoLaunch(boolean bLaunch) {
        this.m_bAutoLaunch = bLaunch;
    }

    public boolean isAutoLaunch() {
        return this.m_bAutoLaunch;
    }

    public void setAutoLaunchVariable(OiisVariable var) {
        this.m_autoLaunchVar = var;
    }

    public OiisVariable getAutoLaunchVariable() {
        return this.m_autoLaunchVar;
    }

    public void setAutoLaunchForDeinstall(boolean bLaunch) {
        this.m_bAutoLaunchForDeinstall = bLaunch;
    }

    public boolean isAutoLaunchForDeinstall() {
        return this.m_bAutoLaunchForDeinstall;
    }

    public void setAutoLaunchDeinstallVariable(OiisVariable var) {
        this.m_autoLaunchDeinstallVar = var;
    }

    public boolean makeNonAutoToolsToAutoLaunch() {
        Boolean varVal;
        boolean val = true;
        if (this.m_autoLaunchVar != null && (varVal = (Boolean)this.m_autoLaunchVar.getValue()) != null) {
            val = varVal;
        }
        return val;
    }

    public void setRequired(boolean bReq) {
        this.m_bRequired = bReq;
        if (this.m_bRequired) {
            this.setVisible(true);
        }
    }

    public boolean isRequired() {
        return this.m_bRequired;
    }

    public void setVisible(boolean bVisible) {
        this.m_bVisible = bVisible;
    }

    public boolean isVisible() {
        return this.m_bVisible;
    }

    public void setSupportedPlatAndCommand(Integer plat, String commandName) {
        this.platCommands.put(plat, commandName);
    }

    public String getCommandNameOnPlat(Integer plat) {
        String commandName = (String)this.platCommands.get(plat);
        return commandName;
    }

    public Enumeration getSupportedPlats() {
        return this.platCommands.keys();
    }

    public void setToolJavaType(boolean toolType) {
        this.m_bJavaToolType = toolType;
    }

    public boolean isJavaTool() {
        return this.m_bJavaToolType;
    }

    public void setJavaToolClassName(String className) {
        this.m_sJavaToolClassName = className;
    }

    public String getJavaToolClassName() {
        return this.m_sJavaToolClassName;
    }

    public void setInteractiveInstall(boolean bInteractiveInstall) {
        this.m_bInteractiveInstall = bInteractiveInstall;
    }

    public void setSilentInstall(boolean bSilentInstall) {
        this.m_bSilentInstall = bSilentInstall;
    }

    public void setSilentDeInstall(boolean bSilentDeInstall) {
        this.m_bSilentDeinstall = bSilentDeInstall;
    }

    public void setInteractiveDeInstall(boolean bInteractiveDeInstall) {
        this.m_bInteractiveDeinstall = bInteractiveDeInstall;
    }

    public void setClone(boolean bClone) {
        this.m_bClone = bClone;
    }

    public void setDeinstall(boolean bDeinstall) {
        this.m_bDeinstall = bDeinstall;
    }

    public void setAddNode(boolean bAddNode) {
        this.m_bAddNode = bAddNode;
    }

    public boolean isAddNode() {
        return this.m_bAddNode;
    }

    public boolean isDeinstall() {
        return this.m_bDeinstall;
    }

    public boolean isInteractiveInstall() {
        return this.m_bInteractiveInstall;
    }

    public boolean isSilentInstall() {
        return this.m_bSilentInstall;
    }

    public boolean isInteractiveDeinstall() {
        return this.m_bInteractiveDeinstall;
    }

    public boolean isSilentDeinstall() {
        return this.m_bSilentDeinstall;
    }

    public boolean isClone() {
        return this.m_bClone;
    }

    public String getInteractiveDeinstallCmdLine(boolean bLog) {
        this.interactiveDeinstallInitialize();
        return this.constructCommandLine(2, bLog);
    }

    public String getDeinstallCmd(int mode, boolean bLog) {
        String commandLine = null;
        int curPlat = OiixPlatform.getCurrentPlatform();
        int nArgSize = this.m_configArgVect.size();
        if (this.m_bJavaToolType) {
            commandLine = this.getJreLocation();
            commandLine = this.addQuotes(commandLine);
            commandLine = this.addDebugFlags(commandLine);
            commandLine = this.addSRVMFlags(commandLine);
        } else {
            commandLine = (String)this.platCommands.get(new Integer(curPlat));
            commandLine = this.addQuotes(commandLine);
        }
        return commandLine;
    }

    public String[] getDeinstallArgs(int mode, boolean bLog) {
        int argsSize;
        int i;
        String commandLine = "";
        int curPlat = OiixPlatform.getCurrentPlatform();
        int nArgSize = this.m_configArgVect.size();
        Vector<String> vDeinstArgs = new Vector<String>();
        if (this.m_bJavaToolType) {
            OiisConfigArgElem oElem;
            int sepIndex = -1;
            for (i = 0; i < nArgSize; ++i) {
                if (!((OiisConfigArgElem)this.m_configArgVect.elementAt(i)).getInternalName().equals("COMMAND")) continue;
                sepIndex = i;
                break;
            }
            if (sepIndex != -1) {
                for (i = 0; i < sepIndex; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        vDeinstArgs.addElement(oElem.getSwitch());
                    }
                    if (!this.isEmptyValue(oElem.getVariable())) {
                        vDeinstArgs.addElement("${" + oElem.getVariable() + "}");
                        continue;
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    vDeinstArgs.addElement(this.addQuotes(oElem.getValue(false)));
                }
                vDeinstArgs.addElement(this.m_sJavaToolClassName);
                for (i = sepIndex + 1; i < nArgSize; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        vDeinstArgs.addElement(oElem.getSwitch());
                    }
                    if (!this.isEmptyValue(oElem.getVariable())) {
                        vDeinstArgs.addElement("${" + oElem.getVariable() + "}");
                        continue;
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    vDeinstArgs.addElement(this.addQuotes(oElem.getValue(false)));
                }
            } else {
                vDeinstArgs.addElement(this.m_sJavaToolClassName);
                for (i = 0; i < nArgSize; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        vDeinstArgs.addElement(oElem.getSwitch());
                    }
                    if (!this.isEmptyValue(oElem.getVariable())) {
                        vDeinstArgs.addElement("${" + oElem.getVariable() + "}");
                        continue;
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    vDeinstArgs.addElement(this.addQuotes(oElem.getValue(false)));
                }
            }
        } else {
            for (i = 0; i < nArgSize; ++i) {
                OiisConfigArgElem oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                if (!this.isEmptyValue(oElem.getSwitch())) {
                    vDeinstArgs.addElement(oElem.getSwitch());
                }
                if (!this.isEmptyValue(oElem.getVariable())) {
                    vDeinstArgs.addElement("${" + oElem.getVariable() + "}");
                    continue;
                }
                if (this.isEmptyValue(oElem.getValue())) continue;
                vDeinstArgs.addElement(this.addQuotes(oElem.getValue(false)));
            }
        }
        if ((argsSize = vDeinstArgs.size()) == 0) {
            return null;
        }
        String[] args = new String[argsSize];
        for (i = 0; i < argsSize; ++i) {
            args[i] = (String)vDeinstArgs.elementAt(i);
        }
        return args;
    }

    public String getInteractiveInstallCmdLine(boolean bLog) {
        this.interactiveInstallInitialize();
        return this.constructCommandLine(1, bLog);
    }

    public String getCloneCmdLine(boolean bLog) {
        this.cloneInitialize();
        return this.constructCommandLine(5, bLog);
    }

    public String getAddNodeCmdLine(boolean bLog) {
        this.addNodeInitialize();
        return this.constructCommandLine(6, bLog);
    }

    public String getSilentDeinstallCmdLine(boolean bLog) {
        this.silentDeinstallInitialize();
        return this.constructCommandLine(4, bLog);
    }

    public String getSilentInstallCmdLine(boolean bLog) {
        this.silentInstallInitialize();
        return this.constructCommandLine(3, bLog);
    }

    public boolean needDeinstallLog() {
        boolean bNeedDeinstallLog = false;
        if (this.m_bInvokeAtDeinstall) {
            if (this.m_autoLaunchDeinstallVar != null) {
                Object oVal = this.m_autoLaunchDeinstallVar.getValue();
                if (oVal != null) {
                    Boolean val = (Boolean)oVal;
                    bNeedDeinstallLog = val;
                }
            } else {
                bNeedDeinstallLog = this.isInteractiveDeinstall() || this.isSilentDeinstall() || this.isAutoLaunchForDeinstall();
            }
        }
        return bNeedDeinstallLog;
    }

    public void addArgument(OiisConfigArgElem cae) {
        this.m_configArgVect.addElement(cae);
    }

    public OiisConfigArgElem getArgument(String internalName) {
        for (int i = 0; i < this.m_configArgVect.size(); ++i) {
            if (!internalName.equals(((OiisConfigArgElem)this.m_configArgVect.elementAt(i)).getInternalName())) continue;
            return (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
        }
        return null;
    }

    private boolean argumentApplicable(int platform, int mode, OiisConfigArgElem cae) {
        if (cae.getInternalName().equalsIgnoreCase(OiixResourceBundle.getString("S_ARG_RECORD")) && OiicPullSession.isRecordMode()) {
            return true;
        }
        if (cae.getPlats() != null && cae.getPlats().indexOf(new Integer(platform)) == -1) {
            return false;
        }
        switch (mode) {
            case 1: {
                return cae.isInteractiveInstall();
            }
            case 2: {
                return cae.isInteractiveDeinstall();
            }
            case 3: {
                return cae.isSilentInstall();
            }
            case 4: {
                return cae.isSilentDeinstall();
            }
            case 5: {
                return cae.isClone();
            }
            case 6: {
                return cae.isAddNode();
            }
        }
        return false;
    }

    private String addQuotes(String sCommand) {
        return sCommand;
    }

    private String addDebugFlags(String sCommand) {
        if (OiixDebug.PRINT_TIME) {
            sCommand = sCommand + " -Doracle.installer.printtime=true ";
        }
        if (OiixDebug.PRINT_MEMORY) {
            sCommand = sCommand + " -Doracle.installer.printmemory=true ";
        }
        if (OiixDebug.PRINT_DISKUSAGE) {
            sCommand = sCommand + " -Doracle.installer.printdiskusage=true ";
        }
        return sCommand;
    }

    private String addSRVMFlags(String sCommand) {
        String remoteCopy;
        Properties props = System.getProperties();
        String remoteShell = props.getProperty("oracle.srvm.remoteShell");
        if (remoteShell != null) {
            sCommand = sCommand + " -Doracle.srvm.remoteShell=" + remoteShell + " ";
        }
        if ((remoteCopy = props.getProperty("oracle.srvm.remoteCopy")) != null) {
            sCommand = sCommand + " -Doracle.srvm.remoteCopy=" + remoteCopy + " ";
        }
        return sCommand;
    }

    private String getJreLocation() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return JRE_EXECUTABLE;
        }
        String jreLoc = "";
        jreLoc = javaHome + File.separator + "bin" + File.separator + JRE_EXECUTABLE;
        return OiixPathOps.getNativeForm(jreLoc);
    }

    private String constructCommandLine(int mode, boolean bLog) {
        String commandLine = null;
        int curPlat = OiixPlatform.getCurrentPlatform();
        int nArgSize = this.m_configArgVect.size();
        if (this.m_bJavaToolType) {
            int i;
            commandLine = this.getJreLocation();
            commandLine = this.addQuotes(commandLine);
            commandLine = this.addDebugFlags(commandLine);
            commandLine = this.addSRVMFlags(commandLine);
            int sepIndex = -1;
            for (i = 0; i < nArgSize; ++i) {
                if (!((OiisConfigArgElem)this.m_configArgVect.elementAt(i)).getInternalName().equals("COMMAND")) continue;
                sepIndex = i;
                break;
            }
            if (sepIndex != -1) {
                OiisConfigArgElem oElem;
                for (i = 0; i < sepIndex; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        commandLine = commandLine + " " + oElem.getSwitch();
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    commandLine = commandLine + " " + this.addQuotes(oElem.getValue(bLog));
                }
                commandLine = commandLine + " " + this.m_sJavaToolClassName;
                for (i = sepIndex + 1; i < nArgSize; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        commandLine = commandLine + " " + oElem.getSwitch();
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    commandLine = commandLine + " " + this.addQuotes(oElem.getValue(bLog));
                }
            } else {
                commandLine = commandLine + " " + this.m_sJavaToolClassName;
                for (i = 0; i < nArgSize; ++i) {
                    OiisConfigArgElem oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        commandLine = commandLine + " " + oElem.getSwitch();
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    commandLine = commandLine + " " + this.addQuotes(oElem.getValue(bLog));
                }
            }
        } else {
            commandLine = (String)this.platCommands.get(new Integer(curPlat));
            commandLine = this.addQuotes(commandLine);
            for (int i = 0; i < nArgSize; ++i) {
                OiisConfigArgElem oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                if (!this.isEmptyValue(oElem.getSwitch())) {
                    commandLine = commandLine + " " + oElem.getSwitch();
                }
                if (this.isEmptyValue(oElem.getValue())) continue;
                commandLine = commandLine + " " + this.addQuotes(oElem.getValue(bLog));
            }
        }
        return commandLine;
    }

    public String constructCommandLine(int mode) {
        return this.constructCommandLine(mode, false);
    }

    public String constructLogCommand(int mode) {
        return this.constructCommandLine(mode, true);
    }

    public String getCommand(int mode) {
        String command = null;
        if (this.m_bJavaToolType) {
            command = this.getJreLocation();
            command = this.addQuotes(command);
            command = this.addDebugFlags(command);
        } else {
            int curPlat = OiixPlatform.getCurrentPlatform();
            command = (String)this.platCommands.get(new Integer(curPlat));
            command = this.addQuotes(command);
        }
        return command;
    }

    public String getClassPath(int mode) {
        int curPlat = OiixPlatform.getCurrentPlatform();
        int nArgSize = this.m_configArgVect.size();
        Vector vArgs = new Vector();
        String SPACE = " ";
        if (this.m_bJavaToolType) {
            OiisConfigArgElem oElem;
            int sepIndex = -1;
            for (int i = 0; i < nArgSize; ++i) {
                if (!((OiisConfigArgElem)this.m_configArgVect.elementAt(i)).getInternalName().equals("CLASSPATH")) continue;
                sepIndex = i;
                break;
            }
            if (sepIndex != -1 && this.argumentApplicable(curPlat, mode, oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(sepIndex))) {
                return oElem.getValue();
            }
        }
        return null;
    }

    public String[] getCommandLineArgs(int mode) {
        int argsSize;
        int i;
        int curPlat = OiixPlatform.getCurrentPlatform();
        int nArgSize = this.m_configArgVect.size();
        Vector<String> vArgs = new Vector<String>();
        String SPACE = " ";
        if (this.m_bJavaToolType) {
            OiisConfigArgElem oElem;
            int sepIndex = -1;
            for (i = 0; i < nArgSize; ++i) {
                if (!((OiisConfigArgElem)this.m_configArgVect.elementAt(i)).getInternalName().equals("COMMAND")) continue;
                sepIndex = i;
                break;
            }
            if (sepIndex != -1) {
                for (i = 0; i < sepIndex; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        vArgs.addElement(oElem.getSwitch());
                    }
                    if (!this.isEmptyValue(oElem.getVariable())) {
                        vArgs.addElement("${" + oElem.getVariable() + "}");
                        continue;
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    vArgs.addElement(this.addQuotes(oElem.getValue(false)));
                }
                vArgs.addElement(this.m_sJavaToolClassName);
                for (i = sepIndex + 1; i < nArgSize; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        vArgs.addElement(oElem.getSwitch());
                    }
                    if (!this.isEmptyValue(oElem.getVariable())) {
                        vArgs.addElement("${" + oElem.getVariable() + "}");
                        continue;
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    vArgs.addElement(this.addQuotes(oElem.getValue(false)));
                }
            } else {
                vArgs.addElement(this.m_sJavaToolClassName);
                for (i = 0; i < nArgSize; ++i) {
                    oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                    if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                    if (!this.isEmptyValue(oElem.getSwitch())) {
                        vArgs.addElement(oElem.getSwitch());
                    }
                    if (!this.isEmptyValue(oElem.getVariable())) {
                        vArgs.addElement("${" + oElem.getVariable() + "}");
                        continue;
                    }
                    if (this.isEmptyValue(oElem.getValue())) continue;
                    vArgs.addElement(this.addQuotes(oElem.getValue(false)));
                }
            }
        } else {
            for (i = 0; i < nArgSize; ++i) {
                OiisConfigArgElem oElem = (OiisConfigArgElem)this.m_configArgVect.elementAt(i);
                if (!this.argumentApplicable(curPlat, mode, oElem)) continue;
                if (!this.isEmptyValue(oElem.getSwitch())) {
                    vArgs.addElement(oElem.getSwitch());
                }
                if (!this.isEmptyValue(oElem.getVariable())) {
                    vArgs.addElement("${" + oElem.getVariable() + "}");
                    continue;
                }
                if (this.isEmptyValue(oElem.getValue())) continue;
                vArgs.addElement(this.addQuotes(oElem.getValue(false)));
            }
        }
        if ((argsSize = vArgs.size()) == 0) {
            return null;
        }
        String[] args = new String[argsSize];
        for (i = 0; i < argsSize; ++i) {
            args[i] = (String)vArgs.elementAt(i);
        }
        return args;
    }

    private boolean isEmptyValue(String argValue) {
        return argValue == null || argValue.trim().equals("");
    }

    public boolean isUseCommmandArray() {
        return this.m_bUseCmdArray;
    }

    public void setUseCommandArray(boolean bUseCommandArray) {
        this.m_bUseCmdArray = bUseCommandArray;
    }

    public boolean getInvokeAtInstall() {
        return this.m_bInvokeAtInstall;
    }

    public void setInvokeAtInstall(boolean bInvokeAtInstall) {
        this.m_bInvokeAtInstall = bInvokeAtInstall;
    }

    public boolean getInvokeAtDeinstall() {
        return this.m_bInvokeAtDeinstall;
    }

    public void setInvokeAtDeinstall(boolean bInvokeAtDeinstall) {
        this.m_bInvokeAtDeinstall = bInvokeAtDeinstall;
    }
}

