/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import oracle.sysman.oii.oiii.OiiiCompInstallID;

public class OiisPatchDepObj {
    static final long serialVersionUID = -9019480533289194807L;
    private OiiiCompInstallID m_origDepId;
    private boolean m_verUpgraded;
    private OiiiCompInstallID m_curDepId;

    public OiisPatchDepObj(OiiiCompInstallID origDepId) {
        this(origDepId, null);
    }

    public OiisPatchDepObj(OiiiCompInstallID origDepId, OiiiCompInstallID curDepId) {
        this.m_origDepId = origDepId;
        if (curDepId != null) {
            this.setCurDepId(curDepId);
        } else {
            this.m_verUpgraded = false;
        }
    }

    public OiiiCompInstallID getOrigDepId() {
        return this.m_origDepId;
    }

    public boolean isVerUpgraded() {
        return this.m_verUpgraded;
    }

    public OiiiCompInstallID getCurDepId() {
        if (this.m_verUpgraded) {
            return this.m_curDepId;
        }
        return this.m_origDepId;
    }

    public void setCurDepId(OiiiCompInstallID curDepId) throws IllegalArgumentException {
        if (!this.m_origDepId.equals(curDepId)) {
            if (!this.m_origDepId.getName().equals(curDepId.getName()) || !curDepId.getVersion().laterThan(this.m_origDepId.getVersion())) {
                throw new IllegalArgumentException(curDepId + " !> " + this.m_origDepId);
            }
            this.m_verUpgraded = true;
            this.m_curDepId = curDepId;
        } else {
            this.m_verUpgraded = false;
        }
    }

    public String toString() {
        if (this.m_curDepId != null) {
            return "[" + this.m_curDepId.toString() + "]" + "[" + this.m_verUpgraded + "]";
        }
        return "[" + this.m_origDepId.toString() + "]" + "[" + this.m_verUpgraded + "]";
    }
}

