/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisMakeDeps;
import oracle.sysman.oii.oiis.OiisRelinkInfo;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oix.oixp.OixpIAttribute;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;

public class OiisMakeDepsReader
implements OixpIHandler {
    public static final String MAKE_TAG = "ohmd:MAKE";
    public static final String INPUT_TAG = "ohmd:INPUT";
    public static final String MAKE_LIST_TAG = "ohmd:MAKE_LIST";
    public static final String INPUT_LIST_TAG = "ohmd:INPUT_LIST";
    public static final String TARGET_TAG = "ohmd:TARGET";
    public static final String TARGETNAME_ATT = "TARGETNAME";
    public static final String FILENAME_ATT = "FILENAME";
    public static final String MAKEPATH_ATT = "MAKEPATH";
    public static final String VAL_ATT = "VAL";
    public static final String ACTIONTYPE_ATT = "ACTIONTYPE";
    public static final String COMP_TAG = "ohmd:COMP";
    public static final String PATCH_TAG = "ohmd:PATCH";
    public static final String NAME = "NAME";
    public static final String VERSION = "VERSION";
    public static final String INSTALL = "INSTALL";
    public static final String DEINSTALL = "DEINSTALL";
    public static final String BOTH = "BOTH";
    private static String cur_makefile = null;
    private static String cur_makepath = null;
    private static String cur_action = null;
    private String[] args;
    private ArrayList args_list = new ArrayList();
    private OiisRelinkInfo obj;
    private String m_sLoc;
    private String m_sohLoc;
    private boolean b_isInstall;
    private OiisCompContext m_cc = null;

    public OiisMakeDepsReader(String loc) {
        this.m_sLoc = loc;
    }

    public OiisMakeDepsReader(String loc, String ohLoc, boolean isInstall) {
        this(loc, ohLoc, isInstall, new OiisCompContext());
    }

    public OiisMakeDepsReader(String loc, String ohLoc, boolean isInstall, OiisCompContext cc) {
        this.m_sLoc = loc;
        this.m_sohLoc = ohLoc;
        this.b_isInstall = isInstall;
        this.m_cc = cc;
    }

    public String getLoc() {
        return this.m_sLoc;
    }

    public String getohLoc() {
        return this.m_sohLoc;
    }

    public boolean isInstall() {
        return this.b_isInstall;
    }

    public OiisCompContext getCompContext() {
        return this.m_cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile() throws IOException {
        try (FileInputStream fis = null;){
            OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
            File f = new File(this.m_sLoc);
            if (!f.exists()) {
                return;
            }
            parser.setHandler(this);
            parser.readXML((OixpIHandler)this, new File(this.m_sLoc));
        }
    }

    @Override
    public boolean doStartTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(MAKE_TAG)) {
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (tmp.equals(FILENAME_ATT)) {
                    cur_makefile = retLst[i].getValue();
                    continue;
                }
                if (tmp.equals(MAKEPATH_ATT)) {
                    cur_makepath = retLst[i].getValue();
                    continue;
                }
                OiiolTextLogger.appendText("Improper attribute found in MAKE TAG");
            }
        } else if (type.equalsIgnoreCase(TARGET_TAG)) {
            this.obj = new OiisRelinkInfo();
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (tmp.equals(TARGETNAME_ATT)) {
                    this.obj.setTarget(retLst[i].getValue());
                    continue;
                }
                if (!tmp.equals(ACTIONTYPE_ATT)) continue;
                cur_action = retLst[i].getValue();
            }
        } else if (type.equalsIgnoreCase(INPUT_TAG)) {
            this.args_list.add(el.getAttribValue(VAL_ATT));
        }
        return false;
    }

    @Override
    public boolean doText(OixpIElement el, String text) {
        return false;
    }

    @Override
    public boolean doEndTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(TARGET_TAG)) {
            this.args = this.args_list.toArray(new String[this.args_list.size()]);
            if (this.args.length == 0) {
                this.args = new String[0];
            }
            this.obj.setParamArguments(this.args);
            this.obj.setMakeFileName(this.m_sohLoc + File.separator + cur_makefile);
            if (this.getCompContext() != null) {
                OiixInstantiateOps ops = new OiixInstantiateOps();
                cur_makepath = ops.replaceVarVal(this.m_cc, cur_makepath);
            }
            this.obj.setMakePath(cur_makepath);
            this.args_list.clear();
            if (cur_action.equalsIgnoreCase(BOTH) || cur_action.equalsIgnoreCase(INSTALL) && this.b_isInstall || cur_action.equalsIgnoreCase(DEINSTALL) && !this.b_isInstall) {
                this.obj.setActionType(cur_action);
                OiisMakeDeps.add(this.obj);
            } else {
                OiiolTextLogger.appendText("Improper Action Type Found in Parsing" + cur_action);
            }
        } else if (type.equalsIgnoreCase(MAKE_TAG)) {
            cur_makefile = null;
            cur_makepath = null;
            cur_action = null;
        } else if (type.equalsIgnoreCase(MAKE_LIST_TAG)) {
            // empty if block
        }
        return false;
    }
}

