/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisMakeDepsReader;
import oracle.sysman.oii.oiis.OiisRelinkInfo;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisMakeDeps {
    private static final String CHANGE_DIR_EXCEPTION = "ChangeDirException";
    private static ArrayList make_table = new ArrayList();
    private static HashMap ohTable = new HashMap();
    private OiisRelinkInfo m_obj;
    private Boolean m_Selected;
    private String logFileName = "relinkActions";

    public OiisMakeDeps(OiisRelinkInfo obj, Boolean selected) {
        this.m_obj = obj;
        this.m_Selected = selected;
    }

    public OiisMakeDeps() {
    }

    public OiisRelinkInfo getRelinkInfo() {
        return this.m_obj;
    }

    public void setRelinkInfo(OiisRelinkInfo obj) {
        this.m_obj = obj;
    }

    public Boolean getSelected() {
        return this.m_Selected;
    }

    public void setSelected(boolean sel) {
        this.m_Selected = new Boolean(sel);
    }

    public String toString() {
        return "RELINK " + this.m_obj + " Bool " + this.m_Selected;
    }

    public static void add(OiisRelinkInfo obj) {
        make_table.add(new OiisMakeDeps(obj, new Boolean(false)));
    }

    public static void add(OiisRelinkInfo obj, Boolean bool) {
        make_table.add(new OiisMakeDeps(obj, bool));
    }

    public static ArrayList getTable() {
        return make_table;
    }

    public static void setTable(ArrayList table) {
        make_table = table;
    }

    public static ArrayList retrieveFromHash(Integer key) {
        return (ArrayList)ohTable.get(key);
    }

    public static void storeInHash(int ohIndex) {
        Integer key = new Integer(ohIndex);
        ArrayList val = (ArrayList)make_table.clone();
        ohTable.put(key, val);
    }

    public static void reverseTable() {
        ArrayList reverse = new ArrayList();
        ListIterator iterator = make_table.listIterator(make_table.size());
        while (iterator.hasPrevious()) {
            reverse.add(iterator.previous());
        }
        make_table = reverse;
    }

    public static ArrayList getSelectedTargets() {
        ArrayList<OiisRelinkInfo> retLst = new ArrayList<OiisRelinkInfo>();
        for (int i = 0; i < make_table.size(); ++i) {
            OiisMakeDeps md = (OiisMakeDeps)make_table.get(i);
            if (!md.getSelected().booleanValue()) continue;
            retLst.add(md.getRelinkInfo());
        }
        return retLst;
    }

    public static void clearCommandTable() {
        make_table.clear();
    }

    public static void registerForMake(OiisRelinkInfo obj) {
        if (make_table == null) {
            make_table = new ArrayList();
        }
        for (int i = 0; i < make_table.size(); ++i) {
            OiisMakeDeps md = (OiisMakeDeps)make_table.get(i);
            OiisRelinkInfo ri = md.getRelinkInfo();
            if (!ri.equalsIgnoreLogs(obj)) continue;
            obj.setActionType(ri.getActionType());
            obj.addToCIDList(ri.getCIDList());
            md.setRelinkInfo(obj);
            md.setSelected(true);
            return;
        }
        obj.setActionType("INSTALL");
        obj.addToCIDList(obj.getCIDList());
        make_table.add(new OiisMakeDeps(obj, new Boolean(true)));
    }

    public static void registerTargetForMake(OiisRelinkInfo obj) {
        for (int i = 0; i < make_table.size(); ++i) {
            OiisMakeDeps md = (OiisMakeDeps)make_table.get(i);
            OiisRelinkInfo ri = md.getRelinkInfo();
            if (!ri.equalsIgnoreArgs(obj)) continue;
            obj.setActionType(ri.getActionType());
            obj.addToCIDList(ri.getCIDList());
            obj.setParamArguments(ri.getParamArguments());
            String[] union = OiixVectorOps.getUnionOfStringLists(obj.getArguments(), ri.getArguments());
            obj.setArguments(union);
            md.setRelinkInfo(obj);
            md.setSelected(true);
            return;
        }
    }

    public static void setRelinkOrder(ArrayList[] result) {
        try {
            OiisRelinkInfo obj;
            int j;
            OiisMakeDeps md;
            for (int i = 0; i < result[0].size(); ++i) {
                md = (OiisMakeDeps)result[0].get(i);
                OiisRelinkInfo ri = md.getRelinkInfo();
                for (j = 0; j < result[1].size(); ++j) {
                    md = (OiisMakeDeps)result[1].get(j);
                    obj = md.getRelinkInfo();
                    if (!ri.equalsIgnoreArgs(obj)) continue;
                    md.setSelected(true);
                    break;
                }
                if (j != result[1].size()) continue;
                result[1].add(new OiisMakeDeps(ri, new Boolean(true)));
            }
            for (j = 0; j < result[1].size(); ++j) {
                md = (OiisMakeDeps)result[1].get(j);
                obj = md.getRelinkInfo();
                if (!md.getSelected().booleanValue()) continue;
                OiisMakeDeps.add(obj, new Boolean(true));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMakefile(String installMakePath, String installMakeFileName, String installTarget, String[] installArguments) throws OiilActionException {
        String errString;
        int i;
        String userDir;
        File f1;
        String makeFileLoc = null;
        String makeFileName = null;
        if (installMakePath == null) {
            return;
        }
        if (installMakePath.indexOf(47) != -1 && !(f1 = new File(installMakePath)).exists()) {
            int severity = 1;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%makePath%");
            values[0] = new String(installMakePath);
            String exName = "MakeNotFoundException";
            String errString2 = "MakeNotFound";
            String exString = OiixInstantiateString.processString(errString2, variables, values);
            throw new OiilActionException(exName, exString, severity);
        }
        if (installMakeFileName == null) {
            return;
        }
        File f2 = new File(installMakeFileName);
        if (!f2.exists()) {
            int severity = 1;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = "%makeFileName%";
            values[0] = installMakeFileName;
            String exName = "MakefileNotFoundException";
            String errString3 = "MakefileNotFound";
            String exString = OiixInstantiateString.processString(errString3, variables, values);
            throw new OiilActionException(exName, exString, severity);
        }
        if (installTarget == null || installTarget.trim().equals("")) {
            return;
        }
        String curWD = OiixEnvironmentOps.getCurrentWorkingDir();
        if (curWD == null && (userDir = System.getProperty("user.dir")) != null) {
            if (OiixEnvironmentOps.changeDir(userDir) != 0) {
                int severity = 1;
                String errString4 = "ChangeDirExpetion";
                throw new OiilActionException(CHANGE_DIR_EXCEPTION, errString4, severity);
            }
            curWD = OiixEnvironmentOps.getCurrentWorkingDir();
            if (curWD == null) {
                int severity = 1;
                String exName = "GetDirException";
                String errString5 = "GetDirException";
                throw new OiilActionException(exName, errString5, severity);
            }
        }
        File f = new File(installMakeFileName);
        makeFileLoc = f.getParent();
        makeFileName = f.getName();
        if (OiixEnvironmentOps.changeDir(makeFileLoc) != 0) {
            int severity = 1;
            String errString6 = "ChangeDirException_desc";
            throw new OiilActionException(CHANGE_DIR_EXCEPTION, errString6, severity);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(installMakePath);
        buf.append(" -f ");
        buf.append(makeFileName);
        ArrayList<String> oCmdArray = new ArrayList<String>(4 + installArguments.length);
        oCmdArray.add(installMakePath);
        oCmdArray.add("-f");
        oCmdArray.add(installMakeFileName);
        String[] asTargets = OiixFunctionOps.explodeString(installTarget, " ");
        for (i = 0; i < asTargets.length; ++i) {
            buf.append(" ");
            buf.append(asTargets[i]);
            oCmdArray.add(asTargets[i]);
        }
        for (i = 0; i < installArguments.length; ++i) {
            buf.append(" ");
            buf.append(installArguments[i]);
            oCmdArray.add(installArguments[i]);
        }
        buf.append(File.separator);
        String[] cmdArr = new String[oCmdArray.size()];
        oCmdArray.toArray(cmdArr);
        int retVal = -1;
        try {
            OiixSpawner proc = new OiixSpawner(new PrintStream(System.out), new PrintStream(System.err));
            proc.execute(cmdArr);
            retVal = proc.getResultCode();
        }
        catch (OiixSpawnException spe) {
            try {
                spe.printStackTrace();
            }
            catch (Throwable throwable) {
                if (OiixEnvironmentOps.changeDir(curWD) != 0) {
                    int severity = 1;
                    String errString7 = "Error In Changing Directory";
                    throw new OiilActionException(CHANGE_DIR_EXCEPTION, errString7, severity);
                }
                if (retVal != 0) {
                    int severity = 1;
                    String logLocation = OiiolTextLogger.getCurLogFileName();
                    Object[] args = new String[]{installTarget, installMakeFileName, logLocation};
                    String exName = "MakefileException";
                    String errString8 = "Error in invoking target ''{0}'' of makefile ''{1}''. See ''{2}'' for details.";
                    String exString = MessageFormat.format(errString8, args);
                    System.out.println(exString);
                    throw new OiilActionException(exName, exString, severity);
                }
                throw throwable;
            }
            if (OiixEnvironmentOps.changeDir(curWD) != 0) {
                int severity = 1;
                String errString9 = "Error In Changing Directory";
                throw new OiilActionException(CHANGE_DIR_EXCEPTION, errString9, severity);
            }
            if (retVal != 0) {
                int severity = 1;
                String logLocation = OiiolTextLogger.getCurLogFileName();
                Object[] args = new String[]{installTarget, installMakeFileName, logLocation};
                String exName = "MakefileException";
                String errString10 = "Error in invoking target ''{0}'' of makefile ''{1}''. See ''{2}'' for details.";
                String exString = MessageFormat.format(errString10, args);
                System.out.println(exString);
                throw new OiilActionException(exName, exString, severity);
            }
        }
        if (OiixEnvironmentOps.changeDir(curWD) != 0) {
            int severity = 1;
            errString = "Error In Changing Directory";
            throw new OiilActionException(CHANGE_DIR_EXCEPTION, errString, severity);
        }
        if (retVal != 0) {
            int severity = 1;
            String logLocation = OiiolTextLogger.getCurLogFileName();
            Object[] args = new String[]{installTarget, installMakeFileName, logLocation};
            String exName = "MakefileException";
            errString = "Error in invoking target ''{0}'' of makefile ''{1}''. See ''{2}'' for details.";
            String exString = MessageFormat.format(errString, args);
            System.out.println(exString);
            throw new OiilActionException(exName, exString, severity);
        }
    }

    private boolean canConsolidateTargets(OiisRelinkInfo oLinkInfo1, OiisRelinkInfo oLinkInfo2) {
        String[] asArgs1 = oLinkInfo1.getArguments();
        String[] asArgs2 = oLinkInfo2.getArguments();
        return OiipgFileSystem.equalPathStrs(oLinkInfo1.getMakePath(), oLinkInfo2.getMakePath()) && OiipgFileSystem.equalPathStrs(oLinkInfo1.getMakeFileName(), oLinkInfo2.getMakeFileName()) && (asArgs1 == null && asArgs2 == null || asArgs1 != null && asArgs2 != null && asArgs1.length == asArgs2.length);
    }

    public boolean doRelink(List commandTable, String[] installArguments) {
        int nLinks = commandTable.size();
        ArrayList<String> args_List = new ArrayList<String>();
        boolean linkSuccess = true;
        for (int i = 0; i < installArguments.length; ++i) {
            if (installArguments[i] == null) continue;
            args_List.add(installArguments[i]);
        }
        String[] args = args_List.toArray(new String[args_List.size()]);
        for (int i = 0; i < nLinks; ++i) {
            OiisRelinkInfo linkInfo = (OiisRelinkInfo)commandTable.get(i);
            String installMakePath = linkInfo.getMakePath();
            String installMakeFileName = linkInfo.getMakeFileName();
            String installTarget = linkInfo.getTarget();
            boolean bConsolidateTargets = true;
            while (bConsolidateTargets) {
                if (i < nLinks - 1) {
                    OiisRelinkInfo linkInfo2 = (OiisRelinkInfo)commandTable.get(i + 1);
                    if (this.canConsolidateTargets(linkInfo, linkInfo2)) {
                        installTarget = installTarget + " " + linkInfo2.getTarget();
                        ++i;
                        continue;
                    }
                    bConsolidateTargets = false;
                    continue;
                }
                bConsolidateTargets = false;
            }
            try {
                this.invokeMakefile(installMakePath, installMakeFileName, installTarget, args);
                continue;
            }
            catch (OiilActionException e) {
                OiiolTextLogger.appendException(e);
                linkSuccess = false;
            }
        }
        return linkSuccess;
    }

    public boolean validateCmdArgs(String[] args) {
        int size = args == null ? 0 : args.length;
        boolean foundArg = false;
        for (int i = 0; i < size; ++i) {
            if (args[i].equalsIgnoreCase("-maketargetsxml")) {
                foundArg = true;
                if (args[i + 1] == null) {
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("-makedepsxml") && args[i + 1] == null) {
                return false;
            }
            if (!args[i].equalsIgnoreCase("-logDir") || args[i + 1] != null) continue;
            return false;
        }
        return foundArg;
    }

    public static boolean doLink(String makeorderXML, String[] nameValue) {
        if (makeorderXML == null || makeorderXML.length() <= 0) {
            return false;
        }
        String[] commandLine = new String[]{"-relink", "-maketargetsxml", makeorderXML};
        String[] args = OiixVectorOps.getUnionOfStringLists(commandLine, nameValue);
        OiisMakeDeps md = new OiisMakeDeps();
        boolean ret = md.doOperation(args);
        return ret;
    }

    public boolean doOperation(String[] args) {
        OiisMakeDeps m;
        int i;
        String[] xmlFiles = new String[2];
        ArrayList[] result = new ArrayList[2];
        String logDir = null;
        int size = args == null ? 0 : args.length;
        String[] installArgs = new String[size];
        String homeLoc = "";
        int startIndex = 3;
        if (!this.validateCmdArgs(args)) {
            System.out.println("Usage: -relink -maketargetsxml <location of maketargetsxml> [-makedepsxml <location of makedepsxml>] [-logDir <location of logDir] [name=value] ");
            return false;
        }
        int noOfFiles = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (args[i2].equalsIgnoreCase("-maketargetsxml")) {
                xmlFiles[0] = args[i2 + 1];
                startIndex = i2 + 2;
                ++noOfFiles;
                continue;
            }
            if (args[i2].equalsIgnoreCase("-makedepsxml")) {
                xmlFiles[1] = args[i2 + 1];
                startIndex = i2 + 2;
                ++noOfFiles;
                continue;
            }
            if (!args[i2].equalsIgnoreCase("-logDir")) continue;
            logDir = args[i2 + 1];
            startIndex = i2 + 2;
            try {
                OiiolTextLogger.setSkipFilePerChange(true);
                OiiolTextLogger.setLogLoc(logDir, this.logFileName);
                OiiolTextLogger.setSkipFilePerChange(false);
                System.out.println("Please find the log file at " + OiiolTextLogger.getCurLogFileName());
                continue;
            }
            catch (IOException e) {
                System.out.println("Error while setting logDir" + e.getMessage());
                return false;
            }
        }
        int k = 0;
        for (i = startIndex; i < size; ++i) {
            if (args[i].indexOf("=") == -1) continue;
            installArgs[k++] = args[i];
            StringTokenizer st = new StringTokenizer(args[i], "=");
            if (!st.nextToken().equalsIgnoreCase("ORACLE_HOME")) continue;
            homeLoc = st.nextToken();
        }
        OiisMakeDeps.clearCommandTable();
        for (i = 0; i < noOfFiles; ++i) {
            OiisMakeDepsReader mdr = new OiisMakeDepsReader(xmlFiles[i], homeLoc, true);
            try {
                mdr.loadFromFile();
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
                return false;
            }
            result[i] = new ArrayList(OiisMakeDeps.getTable());
            OiisMakeDeps.clearCommandTable();
        }
        if (result[1] != null) {
            for (i = 0; i < result[1].size(); ++i) {
                m = (OiisMakeDeps)result[1].get(i);
                OiisRelinkInfo obj = m.getRelinkInfo();
                OiisMakeDeps.add(obj, new Boolean(false));
            }
            OiisMakeDeps.setRelinkOrder(result);
        } else {
            for (i = 0; i < result[0].size(); ++i) {
                m = (OiisMakeDeps)result[0].get(i);
                OiisRelinkInfo ri = m.getRelinkInfo();
                OiisMakeDeps.add(ri, new Boolean(true));
            }
        }
        boolean linkSuccess = this.doRelink(OiisMakeDeps.getSelectedTargets(), installArgs);
        return linkSuccess;
    }

    public static void main(String[] args) {
        OiisMakeDeps md = new OiisMakeDeps();
        if (!md.doOperation(args)) {
            OiicExitCode.setExitCode(-1);
        } else {
            OiicExitCode.setExitCode(0);
        }
        System.exit(OiicExitCode.getExitCode());
    }
}

