/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.sysman.oii.oiis.OiisTargetStructure;
import oracle.sysman.oix.oixs.OixsXMLOps;

public class OiisMakeConfigWriter {
    public static final String MAKE_LIST_TAG = "ohmd:MAKE_LIST";
    public static final String HEADER = " xmlns:ohmd=\"make_desc.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"make_desc.xsd make_desc.xsd\"";
    private ArrayList m_targetStructure;
    private String m_sLoc;

    public OiisMakeConfigWriter(String loc, ArrayList tgts) {
        this.m_sLoc = loc;
        this.m_targetStructure = tgts;
    }

    public String getLoc() {
        return this.m_sLoc;
    }

    public ArrayList getTargetStructure() {
        return this.m_targetStructure;
    }

    public void saveMakeXML() throws IOException {
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            fos = new FileOutputStream(this.m_sLoc);
            pw = new PrintWriter(fos);
            this.writeXmlForm(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void writeXmlForm(PrintWriter pw) throws IOException {
        int size = this.m_targetStructure.size();
        pw.println(OixsXMLOps.createXMLDirective(true));
        pw.println(OixsXMLOps.getStandardHeader());
        pw.println("<ohmd:MAKE_LIST xmlns:ohmd=\"make_desc.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"make_desc.xsd make_desc.xsd\">");
        for (int i = 0; i < size; ++i) {
            OiisTargetStructure ts = (OiisTargetStructure)this.m_targetStructure.get(i);
            ts.writeXmlForm(pw);
        }
        pw.println("</ohmd:MAKE_LIST>");
    }
}

