/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisRelinkInfo;
import oracle.sysman.oii.oiis.OiisTargetStructure;
import oracle.sysman.oix.oixp.OixpIAttribute;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;

public class OiisMakeConfigReader
implements OixpIHandler {
    private static final String MAKE_TAG = "ohmd:MAKE";
    private static final String INPUT_TAG = "ohmd:INPUT";
    private static final String MAKE_LIST_TAG = "ohmd:MAKE_LIST";
    private static final String INPUT_LIST_TAG = "ohmd:INPUT_LIST";
    private static final String TARGET_TAG = "ohmd:TARGET";
    private static final String COMP_TAG = "ohmd:COMP";
    private static final String PATCH_TAG = "ohmd:PATCH";
    private static final String TARGETNAME_ATT = "TARGETNAME";
    private static final String FILENAME_ATT = "FILENAME";
    private static final String MAKEPATH_ATT = "MAKEPATH";
    private static final String VAL_ATT = "VAL";
    private static final String NAME_ATT = "NAME";
    private static final String VERSION_ATT = "VERSION";
    private static final String ACTIONTYPE_ATT = "ACTIONTYPE";
    private static final String INSTALL = "INSTALL";
    private static final String DEINSTALL = "DEINSTALL";
    private static final String BOTH = "BOTH";
    private static String cur_makefile = null;
    private static String cur_makepath = null;
    private static String cur_action = null;
    private String[] args;
    private ArrayList args_list = new ArrayList();
    private ArrayList comp_list = new ArrayList();
    private OiisRelinkInfo obj;
    private OiisTargetStructure m_tgt;
    private ArrayList m_targetStructure;
    private ArrayList m_oldList = new ArrayList();
    private ArrayList m_newList;
    private String m_sLoc;

    public OiisMakeConfigReader(String loc, ArrayList args) {
        this.m_sLoc = loc;
        this.m_newList = args;
        this.m_targetStructure = new ArrayList();
    }

    public String getLoc() {
        return this.m_sLoc;
    }

    public ArrayList getArgs() {
        return this.m_newList;
    }

    public ArrayList getTargetStructure() {
        return this.m_targetStructure;
    }

    public ArrayList parseMakeXML() throws IOException {
        this.loadFromFile();
        this.createUniqueList();
        return this.m_targetStructure;
    }

    public void loadFromFile() throws IOException {
        try (FileInputStream fis = null;){
            OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
            File f = new File(this.m_sLoc);
            if (!f.exists()) {
                return;
            }
            fis = new FileInputStream(this.m_sLoc);
            parser.setInputStream(fis);
            parser.setHandler(this);
            parser.readXML();
        }
    }

    @Override
    public boolean doStartTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(MAKE_TAG)) {
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (tmp.equals(FILENAME_ATT)) {
                    cur_makefile = retLst[i].getValue();
                    continue;
                }
                if (tmp.equals(MAKEPATH_ATT)) {
                    cur_makepath = retLst[i].getValue();
                    continue;
                }
                OiiolTextLogger.appendText("Improper attribute found in MAKE TAG");
            }
        } else if (type.equalsIgnoreCase(TARGET_TAG)) {
            this.obj = new OiisRelinkInfo();
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (tmp.equals(TARGETNAME_ATT)) {
                    this.obj.setTarget(retLst[i].getValue());
                    continue;
                }
                if (!tmp.equals(ACTIONTYPE_ATT)) continue;
                cur_action = retLst[i].getValue();
            }
        } else if (type.equalsIgnoreCase(INPUT_TAG)) {
            this.args_list.add(el.getAttribValue(VAL_ATT));
        } else if (type.equalsIgnoreCase(COMP_TAG)) {
            OiiiVersion v = new OiiiVersion(el.getAttribValue(VERSION_ATT));
            String name = el.getAttribValue(NAME_ATT);
            OiiiCompInstallID cid = new OiiiCompInstallID(name, v, new Vector(), new OiiiVersion("0.0.0.0.0"), 1, 0, 0);
            this.comp_list.add(cid);
        } else if (type.equalsIgnoreCase(PATCH_TAG)) {
            OiiiVersion v = new OiiiVersion(el.getAttribValue(VERSION_ATT));
            String name = el.getAttribValue(NAME_ATT);
            OiiiCompInstallID cid = new OiiiCompInstallID(name, v, new Vector(), new OiiiVersion("0.0.0.0.0"), 2, 0, 0);
            this.comp_list.add(cid);
        }
        return false;
    }

    @Override
    public boolean doText(OixpIElement el, String text) {
        return false;
    }

    @Override
    public boolean doEndTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(TARGET_TAG)) {
            this.args = this.args_list.toArray(new String[this.args_list.size()]);
            if (this.args.length == 0) {
                this.args = new String[0];
            }
            this.obj.setParamArguments(this.args);
            this.obj.setMakeFileName(cur_makefile);
            this.obj.setMakePath(cur_makepath);
            ArrayList cidList = new ArrayList(this.comp_list);
            this.obj.setCIDList(cidList);
            this.args_list.clear();
            this.comp_list.clear();
            this.obj.setActionType(cur_action);
            this.m_oldList.add(new OiisTargetStructure(this.obj));
        } else if (type.equalsIgnoreCase(MAKE_TAG)) {
            cur_makefile = null;
            cur_makepath = null;
            cur_action = null;
        } else if (type.equalsIgnoreCase(MAKE_LIST_TAG)) {
            // empty if block
        }
        return false;
    }

    public void createUniqueList() {
        OiisTargetStructure oldTgt = null;
        OiisTargetStructure newTgt = null;
        for (int j = 0; j < this.m_oldList.size(); ++j) {
            oldTgt = (OiisTargetStructure)this.m_oldList.get(j);
            this.m_targetStructure.add(oldTgt);
        }
        int size = this.m_newList.size();
        for (int i = 0; i < size; ++i) {
            newTgt = (OiisTargetStructure)this.m_newList.get(i);
            boolean isPresentInOldList = false;
            for (int j = 0; j < this.m_oldList.size(); ++j) {
                oldTgt = (OiisTargetStructure)this.m_oldList.get(j);
                if (!oldTgt.equals(newTgt)) continue;
                ArrayList cidListForoldTgt = oldTgt.getCIDList();
                ArrayList cidListFornewTgt = newTgt.getCIDList();
                cidListForoldTgt.addAll(cidListFornewTgt);
                oldTgt.setCIDList(cidListForoldTgt);
                isPresentInOldList = true;
                break;
            }
            if (isPresentInOldList) continue;
            this.m_targetStructure.add(newTgt);
        }
    }
}

