/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.BitSet;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixLanguage;

public class OiisLangIndexMapping
implements Cloneable {
    public static final int I_DEFAULT_FILES_LANGINDEX = -554696704;
    private static final boolean s_debug = false;
    static final long serialVersionUID = 7362207346662303522L;
    private Locale[] m_langArr;
    private Vector m_vLangSets;
    private transient int[] m_aiCurLangToLangSetMapping;

    public OiisLangIndexMapping() {
        this(new Vector(0));
    }

    public OiisLangIndexMapping(Vector vLangs) {
        if (vLangs != null) {
            this.m_langArr = new Locale[vLangs.size()];
            vLangs.copyInto(this.m_langArr);
        } else {
            this.m_langArr = new Locale[0];
        }
        this.m_vLangSets = new Vector(5, 5);
        this.addLangSet(null);
    }

    public Locale[] getLangs() {
        return this.m_langArr;
    }

    public Vector getLangSets() {
        return this.m_vLangSets;
    }

    public boolean updateFrom(OiisLangIndexMapping oldMapping) {
        boolean anyChanges = false;
        Locale[] curLangs = OiixLanguage.getLanguages();
        if (oldMapping == null) {
            anyChanges = true;
        } else {
            Vector<Locale> newLangs = new Vector<Locale>();
            for (int i = 0; i < curLangs.length; ++i) {
                if (oldMapping.indexOfLang(curLangs[i]) != -1) continue;
                newLangs.addElement(curLangs[i]);
            }
            int numAddLangs = newLangs.size();
            Locale[] oldLangs = oldMapping.getLangs();
            this.m_langArr = new Locale[oldLangs.length + numAddLangs];
            System.arraycopy(oldLangs, 0, this.m_langArr, 0, oldLangs.length);
            if (numAddLangs != 0) {
                anyChanges = true;
                int oldLen = oldLangs.length;
                for (int i = 0; i < numAddLangs; ++i) {
                    this.m_langArr[oldLen + i] = (Locale)newLangs.elementAt(i);
                }
            }
        }
        return anyChanges;
    }

    public int indexOfLang(Locale locale) {
        int retInd = -1;
        int numLangs = this.m_langArr.length;
        for (int i = 0; i < numLangs; ++i) {
            if (!this.m_langArr[i].equals(locale)) continue;
            retInd = i;
            break;
        }
        return retInd;
    }

    public void addLang(Locale lang) {
        Locale[] tmpLangArr = new Locale[this.m_langArr.length + 1];
        System.arraycopy(this.m_langArr, 0, tmpLangArr, 0, this.m_langArr.length);
        tmpLangArr[tmpLangArr.length - 1] = lang;
        this.m_langArr = tmpLangArr;
    }

    public void addLangs(Locale[] langs) {
        if (langs == null) {
            return;
        }
        Locale[] tmpLangArr = new Locale[this.m_langArr.length + langs.length];
        System.arraycopy(this.m_langArr, 0, tmpLangArr, 0, this.m_langArr.length);
        System.arraycopy(langs, 0, tmpLangArr, this.m_langArr.length, langs.length);
        this.m_langArr = tmpLangArr;
    }

    public BitSet genLangsBitSet(Vector langs) {
        return this.genLangsBitSet(langs, false);
    }

    public BitSet genLangsBitSet(Vector langs, boolean bAddLangs) {
        BitSet retBs = null;
        if (langs == null) {
            retBs = this.genLangAllBitSet();
        } else {
            int i;
            int numFLangs = langs.size();
            Locale[] aoNewLangs = new Locale[numFLangs];
            int[] aiLangsIdx = new int[numFLangs];
            int nNewLangs = 0;
            for (i = 0; i < numFLangs; ++i) {
                Locale lang = (Locale)langs.elementAt(i);
                aiLangsIdx[i] = this.indexOfLang(lang);
                if (aiLangsIdx[i] != -1 || !bAddLangs) continue;
                aoNewLangs[nNewLangs] = lang;
                aiLangsIdx[i] = this.m_langArr.length + ++nNewLangs;
            }
            if (bAddLangs & nNewLangs > 0) {
                Locale[] aoTmpNewLangs = new Locale[nNewLangs];
                System.arraycopy(aoNewLangs, 0, aoTmpNewLangs, 0, nNewLangs);
                this.addLangs(aoTmpNewLangs);
            }
            retBs = new BitSet(this.m_langArr.length);
            for (i = 0; i < aiLangsIdx.length; ++i) {
                if (aiLangsIdx[i] == -1) continue;
                retBs.set(aiLangsIdx[i]);
            }
        }
        return retBs;
    }

    public BitSet genLangAllBitSet() {
        return null;
    }

    public int indexOfLangBitSet(BitSet bs) {
        int exPos = -1;
        if (OiisLangIndexMapping.isLangAllBitSet(bs)) {
            int numLS = this.m_vLangSets.size();
            for (int i = 0; i < numLS; ++i) {
                BitSet exBS = (BitSet)this.m_vLangSets.elementAt(i);
                if (!OiisLangIndexMapping.isLangAllBitSet(exBS)) continue;
                exPos = i;
                break;
            }
        } else {
            exPos = this.m_vLangSets.indexOf(bs);
        }
        return exPos;
    }

    public int addLangSet(BitSet lbs) {
        int idx = this.indexOfLangBitSet(lbs);
        if (idx == -1) {
            idx = this.m_vLangSets.size();
            this.m_vLangSets.addElement(lbs);
        }
        return idx;
    }

    static boolean isLangAllBitSet(BitSet bs) {
        return bs == null;
    }

    public void setSelectedLanguages(Vector langs) {
        this.m_aiCurLangToLangSetMapping = this.getRelevantLangSetList(langs, false);
    }

    public int[] getRelevantLangSetList() {
        if (this.m_aiCurLangToLangSetMapping == null) {
            return this.getRelevantLangSetList(null, true);
        }
        return this.m_aiCurLangToLangSetMapping;
    }

    public int[] getRelevantLangSetList(Vector langs) {
        return this.getRelevantLangSetList(langs, false);
    }

    public int[] getRelevantLangSetList(Vector langs, boolean bAllLangs) {
        int nLangSets = this.m_vLangSets.size();
        int[] aiLangSets = new int[nLangSets];
        if (langs == null || bAllLangs) {
            for (int i = 0; i < nLangSets; ++i) {
                aiLangSets[i] = i;
            }
        } else {
            BitSet bs = this.genLangsBitSet(langs, false);
            int nCnt = 0;
            for (int i = 0; i < nLangSets; ++i) {
                BitSet bsLS = (BitSet)this.m_vLangSets.elementAt(i);
                BitSet bsClone = (BitSet)bs.clone();
                if (!OiisLangIndexMapping.isLangAllBitSet(bsLS)) {
                    bsClone.and(bsLS);
                }
                if (bsClone.length() == 0) continue;
                aiLangSets[nCnt] = i;
                ++nCnt;
            }
            if (nCnt > 0) {
                int[] aiTmpLangSets = new int[nCnt];
                System.arraycopy(aiLangSets, 0, aiTmpLangSets, 0, nCnt);
                aiLangSets = aiTmpLangSets;
            }
        }
        return aiLangSets;
    }

    public int[] getRelevantLangSetList(Locale language) {
        Vector<Locale> vLangs = new Vector<Locale>(1);
        vLangs.addElement(language);
        return this.getRelevantLangSetList(vLangs);
    }

    public Vector getRelevantLangSets(Vector langs) {
        int[] setList = this.getRelevantLangSetList(langs);
        Vector retSets = new Vector(setList.length);
        for (int i = 0; i < setList.length; ++i) {
            retSets.addElement(this.m_vLangSets.elementAt(setList[i]));
        }
        return retSets;
    }

    public Vector getLangsForLangSet(BitSet bsLS) {
        Vector<Locale> vLangs = new Vector<Locale>(this.m_langArr.length, 5);
        if (OiisLangIndexMapping.isLangAllBitSet(bsLS)) {
            for (int i = 0; i < this.m_langArr.length; ++i) {
                vLangs.addElement(this.m_langArr[i]);
            }
        } else {
            int nMaxSize = Math.min(this.m_langArr.length, bsLS.length());
            for (int i = 0; i < nMaxSize; ++i) {
                if (!bsLS.get(i)) continue;
                vLangs.addElement(this.m_langArr[i]);
            }
        }
        return vLangs;
    }

    public Vector getLangsForLangSetIndex(int idx) {
        if (idx == -554696704) {
            return this.getLangsForLangSet(this.genLangAllBitSet());
        }
        if (idx < 0 || idx > this.m_vLangSets.size()) {
            return null;
        }
        BitSet bsLS = (BitSet)this.m_vLangSets.elementAt(idx);
        return this.getLangsForLangSet(bsLS);
    }

    public BitSet getLangSetForIndex(int idx) {
        return (BitSet)this.m_vLangSets.elementAt(idx);
    }

    public String toString() {
        int i;
        StringBuffer sbuf = new StringBuffer();
        for (i = 0; i < this.m_langArr.length - 1; ++i) {
            sbuf.append("[" + i + "=>" + this.m_langArr[i] + "]");
            sbuf.append(",");
        }
        sbuf.append("[" + i + "=>" + this.m_langArr[i] + "]");
        return sbuf.toString();
    }

    public void optimizeLangList() {
        int size = this.m_langArr.length;
        for (int i = 0; i < size; ++i) {
            this.m_langArr[i] = OiixLanguage.getLocaleInstance(this.m_langArr[i]);
        }
    }

    public Object clone() {
        OiisLangIndexMapping oClone = null;
        try {
            oClone = (OiisLangIndexMapping)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return oClone;
    }

    public static void main(String[] args) {
        OiisLangIndexMapping lim = new OiisLangIndexMapping();
        System.out.println(lim.toString());
    }
}

