/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisLangFileGroup
implements Serializable {
    static final long serialVersionUID = 9128965890055009955L;
    private Vector m_fGroups;
    private int namelen = -1;
    private String m_name;
    private transient OiisFileMap m_fileMapRef;

    public OiisLangFileGroup(String name) {
        this.m_name = name;
        this.m_fGroups = new Vector();
        this.m_fileMapRef = null;
    }

    public void setFileMapRef(OiisFileMap fileMapRef) {
        this.m_fileMapRef = fileMapRef;
        int numGps = this.m_fGroups.size();
        for (int i = 0; i < numGps; ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            fg.setFileMapRef(fileMapRef);
        }
    }

    public OiisLangFileGroup(String name, Locale[] groupNames) {
        this(name);
        for (int i = 0; i < groupNames.length; ++i) {
            this.addFileGroup(groupNames[i]);
        }
    }

    public OiisFileGroup addFileGroup(Locale locale) {
        String subgp = this.concoctSubGpName(locale);
        OiisFileGroup fg = null;
        if (this.m_fGroups.indexOf(subgp) == -1) {
            fg = new OiisFileGroup(subgp);
            this.m_fGroups.addElement(fg);
            fg.setFileMapRef(this.m_fileMapRef);
        }
        return fg;
    }

    public OiisFileGroup getFileGroup(Locale locale) {
        OiisFileGroup retGp = null;
        String subgp = this.concoctSubGpName(locale);
        for (int pos = 0; pos < this.m_fGroups.size(); ++pos) {
            retGp = (OiisFileGroup)this.m_fGroups.elementAt(pos);
            if (!retGp.getName().equals(subgp)) continue;
            return retGp;
        }
        return null;
    }

    public Vector getFileGroups() {
        return this.m_fGroups;
    }

    public int getSize(Vector langs) {
        int size = 0;
        for (int i = 0; i < this.m_fGroups.size(); ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            Locale locale = this.extractSubGpLocale(fg.getName());
            if (langs != null && !langs.contains(locale)) continue;
            size = (int)((long)size + fg.getSize());
        }
        return size;
    }

    public boolean equals(String name) {
        return this.m_name.equals(name);
    }

    public boolean equals(OiisLangFileGroup lgroup) {
        if (lgroup != null && this.m_name.equals(lgroup.getName())) {
            return OiixVectorOps.vectorsEqual(this.m_fGroups, lgroup.getFileGroups());
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public Enumeration getSubGroupNames() {
        Vector<String> names = new Vector<String>();
        Enumeration enum_1 = this.m_fGroups.elements();
        while (enum_1.hasMoreElements()) {
            String subGp = ((OiisFileGroup)enum_1.nextElement()).getName();
            names.addElement(this.extractSubGpName(subGp));
        }
        return names.elements();
    }

    public Enumeration getSubGroupLocales() {
        Vector<Locale> locales = new Vector<Locale>();
        Enumeration enum_1 = this.m_fGroups.elements();
        while (enum_1.hasMoreElements()) {
            String subGp = ((OiisFileGroup)enum_1.nextElement()).getName();
            locales.addElement(this.extractSubGpLocale(subGp));
        }
        return locales.elements();
    }

    private String extractSubGpName(String gpname) {
        if (this.namelen == -1) {
            this.namelen = new String(this.m_name + ".").length();
        }
        return gpname.substring(this.namelen);
    }

    private Locale extractSubGpLocale(String gpname) {
        int cindex;
        if (this.namelen == -1) {
            this.namelen = new String(this.m_name + ".").length();
        }
        if ((cindex = gpname.indexOf("_", this.namelen)) > -1) {
            String lang = gpname.substring(this.namelen, cindex);
            int vindex = gpname.indexOf("_", cindex + 1);
            if (vindex > -1) {
                String country = gpname.substring(cindex + 1, vindex);
                String variant = gpname.substring(vindex + 1);
                return new Locale(lang, country, variant);
            }
            String country = gpname.substring(cindex + 1);
            return new Locale(lang, country);
        }
        return null;
    }

    private String concoctSubGpName(Locale locale) {
        return this.m_name + "." + locale.toString();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        Enumeration fgs = this.getSubGroupLocales();
        while (fgs.hasMoreElements()) {
            Locale fgName = (Locale)fgs.nextElement();
            OiisFileGroup fg = this.getFileGroup(fgName);
            sbuf.append("[ \"" + fgName + "\" -> " + fg.toString() + " ]");
        }
        return sbuf.toString();
    }
}

