/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiis.OiisChildVarElem;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisConstantException;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisPlatformSpecificConstant;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class OiisIdentifiersXMLHandler
extends OixsDefaultHandler {
    private Hashtable m_htIdentifiers = new Hashtable();
    private OixsElementHandler m_IdentifiersHandler;
    private OixsElementHandler m_ConstantsHandler;
    private OixsElementHandler m_ConstHandler;
    private OixsElementHandler m_TransIdHandler;
    private OixsElementHandler m_IDHandler;
    private OixsElementHandler m_ValHandler;
    private OixsElementHandler m_VariablesHandler;
    private OixsElementHandler m_VarHandler;
    private OixsElementHandler m_AssocDepNameHandler;
    private String m_sConst = null;
    private String m_sVar = null;
    private OiisCompContext m_oContext;
    private static final int s_iCurrPlatform = OiixPlatform.getCurrentPlatform();
    private OiixJarResourceBundle m_jrb;
    private boolean m_bLoadAllConstants = false;

    OiisIdentifiersXMLHandler(OiisCompContext oContext, OiixJarResourceBundle jrb, boolean bLoadAllConstants) throws SAXException {
        this.m_oContext = oContext;
        this.m_jrb = jrb;
        this.m_bLoadAllConstants = bLoadAllConstants;
    }

    @Override
    public OixsElementHandler createElementHandlers() {
        this.m_IdentifiersHandler = new OixsElementHandler("IDENTIFIERS");
        this.m_ConstantsHandler = new OiisConstsVarsHandler("CONSTS");
        this.m_ConstHandler = new OiisConstantHandler("CONST");
        this.m_TransIdHandler = new OixsElementHandler("TRANSID");
        this.m_IDHandler = new OiisIDHandler("ID");
        this.m_ValHandler = new OiisValHandler("VAL");
        this.m_VariablesHandler = new OiisConstsVarsHandler("CONSTS");
        this.m_VarHandler = new OiisVarHandler("VAR");
        this.m_AssocDepNameHandler = new OiisAssocDepNameHandler("ASSOC_DEP");
        this.m_IdentifiersHandler.addChildHandler("CONSTS", this.m_ConstantsHandler);
        this.m_IdentifiersHandler.addChildHandler("VARS", this.m_VariablesHandler);
        this.m_ConstantsHandler.addChildHandler("CONST", this.m_ConstHandler);
        this.m_ConstHandler.addChildHandler("TRANSID", this.m_TransIdHandler);
        this.m_ConstHandler.addChildHandler("VAL", this.m_ValHandler);
        this.m_TransIdHandler.addChildHandler("ID", this.m_IDHandler);
        this.m_VariablesHandler.addChildHandler("VAR", this.m_VarHandler);
        this.m_VarHandler.addChildHandler("ASSOC_DEP", this.m_AssocDepNameHandler);
        return this.m_IdentifiersHandler;
    }

    boolean getBoolFromString(String sFlag, boolean bDefault) {
        if (sFlag != null) {
            return sFlag.equalsIgnoreCase("T");
        }
        return bDefault;
    }

    Vector getIntVectorFromString(String sPlats) {
        sPlats = sPlats.substring(1, sPlats.length() - 1);
        StringTokenizer st = new StringTokenizer(sPlats, ",");
        Vector<Integer> retVal = new Vector<Integer>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int iPlat = Integer.parseInt(token);
                retVal.addElement(new Integer(iPlat));
            }
            catch (NumberFormatException e) {
                System.err.println("Identifiers.xml encountered '" + token + "' in platform array of dependee var association.");
                return null;
            }
        }
        return retVal;
    }

    void createConstantObject(int nsize) {
        this.m_oContext.setConstants(new OiisCompConstants(nsize));
    }

    class OiisAssocDepNameHandler
    extends OixsElementHandler {
        OiisAssocDepNameHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String sName, AttributeList atts) {
            if (OiisIdentifiersXMLHandler.this.m_htIdentifiers.get(OiisIdentifiersXMLHandler.this.m_sVar) == null || !(OiisIdentifiersXMLHandler.this.m_htIdentifiers.get(OiisIdentifiersXMLHandler.this.m_sVar) instanceof OiisVariable)) {
                return;
            }
            OiisVariable oVar = (OiisVariable)OiisIdentifiersXMLHandler.this.m_htIdentifiers.get(OiisIdentifiersXMLHandler.this.m_sVar);
            String sCompName = atts.getValue("NAME");
            String sCompVer = atts.getValue("VERSION");
            String sCompPlats = atts.getValue("PLATS");
            String sVarName = atts.getValue("ASSOC");
            Vector vPlats = OiisIdentifiersXMLHandler.this.getIntVectorFromString(sCompPlats);
            OiiiVersion oVer = new OiiiVersion(sCompVer);
            OiiiCompInstallID oCompID = new OiiiCompInstallID(sCompName, oVer, vPlats);
            oCompID = OiiiCompIDPool.getInstance().get(oCompID);
            oCompID.optimizePlatList();
            OiisChildVarElem oChildVar = new OiisChildVarElem(oCompID, sVarName, true);
            oVar.setChildVarElem(oChildVar);
        }
    }

    class OiisVarHandler
    extends OixsElementHandler {
        OiisVarHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String sName, AttributeList atts) {
            String sDerivedVarNamesList;
            OiisIdentifiersXMLHandler.this.m_sVar = atts.getValue("NAME");
            String sType = atts.getValue("TYPE");
            int iType = OiisDataTypes.getTypeID(sType);
            String sDescID = atts.getValue("DESC_ID");
            String sSec = atts.getValue("SEC");
            boolean bSec = OiisIdentifiersXMLHandler.this.getBoolFromString(sSec, true);
            String sForceTrans = atts.getValue("FORCE_TRANS");
            boolean bForceTrans = OiisIdentifiersXMLHandler.this.getBoolFromString(sForceTrans, false);
            String sCalc = atts.getValue("CALC");
            boolean bCalc = OiisIdentifiersXMLHandler.this.getBoolFromString(sCalc, true);
            String sExp = atts.getValue("EXP");
            boolean bExp = OiisIdentifiersXMLHandler.this.getBoolFromString(sExp, true);
            String sValn = atts.getValue("VALDN");
            boolean bValn = OiisIdentifiersXMLHandler.this.getBoolFromString(sValn, true);
            OiisVariable oVar = OiisIdentifiersXMLHandler.this.m_oContext.createVariable(OiisIdentifiersXMLHandler.this.m_oContext, OiisIdentifiersXMLHandler.this.m_sVar, sDescID, iType, bExp, bSec, bCalc, bValn);
            oVar.setForceTranslate(bForceTrans);
            String sGenerateRes = atts.getValue("GEN_RES");
            boolean bGenRes = OiisIdentifiersXMLHandler.this.getBoolFromString(sGenerateRes, true);
            oVar.setGenerateRSP(bGenRes);
            String sComputeAtClone = atts.getValue("CLONE");
            boolean bComputeAtClone = OiisIdentifiersXMLHandler.this.getBoolFromString(sComputeAtClone, false);
            oVar.setComputeAtClone(bComputeAtClone);
            if (!bComputeAtClone && null != (sDerivedVarNamesList = atts.getValue("DERIVED_VARS")) && !sDerivedVarNamesList.equals("")) {
                StringTokenizer st = new StringTokenizer(sDerivedVarNamesList, ",");
                Vector<String> vDerivedVarNames = new Vector<String>(st.countTokens());
                while (st.hasMoreTokens()) {
                    vDerivedVarNames.addElement(st.nextToken());
                }
                oVar.setDerivedVarNames(vDerivedVarNames);
            }
            OiisIdentifiersXMLHandler.this.m_oContext.addVariable(oVar);
            OiisIdentifiersXMLHandler.this.m_htIdentifiers.put(OiisIdentifiersXMLHandler.this.m_sVar, oVar);
        }

        public void onEnd() {
            OiisIdentifiersXMLHandler.this.m_sVar = null;
        }
    }

    class OiisValHandler
    extends OixsElementHandler {
        String m_sPlat;

        OiisValHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String sName, AttributeList atts) {
            if (OiisIdentifiersXMLHandler.this.m_sConst == null) {
                return;
            }
            Object obj = OiisIdentifiersXMLHandler.this.m_htIdentifiers.get(OiisIdentifiersXMLHandler.this.m_sConst);
            if (obj == null || !(obj instanceof OiisGenericConstant)) {
                return;
            }
            OiisGenericConstant oConst = (OiisGenericConstant)obj;
            if (oConst == null) {
                return;
            }
            this.m_sPlat = atts.getValue("PLAT");
            String sVal = atts.getValue("VALUE");
            sVal = this.replaceSpecialChars(sVal);
            Object oVal = OiisDataTypes.getValueObject(sVal, OiisDataTypes.findTypeWithID(oConst.getType()).getName());
            if (this.m_sPlat != null && this.m_sPlat.equalsIgnoreCase("ALL")) {
                try {
                    oConst.setValue(oVal);
                }
                catch (OiisConstantException e) {
                    e.printStackTrace();
                }
            } else {
                int iPlat = OiixPlatform.getPlatformIDFromCommonName(this.m_sPlat);
                if (OiisIdentifiersXMLHandler.this.m_bLoadAllConstants || s_iCurrPlatform == iPlat) {
                    ((OiisPlatformSpecificConstant)oConst).setValue(iPlat, oVal);
                }
            }
        }

        public void onEnd() {
            OiisIdentifiersXMLHandler.this.m_sConst = null;
        }

        public String replaceSpecialChars(String s) {
            String sInput = s;
            int size = sInput.length();
            StringBuffer formatted = new StringBuffer("");
            for (int i = 0; i < size; ++i) {
                if (sInput.charAt(i) == '\\') {
                    if (sInput.length() >= i + 2) {
                        if (sInput.charAt(i + 1) == 'n') {
                            formatted.append("\n");
                            ++i;
                            continue;
                        }
                        if (sInput.charAt(i + 1) == 't') {
                            formatted.append("\t");
                            ++i;
                            continue;
                        }
                        if (sInput.charAt(i + 1) == '\\') {
                            formatted.append("\\");
                            ++i;
                            continue;
                        }
                        if (sInput.charAt(i + 1) == '\"') {
                            formatted.append("\"");
                            ++i;
                            continue;
                        }
                        if (sInput.charAt(i + 1) == 'r') {
                            formatted.append("\r");
                            ++i;
                            continue;
                        }
                        formatted.append("\\");
                        continue;
                    }
                    formatted.append("\\");
                    continue;
                }
                formatted.append(sInput.charAt(i));
            }
            return formatted.toString();
        }
    }

    class OiisIDHandler
    extends OixsElementHandler {
        OiisIDHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String sName, AttributeList atts) {
            if (OiisIdentifiersXMLHandler.this.m_sConst == null) {
                return;
            }
            Object obj = OiisIdentifiersXMLHandler.this.m_htIdentifiers.get(OiisIdentifiersXMLHandler.this.m_sConst);
            if (obj == null || !(obj instanceof OiisGenericConstant)) {
                return;
            }
            OiisGenericConstant oConst = (OiisGenericConstant)obj;
            if (oConst == null) {
                return;
            }
            String sPlat = atts.getValue("PLAT");
            String sID = atts.getValue("NAME");
            try {
                if (sPlat.equalsIgnoreCase("ALL")) {
                    oConst.setID(sID);
                } else {
                    int iPlat = OiixPlatform.getPlatformIDFromCommonName(sPlat);
                    if (OiisIdentifiersXMLHandler.this.m_bLoadAllConstants || s_iCurrPlatform == iPlat) {
                        ((OiisPlatformSpecificConstant)oConst).setID(iPlat, sID);
                    }
                }
            }
            catch (OiisConstantException e) {
                System.err.println(e.getMessage());
            }
        }

        public void onEnd() {
        }
    }

    class OiisConstantHandler
    extends OixsElementHandler {
        OiisConstantHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String sName, AttributeList atts) {
            OiisIdentifiersXMLHandler.this.m_sConst = atts.getValue("NAME");
            String temp = OiisIdentifiersXMLHandler.this.m_sConst;
            String sType = atts.getValue("TYPE");
            int iType = OiisDataTypes.getTypeID(sType);
            String sGen = atts.getValue("GEN");
            boolean bGen = OiisIdentifiersXMLHandler.this.getBoolFromString(sGen, true);
            String sTrans = atts.getValue("TRANS");
            boolean bTrans = OiisIdentifiersXMLHandler.this.getBoolFromString(sTrans, false);
            OiisGenericConstant oConst = bGen ? new OiisGenericConstant(OiisIdentifiersXMLHandler.this.m_sConst, iType) : new OiisPlatformSpecificConstant(OiisIdentifiersXMLHandler.this.m_sConst, iType);
            oConst.setResourceBundle(OiisIdentifiersXMLHandler.this.m_jrb);
            OiisIdentifiersXMLHandler.this.m_oContext.addConstant(oConst);
            OiisIdentifiersXMLHandler.this.m_htIdentifiers.put(OiisIdentifiersXMLHandler.this.m_sConst, oConst);
        }

        public void onEnd() {
            OiisIdentifiersXMLHandler.this.m_sConst = null;
        }
    }

    class OiisConstsVarsHandler
    extends OixsElementHandler {
        int m_size;

        OiisConstsVarsHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            try {
                this.m_size = Integer.parseInt(atts.getValue("SIZE"));
                if (name.equalsIgnoreCase("CONSTS")) {
                    OiisIdentifiersXMLHandler.this.createConstantObject(this.m_size);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        public int getSize() {
            return this.m_size;
        }

        @Override
        public void onEnd(String name) {
        }
    }
}

